/*
 * Decompiled with CFR 0.152.
 */
package ui.gui;

import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JsqlFontDialog
extends JDialog {
    private static final String[] styleValue = new String[]{"Regular", "Italic", "Bold", "Blod Italic"};
    private static final String[] sizeValue = new String[]{"6", "7", "8", "9", "10", "11", "12", "13", "14", "16", "18", "20", "22", "24", "26", "28", "32", "36", "40", "48", "56", "64", "72"};
    private Font initFont = null;
    private Font font = null;
    private JLabel familyLabel = new JLabel("Family:");
    private JList familyList = null;
    private JLabel styleLabel = new JLabel("Style:");
    private JList styleList = new JList<String>(styleValue);
    private JLabel sizeLabel = new JLabel("Size:");
    private JList sizeList = new JList<String>(sizeValue);
    private JLabel previewLabel = new JLabel("Preview:");
    private JTextField previewTextField = new JTextField();
    private DbaButton okButton = new DbaButton(new Dimension(80, 24), "OK", 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "okButtonActionPerformed"));
    private DbaButton cancelButton = new DbaButton(new Dimension(80, 24), "Cancel", 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));

    public JsqlFontDialog(JFrame parent, Font font) {
        super(parent);
        this.initFont = font;
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JsqlFontDialog.this.cancelButtonActionPerformed(null);
            }
        });
        String[] fNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.familyList = new JList<String>(fNames);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel familyPanel = new JPanel(new BorderLayout());
        familyPanel.add((Component)this.familyLabel, "North");
        JScrollPane fms = new JScrollPane();
        fms.getViewport().add(this.familyList);
        familyPanel.add((Component)fms, "Center");
        familyPanel.add((Component)new JPanel(), "West");
        familyPanel.add((Component)new JPanel(), "East");
        JPanel stylePanel = new JPanel(new BorderLayout());
        stylePanel.add((Component)this.styleLabel, "North");
        JScrollPane sys = new JScrollPane();
        sys.getViewport().add(this.styleList);
        stylePanel.add((Component)sys, "Center");
        stylePanel.add((Component)new JPanel(), "West");
        stylePanel.add((Component)new JPanel(), "East");
        JPanel sizePanel = new JPanel(new BorderLayout());
        sizePanel.add((Component)this.sizeLabel, "North");
        JScrollPane szs = new JScrollPane();
        szs.getViewport().add(this.sizeList);
        sizePanel.add((Component)szs, "Center");
        sizePanel.add((Component)new JPanel(), "West");
        sizePanel.add((Component)new JPanel(), "East");
        centerPanel.add((Component)familyPanel, "West");
        centerPanel.add((Component)stylePanel, "Center");
        centerPanel.add((Component)sizePanel, "East");
        centerPanel.add((Component)new JPanel(), "North");
        centerPanel.add((Component)new JPanel(), "South");
        JPanel previewPanel = new JPanel(new FlowLayout(0));
        previewPanel.add(this.previewLabel);
        JPanel previewPanel2 = new JPanel(new BorderLayout());
        previewPanel2.add((Component)previewPanel, "North");
        previewPanel2.add(this.previewTextField);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)previewPanel2, "Center");
        southPanel.add((Component)buttonPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)centerPanel, "Center");
        this.add((Component)southPanel, "South");
        this.setTitle("Font");
        this.setModal(true);
        this.setSize(480, 300);
        this.setResizable(false);
        this.familyList.setSelectedValue(this.initFont.getFamily(), true);
        this.familyList.setVisibleRowCount(10);
        this.familyList.setSelectionMode(0);
        this.familyList.setAutoscrolls(true);
        this.familyList.ensureIndexIsVisible(this.familyList.getSelectedIndex());
        this.familyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JsqlFontDialog.this.listValueChanged(e);
            }
        });
        this.familyList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JsqlFontDialog.this.okButtonActionPerformed(null);
                }
            }
        });
        this.styleList.setSelectionMode(0);
        int style = this.initFont.getStyle();
        String initStyle = null;
        if (style == 0) {
            initStyle = "Regular";
        } else if (style == 2) {
            initStyle = "Italic";
        } else if (style == 1) {
            initStyle = "Bold";
        } else if (style == 3) {
            initStyle = "Blod Italic";
        }
        this.styleList.setSelectedValue(initStyle, true);
        this.styleList.setVisibleRowCount(10);
        this.styleList.setAutoscrolls(true);
        this.styleList.ensureIndexIsVisible(this.styleList.getSelectedIndex());
        this.styleList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JsqlFontDialog.this.listValueChanged(e);
            }
        });
        this.styleList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JsqlFontDialog.this.okButtonActionPerformed(null);
                }
            }
        });
        this.sizeList.setSelectedValue(this.initFont.getSize() + "", true);
        this.sizeList.setSelectionMode(0);
        this.sizeList.setVisibleRowCount(10);
        this.sizeList.setAutoscrolls(true);
        this.sizeList.ensureIndexIsVisible(this.sizeList.getSelectedIndex());
        this.sizeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JsqlFontDialog.this.listValueChanged(e);
            }
        });
        this.sizeList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JsqlFontDialog.this.okButtonActionPerformed(null);
                }
            }
        });
        this.previewTextField.setFont(this.initFont);
        this.previewTextField.setText("How about this font?");
        this.setNames();
    }

    private void setNames() {
        this.setName("FontDialog");
        this.familyList.setName("FamilyList");
        this.styleList.setName("StyleList");
        this.sizeList.setName("SizeList");
        this.previewTextField.setName("PreviewTextField");
        this.okButton.setName("OKButton");
        this.cancelButton.setName("CancelButton");
    }

    private void listValueChanged(ListSelectionEvent e) {
        String f = (String)this.familyList.getSelectedValue();
        String style = (String)this.styleList.getSelectedValue();
        String size = (String)this.sizeList.getSelectedValue();
        int s = 0;
        if (style.equals("Regular")) {
            s = 0;
        } else if (style.equals("Italic")) {
            s = 2;
        } else if (style.equals("Bold")) {
            s = 1;
        } else if (style.equals("Blod Italic")) {
            s = 3;
        }
        try {
            this.font = new Font(f, s, Integer.parseInt(size));
        }
        catch (Exception e1) {
            this.font = this.initFont;
        }
        this.previewTextField.setFont(this.font);
        this.previewTextField.validate();
        this.validate();
    }

    public void okButtonActionPerformed(ActionEvent e) {
        String f = (String)this.familyList.getSelectedValue();
        String style = (String)this.styleList.getSelectedValue();
        String size = (String)this.sizeList.getSelectedValue();
        int s = 0;
        if (style.equals("Regular")) {
            s = 0;
        } else if (style.equals("Italic")) {
            s = 2;
        } else if (style.equals("Bold")) {
            s = 1;
        } else if (style.equals("Blod Italic")) {
            s = 3;
        }
        try {
            this.font = new Font(f, s, Integer.parseInt(size));
        }
        catch (Exception e1) {
            this.font = this.initFont;
        }
        this.setVisible(false);
        this.dispose();
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.font = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public static Font showDialog(JFrame parent, String title, Font initFont) {
        JsqlFontDialog dlg = new JsqlFontDialog(parent, initFont);
        GuiUt.setCenterLocation(parent, dlg);
        dlg.setVisible(true);
        return dlg.getFont();
    }
}

