/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.restore;

import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.GuiUt;
import dbaut.JRestore;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.WizardTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import svrmgrwizard.restore.RestoreConstants;
import svrmgrwizard.restore.RestoreDlg;

public class PanelRestoreOfflineSummary
extends AbstractWizardPanel {
    private static final long serialVersionUID = -2353877826008668494L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.ResWizard", LocaleManager.getLocale());
    private RestoreDlg parentDlg = null;
    private AbstractWizardPanel previousPanel = null;
    private String title = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(80, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton finishButton = new DbaButton(new Dimension(80, 24), this.res.getString("Finish"), 'F', DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"), new ReflectionAction(this, "finshButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(80, 24), this.res.getString("_Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private String configFileFullPath = null;
    private String restoreDBName = null;
    private String historyFileFullPath = null;
    private String realHistoryFullPath = null;
    private String rTime = null;
    private JRestore cfun = new JRestore(SmFrame.frame);
    private WizardTextPane jTextPane1 = new WizardTextPane(20, 14);

    public PanelRestoreOfflineSummary(RestoreDlg parentDlg, AbstractWizardPanel previousPanel, String configFileFullPath, String restoreDBName, String historyFileFullPath, String realHistoryFullPath, String rTime) {
        this.parentDlg = parentDlg;
        this.previousPanel = previousPanel;
        this.configFileFullPath = configFileFullPath;
        this.restoreDBName = restoreDBName;
        this.historyFileFullPath = historyFileFullPath;
        this.realHistoryFullPath = realHistoryFullPath;
        this.rTime = rTime;
        this.init();
    }

    private void init() {
        this.setName("OfflineSummaryPanel");
        this.finishButton.setName("FinishButton");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new XYLayout(640, 450));
        panel.setPreferredSize(new Dimension(640, 450));
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jTextPane1.setText("");
        this.jTextPane1.setBackground(UIManager.getColor(new UIManager()));
        jScrollPane1.getViewport().add((Component)this.jTextPane1, null);
        panel.add((Component)jScrollPane1, new XYConstraints(150, 0, 490, 450));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.finishButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Wizard_restore_offline_summary", null);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.finishButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        JPanel pPanel = new JPanel(new BorderLayout());
        pPanel.setPreferredSize(new Dimension(150, 450));
        JLabel jLabel1 = new JLabel();
        jLabel1.setBorder(BorderFactory.createEtchedBorder());
        ImageIcon imgIcon = DBAImageResource.getResource(this.getClass(), "/svrmgrimages/restorewizard-1.gif");
        jLabel1.setIcon(new ImageIcon(imgIcon.getImage().getScaledInstance(150, 450, 4)));
        pPanel.add(jLabel1);
        panel.add((Component)pPanel, new XYConstraints(0, 0, 150, 450));
        this.add((Component)panel, "Center");
        this.setButtonBar(buttonPanel);
        this.finishButton.setEnabled(true);
        this.setConents();
    }

    private void setConents() {
        StringBuffer contents = new StringBuffer();
        contents.append(this.res.getString("Restore_DataBase_Summary") + ":" + RestoreConstants.LINE_SEPARATOR);
        contents.append(this.res.getString("Restore_DataBase_Name") + ": " + this.restoreDBName + "." + RestoreConstants.LINE_SEPARATOR);
        contents.append(this.res.getString("Restore_Time") + ": " + this.rTime + "." + RestoreConstants.LINE_SEPARATOR);
        contents.append(this.res.getString("Restore_Type") + ": " + this.res.getString("OffLine_Backup_Restore") + "." + RestoreConstants.LINE_SEPARATOR);
        contents.append(this.res.getString("Restore_Config_File_Path") + ": " + this.validatePath(this.configFileFullPath) + "." + RestoreConstants.LINE_SEPARATOR);
        contents.append(this.res.getString("Restore_History_File_Path") + ": " + this.validatePath(this.historyFileFullPath) + "." + RestoreConstants.LINE_SEPARATOR);
        this.jTextPane1.setText(contents.toString());
    }

    private String validatePath(String path) {
        String temp1 = path;
        if (temp1.indexOf(32) >= 0 && !temp1.startsWith("\"") && !temp1.endsWith("\"")) {
            temp1 = "\"" + temp1 + "\"";
        }
        return temp1;
    }

    @Override
    public String getTitle() {
        this.title = "Restore_Wizard_Summary";
        return this.title;
    }

    public void finshButtonActionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String rTime = this.rTime;
        String dbName = this.restoreDBName;
        String configFileName = this.configFileFullPath;
        String hisFileName = this.historyFileFullPath;
        String msg = new String();
        byte[] amsg = new byte[1024];
        int returnValue = this.cfun.offlineutrolsvr(0, rTime, dbName, configFileName, hisFileName, amsg);
        msg = new String(amsg).trim();
        String logContents = "";
        int lastIndex = msg.lastIndexOf("\"");
        int lastSecondIndex = msg.lastIndexOf("\"", lastIndex - 1);
        String filePath = msg.substring(lastSecondIndex + 1, lastIndex);
        File file = new File(filePath);
        if (!file.exists()) {
            logContents = "";
        } else {
            try {
                BufferedReader re = new BufferedReader(new FileReader(file));
                String temp = "";
                while (temp != null) {
                    temp = re.readLine();
                    if (temp == null) continue;
                    logContents = logContents + temp + RestoreConstants.LINE_SEPARATOR;
                }
                re.close();
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        if (returnValue == 0) {
            GuiUt.showSuccessDlg(this.parentDlg, msg, logContents);
        } else {
            GuiUt.showErrorDlg(this.parentDlg, msg, logContents);
        }
        this.parentDlg.setVisible(false);
        this.parentDlg.dispose();
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        this.parentDlg.Next(this.previousPanel);
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.parentDlg.dispose();
    }
}

