/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.restore;

import dbaut.GuiUt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class OffBackupListFile {
    private String listFilePath = null;
    private ArrayList records = null;
    private File listFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffBackupListFile(String listFilePath) {
        this.listFile = new File(listFilePath);
        this.listFilePath = listFilePath;
        this.records = new ArrayList();
        BufferedReader br = null;
        try {
            File f = new File(this.listFilePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            br = new BufferedReader(new InputStreamReader(new FileInputStream(this.listFilePath)));
            String aLine = null;
            while ((aLine = br.readLine()) != null) {
                if (!aLine.endsWith("dmOffBK.his")) continue;
                this.records.add(aLine);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getFirstHisPath() {
        if (this.records.size() > 0) {
            return (String)this.records.get(0);
        }
        return null;
    }

    public String getLastHisPath() {
        if (this.records.size() > 0) {
            return (String)this.records.get(this.records.size() - 1);
        }
        return null;
    }

    public int getHisCount() {
        return this.records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendHisPath(String newPath) {
        if (newPath == null || newPath.length() < 0) {
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.listFilePath, true)));
            bw.write(newPath);
            bw.newLine();
            bw.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ArrayList getAllHisPath() {
        return this.records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExistHisPath(String hisPath) {
        for (int i = 0; i < this.records.size(); ++i) {
            String record = (String)this.records.get(i);
            if (GuiUt.isWindows()) {
                if (!hisPath.equalsIgnoreCase(record)) continue;
                this.records.remove(record);
                continue;
            }
            if (!hisPath.equals(record)) continue;
            this.records.remove(record);
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.listFilePath)));
            for (int i = 0; i < this.records.size(); ++i) {
                String record = (String)this.records.get(i);
                bw.write(record);
                bw.newLine();
            }
            bw.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isHisPathExist(String hisPath) {
        String aLine = null;
        for (int i = 0; i < this.records.size(); ++i) {
            aLine = (String)this.records.get(i);
            if (!(GuiUt.isWindows() ? aLine.equalsIgnoreCase(hisPath) : aLine.equals(hisPath))) continue;
            return true;
        }
        return false;
    }

    public boolean isExist() {
        return this.listFile.exists();
    }
}

