/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.renameDB;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.syscom.dm.svrmgr.sca.DefaultSvrmgrAuthority;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.util.PlatformUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import svrmgrwizard.renameDB.RenameDBDlg;
import svrmgrwizard.renameDB.RenameStatus;

public class RenameDatabase
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.ReNameDBRes", LocaleManager.getLocale());
    private String title = this.res.getString("Choose_a_database");
    private RenameDBDlg renamedlg = null;
    private AbstractWizardPanel previous = null;
    private SteppedComboBox combo = new SteppedComboBox();
    private CharField NewDB = new CharField(128, true);
    private DbaButton next_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Next"), 'N', DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"), new ReflectionAction(this, "next_Button_actionPerformed"));

    public RenameDatabase(RenameDBDlg renamedlg, AbstractWizardPanel previous) {
        try {
            this.renamedlg = renamedlg;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setName("RenamePanel");
        this.next_Button.setName("NextButton");
        DbaButton cancel_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancel_Button_actionPerformed"));
        DbaButton back_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "back_Button_actionPerformed"));
        SmHelpButton help_Button = new SmHelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JLabel jlabel3 = new JLabel(this.res.getString("Old_database_name"));
        JLabel jlabel4 = new JLabel(this.res.getString("New_database_name"));
        JLabel jlabel5 = new JLabel(this.res.getString("User_name"));
        JLabel jlabel6 = new JLabel(this.res.getString("Password"));
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Choose_a_database_name"));
        this.renamedlg.setTitle(this.res.getString("Rename_database_wizard"));
        this.next_Button.setHorizontalTextPosition(2);
        this.NewDB.setPreferredSize(new Dimension(220, 28));
        this.combo.setPreferredSize(new Dimension(220, 24));
        this.combo.setName("DatabaseNameComboBox");
        this.NewDB.setName("NewDatabaseNameField");
        this.combo.addActionListener(new ReflectionAction(this, "combo_actionPerformed"));
        jlabel3.setPreferredSize(new Dimension(150, 24));
        jlabel4.setPreferredSize(new Dimension(150, 24));
        jlabel5.setPreferredSize(new Dimension(150, 24));
        jlabel6.setPreferredSize(new Dimension(150, 24));
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(new EmptyPanel());
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        JPanel panel8 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel panel9 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel panel10 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel panel11 = new JPanel(new FlowLayout(0, 0, 0));
        panel8.add(jlabel3);
        panel8.add(this.combo);
        panel9.add(jlabel4);
        panel9.add(this.NewDB);
        panel6.add(panel8);
        panel6.add(panel9);
        this.setImage(DBAImageResource.getResource(this.getClass(), "/svrmgrimages/RenameDB.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        SmFrame.frame.enableDialogHelp(this, help_Button, "wizard_RenameDB_RenameDatabase", null);
        this.NewDB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    RenameDatabase.this.DBName_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                RenameDatabase.this.DBName_keyReleased(e);
            }
        });
        Vector<String> dbnames = JdmConfig.getDatabaseNames("dmconfig.ini", true, false);
        dbnames.insertElementAt(new String("  "), 0);
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>(dbnames);
        this.combo.setModel((ComboBoxModel)comboModel);
        if (this.NewDB.getText().trim().length() <= 0 || this.combo.getSelectedIndex() == 0 || !this.isLegalObjectName(this.NewDB.getText().trim())) {
            this.next_Button.setEnabled(false);
        }
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.renamedlg.Next(this.previous);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        this.renamedlg.newdbname = this.NewDB.getText().trim();
        this.renamedlg.olddbname = (String)this.combo.getSelectedItem();
        RenameStatus status = new RenameStatus(this.renamedlg, this);
        this.renamedlg.Next(status);
    }

    private boolean isUserAuthorized(String dbName, String userName, String password, Window window) {
        boolean result = false;
        try {
            JdmConfig config = new JdmConfig();
            boolean isTerminalServer = config.isTerminalServer(dbName);
            boolean isServerOn = false;
            int rc = config.fileOpen("dmconfig.ini", dbName, "r");
            if (rc != 0) {
                GuiUt.showErrorDlg(window, this.res.getString("Fail_to_open") + " " + dbName, null);
                return result;
            }
            String svr_address = (String)config.getPara("DB_SVADR", 4096);
            Integer svr_portnum = (Integer)config.getPara("DB_PTNUM", 8192);
            config.fileClose();
            if (!isTerminalServer) {
                isServerOn = DatabaseConnection.isServerOn(dbName, userName, password);
            }
            result = isTerminalServer || isServerOn ? this.isRoleValid(dbName, userName, password, window) : this.isRoleValid(dbName, userName, password, svr_address, svr_portnum, window);
        }
        catch (SQLException ex) {
            result = false;
            GuiUt.showSQLException(window, null, ex);
        }
        catch (Exception ex) {
            result = false;
            GuiUt.showErrorDlg(window, ex.getMessage(), null);
        }
        return result;
    }

    private boolean isRoleValid(String dbName, String userName, String password, String svr_address, Integer svr_portnum, Window window) throws Exception {
        boolean result = false;
        try {
            JdmConfig.setTerminalServer(true, dbName, null, null);
            result = this.isRoleValid(dbName, userName, password, window);
        }
        catch (Exception ex) {
            result = false;
            throw ex;
        }
        finally {
            JdmConfig.setTerminalServer(false, dbName, svr_address, svr_portnum);
        }
        return result;
    }

    private boolean isRoleValid(String dbName, String userName, String password, Window window) {
        boolean result = false;
        DatabaseConnection connection = new DatabaseConnection(dbName, userName, password, window);
        if (connection != null && connection.isConnected()) {
            DefaultSvrmgrAuthority authority = new DefaultSvrmgrAuthority(connection);
            if (authority.isAboveDba()) {
                result = true;
            } else {
                authority.errorIsNotDBA(window);
            }
            connection.disconnect();
        }
        return result;
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.renamedlg.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    void DBName_keyReleased(KeyEvent e) {
        if (this.NewDB.getText().trim().length() > 0 && this.combo.getSelectedIndex() != 0) {
            if (this.isLegalObjectName(this.NewDB.getText().trim())) {
                this.next_Button.setEnabled(true);
            } else {
                this.next_Button.setEnabled(false);
            }
        } else {
            this.next_Button.setEnabled(false);
        }
    }

    boolean isLegalObjectName(String inStr) {
        boolean b = true;
        int size = inStr.length();
        char[] ar = new char[size];
        inStr.getChars(0, size, ar, 0);
        for (int i = 0; i < size; ++i) {
            if (ar[i] >= 'A' && ar[i] < '[' || ar[i] >= 'a' && ar[i] < '{' || ar[i] == '_' || i >= 0 && ar[i] >= '0' && ar[i] <= '9') continue;
            b = false;
            break;
        }
        return b;
    }

    public void combo_actionPerformed(ActionEvent e) {
        this.DBName_keyReleased(null);
        if (this.combo.getSelectedIndex() != 0) {
            String string = (String)this.combo.getSelectedItem();
        }
    }
}

