/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.diagnoseDB;

import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.CheckingStatusRenderer;
import dbaut.CommonUt.ColumnTableModel;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.alarm.Sleeper;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import svrmgrwizard.diagnoseDB.Alarm;
import svrmgrwizard.diagnoseDB.ProcessPanel;
import svrmgrwizard.diagnoseDB.RepairTableDialog;
import svrmgrwizard.diagnoseDB.RepairedTable;

public class CheckBasicSystemTable
extends AbstractWizardPanel
implements ProcessPanel,
Sleeper {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.DiagnoseRes", LocaleManager.getLocale());
    private String title = this.res.getString("wizard_title3");
    private RepairTableDialog redlg = null;
    private AbstractWizardPanel next1 = null;
    private AbstractWizardPanel previous = null;
    private ColumnTableModel model = new ColumnTableModel(new String[]{this.res.getString("Status"), this.res.getString("Check_statement"), this.res.getString("Message")});
    private JTable jtable = new JTable(this.model);
    private Alarm clock = null;
    private int statusCount = 0;
    private DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
    private DbaButton next_Button = new DbaButton(this.res.getString("Next"), 'N', new ReflectionAction(this, "next_Button_actionPerformed"));

    public CheckBasicSystemTable(RepairTableDialog redlg, AbstractWizardPanel previous) {
        try {
            this.redlg = redlg;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setName("CheckBasicSystemTablePanel");
        this.next_Button.setName("NextButton");
        DbaButton back_Button = new DbaButton(this.res.getString("Previous"), 'P', new ReflectionAction(this, "back_Button_actionPerformed"));
        SmHelpButton help_Button = new SmHelpButton();
        JPanel panel1 = new JPanel(new BorderLayout(10, 0));
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel(new BorderLayout());
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Before_any_repair_operation"));
        JScrollPane jscroll2 = new JScrollPane(this.jtable);
        this.next_Button.setHorizontalTextPosition(2);
        back_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"));
        this.next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"));
        this.cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        jscroll2.setBorder(null);
        jscroll2.setPreferredSize(new Dimension(300, 80));
        jscroll2.setVerticalScrollBarPolicy(20);
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(new EmptyPanel());
        panel4.add(this.cancel_Button);
        panel4.add(help_Button);
        panel6.add((Component)jscroll2, "Center");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/svrmgrimages/DiagnoseDB.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        this.next_Button.setEnabled(false);
        this.cancel_Button.setEnabled(false);
        SmFrame.frame.enableDialogHelp(this, help_Button, "wizard_DiagnoseDB_CheckBasicSystemTable", null);
        TableColumnModel tcmodel = this.jtable.getColumnModel();
        TableColumn col = tcmodel.getColumn(0);
        col.setPreferredWidth(5);
        col.setCellRenderer(new CheckingStatusRenderer());
        tcmodel.getColumn(1).setPreferredWidth(200);
        tcmodel.getColumn(2).setPreferredWidth(200);
        this.model.addValue(new Object[]{new Integer(0), "CHECK CATALOG BASIC", ""});
        this.model.addValue(new Object[]{new Integer(0), "CHECK TABLESPACE SYSTABLESPACE EXPRESS", ""});
        this.model.addValue(new Object[]{new Integer(0), "CHECK TABLE SYSTEM.SYSTABLESPACE", ""});
        this.model.addValue(new Object[]{new Integer(0), "CHECK TABLE SYSTEM.SYSTABLE", ""});
    }

    private String executeSQL(Statement stmt, String query) {
        this.redlg.log.append(query);
        try {
            stmt.execute(query);
            this.redlg.log.append(" --> OK " + this.redlg.endline);
            return null;
        }
        catch (SQLException sqle) {
            this.redlg.log.append(" --> FAIL " + this.redlg.endline);
            String msg = "";
            for (SQLException e = sqle; e != null; e = e.getNextException()) {
                this.redlg.log.append(e.getMessage() + this.redlg.endline);
                msg = msg + " " + e.getMessage();
            }
            return msg;
        }
    }

    private void setStatus(int status, int row) {
        this.model.setValueAt(new Integer(status), row, 0);
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    @Override
    public void procStart() {
        String query = null;
        Statement stmt = null;
        Object rs = null;
        int i = 0;
        try {
            stmt = this.redlg.conn.getDbConnection().createStatement();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this.redlg, this.res.getString("CreateStatement_error"), sqle);
            this.cancel_Button.setEnabled(true);
            return;
        }
        String errormsg = null;
        int size = this.model.getRowCount();
        for (i = 0; i < size; ++i) {
            this.setStatus(1, i);
            query = (String)this.model.getValueAt(i, 1);
            errormsg = this.executeSQL(stmt, query);
            if (errormsg == null) {
                this.model.setValueAt(this.res.getString("Check_ok"), i, 2);
                this.setStatus(2, i);
                continue;
            }
            if (i == 2) {
                errormsg = this.executeSQL(stmt, "rebuild index TS_NAME for SYSTEM.SYSTABLESPACE");
                if (errormsg == null) {
                    errormsg = this.executeSQL(stmt, query);
                }
            } else if (i == 3 && (errormsg = this.executeSQL(stmt, "rebuild index TABLE_OWNER for SYSTEM.SYSTABLE")) == null) {
                errormsg = this.executeSQL(stmt, query);
            }
            if (errormsg == null) {
                this.setStatus(2, i);
                continue;
            }
            this.model.setValueAt(this.res.getString("Serious_error_found"), i, 2);
            this.setStatus(4, i);
            GuiUt.showErrorDlg(this.redlg, this.res.getString("Serious_found_diagnose_connot"), errormsg);
            DbaObject.close(stmt);
            this.cancel_Button.setEnabled(true);
            return;
        }
        if (DbaObject.close(stmt)) {
            this.next_Button.setEnabled(true);
            this.cancel_Button.setEnabled(true);
        }
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.redlg.Next(this.previous);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        if (this.next1 == null) {
            this.next1 = new RepairedTable(this.redlg, this);
        }
        this.redlg.Next(this.next1);
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.redlg.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public synchronized void wakeUp() {
        if (this.statusCount < this.model.getRowCount()) {
            this.model.setValueAt(new Integer(2), this.statusCount, 0);
            this.model.fireTableChanged(new TableModelEvent(this.model));
            ++this.statusCount;
            this.setTimer();
        } else {
            this.next_Button.setEnabled(true);
            this.cancel_Button.setEnabled(true);
        }
    }

    public void setTimer() {
        this.clock.cancelAlarm(this);
        this.clock.setAlarm(this, 1L);
    }
}

