/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.backup;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.DbaObject;
import dbaut.DbaUtDef;
import dbaut.FullBackupFile;
import dbaut.GuiUt;
import dbaut.JBackupHistory;
import dbaut.JdmConfig;
import dbaut.String_array;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaTable;
import dbaut.comp.ProgressDialog;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.system.BackupFile;
import dbaut.textField.FilePathField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import svrmgrwizard.backup.BackupConstants;
import svrmgrwizard.backup.BackupDlg;
import svrmgrwizard.backup.FullBackupTableModel;
import svrmgrwizard.backup.exception.CopyFileErrorException;
import svrmgrwizard.backup.exception.DeleteFileFailedException;
import svrmgrwizard.backup.exception.UserCancelException;
import svrmgrwizard.restore.OffBackupListFile;

public class OfflineFullBackupPanel
extends AbstractWizardPanel {
    private static final long serialVersionUID = 6221383963933156031L;
    public static final short LOGICAL_NAME = 0;
    public static final short PHYSICAL_NAME = 1;
    public static final short DESTINATION = 2;
    public static final short FILE_TYPE = 3;
    public static final short DATA_FILE = 0;
    public static final short JOURNAL_FILE = 1;
    private BackupDlg parentDialog = null;
    private AbstractWizardPanel previousPanel = null;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.BackupRes", LocaleManager.getLocale());
    private String title = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(80, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton finishButton = new DbaButton(new Dimension(80, 24), this.res.getString("Finish"), 'F', DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"), new ReflectionAction(this, "finishButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(80, 24), this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private JLabel backupDestinationLabel = new JLabel(this.res.getString("Backup_Directory_Colon"));
    private FilePathField backupDestinationField = new FilePathField(this, "", this.res.getString("Select_Path"), true);
    private FullBackupTableModel model = new FullBackupTableModel();
    private DbaTable table = new DbaTable(this.model);
    private DatabaseConnection connection = null;
    private ArrayList info = null;
    private String db_bkdir = null;
    private String dbName = null;
    private boolean isTerminalServer = false;
    private boolean isServerOn = false;
    private String svr_address = null;
    private Integer svr_portnum = null;
    private Integer db_bkzip = null;
    private int option = -1;

    public OfflineFullBackupPanel(BackupDlg parentDialog, AbstractWizardPanel previousPanel, DatabaseConnection connection, ArrayList info) {
        this.parentDialog = parentDialog;
        this.previousPanel = previousPanel;
        this.connection = connection;
        this.info = info;
        if (this.info.size() <= 0) {
            System.out.println("No connection information." + this.getClass().getName());
            return;
        }
        this.dbName = (String)this.info.get(0);
        this.isTerminalServer = (Boolean)this.info.get(3);
        this.isServerOn = (Boolean)this.info.get(4);
        this.svr_address = (String)this.info.get(5);
        this.svr_portnum = (Integer)this.info.get(6);
        this.db_bkzip = (Integer)this.info.get(7);
        this.init();
    }

    private void init() {
        this.setName("OfflineFullBackupPanel");
        this.finishButton.setName("FinishButton");
        JPanel jPanel1 = new JPanel();
        jPanel1.setPreferredSize(new Dimension(640, 440));
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jPanel1.setLayout(new BorderLayout());
        JPanel destinationPanel = new JPanel(new FlowLayout(0));
        destinationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Destination"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.backupDestinationField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.backupDestinationField.setPreferredSize(new Dimension(440, 24));
        this.backupDestinationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfflineFullBackupPanel.this.backupDestinationFieldKeyReleased();
            }
        });
        destinationPanel.add(this.backupDestinationLabel);
        destinationPanel.add(this.backupDestinationField);
        JPanel tableContentsPanel = new JPanel(new BorderLayout());
        tableContentsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Backup_Contents"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JScrollPane tableContentsScrollPane = new JScrollPane();
        tableContentsScrollPane.setBorder(BorderFactory.createEtchedBorder());
        tableContentsScrollPane.getViewport().add(this.table);
        tableContentsPanel.add(tableContentsScrollPane);
        jPanel1.add((Component)destinationPanel, "North");
        jPanel1.add((Component)tableContentsPanel, "Center");
        this.add((Component)jPanel1, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.finishButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Help_Backup_OfflineFullBackupPanel", null);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.finishButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        this.setButtonBar(buttonPanel);
        this.initBackupDir();
        this.initColumnSizes(this.table);
        this.initTableContents();
        this.setFinishButtonStatus();
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(200);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(300);
    }

    private void backupDestinationFieldKeyReleased() {
        this.table.editingStopped(null);
        String current_bkdir = this.backupDestinationField.getText();
        if (current_bkdir.endsWith(BackupConstants.FILE_SEPARATOR)) {
            current_bkdir = current_bkdir.substring(0, current_bkdir.length() - 1);
        }
        if (!current_bkdir.equals(this.db_bkdir)) {
            String bk_file = null;
            for (int j = 0; j < this.model.getRowCount(); ++j) {
                bk_file = (String)this.model.getValueAt(j, 2);
                bk_file = this.replacePath(bk_file, this.db_bkdir, current_bkdir);
                this.model.setValueAt(bk_file, j, 2);
            }
            this.model.fireTableChanged(new TableModelEvent(this.model));
            this.db_bkdir = current_bkdir;
        }
        String onlineBkDir = JdmConfig.getOnlineBackupDir(this.dbName);
        if (GuiUt.isWindows()) {
            if (current_bkdir.equalsIgnoreCase(onlineBkDir)) {
                GuiUt.showWarningDlg(this.parentDialog, this.res.getString("Warning"), this.res.getString("You_had_better_do_not_use_default_online_backup_dir_excalmatorymark"));
            }
        } else if (current_bkdir.equals(onlineBkDir)) {
            GuiUt.showWarningDlg(this.parentDialog, this.res.getString("Warning"), this.res.getString("You_had_better_do_not_use_default_online_backup_dir_excalmatorymark"));
        }
        this.setFinishButtonStatus();
    }

    private String replacePath(String filename, String origPath, String replacePath) {
        int i = filename.lastIndexOf(BackupConstants.FILE_SEPARATOR);
        String temp = filename.substring(0, i);
        if (temp.equals(origPath)) {
            return replacePath + filename.substring(i);
        }
        return filename;
    }

    private void initTableContents() {
        this.getDmConfigBackupInfo("dmconfig.ini");
        this.getDataFileBackupInfo(this.db_bkzip);
        this.getJournalFileBackupInfo(this.dbName, this.db_bkzip);
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void initBackupDir() {
        this.db_bkdir = JdmConfig.getOfflineBackupDir(this.dbName);
        this.backupDestinationField.setText(this.db_bkdir);
    }

    private String getFullBackupFileName(String fileName) {
        long nowMillis = System.currentTimeMillis();
        fileName = "F" + nowMillis + "_" + fileName;
        return fileName;
    }

    private void getDmConfigBackupInfo(String fileName) {
        JdmConfig dmConfig = new JdmConfig();
        String dmConfigFilePath = dmConfig.filePath(fileName);
        String tmpFileName = null;
        if (dmConfigFilePath != null && dmConfigFilePath.length() > 0) {
            int index = dmConfigFilePath.lastIndexOf(BackupConstants.FILE_SEPARATOR);
            tmpFileName = dmConfigFilePath.substring(index + 1);
        }
        Object[] one_row = new Object[]{"CONFIG", dmConfigFilePath, this.db_bkdir + BackupConstants.FILE_SEPARATOR + tmpFileName, new Short(0)};
        this.model.addValue(one_row);
    }

    private void getDataFileBackupInfo(int db_bkzip) {
        String temp = null;
        Statement stmt = null;
        try {
            stmt = this.connection.dbconn.createStatement();
            String query = "select FILE_NAME, GETFILENAME(FILE_NAME) from SYSTEM.SYSFILE where FILE_NAME not in ('SYSJNL', 'DB_TMPDB', 'DB_TMPBB')";
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                Object[] one_row = new Object[4];
                temp = rs.getString(1);
                one_row[0] = rs.wasNull() ? "" : temp.trim();
                temp = rs.getString(2);
                String physical_name = rs.wasNull() ? "" : temp.trim();
                one_row[1] = physical_name;
                int index = physical_name.lastIndexOf(BackupConstants.FILE_SEPARATOR);
                if (index > 0) {
                    physical_name = new String(physical_name.substring(index + BackupConstants.FILE_SEPARATOR_LEN));
                }
                String tmpDes = null;
                tmpDes = this.db_bkdir + BackupConstants.FILE_SEPARATOR + physical_name;
                if (db_bkzip == 1) {
                    tmpDes = tmpDes + ".gz";
                }
                one_row[2] = tmpDes;
                one_row[3] = new Short(0);
                this.model.addValue(one_row);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this, null, sqle);
            DbaObject.close(stmt);
        }
    }

    private void getJournalFileBackupInfo(String dbName, int db_bkzip) {
        String dbDir = JdmConfig.getDBDir(dbName);
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", dbName, "r");
        if (rc != 0) {
            return;
        }
        String_array files = (String_array)config.getPara("DB_JNFIL", 53504);
        config.fileClose();
        for (int i = 0; i < files.size(); ++i) {
            String str = files.content[i];
            if (str.length() == 0) continue;
            int g = str.lastIndexOf(BackupConstants.FILE_SEPARATOR);
            String filename = g >= 0 ? new String(str.substring(g + 1)) : str;
            Object[] one_row = new Object[4];
            one_row[0] = "SYSJNL";
            one_row[1] = g >= 0 ? str : dbDir + BackupConstants.FILE_SEPARATOR + filename;
            String tmpDes = null;
            tmpDes = this.db_bkdir + BackupConstants.FILE_SEPARATOR + filename;
            if (db_bkzip == 1) {
                tmpDes = tmpDes + ".gz";
            }
            one_row[2] = tmpDes;
            one_row[3] = new Short(1);
            this.model.addValue(one_row);
        }
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        this.parentDialog.next(this.previousPanel);
    }

    public void finishButtonActionPerformed(ActionEvent e) {
        int rowCount = this.model.getRowCount();
        String fileFullPath = null;
        File tmpFile = null;
        long len = 0L;
        for (int i = 0; i < rowCount; ++i) {
            fileFullPath = (String)this.model.getValueAt(i, 1);
            tmpFile = new File(fileFullPath);
            len += tmpFile.length();
        }
        final long totalLen = len;
        Thread t1 = new Thread(){

            @Override
            public void run() {
                OfflineFullBackupPanel.this.runBackupTask(totalLen);
            }
        };
        t1.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBackupTask(long len) {
        this.disConnectionAndRestoreDmConfig();
        final ProgressDialog progressDialog = new ProgressDialog(this.parentDialog, this.res.getString("Offline_Full_Backup"));
        JBackupHistory hist = null;
        BackupFile bf = null;
        try {
            int rc;
            this.table.editingStopped(null);
            String backupDir = this.backupDestinationField.getText().trim();
            File file = new File(backupDir);
            this.cleanBackupFile(file);
            if (!file.exists()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        OfflineFullBackupPanel.this.option = GuiUt.showOptionDlg(OfflineFullBackupPanel.this.parentDialog, OfflineFullBackupPanel.this.res.getString("Create_Directory"), OfflineFullBackupPanel.this.res.getString("Do_You_Want_Create_Backup_Directory_QuestionMark"));
                    }
                });
                if (this.option == 0) {
                    boolean isMkDirsSuccessful = file.mkdirs();
                    if (!isMkDirsSuccessful) {
                        System.out.println("Create backup dir failed!");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GuiUt.showErrorDlg(OfflineFullBackupPanel.this.parentDialog, OfflineFullBackupPanel.this.res.getString("Create_Backup_Directory_Failed_FullStop"), "");
                            }
                        });
                        return;
                    }
                } else {
                    return;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressDialog.show();
                }
            });
            bf = new BackupFile();
            String logical_name = null;
            String db_file = null;
            String dest_file = null;
            File tmpFile = null;
            long fileLen = -1L;
            long workLen = -1L;
            int rowCount = this.model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                logical_name = (String)this.model.getValueAt(i, 0);
                db_file = (String)this.model.getValueAt(i, 1);
                tmpFile = new File(db_file);
                fileLen = tmpFile.length();
                workLen += fileLen;
                dest_file = (String)this.model.getValueAt(i, 2);
                if (logical_name.equalsIgnoreCase("CONFIG")) {
                    rc = JdmConfig.copyDBSection(db_file, dest_file, this.dbName);
                    if (rc != 0) {
                        throw new CopyFileErrorException(this.res.getString("copy_dbsection_failed_excalmatorymark"));
                    }
                } else {
                    boolean isSuccessful = bf.copyFile(db_file, dest_file);
                    if (!isSuccessful) {
                        throw new CopyFileErrorException(bf.copyFileErrorMessage);
                    }
                }
                int percent = (int)((double)workLen / (double)len * 100.0);
                progressDialog.setProgressBarValue(percent);
                if (!progressDialog.isCanceling()) continue;
                ProgressDialog.sem.semaphoreWait();
                progressDialog.setIsCanceling(false);
                if (!progressDialog.isUserCanceled()) continue;
                throw new UserCancelException();
            }
            hist = new JBackupHistory(SmFrame.frame);
            String offBackupHisFileFullPath = null;
            offBackupHisFileFullPath = backupDir.endsWith(BackupConstants.FILE_SEPARATOR) ? backupDir + "dmOffBK.his" : backupDir + BackupConstants.FILE_SEPARATOR + "dmOffBK.his";
            rc = hist.FileOpen(this.dbName, offBackupHisFileFullPath, "1");
            if (rc != DbaUtDef.RTN_OK) {
                System.out.println("Error open backup history file " + offBackupHisFileFullPath + ". And err no = " + rc);
                throw new UserCancelException();
            }
            int isSetBackupDataSuccessful = -1;
            for (int i = 0; i < rowCount; ++i) {
                logical_name = (String)this.model.getValueAt(i, 0);
                db_file = (String)this.model.getValueAt(i, 1);
                dest_file = (String)this.model.getValueAt(i, 2);
                isSetBackupDataSuccessful = i == 0 ? hist.setBackupData(0, 1, db_file, logical_name, dest_file, 1) : (i == rowCount - 1 ? hist.setBackupData(0, 1, db_file, logical_name, dest_file, 2) : hist.setBackupData(0, 1, db_file, logical_name, dest_file, 0));
                if (isSetBackupDataSuccessful == 0) continue;
                throw new UserCancelException();
            }
            String bkdir = JdmConfig.getOnlineBackupDir(this.dbName);
            String dmOffBKListPath = bkdir + BackupConstants.FILE_SEPARATOR + "dmOffBK.lst";
            OffBackupListFile listFile = new OffBackupListFile(dmOffBKListPath);
            listFile.appendHisPath(offBackupHisFileFullPath);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressDialog.setVisible(false);
                    progressDialog.dispose();
                    GuiUt.showInformationDlg(OfflineFullBackupPanel.this.parentDialog, OfflineFullBackupPanel.this.res.getString("Backup_Successfully_FullStop"));
                    OfflineFullBackupPanel.this.cancelButtonActionPerformed(null);
                }
            });
        }
        catch (UserCancelException ex1) {
            System.out.println("User canceled.");
            this.clean(progressDialog);
        }
        catch (CopyFileErrorException e) {
            System.out.println("Copy file error.");
            this.clean(progressDialog, e.getMessage());
        }
        catch (DeleteFileFailedException e) {
            final String message = e.getMessage();
            System.out.println(message);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiUt.showErrorDlg(OfflineFullBackupPanel.this.parentDialog, message, "");
                }
            });
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted exception.");
            this.clean(progressDialog);
        }
        catch (InvocationTargetException e) {
            System.out.println("Invocation target exception.");
            this.clean(progressDialog);
        }
        finally {
            if (hist != null) {
                hist.FileClose();
            }
        }
    }

    private void clean(final ProgressDialog progressDialog) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
                OfflineFullBackupPanel.this.cancelButtonActionPerformed(null);
            }
        });
        try {
            this.cleanBackupFile();
        }
        catch (DeleteFileFailedException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void clean(final ProgressDialog progressDialog, final String str) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
                GuiUt.showErrorDlg(OfflineFullBackupPanel.this.parentDialog, str, "");
                OfflineFullBackupPanel.this.cancelButtonActionPerformed(null);
            }
        });
        try {
            this.cleanBackupFile();
        }
        catch (DeleteFileFailedException e1) {
            System.out.println(e1.getMessage());
            e1.printStackTrace();
        }
    }

    private void cleanBackupFile() throws DeleteFileFailedException {
        String dest_file = null;
        File desFile = null;
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            dest_file = (String)this.model.getValueAt(i, 2);
            desFile = new File(dest_file);
            if (!desFile.exists() || desFile.delete()) continue;
            throw new DeleteFileFailedException(desFile.getAbsolutePath());
        }
    }

    private void cleanBackupFile(File backupDir) throws DeleteFileFailedException, InterruptedException, InvocationTargetException, UserCancelException {
        File backupLogFile;
        if (!backupDir.exists()) {
            return;
        }
        String absolutePath = backupDir.getAbsolutePath();
        if (!absolutePath.endsWith(BackupConstants.FILE_SEPARATOR)) {
            absolutePath = absolutePath + BackupConstants.FILE_SEPARATOR;
        }
        if (!(backupLogFile = new File(absolutePath + "dmOffBK.his")).exists()) {
            return;
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                OfflineFullBackupPanel.this.option = GuiUt.showOptionDlg(OfflineFullBackupPanel.this.parentDialog, OfflineFullBackupPanel.this.res.getString("Replace_File"), OfflineFullBackupPanel.this.res.getString("Replace_The_Existing_Files_QuestionMark"));
            }
        });
        if (this.option != 0) {
            throw new UserCancelException();
        }
        JBackupHistory hist = new JBackupHistory(SmFrame.frame);
        int rc = hist.FileOpen(this.dbName, backupLogFile.getAbsolutePath(), "0");
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("Error open offline backup history file " + backupLogFile.getAbsolutePath() + ".And err no = " + rc);
            return;
        }
        FullBackupFile fullBackupFile = null;
        String str = null;
        File tmpFile = null;
        Vector fullBackupList = hist.getFullBackupList();
        for (int i = 0; i < fullBackupList.size(); ++i) {
            Vector fullBackupInfo = hist.getFullBackupInfo(i + 1);
            for (int j = 0; j < fullBackupInfo.size(); ++j) {
                fullBackupFile = (FullBackupFile)fullBackupInfo.get(j);
                str = fullBackupFile.getBackupFile();
                tmpFile = new File(str);
                if (!tmpFile.exists() || tmpFile.delete()) continue;
                String str1 = tmpFile.getAbsolutePath();
                throw new DeleteFileFailedException(str1);
            }
        }
        Vector diffBackupList = hist.getDiffBackupList();
        for (int i = 0; i < diffBackupList.size(); ++i) {
            Vector diffBackupInfo = hist.getDiffBackupInfo(i + 1);
            for (int j = 0; j < diffBackupInfo.size(); ++j) {
                fullBackupFile = (FullBackupFile)diffBackupInfo.get(j);
                str = fullBackupFile.getBackupFile();
                tmpFile = new File(str);
                if (!tmpFile.exists() || tmpFile.delete()) continue;
                String str1 = tmpFile.getAbsolutePath();
                throw new DeleteFileFailedException(str1);
            }
        }
        hist.FileClose();
        if (!backupLogFile.delete()) {
            String str1 = backupLogFile.getAbsolutePath();
            throw new DeleteFileFailedException(str1);
        }
        String bkdir = JdmConfig.getOnlineBackupDir(this.dbName);
        String dmOffBKListPath = bkdir + BackupConstants.FILE_SEPARATOR + "dmOffBK.lst";
        OffBackupListFile listFile = new OffBackupListFile(dmOffBKListPath);
        if (!listFile.isExist()) {
            System.out.println("dmOffBK.lst file not found!");
            return;
        }
        listFile.removeExistHisPath(backupLogFile.getAbsolutePath());
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        this.disConnectionAndRestoreDmConfig();
        this.parentDialog.setVisible(false);
        this.parentDialog.dispose();
    }

    @Override
    public void windowClosing() {
        this.cancelButtonActionPerformed(null);
    }

    private void disConnectionAndRestoreDmConfig() {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        if (!this.isTerminalServer && !this.isServerOn) {
            JdmConfig.setTerminalServer(false, this.dbName, this.svr_address, this.svr_portnum);
        }
    }

    @Override
    public String getTitle() {
        this.title = "Offline_Full_Backup";
        return this.title;
    }

    private void setFinishButtonStatus() {
        if (this.backupDestinationField.getText() == null || this.backupDestinationField.getText().trim().length() == 0) {
            this.finishButton.setEnabled(false);
        } else {
            this.finishButton.setEnabled(true);
        }
    }
}

