/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import monitor.AddItemDialog;
import monitor.DataObject;
import monitor.DataSet;
import monitor.DataTableModel;
import monitor.LineDialog;
import monitor.LineRenderer;
import monitor.MonitorFrame;
import monitor.ProportionObject;
import monitor.TablePopupMenu;

public class TablePanel
extends JPanel
implements LocaleChangeListener {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", LocaleManager.getLocale());
    private DataSet dataset = null;
    JScrollPane jScrollPane1 = new JScrollPane();
    DataTableModel model = null;
    static JTable table = null;
    static JLabel timeLabel;
    DbaButton Object_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("TablePanel_Line"), 'O', DBAImageResource.getResource(this.getClass(), "/monitorimages/line.gif"), new ReflectionAction(this, "Object_Button_actionPerformed"));
    DbaButton Delete_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("TablePanel_Delete"), 'D', DBAImageResource.getResource(this.getClass(), "/monitorimages/delete.gif"), new ReflectionAction(this, "Delete_Button_actionPerformed"));
    DbaButton Add_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("TablePanel_Add"), 'A', DBAImageResource.getResource(this.getClass(), "/monitorimages/add.gif"), new ReflectionAction(this, "Add_Button_actionPerformed"));
    JLabel serverTimeLabel = new JLabel();

    public TablePanel(DataSet dataset) {
        this.dataset = dataset;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
        JToolBar jToolBar1 = new JToolBar();
        this.model = new DataTableModel(this.dataset);
        table = new JTable(this.model);
        this.setLayout(new BorderLayout());
        this.Add_Button.setEnabled(false);
        jToolBar1.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TablePanel.this.table_mousePressed(e);
            }
        });
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TablePanel.this.jScrollPane1_mousePressed(e);
            }
        });
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)jToolBar1, "North");
        jToolBar1.add((Component)this.Add_Button, null);
        jToolBar1.add((Component)this.Delete_Button, null);
        jToolBar1.add((Component)this.Object_Button, null);
        JPanel tmpPanel = new JPanel(new BorderLayout());
        JPanel tmpPanelx = new JPanel(new BorderLayout());
        JPanel tmpPanely = new JPanel();
        tmpPanely.setMaximumSize(new Dimension(145, 24));
        tmpPanely.setMinimumSize(new Dimension(145, 24));
        tmpPanely.setPreferredSize(new Dimension(145, 24));
        timeLabel = new JLabel(this.res.getString("Server_Time") + " ");
        tmpPanel.add((Component)timeLabel, "West");
        tmpPanel.add((Component)this.serverTimeLabel, "Center");
        tmpPanelx.add((Component)tmpPanely, "West");
        tmpPanelx.add((Component)tmpPanel, "Center");
        jToolBar1.add(tmpPanelx);
        this.jScrollPane1.getViewport().add((Component)table, null);
        table.getColumnModel().getColumn(0).setCellRenderer(new LineRenderer());
        this.initColumnSizes(table);
        this.Object_Button.setEnabled(false);
        this.Delete_Button.setEnabled(false);
        table.setSelectionMode(0);
    }

    public void Add_Button_actionPerformed(ActionEvent e) {
        AddItemDialog dlg = null;
        dlg = GuiUt.isWindows() ? new AddItemDialog(MonitorFrame.frame) : new AddItemDialog(MonitorFrame.frame, "", true);
        GuiUt.setCenterLocation(MonitorFrame.frame, dlg);
        dlg.show();
        if (dlg.result != null) {
            this.dataset.addItem(dlg.result);
            MonitorFrame.frame.calculateCaptoinSize();
            dlg.result.update();
            MonitorFrame.frame.isDataRefresh = true;
            this.dataset.setTimer();
            if (dlg.result.proportion.toString().equals(this.res.getString("auto"))) {
                dlg.result.proportion = this.adjustProportion(dlg.result, this.dataset);
            }
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
        MonitorFrame.frame.repaint();
    }

    public ProportionObject adjustProportion(DataObject obj, DataSet dataset) {
        long max;
        long min = 0L;
        long tmp = 0L;
        min = max = obj.t[0];
        for (int i = 1; i < 60; ++i) {
            tmp = obj.t[i];
            if (tmp > max) {
                max = tmp;
            }
            if (tmp >= min) continue;
            min = tmp;
        }
        if (max > (long)dataset.rangehi && max - (long)dataset.rangehi - ((long)dataset.rangelow - min) > 0L) {
            double trueProportionValue = 1.0;
            int count = 0;
            for (int i = 0; i < 4 && !((double)max * trueProportionValue < (double)dataset.rangehi); ++i) {
                trueProportionValue = Math.pow(0.1, count + 1);
                ++count;
            }
            obj.proportion.d = trueProportionValue;
            switch (count) {
                case 0: {
                    obj.proportion.s = " 1 : 1 ";
                    break;
                }
                case 1: {
                    obj.proportion.s = " 1 : 0.1 ";
                    break;
                }
                case 2: {
                    obj.proportion.s = " 1 : 0.01 ";
                    break;
                }
                case 3: {
                    obj.proportion.s = " 1 : 0.001 ";
                    break;
                }
                case 4: {
                    obj.proportion.s = " 1 : 0.0001 ";
                }
            }
        } else if (min < (long)dataset.rangelow) {
            double trueProportionValue = 1.0;
            int count = 0;
            for (int i = 0; i < 4 && !((double)min * trueProportionValue < (double)dataset.rangelow); ++i) {
                trueProportionValue = Math.pow(10.0, count + 1);
                ++count;
            }
            obj.proportion.d = trueProportionValue;
            switch (count) {
                case 0: {
                    obj.proportion.s = " 1 : 1 ";
                    break;
                }
                case 1: {
                    obj.proportion.s = " 1 : 10 ";
                    break;
                }
                case 2: {
                    obj.proportion.s = " 1 : 100 ";
                    break;
                }
                case 3: {
                    obj.proportion.s = " 1 : 1000 ";
                    break;
                }
                case 4: {
                    obj.proportion.s = " 1 : 10000 ";
                }
            }
        } else if (max <= 0L) {
            obj.proportion.d = 1.0;
            obj.proportion.s = " 1 : 1 ";
        } else if (max * 10000L < (long)dataset.rangehi) {
            obj.proportion.d = 10000.0;
            obj.proportion.s = " 1 : 10000 ";
        } else if (max * 1000L < (long)dataset.rangehi) {
            obj.proportion.d = 1000.0;
            obj.proportion.s = " 1 : 1000 ";
        } else if (max * 100L < (long)dataset.rangehi) {
            obj.proportion.d = 100.0;
            obj.proportion.s = " 1 : 100 ";
        } else if (max * 10L < (long)dataset.rangehi) {
            obj.proportion.d = 10.0;
            obj.proportion.s = " 1 : 10 ";
        } else {
            obj.proportion.d = 1.0;
            obj.proportion.s = " 1 : 1 ";
        }
        return obj.proportion;
    }

    public void table_valueChanged(ListSelectionEvent e) {
        boolean enable = table.getSelectedRow() >= 0;
        this.Delete_Button.setEnabled(enable);
        this.Object_Button.setEnabled(enable);
    }

    public void Delete_Button_actionPerformed(ActionEvent e) {
        this.dataset.removeItem(table.getSelectedRow());
        this.model.fireTableChanged(new TableModelEvent(this.model));
        MonitorFrame.frame.isDataRefresh = true;
        MonitorFrame.frame.repaint();
    }

    public void Object_Button_actionPerformed(ActionEvent e) {
        DataObject current = (DataObject)this.model.getValueAt(table.getSelectedRow(), 0);
        LineDialog dlg = null;
        dlg = GuiUt.isWindows() ? new LineDialog((Frame)MonitorFrame.frame, current) : new LineDialog((Frame)MonitorFrame.frame, "", true, current);
        GuiUt.setCenterLocation(MonitorFrame.frame, dlg);
        dlg.show();
        if (dlg.result != null) {
            current.color = dlg.result.color;
            current.linewidth = dlg.result.linewidth;
            current.proportion = dlg.result.proportion.toString().equals(this.res.getString("auto")) ? this.adjustProportion(dlg.current, this.dataset) : dlg.result.proportion;
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
        MonitorFrame.frame.repaint();
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(40);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(80);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(420);
        column = table.getColumnModel().getColumn(3);
        column.setPreferredWidth(100);
    }

    void table_mousePressed(MouseEvent e) {
        if (table.isEnabled()) {
            if (e.getModifiers() == 4) {
                int row = table.rowAtPoint(new Point(e.getX(), e.getY()));
                table.setRowSelectionInterval(row, row);
                TablePopupMenu tablePopupMenu = new TablePopupMenu(this, 1);
                tablePopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    void jScrollPane1_mousePressed(MouseEvent e) {
        if (this.jScrollPane1.isEnabled()) {
            if (e.getModifiers() == 4) {
                TablePopupMenu tablePopupMenu = new TablePopupMenu(this, 2);
                tablePopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e == null ? DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", LocaleManager.getLocale()) : DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", e.getLocale());
        this.Object_Button.setText(this.res.getString("TablePanel_Line"));
        this.Delete_Button.setText(this.res.getString("TablePanel_Delete"));
        this.Add_Button.setText(this.res.getString("TablePanel_Add"));
        timeLabel.setText(this.res.getString("Server_Time") + " ");
    }
}

