/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import monitor.DataObject;

public class LineRenderer
extends JPanel
implements TableCellRenderer,
ListCellRenderer {
    private DataObject obj = null;

    public LineRenderer() {
        this.setBorder(null);
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(10, 24));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.obj = value instanceof DataObject ? (DataObject)value : null;
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        return this;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.obj = value instanceof DataObject ? (DataObject)value : null;
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setBackground(list.getBackground());
        }
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.obj != null) {
            Insets insets = this.getInsets();
            int currentWidth = this.getWidth() - insets.left - insets.right;
            int currentHeight = this.getHeight() - insets.top - insets.bottom;
            int center = insets.top + currentHeight / 2;
            g2.setColor(this.obj.color);
            g2.setStroke(new BasicStroke(this.obj.linewidth, 1, 1));
            g2.drawLine(insets.left, center, insets.left + currentWidth, center);
        }
    }
}

