/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importXML;

import dbaut.SqlTypeDef;
import dttwizard.importXML.XmlAttribute;
import java.util.Vector;

public class XmlElement {
    public int type = 0;
    public int quant = 0;
    public Vector child = new Vector();
    public Vector attribute = new Vector();
    public String name = null;
    public XmlElement parent = null;
    public String data = "";
    private boolean decl_only = true;

    public XmlElement(String name, int type, int quant) {
        this(name, type, quant, null, true);
    }

    public XmlElement(String name, int type, int quant, XmlElement parent) {
        this(name, type, quant, parent, true);
    }

    public XmlElement(String name, int type, int quant, XmlElement parent, boolean decl_only) {
        this.name = name;
        this.type = type;
        this.quant = quant;
        this.parent = parent;
        this.decl_only = decl_only;
    }

    private XmlElement searchElement(XmlElement elm) {
        int size = this.child.size();
        XmlElement celm = null;
        for (int i = 0; i < size; ++i) {
            celm = (XmlElement)this.child.elementAt(i);
            if (!celm.name.equals(elm.name)) continue;
            return celm;
        }
        return null;
    }

    public XmlElement searchElement(String s) {
        int size = this.child.size();
        XmlElement celm = null;
        for (int i = 0; i < size; ++i) {
            celm = (XmlElement)this.child.elementAt(i);
            if (!celm.name.equals(s)) continue;
            return celm;
        }
        return null;
    }

    public void addChild(XmlElement elm) {
        if (this.decl_only && this.searchElement(elm) != null) {
            return;
        }
        this.child.addElement(elm);
    }

    public void addChild(byte[] name, int type, int quant) {
        try {
            XmlElement elm = new XmlElement(new String(name, "UTF-8"), type, quant);
            this.child.addElement(elm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XmlAttribute searchAttribute(String name) {
        XmlAttribute attr = null;
        int size = this.attribute.size();
        for (int i = 0; i < size; ++i) {
            attr = (XmlAttribute)this.attribute.elementAt(i);
            if (!attr.name.equals(name)) continue;
            return attr;
        }
        return null;
    }

    public void addAttribute(byte[] name, byte[] value) {
        try {
            this.attribute.addElement(new XmlAttribute(new String(name, "UTF-8"), new String(value, "UTF-8")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addAttribute(byte[] name, byte[] type, byte[] dflt, int isrequired) {
        try {
            String atrName = new String(name, "UTF-8");
            if (this.decl_only && this.searchAttribute(new String(name)) != null) {
                return;
            }
            this.attribute.addElement(new XmlAttribute(atrName, new String(type, "UTF-8"), new String(dflt, "UTF-8"), isrequired));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trimData() {
        this.data = this.data.trim();
    }

    public void addData(String s) {
        this.data = this.data + s;
    }

    public String toString() {
        return this.name;
    }

    public void print(int indent) {
        int i;
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < indent; ++i2) {
            sb.append("  ");
        }
        String space = sb.toString();
        if (this.data.length() > 0) {
            System.out.println(space + this.name + "-->" + this.data);
        } else {
            System.out.println(space + this.name);
        }
        if (this.attribute.size() > 0) {
            System.out.println(sb.toString() + "Attribute:(" + this.attribute.size() + ")");
        }
        for (i = 0; i < this.attribute.size(); ++i) {
            System.out.println(space + this.attribute.elementAt(i).toString());
        }
        for (i = 0; i < this.child.size(); ++i) {
            if (this.decl_only) {
                ((XmlElement)this.child.elementAt(i)).toString();
                continue;
            }
            ((XmlElement)this.child.elementAt(i)).print(indent + 2);
        }
    }

    public String getType() {
        int size = this.attribute.size();
        XmlAttribute a = null;
        for (int i = 0; i < size; ++i) {
            a = (XmlAttribute)this.attribute.elementAt(i);
            if (!a.name.equalsIgnoreCase("TYPE") || a.dflt.indexOf("SQL_") != 0) continue;
            return SqlTypeDef.getDBMakerDbType(a.dflt);
        }
        return "char";
    }

    public String getAttributeValue(String name) {
        int size = this.attribute.size();
        XmlAttribute a = null;
        for (int i = 0; i < size; ++i) {
            a = (XmlAttribute)this.attribute.elementAt(i);
            if (!a.name.equalsIgnoreCase(name)) continue;
            if (a.value == null) {
                return a.dflt;
            }
            return a.value;
        }
        return null;
    }
}

