/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importXML;

import com.syscom.dm.dtt.sca.DefaultDataTransferAuthority;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import datatransfer.dttlib;
import dbaut.ComboEditorField;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.SyscomCommonDatabaseConnection;
import dbaut.comp.ComboBoxCellEditor;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaTable;
import dbaut.comp.ReflectionAction;
import dbaut.comp.SteppedComboBox;
import dbaut.infoObject.ColumnInfoObject;
import dbaut.infoObject.TableInfoObject;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.IntegerField;
import dbaut.textField.SmallintField;
import dbaut.util.PlatformUtil;
import dttwizard.importODBC.LogDialog;
import dttwizard.importText.SchemaTypes;
import dttwizard.importText.TransferCols;
import dttwizard.importText.TransferRowInfo;
import dttwizard.importXML.ImXmlDialog;
import dttwizard.importXML.XmlAttribute;
import dttwizard.importXML.XmlElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TransferSetting
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportXmlRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_trnasferset");
    private ImXmlDialog imx = null;
    private AbstractWizardPanel previous = null;
    private JRadioButton create_RadioButton = new JRadioButton(this.res.getString("Create_destination_table"), true);
    private JRadioButton delete_RadioButton = new JRadioButton(this.res.getString("Delete_rows_in"));
    private JRadioButton append_RadioButton = new JRadioButton(this.res.getString("Append_rows_to"));
    private JRadioButton replace_RadioButton = new JRadioButton(this.res.getString("Replace_destination_table"));
    private DbaButton next_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Execute"), 'E', DBAImageResource.getResource(this.getClass(), "/dbautimages/execute.gif"), new ReflectionAction(this, "next_Button_actionPerformed"));
    private TransferCols transferCols = new TransferCols();
    private DbaTable tableSchema_Table = new DbaTable(this.transferCols);
    private SteppedComboBox tableCombo = new SteppedComboBox();
    private int previousSelectedItemCount = 0;
    private JComboBox sourceCombo = new JComboBox();
    private JComboBox destinationCombo = new JComboBox();
    boolean initResult = true;

    public TransferSetting(ImXmlDialog imx, AbstractWizardPanel previous) {
        try {
            this.imx = imx;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        if (!this.initResult()) {
            return;
        }
        DbaButton back_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel(new BorderLayout(0, 8));
        JPanel panel7 = new JPanel();
        JPanel panel8 = new JPanel(new BorderLayout());
        JPanel panel9 = new JPanel(new GridLayout(2, 2, 0, 0));
        JPanel panel11 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel panel12 = new JPanel(new BorderLayout());
        JPanel panel14 = new JPanel(new FlowLayout(0, 0, 0));
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("You_can_select_exist"));
        JScrollPane jscroll2 = new JScrollPane(this.tableSchema_Table);
        ButtonGroup group = new ButtonGroup();
        JLabel jalbel3 = new JLabel(this.res.getString("Source_table"));
        JLabel jlabel4 = new JLabel(this.res.getString("Destination_table"));
        JLabel jlabel7 = new JLabel(this.res.getString("Table_name"));
        this.destinationCombo.setEditor(new ComboEditorField());
        this.tableCombo.setEditor(new ComboEditorField());
        this.imx.setTitle(this.res.getString("Import_from_odbc"));
        this.tableCombo.setEditable(true);
        this.destinationCombo.setEditable(true);
        this.next_Button.setHorizontalTextPosition(2);
        panel7.setPreferredSize(new Dimension(80, 0));
        panel7.setBorder(null);
        jscroll2.setVerticalScrollBarPolicy(20);
        group.add(this.create_RadioButton);
        group.add(this.delete_RadioButton);
        group.add(this.append_RadioButton);
        group.add(this.replace_RadioButton);
        panel8.setBorder(BorderFactory.createEtchedBorder());
        jlabel7.setPreferredSize(new Dimension(100, 24));
        this.tableSchema_Table.setBorder(BorderFactory.createLoweredBevelBorder());
        this.tableSchema_Table.setRowHeight(24);
        this.setColType(this.tableSchema_Table.getColumnModel().getColumn(2));
        this.setColDestination(this.tableSchema_Table.getColumnModel().getColumn(1));
        panel9.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)), BorderFactory.createEmptyBorder(0, 10, 5, 20)));
        this.create_RadioButton.addActionListener(new ReflectionAction(this, "setDestinationComboEditable"));
        this.delete_RadioButton.addActionListener(new ReflectionAction(this, "setDestinationComboEditable"));
        this.append_RadioButton.addActionListener(new ReflectionAction(this, "setDestinationComboEditable"));
        this.replace_RadioButton.addActionListener(new ReflectionAction(this, "setDestinationComboEditable"));
        this.tableCombo.addActionListener(new ReflectionAction(this, "tableCombo_actionPerformed"));
        this.tableCombo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    TransferSetting.this.tableCombo_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TransferSetting.this.tableCombo_keyReleased(e);
            }
        });
        this.setUpSchemaSizeEditor();
        this.setUpSchemaScaleEditor();
        this.tableCombo.setPreferredSize(new Dimension(280, 28));
        panel4.add(back_Button);
        panel4.add(this.next_Button);
        panel4.add(panel7);
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel9.add(this.create_RadioButton);
        panel9.add(this.delete_RadioButton);
        panel9.add(this.replace_RadioButton);
        panel9.add(this.append_RadioButton);
        panel14.add(jlabel7);
        panel14.add(this.tableCombo);
        panel8.add((Component)panel9, "North");
        panel8.add((Component)jscroll2, "Center");
        panel6.add((Component)panel14, "North");
        panel6.add((Component)panel8, "Center");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportXML.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6, false);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportXml_TransferSetting", null);
        TableColumnModel tcmodel = this.tableSchema_Table.getColumnModel();
        TableColumn col = tcmodel.getColumn(0);
        col.setPreferredWidth(110);
        col = tcmodel.getColumn(1);
        col.setPreferredWidth(130);
        col = tcmodel.getColumn(2);
        col.setPreferredWidth(120);
        col = tcmodel.getColumn(3);
        col.setPreferredWidth(60);
        col = tcmodel.getColumn(4);
        col.setPreferredWidth(45);
        col = tcmodel.getColumn(5);
        col.setPreferredWidth(55);
        this.assignTableName();
        this.assignDestinationColumn();
        this.assignTableData();
        this.transferCols.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferSetting.this.setNextButton();
            }
        });
        if (this.tableSchema_Table.getRowCount() <= 0) {
            this.next_Button.setEnabled(false);
            this.tableCombo.setEnabled(false);
        }
        if (this.imx.tbowner != null && this.imx.tbname != null) {
            TableInfoObject tio = null;
            int count = this.tableCombo.getItemCount();
            for (int i = 1; i < count; ++i) {
                tio = (TableInfoObject)this.tableCombo.getItemAt(i);
                if (tio.owner.compareToIgnoreCase(this.imx.tbowner) != 0 || tio.name.compareToIgnoreCase(this.imx.tbname) != 0) continue;
                this.tableCombo.setSelectedIndex(i);
                this.tableCombo.setEnabled(false);
                break;
            }
        }
        if (!this.imx.connection.isTDE()) {
            this.tableSchema_Table.hideColumn(6);
        }
    }

    public void setDestinationComboEditable(ActionEvent e) {
        if (this.create_RadioButton.isSelected() || this.replace_RadioButton.isSelected()) {
            this.destinationCombo.setEditable(true);
            this.transferCols.isSchemaEditable = true;
        } else {
            this.destinationCombo.setEditable(false);
            this.transferCols.isSchemaEditable = false;
        }
        this.setNextButton();
    }

    void assignTableData() {
        TransferRowInfo rowInfo = null;
        XmlElement xmlElement = null;
        xmlElement = this.imx.dtd.searchElement(this.imx.selectedBaseElement);
        if (!this.imx.asAttribute) {
            XmlElement element = null;
            String precision = "";
            String scale = "";
            String temp = "";
            String nullable = "";
            String type = "";
            for (int i = 0; i < xmlElement.child.size(); ++i) {
                element = (XmlElement)xmlElement.child.elementAt(i);
                temp = element.getAttributeValue("storage");
                precision = "";
                scale = "";
                type = element.getType();
                if (temp != null) {
                    if (temp.startsWith("(", 0) && temp.endsWith(")")) {
                        temp = temp.substring(1, temp.length() - 1);
                        precision = temp.substring(0, temp.indexOf(",")).trim();
                        scale = temp.substring(temp.indexOf(",") + 1, temp.length()).trim();
                    } else {
                        precision = temp;
                    }
                } else {
                    temp = element.getAttributeValue("length");
                    if (temp != null) {
                        if (temp.startsWith("(", 0) && temp.endsWith(")")) {
                            temp = temp.substring(1, temp.length() - 1);
                            precision = temp.substring(0, temp.indexOf(",")).trim();
                            scale = temp.substring(temp.indexOf(",") + 1).trim();
                        } else {
                            precision = temp;
                            if (type.equals("nchar") || type.equals("nvarchar")) {
                                precision = Integer.toString(Integer.parseInt(precision) / 2);
                            }
                        }
                    } else {
                        precision = "";
                        scale = "";
                    }
                }
                if (type.equals("smallint") || type.equals("integer") || type.equals("bigint") || type.equals("real") || type.equals("double") || type.equals("date") || type.equals("time") || type.equals("oid") || type.equals("timestamp") || type.equals("file") || type.equals("long varbinary") || type.equals("long varchar") || type.equals("serial") || type.equals("bigserial") || type.equals("nclob") || type.equals("clob") || type.equals("blob")) {
                    precision = "";
                    scale = "";
                }
                int int_precision = 10;
                int int_scale = 0;
                if (precision.length() != 0) {
                    int_precision = Integer.parseInt(precision);
                }
                if (scale.length() != 0) {
                    int_scale = Integer.parseInt(scale);
                }
                nullable = element.getAttributeValue("isnull");
                ColumnInfoObject cio = null;
                cio = nullable != null ? (nullable.equalsIgnoreCase("true") ? new ColumnInfoObject(element.name, type, int_precision, int_scale, true, false) : (nullable.equalsIgnoreCase("false") ? new ColumnInfoObject(element.name, type, int_precision, int_scale, false, false) : new ColumnInfoObject(element.name, type, int_precision, int_scale, true, false))) : new ColumnInfoObject(element.name, type, int_precision, int_scale, true, false);
                rowInfo = new TransferRowInfo(cio, element.name, element.getType(), precision, scale, cio.getNullable(), (Boolean)false);
                this.transferCols.addValue(rowInfo);
            }
        } else {
            XmlAttribute attribute = null;
            for (int i = 0; i < xmlElement.attribute.size(); ++i) {
                attribute = (XmlAttribute)xmlElement.attribute.elementAt(i);
                rowInfo = new TransferRowInfo(attribute.name, attribute.name, "char", "10", "", Boolean.TRUE, (Boolean)false);
                this.transferCols.addValue(rowInfo);
            }
        }
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.tableCombo.getSelectedIndex() <= 0 && this.tableCombo.getSelectedItem().toString().trim().length() == 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            GuiUt.showErrorDlg(this.imx, this.res.getString("Please_input_table_name"), null);
            return;
        }
        this.tableSchema_Table.editingStopped(null);
        String insertStr = this.tableCombo.getSelectedIndex() <= 0 ? "insert into \"" + this.tableCombo.getSelectedItem().toString().trim() + "\" (" : "insert into " + this.tableCombo.getSelectedItem().toString().trim() + " (";
        int rowCount = this.tableSchema_Table.getRowCount();
        if (rowCount > 1) {
            int i;
            if (this.tableCombo.getSelectedIndex() <= 0) {
                for (i = 0; i < rowCount; ++i) {
                    if (i == rowCount - 1) {
                        if (this.tableSchema_Table.getValueAt(i, 1).toString().trim().length() == 0) {
                            insertStr = insertStr + this.tableSchema_Table.getValueAt(i, 0) + ")";
                            continue;
                        }
                        insertStr = insertStr + "\"" + this.tableSchema_Table.getValueAt(i, 1) + "\")";
                        continue;
                    }
                    insertStr = this.tableSchema_Table.getValueAt(i, 1).toString().trim().length() == 0 ? insertStr + this.tableSchema_Table.getValueAt(i, 0) + "," : insertStr + "\"" + this.tableSchema_Table.getValueAt(i, 1) + "\",";
                }
            } else {
                for (i = 0; i < rowCount; ++i) {
                    if (i == rowCount - 1) {
                        if (this.tableSchema_Table.getValueAt(i, 1).toString().trim().length() != 0) {
                            insertStr = insertStr + "\"" + this.tableSchema_Table.getValueAt(i, 1).toString().trim() + "\")";
                            continue;
                        }
                        if (insertStr.endsWith(",")) {
                            insertStr = insertStr.substring(0, insertStr.length() - 1);
                        }
                        insertStr = insertStr + ")";
                        continue;
                    }
                    if (this.tableSchema_Table.getValueAt(i, 1).toString().trim().length() == 0) continue;
                    insertStr = insertStr + "\"" + this.tableSchema_Table.getValueAt(i, 1).toString().trim() + "\",";
                }
            }
        } else if (this.tableCombo.getSelectedIndex() <= 0) {
            insertStr = this.tableSchema_Table.getValueAt(0, 1).toString().trim().length() != 0 ? insertStr + "\"" + this.tableSchema_Table.getValueAt(0, 1).toString().trim() + "\")" : insertStr + this.tableSchema_Table.getValueAt(0, 0).toString().trim() + ")";
        } else if (this.tableSchema_Table.getValueAt(0, 1).toString().trim().length() != 0) {
            insertStr = insertStr + "\"" + this.tableSchema_Table.getValueAt(0, 1).toString().trim() + "\")";
        }
        insertStr = insertStr + " values (";
        String[] stringA = new String[rowCount];
        short insertCount = 0;
        int j = 0;
        if (rowCount > 1) {
            int i;
            if (this.tableCombo.getSelectedIndex() <= 0) {
                for (i = 0; i < rowCount; ++i) {
                    insertStr = i == rowCount - 1 ? insertStr + "?)" : insertStr + "?,";
                    stringA[j++] = this.tableSchema_Table.getValueAt(i, 0).toString().trim();
                    insertCount = (short)(insertCount + 1);
                }
            } else {
                for (i = 0; i < rowCount; ++i) {
                    if (i == rowCount - 1) {
                        if (this.tableSchema_Table.getValueAt(i, 1).toString().trim().length() != 0) {
                            insertStr = insertStr + "?)";
                            stringA[j++] = this.tableSchema_Table.getValueAt(i, 0).toString().trim();
                            insertCount = (short)(insertCount + 1);
                            continue;
                        }
                        if (insertStr.endsWith(",")) {
                            insertStr = insertStr.substring(0, insertStr.length() - 1);
                        }
                        insertStr = insertStr + ")";
                        continue;
                    }
                    if (this.tableSchema_Table.getValueAt(i, 1).toString().trim().length() == 0) continue;
                    insertStr = insertStr + "?,";
                    stringA[j++] = this.tableSchema_Table.getValueAt(i, 0).toString().trim();
                    insertCount = (short)(insertCount + 1);
                }
            }
        } else if (this.tableSchema_Table.getValueAt(0, 1).toString().trim().length() != 0) {
            stringA[j++] = this.tableSchema_Table.getValueAt(0, 0).toString().trim();
            insertStr = insertStr + "?)";
            insertCount = (short)(insertCount + 1);
        }
        Statement stmt = null;
        if (this.create_RadioButton.isSelected()) {
            try {
                String sqlStr = this.createTable();
                stmt = this.imx.connection.getDbConnection().createStatement();
                stmt.execute(sqlStr);
                DbaObject.close(stmt);
                stmt = null;
            }
            catch (SQLException sqle) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                DbaObject.close(stmt);
                GuiUt.showSQLException(this.imx, null, sqle);
                return;
            }
        }
        if (this.delete_RadioButton.isSelected()) {
            try {
                String sqlStr = "delete from " + this.tableCombo.getSelectedItem().toString().trim();
                stmt = this.imx.connection.getDbConnection().createStatement();
                stmt.execute(sqlStr);
                DbaObject.close(stmt);
                stmt = null;
            }
            catch (SQLException sqle) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                DbaObject.close(stmt);
                GuiUt.showSQLException(this.imx, null, sqle);
                return;
            }
        }
        if (!this.append_RadioButton.isSelected()) {
            try {
                String sqlStr = "drop table " + this.tableCombo.getSelectedItem().toString().trim();
                stmt = this.imx.connection.getDbConnection().createStatement();
                stmt.execute(sqlStr);
                DbaObject.close(stmt);
                stmt = null;
                sqlStr = this.createTable();
                stmt = this.imx.connection.getDbConnection().createStatement();
                stmt.execute(sqlStr);
                DbaObject.close(stmt);
                stmt = null;
            }
            catch (SQLException sqle) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                DbaObject.close(stmt);
                GuiUt.showSQLException(this.imx, null, sqle);
                return;
            }
        }
        if (this.imx.asAttribute) {
            this.imx.format.flags |= dttlib.DT_COLUMN_AS_ATTRIBUTE;
        }
        if (this.imx.connection != null && (this.imx.tbowner == null || this.imx.tbname == null) && this.imx.connection.isConnected) {
            this.imx.connection.disconnect();
        }
        dttlib lib = new dttlib();
        this.setCursor(Cursor.getPredefinedCursor(3));
        int result = 0;
        SyscomCommonDatabaseConnection conn = this.imx.connection;
        try {
            result = lib.importXML(lib.getByteArray(conn.dbname, dttlib.DM_UNICODE), lib.getByteArray(conn.username, dttlib.DM_UNICODE), lib.getByteArray(conn.password, dttlib.DM_UNICODE), this.imx.sourceFileName.getBytes(), lib.getByteArray(insertStr, "UTF-8"), lib.getByteArray(this.imx.baseElement, "UTF-8"), insertCount, stringA, new String("ErrImportXml.Log").getBytes(), this.imx.format.flags);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            result = -1;
        }
        if (result == 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (this.imx.tbowner == null || this.imx.tbname == null) {
                GuiUt.showInformationDlg(this.imx, this.res.getString("Import_xml_file") + this.imx.sourceFileName + " " + this.res.getString("To_database") + conn.dbname + " " + this.res.getString("successfully"));
            } else {
                GuiUt.showInformationDlg(this.imx, this.res.getString("Import_xml_file") + this.imx.sourceFileName + " " + this.res.getString("successfully"));
            }
            this.imx.dispose();
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
            LogDialog logdlg = new LogDialog(this.imx, true);
            logdlg.show();
            if (this.imx.connection == null || !this.imx.connection.isConnected) {
                this.imx.connection = new SyscomCommonDatabaseConnection(this.imx.dbName, this.imx.userID, this.imx.passwd, this.imx);
            }
        }
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.imx.dispose();
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.imx.Next(this.previous);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private void assignTableName() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.imx.connection.getDbConnection().createStatement();
            String dbname = this.imx.dbName;
            DefaultDataTransferAuthority authority = new DefaultDataTransferAuthority(this.imx.connection);
            String query = null;
            if (authority.isAboveDba()) {
                query = "SELECT TABLE_OWNER, TABLE_NAME, TABLE_TYPE FROM SYSTABLE WHERE TABLE_TYPE = 'TABLE' ORDER BY TABLE_OWNER, TABLE_NAME ";
            } else if (authority.isResource()) {
                query = "SELECT TABLE_OWNER, TABLE_NAME, TABLE_TYPE FROM SYSTABLE WHERE TABLE_OWNER='" + this.imx.userID + "' OR EXISTS(SELECT TABLE_NAME FROM SYSAUTHTABLE " + "WHERE  TABLE_OWNER=SYSTABLE.TABLE_OWNER AND TABLE_NAME=SYSTABLE.TABLE_NAME " + "AND (INS_ALL<>0 OR INS<>0))" + "ORDER BY TABLE_OWNER, TABLE_NAME";
            } else if (authority.isConnect()) {
                query = "SELECT TABLE_OWNER, TABLE_NAME, TABLE_TYPE FROM SYSTABLE WHERE EXISTS(SELECT TABLE_NAME FROM SYSAUTHTABLE WHERE TABLE_OWNER=SYSTABLE.TABLE_OWNER AND TABLE_NAME=SYSTABLE.TABLE_NAME AND (INS_ALL<>0 OR INS<>0))ORDER BY TABLE_OWNER, TABLE_NAME";
            }
            rs = stmt.executeQuery(query);
            Vector<Object> v = new Vector<Object>();
            TableInfoObject tio = null;
            while (rs.next()) {
                String owner = rs.getString(1).trim();
                String table = rs.getString(2).trim();
                String type = rs.getString(3).trim();
                tio = new TableInfoObject(owner, table, false, false, this.imx.connection.getUserName());
                v.add(tio);
                tio = null;
            }
            v.insertElementAt("", 0);
            DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
            this.tableCombo.setModel((ComboBoxModel)cbm);
            this.tableCombo.setSelectedIndex(0);
            DbaObject.close(rs);
            DbaObject.close(stmt);
            this.initResult = true;
        }
        catch (SQLException sqle) {
            this.initResult = false;
            GuiUt.showSQLException(this.imx, null, sqle);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
    }

    private Vector getColumnName() {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<ColumnInfoObject> v = new Vector<ColumnInfoObject>();
        try {
            TableInfoObject tio = (TableInfoObject)this.tableCombo.getSelectedItem();
            String tb_owner = tio.getOwner();
            String tb_name = tio.getName();
            stmt = this.imx.connection.getDbConnection().createStatement();
            String s = "select COLUMN_NAME, TYPE_NAME, PRECISION, SCALE, LENGTH, RESERVE5 from SYSTEM.SYSCOLUMN where TABLE_NAME = '" + tb_name + "' " + "and TABLE_OWNER = '" + tb_owner + "' order by COLUMN_ORDER";
            rs = stmt.executeQuery(s);
            String colname = "";
            String type = "";
            ColumnInfoObject cio = null;
            boolean isDBTDE = this.imx.connection.isTDE();
            int reserve5 = 0;
            boolean isEncrypted = false;
            while (rs.next()) {
                colname = rs.getString(1).trim();
                type = rs.getString(2).trim();
                int precision = rs.getInt(3);
                int scale = rs.getInt(4);
                int length = rs.getInt(5);
                reserve5 = rs.getInt(6);
                if (!isDBTDE && (reserve5 & 8) != 0) continue;
                isEncrypted = (reserve5 & 8) != 0;
                cio = type.equalsIgnoreCase("decimal") || type.equalsIgnoreCase("nchar") || type.equalsIgnoreCase("nvarchar") ? new ColumnInfoObject(colname, type, precision, scale, true, false, isEncrypted) : new ColumnInfoObject(colname, type, length, scale, true, false, isEncrypted);
                v.add(cio);
                cio = null;
            }
            cio = new ColumnInfoObject("", "char", 10, 0, true, true);
            v.insertElementAt(cio, 0);
            rs.close();
            stmt.close();
        }
        catch (SQLException qce) {
            GuiUt.showSQLException(this.imx, null, qce);
            DbaObject.close(rs);
            DbaObject.close(stmt);
        }
        return v;
    }

    void assignDestinationColumn() {
        Vector<ColumnInfoObject> v = new Vector<ColumnInfoObject>();
        ColumnInfoObject cio = new ColumnInfoObject("", "char", 10, 0, true, true);
        v.add(cio);
        DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
        this.destinationCombo.setModel(cbm);
        this.destinationCombo.setSelectedIndex(0);
    }

    public void tableCombo_actionPerformed(ActionEvent e) {
        this.isExistTableName(this.tableCombo);
        int index = this.tableCombo.getSelectedIndex();
        if (this.tableCombo.getSelectedIndex() <= 0) {
            this.tableCombo.setEditable(true);
        } else {
            this.tableCombo.setEditable(false);
            this.tableCombo.setSelectedIndex(index);
        }
        if (this.previousSelectedItemCount == this.tableCombo.getSelectedIndex()) {
            this.previousSelectedItemCount = this.tableCombo.getSelectedIndex();
            if (this.previousSelectedItemCount <= 0) {
                this.next_Button.setEnabled(false);
                this.create_RadioButton.setSelected(true);
                this.create_RadioButton.setEnabled(true);
                this.delete_RadioButton.setEnabled(false);
                this.append_RadioButton.setEnabled(false);
                this.replace_RadioButton.setEnabled(false);
                this.setDestinationComboEditable(null);
            } else {
                this.append_RadioButton.setSelected(true);
                this.append_RadioButton.setEnabled(true);
                this.create_RadioButton.setEnabled(false);
                this.delete_RadioButton.setEnabled(true);
                this.replace_RadioButton.setEnabled(true);
                this.setDestinationComboEditable(null);
            }
        } else {
            if (this.tableCombo.getSelectedIndex() <= 0) {
                this.tableSchema_Table.editingStopped(null);
                this.destinationCombo.removeAllItems();
                this.assignDestinationColumn();
                this.create_RadioButton.setSelected(true);
                this.create_RadioButton.setEnabled(true);
                this.delete_RadioButton.setEnabled(false);
                this.append_RadioButton.setEnabled(false);
                this.replace_RadioButton.setEnabled(false);
                if (this.tableCombo.getSelectedItem().toString().trim().length() == 0) {
                    ColumnInfoObject cio = null;
                    String type = "";
                    String precision = "";
                    String scale = "";
                    for (int i = 0; i < this.tableSchema_Table.getRowCount(); ++i) {
                        cio = (ColumnInfoObject)this.tableSchema_Table.getValueAt(i, 0);
                        this.tableSchema_Table.setValueAt(cio, i, 1);
                        type = cio.dataType.toLowerCase().trim();
                        precision = new Integer(cio.precision).toString();
                        scale = new Integer(cio.scale).toString();
                        if (type.equals("smallint") || type.equals("integer") || type.equals("bigint") || type.equals("real") || type.equals("double") || type.equals("date") || type.equals("time") || type.equals("oid") || type.equals("timestamp") || type.equals("file") || type.equals("long varbinary") || type.equals("long varchar") || type.equals("serial") || type.equals("bigserial") || type.equals("nclob") || type.equals("clob") || type.equals("blob")) {
                            precision = "";
                            scale = "";
                        }
                        if (!type.equals("decimal")) {
                            scale = "";
                        }
                        this.tableSchema_Table.setValueAt(cio, i, 1);
                        this.tableSchema_Table.setValueAt(type, i, 2);
                        this.tableSchema_Table.setValueAt(precision, i, 3);
                        this.tableSchema_Table.setValueAt(scale, i, 4);
                    }
                    this.tableSchema_Table.editingStopped(null);
                    this.next_Button.setEnabled(false);
                    this.setDestinationComboEditable(null);
                }
            } else {
                this.next_Button.setEnabled(true);
                this.append_RadioButton.setEnabled(true);
                this.append_RadioButton.setSelected(true);
                this.create_RadioButton.setEnabled(false);
                this.delete_RadioButton.setEnabled(true);
                this.replace_RadioButton.setEnabled(true);
                Vector v = this.getColumnName();
                DefaultComboBoxModel cbm = new DefaultComboBoxModel(v);
                this.destinationCombo.setModel(cbm);
                ColumnInfoObject cio = null;
                String type = "";
                String precision = "";
                String scale = "";
                for (int i = 0; i < this.tableSchema_Table.getRowCount(); ++i) {
                    cio = i >= this.destinationCombo.getItemCount() - 1 ? (ColumnInfoObject)this.destinationCombo.getItemAt(0) : (ColumnInfoObject)this.destinationCombo.getItemAt(i + 1);
                    type = cio.dataType.toLowerCase().trim();
                    precision = new Integer(cio.precision).toString();
                    scale = new Integer(cio.scale).toString();
                    if (type.equals("smallint") || type.equals("integer") || type.equals("bigint") || type.equals("real") || type.equals("double") || type.equals("date") || type.equals("time") || type.equals("oid") || type.equals("timestamp") || type.equals("file") || type.equals("long varbinary") || type.equals("long varchar") || type.equals("serial") || type.equals("bigserial") || type.equals("nclob") || type.equals("clob") || type.equals("blob")) {
                        precision = "";
                        scale = "";
                    }
                    if (!type.equals("decimal")) {
                        scale = "";
                    }
                    this.tableSchema_Table.setValueAt(cio, i, 1);
                    this.tableSchema_Table.setValueAt(type, i, 2);
                    this.tableSchema_Table.setValueAt(precision, i, 3);
                    this.tableSchema_Table.setValueAt(scale, i, 4);
                }
                this.tableSchema_Table.editingStopped(null);
                this.setDestinationComboEditable(null);
            }
            this.previousSelectedItemCount = this.tableCombo.getSelectedIndex();
        }
        this.setDestinationComboEditable(null);
        this.tableSchema_Table.revalidate();
        this.tableSchema_Table.repaint();
    }

    private void isExistTableName(JComboBox comboBox) {
        if (comboBox.getSelectedIndex() <= 0 && comboBox.getSelectedItem() != null && comboBox.getSelectedItem().toString().trim().length() > 0) {
            String inputTableName = comboBox.getSelectedItem().toString().trim();
            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                if (!inputTableName.equalsIgnoreCase(comboBox.getItemAt(i).toString().trim())) continue;
                comboBox.setSelectedIndex(i);
                break;
            }
        }
    }

    private void setColSource(TableColumn colSource) {
        colSource.setCellEditor(new DefaultCellEditor(this.sourceCombo));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(this.res.getString("Click_for_combo"));
        colSource.setCellRenderer(renderer);
    }

    private void setColDestination(TableColumn colDest) {
        colDest.setCellEditor(new ComboBoxCellEditor(this.destinationCombo, true, this.imx.connection.getUserName()));
        colDest.setCellRenderer(new DefaultTableCellRenderer());
    }

    private void setColType(TableColumn colType) {
        SchemaTypes comboBox = new SchemaTypes(this.imx);
        colType.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(this.res.getString("Click_for_combo"));
        colType.setCellRenderer(renderer);
    }

    void tableCombo_keyReleased(KeyEvent e) {
        String s = this.tableCombo.getEditor().getItem().toString();
        this.next_Button.setEnabled(s.length() > 0);
        if (s.length() > 0) {
            this.tableCombo.getEditor().setItem(s);
            if (e.getKeyCode() == 10) {
                this.next_Button_actionPerformed(null);
            }
        }
    }

    private void setUpSchemaSizeEditor() {
        this.tableSchema_Table.setUpIntegerEditorStr(3, new IntegerField(4, true, true));
    }

    private void setUpSchemaScaleEditor() {
        this.tableSchema_Table.setUpShortEditorStr(4, new SmallintField(true));
    }

    String createTable() {
        boolean sign = false;
        String createStr = "";
        if (this.tableCombo.getSelectedIndex() == -1) {
            createStr = "create table \"" + this.tableCombo.getSelectedItem().toString().trim() + "\" (";
        } else {
            TableInfoObject tio = (TableInfoObject)this.tableCombo.getSelectedItem();
            createStr = "create table \"" + tio.getName() + "\" (";
        }
        int rowCount = this.tableSchema_Table.getRowCount();
        String tmpStr = "";
        String myStr = "";
        for (int i = 0; i < rowCount; ++i) {
            String nullable;
            String scale;
            String size;
            String type;
            String cName;
            if (!sign) {
                sign = true;
                cName = this.transferCols.getValueAt(i, 1).toString().trim();
                type = this.transferCols.getValueAt(i, 2).toString().trim();
                size = this.transferCols.getValueAt(i, 3).toString().trim();
                scale = this.transferCols.getValueAt(i, 4).toString().trim();
                nullable = this.transferCols.getValueAt(i, 5).toString().trim();
                tmpStr = "";
                if (cName.length() == 0) {
                    cName = this.transferCols.getValueAt(i, 0).toString().trim();
                }
                myStr = myStr + "\"" + cName + "\"";
                if (!size.equalsIgnoreCase("")) {
                    tmpStr = tmpStr + "(" + size;
                    tmpStr = scale.equalsIgnoreCase("") ? tmpStr + ")" : tmpStr + "," + scale + ")";
                }
                myStr = type.indexOf(" ") >= 0 ? (type.equalsIgnoreCase("long varchar") || type.equalsIgnoreCase("long varbinary") || type.equalsIgnoreCase("nclob") || type.equalsIgnoreCase("clob") || type.equalsIgnoreCase("blob") ? myStr + " " + type + tmpStr : myStr + " " + "\"" + type + "\"" + tmpStr) : myStr + " " + type + tmpStr;
                if (nullable.equalsIgnoreCase("false") && !type.equalsIgnoreCase("serial") && !type.equalsIgnoreCase("bigserial")) {
                    myStr = myStr + " not null";
                }
                createStr = createStr + myStr;
                continue;
            }
            myStr = "";
            cName = this.transferCols.getValueAt(i, 1).toString().trim();
            type = this.transferCols.getValueAt(i, 2).toString().trim();
            size = this.transferCols.getValueAt(i, 3).toString().trim();
            scale = this.transferCols.getValueAt(i, 4).toString().trim();
            nullable = this.transferCols.getValueAt(i, 5).toString().trim();
            tmpStr = "";
            if (cName.length() == 0) {
                cName = this.transferCols.getValueAt(i, 0).toString().trim();
            }
            myStr = myStr + "\"" + cName + "\"";
            if (!size.equalsIgnoreCase("")) {
                tmpStr = tmpStr + "(" + size;
                tmpStr = scale.equalsIgnoreCase("") ? tmpStr + ")" : tmpStr + "," + scale + ")";
            }
            myStr = type.indexOf(" ") >= 0 ? (type.equalsIgnoreCase("long varchar") || type.equalsIgnoreCase("long varbinary") || type.equalsIgnoreCase("nclob") || type.equalsIgnoreCase("clob") || type.equalsIgnoreCase("blob") ? myStr + " " + type + tmpStr : myStr + " " + "\"" + type + "\"" + tmpStr) : myStr + " " + type + tmpStr;
            if (nullable.equalsIgnoreCase("false") && !type.equalsIgnoreCase("serial") && !type.equalsIgnoreCase("bigserial")) {
                myStr = myStr + " not null";
            }
            createStr = createStr + " ," + myStr;
        }
        createStr = createStr + ")";
        return createStr;
    }

    public boolean setNextButton() {
        int rowCount = this.tableSchema_Table.getRowCount();
        boolean b = false;
        for (int i = 0; i < rowCount; ++i) {
            if (this.tableSchema_Table.getValueAt(i, 1).toString().trim().length() != 0) {
                b = true;
                break;
            }
            b = false;
        }
        if (this.delete_RadioButton.isSelected() || this.append_RadioButton.isSelected()) {
            if (b) {
                this.next_Button.setEnabled(true);
            } else {
                this.next_Button.setEnabled(false);
            }
        } else {
            this.next_Button.setEnabled(true);
        }
        return b;
    }

    @Override
    public boolean initResult() {
        Statement stmt = null;
        try {
            stmt = this.imx.connection.getDbConnection().createStatement();
            String s = "select * from SYSTEM.SYSTABLE";
            stmt.execute(s);
            this.initResult = true;
            return true;
        }
        catch (SQLException sqle) {
            if (sqle.getErrorCode() == 1102) {
                GuiUt.showSQLException(this.imx, null, sqle);
                this.initResult = false;
                return false;
            }
            this.initResult = true;
            return true;
        }
    }

    public void set_TableTransferCols_Editable(ActionEvent e) {
        this.transferCols.isSchemaEditable = this.create_RadioButton.isSelected() || this.replace_RadioButton.isSelected();
    }
}

