/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importText;

import com.borland.jbcl.layout.VerticalFlowLayout;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import datatransfer.dttlib;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importText.DestinationDataSource;
import dttwizard.importText.ImTextDialog;
import dttwizard.importText.SpecifyColLength;
import dttwizard.importText.TextColumnSchema;
import dttwizard.importText.TransferSetting;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AdvancedSetting
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportTextRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_FormatSetting");
    private ImTextDialog imt = null;
    private AbstractWizardPanel next1 = null;
    private AbstractWizardPanel previous = null;
    private JCheckBox includeColumnName_CheckBox = new JCheckBox(this.res.getString("Include_column_name"), false);
    private JCheckBox includeTableSchema_CheckBox = new JCheckBox(this.res.getString("Include_table_schema"), false);
    private JCheckBox useEscapeFeature_CheckBox = new JCheckBox(this.res.getString("Use_escape_character"), true);
    private JCheckBox tempFileFeature_CheckBox = new JCheckBox(this.res.getString("tmp_file_to_store"), true);
    private JCheckBox displayNull_CheckBox = new JCheckBox(this.res.getString("Use_null"), true);

    public AdvancedSetting(ImTextDialog imt, AbstractWizardPanel previous) {
        try {
            this.imt = imt;
            this.previous = previous;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton back_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "back_Button_actionPerformed"));
        DbaButton cancel_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancel_Button_actionPerformed"));
        DbaButton next_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Next"), 'N', DBAImageResource.getResource(this.getClass(), "/dbautimages/next.gif"), new ReflectionAction(this, "next_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        JPanel panel7 = new JPanel();
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Check_include_column_name"));
        next_Button.setHorizontalTextPosition(2);
        panel7.setPreferredSize(new Dimension(80, 0));
        panel7.setBorder(null);
        panel4.add(back_Button);
        panel4.add(next_Button);
        panel4.add(panel7);
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel6.add(this.includeColumnName_CheckBox);
        panel6.add(this.includeTableSchema_CheckBox);
        panel6.add(this.useEscapeFeature_CheckBox);
        panel6.add(this.tempFileFeature_CheckBox);
        panel6.add(this.displayNull_CheckBox);
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportText.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportText_AdvancedSetting", null);
        if (this.imt.nextStep != 0) {
            this.useEscapeFeature_CheckBox.setSelected(false);
            this.useEscapeFeature_CheckBox.setEnabled(false);
        }
    }

    public void back_Button_actionPerformed(ActionEvent e) {
        this.imt.Next(this.previous);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        if (this.next1 != null && this.imt.nextStep != 0 && this.next1 instanceof DestinationDataSource) {
            this.next1 = null;
        }
        if (this.next1 != null && this.imt.nextStep == 0 && this.next1 instanceof SpecifyColLength) {
            this.next1 = null;
        }
        if (this.includeColumnName_CheckBox.isSelected() != this.imt.includeColumnName || this.includeTableSchema_CheckBox.isSelected() != this.imt.includeTableSchema || this.useEscapeFeature_CheckBox.isSelected() != this.imt.mapEscape || this.tempFileFeature_CheckBox.isSelected() != this.imt.createTempFile || this.displayNull_CheckBox.isSelected() != this.imt.printNull) {
            this.next1 = null;
        }
        this.imt.includeColumnName = this.includeColumnName_CheckBox.isSelected();
        this.imt.includeTableSchema = this.includeTableSchema_CheckBox.isSelected();
        this.imt.mapEscape = this.useEscapeFeature_CheckBox.isSelected();
        this.imt.createTempFile = this.tempFileFeature_CheckBox.isSelected();
        this.imt.printNull = this.displayNull_CheckBox.isSelected();
        if (this.imt.nextStep != 0) {
            this.imt.format.style = dttlib.DT_FIXED_COLUMN_LEN;
            this.imt.format.nspace = (short)this.imt.separateGapNumber;
            this.imt.format.coldelim = 0;
        } else {
            this.imt.format.style = dttlib.DT_WITH_COLUMN_DELIM;
            this.imt.format.coldelim = (byte)this.imt.columnDelimiter.charAt(0);
            if (this.imt.textQualifier != null) {
                this.imt.format.textq = (byte)this.imt.textQualifier.charAt(0);
            }
            if (this.imt.binaryPadding != null) {
                this.imt.format.binaryq = (byte)this.imt.binaryQualifier.charAt(0);
                if (this.imt.binaryPadding.length() > 0) {
                    this.imt.format.binaryp = (byte)this.imt.binaryPadding.charAt(0);
                }
            }
        }
        this.imt.format.rowdelim = this.imt.rowDelimiter.getBytes();
        this.imt.format.ncharFormat = this.imt.ncharFormat;
        this.imt.format.flags = 0L;
        if (this.imt.includeColumnName) {
            this.imt.format.flags |= dttlib.DT_INCLUDE_COL_NAME;
        }
        if (this.imt.includeTableSchema) {
            this.imt.format.flags |= dttlib.DT_INCLUDE_SCHEMA;
        }
        if (!this.imt.mapEscape) {
            this.imt.format.flags |= dttlib.DT_NO_ESCAPE_CHARACTER;
        }
        if (this.imt.createTempFile) {
            this.imt.format.flags |= dttlib.DT_INCLUDE_BLOB;
        }
        if (this.imt.printNull) {
            this.imt.format.flags |= dttlib.DT_PRINT_NULL;
        }
        int result = 0;
        this.imt.schema = new TextColumnSchema();
        result = this.imt.nextStep == 0 ? this.imt.schema.getSchema(this.imt.sourceFileName.getBytes(), this.imt.format) : this.imt.schema.initText(this.imt.sourceFileName.getBytes(), this.imt.format, this.imt.rowDelimiter.getBytes());
        if (result != 0) {
            GuiUt.showErrorDlg(this.imt, this.res.getString("Canont_parse") + this.imt.sourceFileName + "!", null);
            this.next1 = null;
            return;
        }
        if (this.next1 == null) {
            if (this.imt.connection != null && (this.imt.tbowner == null || this.imt.tbname == null) && this.imt.connection.isConnected) {
                this.imt.connection.disconnect();
            }
            this.next1 = this.imt.nextStep == 0 ? (this.imt.tbowner == null || this.imt.tbname == null ? new DestinationDataSource(this.imt, this) : new TransferSetting(this.imt, this)) : new SpecifyColLength(this.imt, this);
        }
        this.imt.Next(this.next1);
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.imt.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

