/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import com.borland.jbcl.layout.VerticalFlowLayout;
import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.editorPanel.SQLTextPane;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.util.PlatformUtil;
import dttwizard.importODBC.QueryObject;
import dttwizard.importODBC.QueryStatementDlg;
import dttwizard.importODBC.SqlQueryStatement;
import dttwizard.importODBC.odbcDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class QueryStatement
extends AbstractWizardPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_SQLStatement");
    private QueryStatementDlg oid = null;
    private odbcDialog odbcdlg = null;
    private SQLTextPane queryStringTextPanel = new SQLTextPane();
    private SqlQueryStatement sqs = null;
    private DbaButton next_Button = new DbaButton(this.res.getString("OK"), 'O', new ReflectionAction(this, "next_Button_actionPerformed"));

    public QueryStatement(QueryStatementDlg oid, odbcDialog odbcdlg, SqlQueryStatement sqs) {
        try {
            this.oid = oid;
            this.odbcdlg = odbcdlg;
            this.sqs = sqs;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        JPanel panel4 = new JPanel(new FlowLayout(2));
        JPanel panel6 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel panel7 = new JPanel();
        JPanel panel8 = new JPanel(new FlowLayout(0));
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("A_sql_select"));
        JLabel jlabel3 = new JLabel(this.res.getString("SQL_query"));
        this.next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        panel7.setPreferredSize(new Dimension(80, 0));
        panel7.setBorder(null);
        this.queryStringTextPanel.setPreferredSize(new Dimension(0, 150));
        this.queryStringTextPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.queryStringTextPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    QueryStatement.this.queryStringTextPanel_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                QueryStatement.this.queryStringTextPanel_keyReleased(e);
            }
        });
        panel4.add(this.next_Button);
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        panel4.add(panel7);
        JScrollPane scroll = new JScrollPane();
        scroll.setPreferredSize(new Dimension(0, 150));
        scroll.getViewport().add(this.queryStringTextPanel);
        panel6.add(jlabel3);
        panel6.add(scroll);
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_QueryStatement", null);
        this.next_Button.setEnabled(false);
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        if (this.queryStringTextPanel.getText().trim().length() != 0) {
            boolean b = true;
            PreparedStatement pstmt = null;
            try {
                if (!this.odbcdlg.isExcelDriver) {
                    this.odbcdlg.sourceConnection.getDbConnection().setAutoCommit(false);
                }
                String s = this.queryStringTextPanel.getText().trim();
                pstmt = this.odbcdlg.sourceConnection.getDbConnection().prepareStatement(s);
                b = pstmt.execute();
                pstmt.close();
                if (!this.odbcdlg.isExcelDriver) {
                    this.odbcdlg.sourceConnection.getDbConnection().rollback();
                    this.odbcdlg.sourceConnection.getDbConnection().setAutoCommit(true);
                }
            }
            catch (SQLException sqle) {
                GuiUt.showErrorDlg(this.oid, sqle.getMessage(), null);
                DbaObject.close(pstmt);
                DbaObject.rollback(this.odbcdlg.sourceConnection.getDbConnection());
                DbaObject.setAutoCommit(this.odbcdlg.sourceConnection.getDbConnection(), true);
                b = false;
            }
            if (b) {
                int rowCount = this.sqs.sqlQueryModel.getRowCount();
                QueryObject qo = null;
                qo = rowCount == 0 ? new QueryObject(this.queryStringTextPanel.getText().trim(), 0) : new QueryObject(this.queryStringTextPanel.getText().trim(), rowCount);
                Object[] oa = new Object[]{qo, this.sqs.destinationCombo.getItemAt(0), null};
                this.sqs.sqlQueryModel.addValue(oa);
            } else {
                GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("This_select_statement"));
                return;
            }
        }
        this.oid.setVisible(false);
        this.oid.dispose();
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.oid.setVisible(false);
        this.oid.dispose();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    void queryStringTextPanel_keyReleased(KeyEvent e) {
        this.next_Button.setEnabled(this.queryStringTextPanel.getText().trim().length() > 0);
    }
}

