/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import datatransfer.DataTransferFrame;
import datatransfer.HelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.CommonUt.EmptyPanel;
import dbaut.CommonUt.WizardTextArea;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importODBC.ForeignKeyInfo;
import dttwizard.importODBC.ForeignKeyProcess;
import dttwizard.importODBC.odbcDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ForeignKeyView
extends AbstractWizardPanel {
    private static final long serialVersionUID = -4652003406815582612L;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private String title = this.res.getString("Page_title_foreignkeyview");
    private odbcDialog odbcdlg = null;
    private AbstractWizardPanel next = null;
    private DbaButton next_Button = new DbaButton(new Dimension(80, 24), false, this.res.getString("Execute"), 'E', DBAImageResource.getResource(this.getClass(), "/dbautimages/execute.gif"), new ReflectionAction(this, "next_Button_actionPerformed"));
    private ForeignKeyTableModel tableModel = new ForeignKeyTableModel();
    JTable viewTable = new JTable(this.tableModel);
    JCheckBox checkAll = new JCheckBox(this.res.getString("All"));
    private ArrayList<ForeignKeyInfo> fkList = null;

    public ForeignKeyView(odbcDialog odbcdlg, ArrayList<ForeignKeyInfo> fkList) {
        try {
            this.odbcdlg = odbcdlg;
            this.fkList = fkList;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        DbaButton cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "cancel_Button_actionPerformed"));
        HelpButton help_Button = new HelpButton();
        this.checkAll.setMnemonic('A');
        this.checkAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ForeignKeyView.this.checkAll();
            }
        });
        WizardTextArea area1 = new WizardTextArea(this.title, this.res.getString("Please_select_foreignkeyview"));
        JScrollPane jscroll2 = new JScrollPane(this.viewTable);
        cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        jscroll2.setVerticalScrollBarPolicy(20);
        this.viewTable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.viewTable.setRowHeight(24);
        JPanel panel4 = new JPanel(new FlowLayout(2));
        panel4.add(this.next_Button);
        panel4.add(new EmptyPanel());
        panel4.add(cancel_Button);
        panel4.add(help_Button);
        JPanel panel10 = new JPanel(new FlowLayout(0));
        panel10.add(this.checkAll);
        JPanel panel6 = new JPanel(new BorderLayout());
        panel6.add((Component)jscroll2, "Center");
        panel6.add((Component)panel10, "South");
        this.setImage(DBAImageResource.getResource(this.getClass(), "/dttimages/ImportODBC.jpg"));
        this.setButtonBar(panel4);
        this.setTextArea(area1);
        this.setContent(panel6);
        DataTransferFrame.enableDialogHelp(this, help_Button, "wizard_ImportODBC_from_tables", null);
        TableColumnModel tcsourceTableModel = this.viewTable.getColumnModel();
        TableColumn col = tcsourceTableModel.getColumn(0);
        col.setPreferredWidth(30);
        col = tcsourceTableModel.getColumn(1);
        col.setPreferredWidth(200);
        col = tcsourceTableModel.getColumn(2);
        col.setPreferredWidth(100);
        col = tcsourceTableModel.getColumn(3);
        col.setPreferredWidth(200);
        this.next_Button.setEnabled(false);
    }

    public boolean checkButtonStatus() {
        int a = this.tableModel.getRowCount();
        boolean status = false;
        Boolean objB = null;
        for (int b = 0; b < a; ++b) {
            objB = (Boolean)this.tableModel.getValueAt(b, 0);
            if (objB.booleanValue()) {
                status = true;
                break;
            }
            if (b != a - 1) continue;
            status = false;
        }
        if (!status) {
            this.next_Button.setEnabled(false);
        } else {
            this.next_Button.setEnabled(true);
        }
        return status;
    }

    public void next_Button_actionPerformed(ActionEvent e) {
        this.viewTable.editingStopped(null);
        if (!this.checkButtonStatus()) {
            GuiUt.showWarningDlg(this.odbcdlg, this.res.getString("Warning"), this.res.getString("Please_select_sometable"));
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        ArrayList<ForeignKeyInfo> list = new ArrayList<ForeignKeyInfo>();
        for (ForeignKeyInfo info : this.fkList) {
            if (!info.create) continue;
            list.add(info);
        }
        this.next = new ForeignKeyProcess(this.odbcdlg, this, list);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.odbcdlg.Next(this.next);
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.odbcdlg.dispose();
    }

    private void checkAll() {
        boolean value = this.checkAll.isSelected();
        int a = this.tableModel.getRowCount();
        for (int b = 0; b < a; ++b) {
            this.tableModel.setValueAt(value, b, 0);
        }
        this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    class ForeignKeyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1850631574004449498L;
        private String[] header;

        public ForeignKeyTableModel() {
            this.header = new String[]{"", ForeignKeyView.this.res.getString("Table_Name"), ForeignKeyView.this.res.getString("FK_Name"), ForeignKeyView.this.res.getString("Referenced_Table"), ForeignKeyView.this.res.getString("Referenced_Column"), ForeignKeyView.this.res.getString("Update_Rule"), ForeignKeyView.this.res.getString("Delete_Rule")};
        }

        @Override
        public String getColumnName(int col) {
            return this.header[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ForeignKeyInfo info = (ForeignKeyInfo)ForeignKeyView.this.fkList.get(row);
            if (col == 0) {
                info.create = (Boolean)value;
            }
            ForeignKeyView.this.checkButtonStatus();
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public int getRowCount() {
            return ForeignKeyView.this.fkList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ForeignKeyInfo info = (ForeignKeyInfo)ForeignKeyView.this.fkList.get(row);
            return info.get(col);
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }
    }
}

