/*
 * Decompiled with CFR 0.152.
 */
package dbaut.editorPanel;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.WrappedPlainView;

public class SQLSPColorView
extends WrappedPlainView {
    private Segment line = new Segment();
    private static Color STRING_LITERAL_COLOR = new Color(130, 0, 0);
    private static Hashtable keywords = new Hashtable();

    public SQLSPColorView(Element e) {
        super(e);
    }

    public SQLSPColorView(Element e, boolean wordWrap) {
        super(e, wordWrap);
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        int tabSize = 4;
        Container host = this.getContainer();
        Font f = host.getFont();
        FontMetrics metrics = host.getFontMetrics(f);
        return x + (float)(tabSize *= metrics.charWidth('m'));
    }

    @Override
    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        this.getDocument().getText(p0, p1 - p0, this.line);
        String lineSeparator = System.getProperty("line.separator");
        StringTokenizer str = new StringTokenizer(this.line.toString(), "\t ;=><()'," + lineSeparator, true);
        int offset = 0;
        boolean in_quote = false;
        Color c = null;
        String t = null;
        while (str.hasMoreTokens()) {
            t = str.nextToken();
            if (t.equals("'")) {
                boolean bl = in_quote = !in_quote;
            }
            if (in_quote) {
                c = STRING_LITERAL_COLOR;
            } else {
                c = (Color)keywords.get(t.toUpperCase());
                if (c == null) {
                    c = Color.black;
                }
            }
            g.setColor(c);
            this.line.count = t.length();
            x = Utilities.drawTabbedText(this.line, x, y, g, (TabExpander)this, offset);
            this.line.offset += t.length();
            offset += t.length();
        }
        return x;
    }

    protected void drawLine(int lineIndex, Graphics g, int x, int y) {
        try {
            Element lineElement = this.getElement().getElement(lineIndex);
            int start = lineElement.getStartOffset();
            int end = lineElement.getEndOffset();
            this.getDocument().getText(start, end - (start + 1), this.line);
            StringTokenizer str = new StringTokenizer(this.line.toString(), " ;=><()',", true);
            int offset = 0;
            boolean in_quote = false;
            Color c = null;
            String t = null;
            while (str.hasMoreTokens()) {
                t = str.nextToken();
                if (t.equals("'")) {
                    boolean bl = in_quote = !in_quote;
                }
                if (in_quote) {
                    c = STRING_LITERAL_COLOR;
                } else {
                    c = (Color)keywords.get(t.toUpperCase());
                    if (c == null) {
                        c = Color.black;
                    }
                }
                g.setColor(c);
                this.line.count = t.length();
                x = Utilities.drawTabbedText(this.line, x, y, g, (TabExpander)this, offset);
                this.line.offset += t.length();
                offset += t.length();
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    static {
        keywords.put("ABORT", Color.blue);
        keywords.put("ABSOLUTE", Color.blue);
        keywords.put("ACTION", Color.blue);
        keywords.put("ADD", Color.blue);
        keywords.put("ADMIN", Color.blue);
        keywords.put("AFTER", Color.blue);
        keywords.put("AGGREGATE", Color.blue);
        keywords.put("ALIAS", Color.blue);
        keywords.put("ALL", Color.blue);
        keywords.put("ALLOCATE", Color.blue);
        keywords.put("ALTER", Color.blue);
        keywords.put("AND", Color.blue);
        keywords.put("ANY", Color.blue);
        keywords.put("ARE", Color.blue);
        keywords.put("ARRAY", Color.blue);
        keywords.put("AS", Color.blue);
        keywords.put("ASC", Color.blue);
        keywords.put("ASENSITIVE", Color.blue);
        keywords.put("ASSERTION", Color.blue);
        keywords.put("AT", Color.blue);
        keywords.put("AUTHORIZATION", Color.blue);
        keywords.put("BACKUP", Color.blue);
        keywords.put("BEFORE", Color.blue);
        keywords.put("BEGIN", Color.blue);
        keywords.put("BIGINT", Color.blue);
        keywords.put("BIGSERIAL", Color.blue);
        keywords.put("BINARY", Color.blue);
        keywords.put("BIT", Color.blue);
        keywords.put("BLOB", Color.blue);
        keywords.put("BOOLEAN", Color.blue);
        keywords.put("BOTH", Color.blue);
        keywords.put("BREADTH", Color.blue);
        keywords.put("BREAK", Color.blue);
        keywords.put("BY", Color.blue);
        keywords.put("CALL", Color.blue);
        keywords.put("CASCADE", Color.blue);
        keywords.put("CASCADED", Color.blue);
        keywords.put("CASE", Color.blue);
        keywords.put("CAST", Color.blue);
        keywords.put("CATALOG", Color.blue);
        keywords.put("CHAR", Color.blue);
        keywords.put("CHECK", Color.blue);
        keywords.put("CLASS", Color.blue);
        keywords.put("CLOB", Color.blue);
        keywords.put("CLOSE", Color.blue);
        keywords.put("COLLATE", Color.blue);
        keywords.put("COLLATION", Color.blue);
        keywords.put("COLUMN", Color.blue);
        keywords.put("COMMAND", Color.blue);
        keywords.put("COMMIT", Color.blue);
        keywords.put("COMPLETION", Color.blue);
        keywords.put("CONDITION", Color.blue);
        keywords.put("CONNECT", Color.blue);
        keywords.put("CONNECTION", Color.blue);
        keywords.put("CONSTRAINT", Color.blue);
        keywords.put("CONSTRAINTS", Color.blue);
        keywords.put("CONSTRUCTOR", Color.blue);
        keywords.put("CONTINUE", Color.blue);
        keywords.put("CORRESPONDING", Color.blue);
        keywords.put("CREATE", Color.blue);
        keywords.put("CROSS", Color.blue);
        keywords.put("CUBE", Color.blue);
        keywords.put("CURRENT", Color.blue);
        keywords.put("CURRENT_DATE", Color.blue);
        keywords.put("CURRENT_PATH", Color.blue);
        keywords.put("CURRENT_ROLE", Color.blue);
        keywords.put("CURRENT_TIME", Color.blue);
        keywords.put("CURRENT_TIMESTAMP", Color.blue);
        keywords.put("CURRENT_USER", Color.blue);
        keywords.put("CURSOR", Color.blue);
        keywords.put("CYCLE", Color.blue);
        keywords.put("DATABASE", Color.blue);
        keywords.put("DATE", Color.blue);
        keywords.put("DAY", Color.blue);
        keywords.put("DEALLOCATE", Color.blue);
        keywords.put("DEC", Color.blue);
        keywords.put("DECIMAL", Color.blue);
        keywords.put("DECLARE", Color.blue);
        keywords.put("DEFAULT", Color.blue);
        keywords.put("DEFERRABLE", Color.blue);
        keywords.put("DEFERRED", Color.blue);
        keywords.put("DELETE", Color.blue);
        keywords.put("DEPTH", Color.blue);
        keywords.put("DEREF", Color.blue);
        keywords.put("DESC", Color.blue);
        keywords.put("DESCRIBE", Color.blue);
        keywords.put("DESCRIPTOR", Color.blue);
        keywords.put("DESTROY", Color.blue);
        keywords.put("DESTRUCTOR", Color.blue);
        keywords.put("DETERMINISTIC", Color.blue);
        keywords.put("DIAGNOSTICS", Color.blue);
        keywords.put("DICTIONARY", Color.blue);
        keywords.put("DISCONNECT", Color.blue);
        keywords.put("DISTINCT", Color.blue);
        keywords.put("DO", Color.blue);
        keywords.put("DOMAIN", Color.blue);
        keywords.put("DOUBLE", Color.blue);
        keywords.put("DROP", Color.blue);
        keywords.put("DYNAMIC", Color.blue);
        keywords.put("EACH", Color.blue);
        keywords.put("ELSE", Color.blue);
        keywords.put("ELSEIF", Color.blue);
        keywords.put("END", Color.blue);
        keywords.put("END-EXEC", Color.blue);
        keywords.put("EQUALS", Color.blue);
        keywords.put("ESCAPE", Color.blue);
        keywords.put("EVERY", Color.blue);
        keywords.put("EXCEPT", Color.blue);
        keywords.put("EXCEPTION", Color.blue);
        keywords.put("EXEC", Color.blue);
        keywords.put("EXECUTE", Color.blue);
        keywords.put("EXIT", Color.blue);
        keywords.put("FALSE", Color.blue);
        keywords.put("FETCH", Color.blue);
        keywords.put("FIRST", Color.blue);
        keywords.put("FLOAT", Color.blue);
        keywords.put("FOR", Color.blue);
        keywords.put("FOREIGN", Color.blue);
        keywords.put("FOUND", Color.blue);
        keywords.put("FREE", Color.blue);
        keywords.put("FROM", Color.blue);
        keywords.put("FULL", Color.blue);
        keywords.put("FUNCTION", Color.blue);
        keywords.put("GENERAL", Color.blue);
        keywords.put("GET", Color.blue);
        keywords.put("GLOBAL", Color.blue);
        keywords.put("GO", Color.blue);
        keywords.put("GOTO", Color.blue);
        keywords.put("GRANT", Color.blue);
        keywords.put("GROUP", Color.blue);
        keywords.put("GROUPING", Color.blue);
        keywords.put("HANDLER", Color.blue);
        keywords.put("HAVING", Color.blue);
        keywords.put("HOLD", Color.blue);
        keywords.put("HOST", Color.blue);
        keywords.put("IDENTITY", Color.blue);
        keywords.put("IF", Color.blue);
        keywords.put("IGNORE", Color.blue);
        keywords.put("IMMEDIATE", Color.blue);
        keywords.put("IN", Color.blue);
        keywords.put("INDICATOR", Color.blue);
        keywords.put("INITIALIZE", Color.blue);
        keywords.put("INITIALLY", Color.blue);
        keywords.put("INNER", Color.blue);
        keywords.put("INOUT", Color.blue);
        keywords.put("INPUT", Color.blue);
        keywords.put("INSENSITIVE", Color.blue);
        keywords.put("INSERT", Color.blue);
        keywords.put("INT", Color.blue);
        keywords.put("INTEGER", Color.blue);
        keywords.put("INTERSECT", Color.blue);
        keywords.put("INTO", Color.blue);
        keywords.put("IS", Color.blue);
        keywords.put("ISOLATION", Color.blue);
        keywords.put("ITERATE", Color.blue);
        keywords.put("JOIN", Color.blue);
        keywords.put("KEY", Color.blue);
        keywords.put("KILL", Color.blue);
        keywords.put("LANGUAGE", Color.blue);
        keywords.put("LARGE", Color.blue);
        keywords.put("LAST", Color.blue);
        keywords.put("LATERAL", Color.blue);
        keywords.put("LEADING", Color.blue);
        keywords.put("LEAVE", Color.blue);
        keywords.put("LESS", Color.blue);
        keywords.put("LEVEL", Color.blue);
        keywords.put("LIKE", Color.blue);
        keywords.put("LIMIT", Color.blue);
        keywords.put("LOAD", Color.blue);
        keywords.put("LOCAL", Color.blue);
        keywords.put("LOCALTIME", Color.blue);
        keywords.put("LOCALTIMESTAMP", Color.blue);
        keywords.put("LOCATOR", Color.blue);
        keywords.put("LOOP", Color.blue);
        keywords.put("LUA", Color.blue);
        keywords.put("/LUA", Color.blue);
        keywords.put("MAP", Color.blue);
        keywords.put("MATCH", Color.blue);
        keywords.put("MODIFIES", Color.blue);
        keywords.put("MODIFY", Color.blue);
        keywords.put("MODULE", Color.blue);
        keywords.put("NAMES", Color.blue);
        keywords.put("NATIONAL", Color.blue);
        keywords.put("NATURAL", Color.blue);
        keywords.put("NCHAR", Color.blue);
        keywords.put("NCLOB", Color.blue);
        keywords.put("NEXT", Color.blue);
        keywords.put("NO", Color.blue);
        keywords.put("NONE", Color.blue);
        keywords.put("NOT", Color.blue);
        keywords.put("NULL", Color.blue);
        keywords.put("NUMERIC", Color.blue);
        keywords.put("NVARCHAR", Color.blue);
        keywords.put("OBJECT", Color.blue);
        keywords.put("OF", Color.blue);
        keywords.put("OFF", Color.blue);
        keywords.put("ON", Color.blue);
        keywords.put("ONLY", Color.blue);
        keywords.put("OPEN", Color.blue);
        keywords.put("OPERATION", Color.blue);
        keywords.put("OPTION", Color.blue);
        keywords.put("OR", Color.blue);
        keywords.put("ORDINALITY", Color.blue);
        keywords.put("OUT", Color.blue);
        keywords.put("OUTER", Color.blue);
        keywords.put("OUTPUT", Color.blue);
        keywords.put("PAD", Color.blue);
        keywords.put("PARTIAL", Color.blue);
        keywords.put("PATH", Color.blue);
        keywords.put("POSITION", Color.blue);
        keywords.put("POSTFIX", Color.blue);
        keywords.put("PREFIX", Color.blue);
        keywords.put("PREORDER", Color.blue);
        keywords.put("PREPARE", Color.blue);
        keywords.put("PRESERVE", Color.blue);
        keywords.put("PRIMARY", Color.blue);
        keywords.put("PRIOR", Color.blue);
        keywords.put("PRIVILEGES", Color.blue);
        keywords.put("PROCEDURE", Color.blue);
        keywords.put("READ", Color.blue);
        keywords.put("READS", Color.blue);
        keywords.put("REAL", Color.blue);
        keywords.put("RECURSIVE", Color.blue);
        keywords.put("REFERENCES", Color.blue);
        keywords.put("REFERENCING", Color.blue);
        keywords.put("RELATIVE", Color.blue);
        keywords.put("REMOVE", Color.blue);
        keywords.put("REPEAT", Color.blue);
        keywords.put("RESTRICT", Color.blue);
        keywords.put("RESULT", Color.blue);
        keywords.put("RESUME", Color.blue);
        keywords.put("RETURN", Color.blue);
        keywords.put("RETURNS", Color.blue);
        keywords.put("REVOKE", Color.blue);
        keywords.put("ROLE", Color.blue);
        keywords.put("ROLLBACK", Color.blue);
        keywords.put("ROLLUP", Color.blue);
        keywords.put("ROUTINE", Color.blue);
        keywords.put("ROW", Color.blue);
        keywords.put("ROWS", Color.blue);
        keywords.put("SAVEPOINT", Color.blue);
        keywords.put("SCHEMA", Color.blue);
        keywords.put("SCOPE", Color.blue);
        keywords.put("SCROLL", Color.blue);
        keywords.put("SEARCH", Color.blue);
        keywords.put("SECTION", Color.blue);
        keywords.put("SELECT", Color.blue);
        keywords.put("SENSITIVE", Color.blue);
        keywords.put("SEQUENCE", Color.blue);
        keywords.put("SERIAL", Color.blue);
        keywords.put("SESSION", Color.blue);
        keywords.put("SESSION_USER", Color.blue);
        keywords.put("SET", Color.blue);
        keywords.put("SETS", Color.blue);
        keywords.put("SIZE", Color.blue);
        keywords.put("SMALLINT", Color.blue);
        keywords.put("SOME", Color.blue);
        keywords.put("SPECIFIC", Color.blue);
        keywords.put("SPECIFICTYPE", Color.blue);
        keywords.put("SQL", Color.blue);
        keywords.put("SQLCODE", Color.blue);
        keywords.put("SQLEXCEPTION", Color.blue);
        keywords.put("SQLSTATE", Color.blue);
        keywords.put("SQLWARNING", Color.blue);
        keywords.put("START", Color.blue);
        keywords.put("STATIC", Color.blue);
        keywords.put("STATISTICS", Color.blue);
        keywords.put("STOP", Color.blue);
        keywords.put("STRUCTURE", Color.blue);
        keywords.put("SUSPEND", Color.blue);
        keywords.put("SYNCHRONIZE", Color.blue);
        keywords.put("SYSTEM_USER", Color.blue);
        keywords.put("TABLE", Color.blue);
        keywords.put("TEMPORARY", Color.blue);
        keywords.put("TERMINATE", Color.blue);
        keywords.put("THAN", Color.blue);
        keywords.put("THEN", Color.blue);
        keywords.put("TIME", Color.blue);
        keywords.put("TIMESTAMP", Color.blue);
        keywords.put("TIMEZONE_HOUR", Color.blue);
        keywords.put("TIMEZONE_MINUTE", Color.blue);
        keywords.put("TO", Color.blue);
        keywords.put("TRACE", Color.blue);
        keywords.put("TRAILING", Color.blue);
        keywords.put("TRANSACTION", Color.blue);
        keywords.put("TRANSLATION", Color.blue);
        keywords.put("TREAT", Color.blue);
        keywords.put("TRIGGER", Color.blue);
        keywords.put("TRIM", Color.blue);
        keywords.put("TRUE", Color.blue);
        keywords.put("UNDER", Color.blue);
        keywords.put("UNION", Color.blue);
        keywords.put("UNKNOWN", Color.blue);
        keywords.put("UNLOAD", Color.blue);
        keywords.put("UNNEST", Color.blue);
        keywords.put("UNTIL", Color.blue);
        keywords.put("UPDATE", Color.blue);
        keywords.put("USAGE", Color.blue);
        keywords.put("USING", Color.blue);
        keywords.put("VALUE", Color.blue);
        keywords.put("VALUES", Color.blue);
        keywords.put("VARBINARY", Color.blue);
        keywords.put("VARCHAR", Color.blue);
        keywords.put("VARIABLE", Color.blue);
        keywords.put("VARYING", Color.blue);
        keywords.put("VIEW", Color.blue);
        keywords.put("WHEN", Color.blue);
        keywords.put("WHENEVER", Color.blue);
        keywords.put("WHERE", Color.blue);
        keywords.put("WHILE", Color.blue);
        keywords.put("WITH", Color.blue);
        keywords.put("WITHOUT", Color.blue);
        keywords.put("WORK", Color.blue);
        keywords.put("WRITE", Color.blue);
        keywords.put("ZONE", Color.blue);
        keywords.put("ABS", Color.blue);
        keywords.put("ACOS", Color.blue);
        keywords.put("ADD_DAYS", Color.blue);
        keywords.put("ADD_HOURS", Color.blue);
        keywords.put("ADD_MONTHS", Color.blue);
        keywords.put("ADD_SECS", Color.blue);
        keywords.put("ADD_YEARS", Color.blue);
        keywords.put("ASCII", Color.blue);
        keywords.put("ASIN", Color.blue);
        keywords.put("ATAN", Color.blue);
        keywords.put("ATAN2", Color.blue);
        keywords.put("ATOF", Color.blue);
        keywords.put("BLOBLEN", Color.blue);
        keywords.put("BLOBLENEX", Color.blue);
        keywords.put("CAST", Color.blue);
        keywords.put("CEILING", Color.blue);
        keywords.put("CHAR", Color.blue);
        keywords.put("CHAR_LENGTH", Color.blue);
        keywords.put("CHARACTER_LENGTH", Color.blue);
        keywords.put("CHECKMEDIAFORMAT", Color.blue);
        keywords.put("CONCAT", Color.blue);
        keywords.put("COS", Color.blue);
        keywords.put("COSH", Color.blue);
        keywords.put("COT", Color.blue);
        keywords.put("CURDATE", Color.blue);
        keywords.put("CURRENT_DATE", Color.blue);
        keywords.put("CURRENT_TIME", Color.blue);
        keywords.put("CURRENT_TIMESTAMP", Color.blue);
        keywords.put("CURRENT_USER", Color.blue);
        keywords.put("CURTIME", Color.blue);
        keywords.put("DATABASE", Color.blue);
        keywords.put("DATEPART", Color.blue);
        keywords.put("DAYNAME", Color.blue);
        keywords.put("DAYOFMONTH", Color.blue);
        keywords.put("DAYOFWEEK", Color.blue);
        keywords.put("DAYOFYEAR", Color.blue);
        keywords.put("DAYS_BETWEEN", Color.blue);
        keywords.put("DEGREES", Color.blue);
        keywords.put("DOCTOTXT", Color.blue);
        keywords.put("EXISTSNODE", Color.blue);
        keywords.put("EXP", Color.blue);
        keywords.put("EXTRACT", Color.blue);
        keywords.put("EXTRACTVALUE", Color.blue);
        keywords.put("FIX", Color.blue);
        keywords.put("FLOOR", Color.blue);
        keywords.put("FREXPE", Color.blue);
        keywords.put("FREXPM", Color.blue);
        keywords.put("FTOA", Color.blue);
        keywords.put("HIGHLIGHT", Color.blue);
        keywords.put("HITCOUNT", Color.blue);
        keywords.put("HITPOS", Color.blue);
        keywords.put("HMS", Color.blue);
        keywords.put("HOUR", Color.blue);
        keywords.put("HTMLHIGHLIGHT", Color.blue);
        keywords.put("HTMLTITLE", Color.blue);
        keywords.put("HTMTOTXT", Color.blue);
        keywords.put("HYPOT", Color.blue);
        keywords.put("INSERT", Color.blue);
        keywords.put("INVDATE", Color.blue);
        keywords.put("INVTIME", Color.blue);
        keywords.put("INVTIMESTAMP", Color.blue);
        keywords.put("LAST_DAY", Color.blue);
        keywords.put("LCASE", Color.blue);
        keywords.put("LDEXP", Color.blue);
        keywords.put("LEFT", Color.blue);
        keywords.put("LENGTH", Color.blue);
        keywords.put("LOCATE", Color.blue);
        keywords.put("LOG", Color.blue);
        keywords.put("LOG10", Color.blue);
        keywords.put("LOWER", Color.blue);
        keywords.put("LTRIM", Color.blue);
        keywords.put("MDY", Color.blue);
        keywords.put("MINUTE", Color.blue);
        keywords.put("MOD", Color.blue);
        keywords.put("MODFI", Color.blue);
        keywords.put("MODFM", Color.blue);
        keywords.put("MONTH", Color.blue);
        keywords.put("MONTHNAME", Color.blue);
        keywords.put("NEXT_DAY", Color.blue);
        keywords.put("NOW", Color.blue);
        keywords.put("PDFTOTXT", Color.blue);
        keywords.put("PI", Color.blue);
        keywords.put("POSITION", Color.blue);
        keywords.put("POW", Color.blue);
        keywords.put("PPTTOTXT", Color.blue);
        keywords.put("QUARTER", Color.blue);
        keywords.put("RADIANS", Color.blue);
        keywords.put("RAND", Color.blue);
        keywords.put("REPEAT", Color.blue);
        keywords.put("REPLACE", Color.blue);
        keywords.put("RIGHT", Color.blue);
        keywords.put("RND", Color.blue);
        keywords.put("ROUND", Color.blue);
        keywords.put("RTRIM", Color.blue);
        keywords.put("SECOND", Color.blue);
        keywords.put("SECS_BETWEEN", Color.blue);
        keywords.put("SESSION_USER", Color.blue);
        keywords.put("SIGN", Color.blue);
        keywords.put("SIN", Color.blue);
        keywords.put("SINH", Color.blue);
        keywords.put("SPACE", Color.blue);
        keywords.put("SQRT", Color.blue);
        keywords.put("STRTOINT", Color.blue);
        keywords.put("SUBBLOB", Color.blue);
        keywords.put("SUBBLOBTOBIN", Color.blue);
        keywords.put("SUBBLOBTOCHAR", Color.blue);
        keywords.put("SUBSTRING", Color.blue);
        keywords.put("TAN", Color.blue);
        keywords.put("TANH", Color.blue);
        keywords.put("TIMEPART", Color.blue);
        keywords.put("TIMESTAMPADD", Color.blue);
        keywords.put("TIMESTAMPDIFF", Color.blue);
        keywords.put("TRIM", Color.blue);
        keywords.put("UCASE", Color.blue);
        keywords.put("UPPER", Color.blue);
        keywords.put("USER", Color.blue);
        keywords.put("WEEK", Color.blue);
        keywords.put("XLSTOTXT", Color.blue);
        keywords.put("XMLUPDATE", Color.blue);
        keywords.put("YEAR", Color.blue);
        keywords.put("ENCRYPT", Color.blue);
        keywords.put("DECRYPT", Color.blue);
        keywords.put(";", Color.red);
        keywords.put("'", new Color(130, 0, 0));
        keywords.put("(", Color.red);
        keywords.put(")", Color.red);
        keywords.put("=", Color.red);
        keywords.put(">", Color.red);
        keywords.put("<", Color.red);
        keywords.put("*", Color.red);
    }
}

