/*
 * Decompiled with CFR 0.152.
 */
package dbaut;

import dbaut.DbaUtDef;
import dbaut.IncBackupFile;
import dbaut.JBackupHistory;
import dbaut.JdmConfig;
import dbaut.svrmgrlib;
import java.awt.Component;
import java.util.Vector;

public class JRestore {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final int FILE_SEPARATOR_LEN = FILE_SEPARATOR.length();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final int OFF_LINE = 1;
    public static final int ON_LINE = 0;
    public static final int STAND_IO = 0;
    public static final int LOG_IO = 1;
    public static final int SP_RECOVERY_ON = 1;
    public static final int SP_RECOVERY_OFF = 0;
    private long[] h_rb = null;
    private String dbname;
    private String usrname;
    private String histfile;
    private int backup_id;
    public int lastrip = -1;
    private static String errstr = null;
    private static final int LEN_FNAME = 256;
    private svrmgrlib cfun = new svrmgrlib();
    private Component comp = null;

    public JRestore(Component comp) {
        this.comp = comp;
    }

    public String geterrstr() {
        if (errstr == null) {
            return new String("");
        }
        return errstr.trim();
    }

    public String getHistoryFilePath(String historyFullPath) {
        int lastIndex;
        String str = null;
        if (historyFullPath != null && historyFullPath.length() > 0 && (lastIndex = historyFullPath.lastIndexOf(FILE_SEPARATOR)) != -1) {
            str = historyFullPath.substring(0, lastIndex + 1);
        }
        return str;
    }

    public int createRealHistoryFile(String dmconfigFullPath, String dbName, String historyFullPath, String realHistoryName) {
        int result = 0;
        if (this.cfun != null) {
            result = this.cfun.createRealHistoryFile(dmconfigFullPath.getBytes(), dbName.getBytes(), historyFullPath.getBytes(), realHistoryName.getBytes());
        }
        return result;
    }

    public int start(String dbname, String usrname, String histfile) {
        errstr = null;
        this.dbname = dbname;
        this.usrname = usrname;
        this.histfile = histfile;
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", dbname, "r+");
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("Error open config file");
            return rc;
        }
        rc = config.insertPara("DB_SMODE", new Integer(DbaUtDef.ENG_JNLOVER), 8192);
        rc = config.fileClose();
        this.h_rb = new long[1];
        int[] secid = new int[1];
        int[] bkid = new int[1];
        byte[] errmsg = new byte[1024];
        rc = this.cfun.cistart(this.h_rb, dbname.getBytes(), usrname.getBytes(), secid, DbaUtDef.ENG_BEG_ROV, bkid, errmsg);
        if (rc != DbaUtDef.RTN_OK && rc != DbaUtDef.ERR_ROV_NEED_MORE) {
            System.out.println("cistart error : " + rc);
            errstr = new String(errmsg);
            this.h_rb = null;
        } else {
            this.backup_id = bkid[0];
        }
        System.out.println("cistart rc=" + rc);
        return rc;
    }

    public int rollover(int rip, Vector v) {
        errstr = null;
        System.out.println("rollover rip=" + rip + " v is " + (v == null ? "null" : "not null and size=" + v.size()));
        this.lastrip = rip;
        if (this.h_rb == null) {
            return -1;
        }
        if (v == null && rip != DbaUtDef.ENG_END_ROV) {
            return -1;
        }
        int rc = 0;
        int size = 0;
        int[] bkid = new int[1];
        byte[] errmsg = new byte[1024];
        if ((v == null || v.size() == 0) && rip == DbaUtDef.ENG_END_ROV) {
            size = 0;
            byte[] jnlnames = new byte[2048];
            rc = this.cfun.cirollover(this.h_rb, this.dbname.getBytes(), rip, jnlnames, size, bkid, errmsg);
            if (rc != DbaUtDef.RTN_OK && rc != DbaUtDef.ERR_ROV_NEED_MORE) {
                System.out.println("cirollover error : " + rc);
                errstr = new String(errmsg);
                System.out.println("errstr = " + errstr);
            }
            return rc;
        }
        while (v.size() > 0) {
            size = v.size() > 8 ? 8 : v.size();
            byte[] jnlnames = new byte[2048];
            for (int i = 0; i < size; ++i) {
                Object obj = v.elementAt(0);
                String str = obj instanceof IncBackupFile ? ((IncBackupFile)v.elementAt((int)0)).filename : obj.toString();
                v.removeElementAt(0);
                byte[] bytes = str.getBytes();
                System.arraycopy(bytes, 0, jnlnames, i * 256, bytes.length);
                System.out.println("jnlnames = " + jnlnames.toString());
            }
            rc = this.cfun.cirollover(this.h_rb, this.dbname.getBytes(), rip, jnlnames, size, bkid, errmsg);
            if (rc != DbaUtDef.RTN_OK && rc != DbaUtDef.ERR_ROV_NEED_MORE) {
                errstr = new String(errmsg);
                System.out.println("cirollover error : " + rc);
                break;
            }
            this.backup_id = bkid[0];
        }
        return rc;
    }

    public Vector getIncBackupInfo(String restoreDBName, String historyFile, int index, int fgFull) {
        if (restoreDBName == null) {
            return null;
        }
        JBackupHistory backupFile = new JBackupHistory(this.comp);
        int rc = backupFile.FileOpen(restoreDBName, historyFile, "0");
        if (rc != DbaUtDef.RTN_OK) {
            return null;
        }
        backupFile.getFullBackupList();
        Vector v = backupFile.getIncBackupInfo(index, fgFull);
        backupFile.FileClose();
        return v;
    }

    public int shutdown(int flag) {
        if (this.h_rb == null) {
            return -1;
        }
        byte[] errmsg = new byte[1024];
        int rc = this.cfun.cishut(this.h_rb, flag, errmsg);
        if (rc != DbaUtDef.RTN_OK) {
            System.out.println("cishut error : " + rc);
            errstr = new String(errmsg);
        }
        this.h_rb = null;
        return rc;
    }

    public int onlineutrolsvr(int fgBkfo, int fgBksp, String rTime, String dbName, String configFileName, String hisFileName, String foHisFileName, String spHisFileName, byte[] msg) {
        int afgBkfo = fgBkfo;
        int afgBksp = fgBksp;
        byte[] arTime = rTime.getBytes();
        byte[] adbName = dbName.getBytes();
        byte[] aconfigFileName = configFileName.getBytes();
        byte[] ahisFileName = hisFileName.getBytes();
        byte[] afoHisFileName = foHisFileName.getBytes();
        byte[] aspHisFileName = spHisFileName.getBytes();
        int returnValue = 0;
        returnValue = this.cfun.utrolsvr(0, afgBkfo, afgBksp, arTime, adbName, aconfigFileName, ahisFileName, afoHisFileName, aspHisFileName, msg, 1);
        return returnValue;
    }

    public int offlineutrolsvr(int fgBkfo, String rTime, String dbName, String configFileName, String hisFileName, byte[] msg) {
        int afgBkfo = fgBkfo;
        byte[] arTime = rTime.getBytes();
        byte[] adbName = dbName.getBytes();
        byte[] aconfigFileName = configFileName.getBytes();
        byte[] ahisFileName = hisFileName.getBytes();
        int returnValue = 0;
        returnValue = this.cfun.utrolsvr(1, afgBkfo, 0, arTime, adbName, aconfigFileName, ahisFileName, "".getBytes(), "".getBytes(), msg, 1);
        return returnValue;
    }
}

