/*
 * Decompiled with CFR 0.152.
 */
package dbatool.User;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableCell.BooleanEditor;
import dbatool.tableCell.BooleanRenderer;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class UserList
extends DbaTabbedPane
implements ComponentPrivilege {
    private static final String SYSADM = "SYSADM";
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private DbaTableModel model1 = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private DbaButton Create_Button = new DbaButton(new Dimension(80, 24), this.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
    private DbaButton Drop_Button = new DbaButton(new Dimension(80, 24), this.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
    public final int USER = 0;
    public final int SYSDBA = 1;
    public final int DBA = 2;
    public final int RESOURCE = 3;
    public final int GROUPS = 4;

    public UserList() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("UsersTabbedPane");
        DbaPanel Users = new DbaPanel(DbFrame.helpres, "user.list");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        String[] columnNames = new String[]{this.res.getString("User"), this.res.getString("SYSDBA"), this.res.getString("DBA"), this.res.getString("Resource")};
        this.model1 = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model1);
        this.table1 = new JTable(this.absModel);
        this.table1.setName("UsersListTable");
        Users.setLayout(new BorderLayout());
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.table1.setSelectionMode(0);
        this.table1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UserList.this.table1_mouseClicked(e);
            }
        });
        Users.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)Users, this.res.getTitle("Users"));
        Users.add((Component)jScrollPane1, "Center");
        Users.add((Component)jPanel2, "North");
        jPanel2.setName("UsersListButtonPanel");
        this.Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        jPanel2.add((Component)this.Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.getUserList();
        this.initColumnSizes(this.table1);
        this.setUpBooleanRendererEditor(this.table1);
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
    }

    @Override
    public int getComponentType() {
        return 8;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Drop_Button.setEnabled(enabled);
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            this.authority.authorise();
        }
    }

    private void setUpBooleanRendererEditor(JTable table) {
        table.setDefaultEditor(Boolean.class, new BooleanEditor(table, table.getModel()));
        table.setDefaultRenderer(Boolean.class, new BooleanRenderer());
    }

    private boolean isDBA(String user) {
        if (this.model1.getRowCount() <= 0) {
            return false;
        }
        int index = 0;
        int row_count = this.model1.getRowCount();
        String u = null;
        for (index = 0; index < row_count && !(u = (String)this.model1.getValueAt(index, 0)).equalsIgnoreCase(user); ++index) {
        }
        if (index < this.model1.getRowCount()) {
            Boolean dba = (Boolean)this.model1.getValueAt(index, 2);
            return dba;
        }
        return false;
    }

    private void getUserList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model1.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "SELECT USER_NAME, DBA, RESOURCE from SYSAUTHUSER ORDER BY USER_NAME";
            rs = stmt.executeQuery(query);
            String user_name = null;
            while (rs.next()) {
                user_name = GuiUt.rightTrim(rs.getString(1));
                this.model1.addValue(new DBARowInfo(this.getRowInfo(user_name, rs.getShort(2), rs.getShort(3))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(this.res.getString("The_number_of_users") + " " + this.model1.getRowCount());
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(3);
        column.setPreferredWidth(60);
    }

    private Object[] getRowInfo(String user_name, short dba, short resource) {
        Object[] data = new Object[4];
        boolean isSysdba = dba == 2 || user_name.equals(SYSADM);
        boolean isDba = dba == 1;
        boolean isResource = resource == 1;
        data[0] = user_name;
        data[1] = new Boolean(isSysdba);
        data[2] = new Boolean(isDba);
        data[3] = new Boolean(isResource);
        return data;
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(7);
        this.getUserList();
        DbFrame.frame.treePanel.refreshUserTree();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        String user_name = (String)this.model1.getValueAt(row, 0);
        Boolean isSYSDBA = (Boolean)this.model1.getValueAt(row, 1);
        if (user_name.equalsIgnoreCase(SYSADM)) {
            DbFrame.frame.setStatusDisc(this.res.getString("Cannot_delete_SYSADM"));
            return;
        }
        if (isSYSDBA.booleanValue() && this.authority.isSysdba()) {
            DbFrame.frame.setStatusDisc(this.res.getString("SYSDBA_cannot_delete_SYSDBA"));
            return;
        }
        if (DbFrame.conn_DatabaseConnection.dropUser(user_name)) {
            DbFrame.frame.treePanel.afterDropObject(8);
        }
    }

    void table1_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.table1.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            String user = (String)this.absModel.getValueAt(row, 0);
            DbFrame.frame.treePanel.openUserTree(user);
        }
    }
}

