/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Tablespace;

import dbatool.DbFrame;
import dbaut.resource.DBAResourceBundle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.JPanel;

public class PercentPanel
extends JPanel {
    private DBAResourceBundle res = DbFrame.frame.getResourceBundle();
    private float dataTotal = 0.0f;
    private float blobTotal = 0.0f;
    private float dataFree = 0.0f;
    private float blobFree = 0.0f;
    private final int DEFAULT_WIDTH = 150;
    private final int DEFAULT_HEIGTH = 20;

    public PercentPanel(int dataTotal, int dataFree, int blobTotal, int blobFree) {
        this.dataTotal = dataTotal;
        this.dataFree = dataFree;
        this.blobTotal = blobTotal;
        this.blobFree = blobFree;
        this.setMaximumSize(new Dimension(480, 200));
        this.setPreferredSize(new Dimension(480, 160));
    }

    @Override
    public void paint(Graphics g) {
        int space = 90;
        Point origin = new Point(20, 20);
        g.setFont(new Font("Dialog", 1, 15));
        g.drawString(this.res.getString("Pages_Graphic"), origin.x, origin.y);
        g.drawString(this.res.getString("Frames_Graphic"), origin.x + 150 + space, origin.y);
        g.drawRect(origin.x, origin.y + 5, 150, 20);
        g.drawRect(origin.x + 150 + space, origin.y + 5, 150, 20);
        float dataRatio = (this.dataTotal - this.dataFree) / this.dataTotal * 100.0f;
        Color col = null;
        col = dataRatio >= 80.0f ? Color.RED : (dataRatio >= 60.0f ? Color.ORANGE : (0.0f < dataRatio && dataRatio < 60.0f ? Color.GREEN : Color.BLACK));
        g.setColor(col);
        g.fillRect(origin.x + 1, origin.y + 1 + 5, (int)(dataRatio * 150.0f / 100.0f) - 1, 19);
        g.setColor(Color.BLACK);
        g.setFont(new Font("Dialog", 0, 12));
        float f1 = Math.round(dataRatio * 100.0f) / 100;
        g.drawString(this.res.getString("Used") + ":" + f1 + "%", origin.x, 58);
        float blobRatio = (this.blobTotal - this.blobFree) / this.blobTotal * 100.0f;
        col = blobRatio >= 80.0f ? Color.RED : (blobRatio >= 60.0f ? Color.ORANGE : (0.0f < blobRatio && blobRatio < 60.0f ? Color.GREEN : Color.BLACK));
        g.setColor(col);
        g.fillRect(origin.x + 150 + space + 1, origin.y + 1 + 5, (int)(blobRatio * 150.0f / 100.0f) - 1, 19);
        g.setColor(Color.BLACK);
        g.setFont(new Font("Dialog", 0, 12));
        float f = Math.round(blobRatio * 100.0f) / 100;
        g.drawString(this.res.getString("Used") + ":" + f + "%", origin.x + 150 + space, 58);
    }
}

