/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.Table.TableInfo;
import dbatool.tableModel.BasicInfoTableModel;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.panel.PanelWithTitle;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.IntegerField;
import dbaut.textField.IntegerRangeField2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;

public class TableStatistics
extends DbaPanel
implements ComponentPrivilege {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.TableRes", LocaleManager.getLocale());
    private TableInfo tableinfo = null;
    private String table_owner = null;
    private String table_name = null;
    private DbaTableModel columnStatTableModel = null;
    private DBAToolAbstractTableModel absColumnStatTableModel = null;
    private JTable Statistics_Columns = null;
    private BasicInfoTableModel tableStatTableModel = null;
    private JTable Statistics_Table = null;
    private DbaButton Statistics_Update_Button = null;
    private IntegerField Statistics_Sample_Ratio = null;
    private PanelWithTitle daemonPanel = new PanelWithTitle(this.res.getString("Daemon"));
    private PanelWithTitle modePanel = new PanelWithTitle(this.res.getString("Mode"));
    private PanelWithTitle samplePanel = new PanelWithTitle(this.res.getString("Sample"));
    private DbaButton modifyButton = new DbaButton(new Dimension(80, 24), this.res.getString("Start_Modify"), 'M', DBAImageResource.getResource(this.getClass(), "/jdbaimages/start_modify.gif"), new ReflectionAction(this, "modifyButtonActionPreformed"));
    private DbaButton confirmButton = new DbaButton(new Dimension(80, 24), this.res.getString("Confirm"), 'N', DBAImageResource.getResource(this.getClass(), "/jdbaimages/confirm.gif"), new ReflectionAction(this, "confirmButtonActionPreformed"));
    private DbaButton cancelButton = new DbaButton(new Dimension(80, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPreformed"));
    private JRadioButton mode0 = new JRadioButton();
    private JRadioButton mode1 = new JRadioButton();
    private JRadioButton sample0 = new JRadioButton();
    private JRadioButton sample1 = new JRadioButton();
    private JRadioButton sampleRatio = new JRadioButton();
    private IntegerRangeField2 daemonRatioField = new IntegerRangeField2(1, 100, true);
    private JLabel unitLabel = new JLabel("%");

    public TableStatistics(String helpid2, TableInfo tableinfo) {
        super(DbFrame.helpres, helpid2);
        this.tableinfo = tableinfo;
        this.table_owner = tableinfo.table_owner;
        this.table_name = tableinfo.table_name;
        this.res = tableinfo.res;
    }

    public boolean initPanel() {
        if (this.getComponentCount() > 0) {
            return false;
        }
        String[] ColumnStatColumnNames = new String[]{this.res.getString("Column"), this.res.getString("Number_of_Distinct_Values"), this.res.getString("Average_Length"), this.res.getString("Low_Value"), this.res.getString("High_Value")};
        this.columnStatTableModel = new DbaTableModel(ColumnStatColumnNames);
        this.absColumnStatTableModel = new DBAToolAbstractTableModel(this.columnStatTableModel);
        this.Statistics_Columns = new JTable(this.absColumnStatTableModel);
        this.Statistics_Columns.getTableHeader().setReorderingAllowed(false);
        this.tableStatTableModel = new BasicInfoTableModel();
        this.Statistics_Table = new JTable(this.tableStatTableModel);
        this.Statistics_Table.getTableHeader().setReorderingAllowed(false);
        this.Statistics_Update_Button = new DbaButton(new Dimension(160, 24), this.res.getString("Update_Statistics"), 'U', DBAImageResource.getResource(this.getClass(), "/jdbaimages/update_statistics.gif"), new ReflectionAction(this, "Statistics_Update_Button_actionPerformed"));
        this.Statistics_Sample_Ratio = new IntegerField(0, 0, 3);
        JScrollPane jScrollPane4 = new JScrollPane();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        JPanel jPanel15 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel13 = new JPanel();
        jScrollPane4.getViewport().add((Component)this.Statistics_Columns, null);
        this.absColumnStatTableModel.addMouseListenerToHeaderInTable(this.Statistics_Columns);
        jScrollPane4.setPreferredSize(new Dimension(385, 100));
        this.Statistics_Sample_Ratio.setText("100");
        jLabel7.setText(this.res.getString("Sample_Ratio"));
        jLabel8.setText("% [1-100%]");
        jLabel6.setText(this.res.getString("Statistics_Data_for1"));
        this.Statistics_Table.setBorder(BorderFactory.createEmptyBorder());
        jPanel13.setLayout(new BorderLayout());
        jPanel13.add((Component)jLabel6, "North");
        jPanel13.add((Component)this.Statistics_Table, "Center");
        JLabel emptyLabel = new JLabel();
        emptyLabel.setPreferredSize(new Dimension(80, 1));
        jPanel15.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Manual"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        jPanel15.setLayout(new FlowLayout(0));
        jPanel15.add(this.Statistics_Update_Button);
        jPanel15.add(emptyLabel);
        jPanel15.add(jLabel7);
        jPanel15.add(this.Statistics_Sample_Ratio);
        jPanel15.add(jLabel8);
        JPanel upPanel = new JPanel(new BorderLayout());
        upPanel.add((Component)jPanel15, "North");
        JPanel bPanel = new JPanel(new FlowLayout(0));
        bPanel.add(this.modifyButton);
        bPanel.add(this.confirmButton);
        bPanel.add(this.cancelButton);
        this.daemonPanel.add(bPanel);
        this.mode0.setText(this.res.getString("Use_dmconfig_Setting"));
        this.mode1.setText(this.res.getString("Every_table_setting"));
        this.mode0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableStatistics.this.mode0ActionPerformed(e);
            }
        });
        this.mode1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableStatistics.this.mode1ActionPerformed(e);
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mode0);
        bg.add(this.mode1);
        this.modePanel.add(this.mode0);
        this.modePanel.add(this.mode1);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.sample0);
        bg2.add(this.sample1);
        bg2.add(this.sampleRatio);
        this.sample0.setText(this.res.getString("Smart_sample_ratio"));
        this.sample1.setText(this.res.getString("Not_do_update_statistics"));
        this.sampleRatio.setText(this.res.getString("Sample_Ratio"));
        this.sampleRatio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TableStatistics.this.sampleRatioChange();
            }
        });
        this.samplePanel.add(this.sample0);
        this.samplePanel.add(this.sample1);
        JPanel sspPanel = new JPanel();
        sspPanel.setLayout(new FlowLayout(0, 0, 0));
        sspPanel.add(this.sampleRatio);
        this.daemonRatioField.setValue(100);
        sspPanel.add(this.daemonRatioField);
        sspPanel.add(this.unitLabel);
        this.samplePanel.add(sspPanel);
        JPanel panel0 = new JPanel(new FlowLayout(0));
        JPanel panel00 = new JPanel(new GridLayout(1, 2, 0, 0));
        panel00.add(this.modePanel);
        panel00.add(this.samplePanel);
        panel0.add(panel00);
        this.daemonPanel.add(panel0);
        upPanel.add(this.daemonPanel);
        jPanel9.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)jPanel13, "Center");
        jPanel9.add((Component)upPanel, "North");
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jLabel5.setText(this.res.getString("Statistics_Data_for"));
        jPanel5.add((Component)jLabel5, "North");
        jPanel5.add((Component)jScrollPane4, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel5, "Center");
        this.add((Component)jPanel9, "North");
        this.modifyButton.setEnabled(true);
        this.setCompEnabled();
        this.setNames();
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce(this.table_owner);
        return true;
    }

    @Override
    public int getComponentType() {
        return 601;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Statistics_Update_Button.setEnabled(enabled);
        this.Statistics_Sample_Ratio.setEnabled(enabled);
        this.modifyButton.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
    }

    private void sampleRatioChange() {
        this.daemonRatioField.setEnabled(this.sampleRatio.isSelected() && this.sampleRatio.isEnabled());
    }

    private void setNames() {
        this.setName("TableStatisticsPanel");
        this.modifyButton.setName("ModifyButton");
        this.confirmButton.setName("ConfirmButton");
        this.cancelButton.setName("CancelButton");
        this.mode0.setName("UsedmconfigModeRadioButton");
        this.mode1.setName("EveryTableSettingRadioButton");
        this.sample0.setName("SmartSampleRatioRadioButton");
        this.sample1.setName("NotDoUpdateStatisticsRadioButton");
        this.sampleRatio.setName("SampleRadioButton");
        this.daemonRatioField.setName("SampleRatioField");
    }

    private void mode0ActionPerformed(ActionEvent e) {
        if (this.mode0.isSelected()) {
            this.sample0.setEnabled(false);
            this.sample1.setEnabled(false);
            this.sampleRatio.setEnabled(false);
            this.daemonRatioField.setEnabled(false);
            this.unitLabel.setEnabled(false);
        }
    }

    private void mode1ActionPerformed(ActionEvent e) {
        if (this.mode1.isSelected()) {
            this.sample0.setEnabled(true);
            this.sample1.setEnabled(true);
            this.sampleRatio.setEnabled(true);
            this.daemonRatioField.setEnabled(this.sampleRatio.isSelected());
            this.unitLabel.setEnabled(this.sampleRatio.isSelected());
        }
    }

    private void setCompEnabled() {
        boolean enabled = this.modifyButton.isEnabled();
        if (enabled) {
            this.confirmButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.mode0.setEnabled(false);
            this.mode1.setEnabled(false);
            this.sample0.setEnabled(false);
            this.sample1.setEnabled(false);
            this.sampleRatio.setEnabled(false);
            this.daemonRatioField.setEnabled(false);
            this.unitLabel.setEnabled(false);
        } else {
            this.confirmButton.setEnabled(true);
            this.cancelButton.setEnabled(true);
            this.mode0.setEnabled(true);
            this.mode1.setEnabled(true);
            this.sample0.setEnabled(true);
            this.sample1.setEnabled(true);
            this.sampleRatio.setEnabled(true);
            this.daemonRatioField.setEnabled(this.sampleRatio.isSelected());
            this.unitLabel.setEnabled(this.sampleRatio.isSelected());
        }
    }

    public void getTableStatistics() {
        if (this.getComponentCount() == 0 && !this.initPanel()) {
            return;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if (this.Statistics_Table == null) {
                return;
            }
            this.tableStatTableModel.removeAll();
            this.columnStatTableModel.removeAll();
            System.gc();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select COLUMN_NAME, DISTINCT_VALUE, AVERAGE_LENGTH, ";
            query = DbFrame.conn_DatabaseConnection.isFileVersionLater35() ? query + "VALUETOSTR(LOW_VALUE,RESERVE1,LENGTH), " + "VALUETOSTR(HIGH_VALUE,RESERVE1,LENGTH) " : query + "LOW_VALUE, " + "HIGH_VALUE ";
            query = query + "from SYSTEM.SYSCOLUMN " + "where TABLE_OWNER = '" + GuiUt.singleQuoteHandle(this.table_owner) + "' and TABLE_NAME = '" + GuiUt.singleQuoteHandle(this.table_name) + "' order by COLUMN_ORDER";
            rs = stmt.executeQuery(query);
            String column_name = null;
            while (rs.next()) {
                column_name = rs.getString(1);
                this.columnStatTableModel.addValue(new DBARowInfo(this.getColumnStatRowInfo(column_name, rs.getInt(2), rs.getInt(3), rs.getString(4), rs.getString(5))));
            }
            rs.close();
            int table_size = 0;
            query = "select NUM_COL, NUM_INDEX, NUM_PAGE, NUM_ROW, AVERAGE_LENGTH, NUM_TRIG, NUM_TEXTINDEX, NUM_PUBLICATION, DWTOSTR(UPD_STS_TIME), NUM_INDIRECT_ROW, NUM_FRAME from SYSTEM.SYSTABLE where TABLE_OWNER = '" + GuiUt.singleQuoteHandle(this.table_owner) + "' and TABLE_NAME = '" + GuiUt.singleQuoteHandle(this.table_name) + "'";
            rs = stmt.executeQuery(query);
            Object[] newData = null;
            while (rs.next()) {
                newData = new Object[]{new String(this.res.getString("Number_of_Columns")), new String("" + rs.getShort("NUM_COL"))};
                this.tableStatTableModel.addValue(newData);
                newData = new Object[]{new String(this.res.getString("Number_of_Indexes")), new String("" + rs.getShort("NUM_INDEX"))};
                this.tableStatTableModel.addValue(newData);
                newData = new Object[2];
                newData[0] = new String(this.res.getString("Number_of_Pages"));
                table_size = rs.getInt("NUM_PAGE");
                newData[1] = new String("" + table_size);
                this.tableStatTableModel.addValue(newData);
                newData = new Object[]{new String(this.res.getString("Number_of_Rows")), new String("" + rs.getInt("NUM_ROW"))};
                this.tableStatTableModel.addValue(newData);
                newData = new Object[]{new String(this.res.getString("Number_of_indirect_rows")), Integer.toString(rs.getInt("NUM_INDIRECT_ROW"))};
                this.tableStatTableModel.addValue(newData);
                newData = new Object[]{new String(this.res.getString("Number_of_blob_frames")), Integer.toString(rs.getInt("NUM_FRAME"))};
                this.tableStatTableModel.addValue(newData);
                newData = new Object[]{new String(this.res.getString("Average_Length")), new String("" + rs.getInt("AVERAGE_LENGTH"))};
                this.tableStatTableModel.addValue(newData);
                newData = new Object[]{new String(this.res.getString("Number_of_Triggers")), new String("" + rs.getInt("NUM_TRIG"))};
                this.tableStatTableModel.addValue(newData);
                newData = new Object[]{new String(this.res.getString("Number_of_Text")), new String("" + rs.getInt("NUM_TEXTINDEX"))};
                this.tableStatTableModel.addValue(newData);
                newData = new Object[]{new String(this.res.getString("Number_of_Publication")), new String("" + rs.getInt("NUM_PUBLICATION"))};
                this.tableStatTableModel.addValue(newData);
                newData = new Object[]{new String(this.res.getString("Update_Statistics_Time")), new String(rs.getString(9))};
                this.tableStatTableModel.addValue(newData);
            }
            rs.close();
            int indexes_size = 0;
            query = "select SUM( NUM_PAGE ) from SYSTEM.SYSINDEX where TABLE_OWNER = '" + GuiUt.singleQuoteHandle(this.table_owner) + "' and TABLE_NAME = '" + GuiUt.singleQuoteHandle(this.table_name) + "'";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                indexes_size = rs.getInt(1);
            }
            rs.close();
            newData = new Object[]{new String(this.res.getString("Total_indexes_size")), new String(indexes_size + "/" + table_size + " (" + (float)indexes_size / (float)table_size + ")")};
            this.tableStatTableModel.addValue(newData);
            this.absColumnStatTableModel.fireTableChanged(new TableModelEvent(this.absColumnStatTableModel));
            this.tableStatTableModel.fireTableChanged(new TableModelEvent(this.tableStatTableModel));
            String sql = "select UPD_STS_MODE, UPD_STS_SAMPLE from SYSTABLE where TABLE_OWNER like '" + this.table_owner + "' AND TABLE_NAME LIKE '" + this.table_name + "';";
            ResultSet rs3 = stmt.executeQuery(sql);
            String mode = null;
            String sample = null;
            while (rs3.next()) {
                mode = rs3.getString(1);
                sample = rs3.getString(2);
            }
            rs3.close();
            if (mode.equals("0")) {
                this.mode0.setSelected(true);
            } else if (mode.equals("1")) {
                this.mode1.setSelected(true);
            }
            if (sample.equals("-1")) {
                this.sample0.setSelected(true);
            } else if (sample.equals("0")) {
                this.sample1.setSelected(true);
            } else {
                this.sampleRatio.setSelected(true);
                this.daemonRatioField.setValue(sample);
            }
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void Statistics_Update_Button_actionPerformed(ActionEvent e) {
        int reply = GuiUt.showOptionDlg(DbFrame.frame, this.res.getString("Update_Statistics"), DbFrame.frame.getResourceBundle().getString("Do_you_want_to_update_table_statistics"));
        if (reply != 0) {
            return;
        }
        int ratio = 100;
        if (this.Statistics_Sample_Ratio != null && ((ratio = Integer.parseInt(this.Statistics_Sample_Ratio.getText())) < 1 || ratio > 100)) {
            DbFrame.frame.setStatusDisc(this.res.getString("Sample_ratio_should"));
        }
        String query = "UPDATE STATISTICS \"" + this.table_owner + "\".\"" + this.table_name + "\" SAMPLE = " + ratio;
        DbFrame.frame.setStatusDisc(this.res.getString("Updating_statistics_"));
        boolean result = DatabaseConnection.executeSQL(query);
        DbFrame.frame.setStatusDisc("  ");
        if (result) {
            GuiUt.showInformationDlg(DbFrame.frame, this.res.getString("Statistics_has_been"));
            DbFrame.frame.setStatusDisc(this.res.getString("Statistics_has_been"));
            this.getTableStatistics();
            this.absColumnStatTableModel.fireTableChanged(new TableModelEvent(this.absColumnStatTableModel));
            this.tableStatTableModel.fireTableChanged(new TableModelEvent(this.tableStatTableModel));
        }
    }

    public void modifyButtonActionPreformed(ActionEvent e) {
        this.modifyButton.setEnabled(false);
        this.tableinfo.fixTabbedPanelAt(this.tableinfo.getSelectedIndex());
        this.setCompEnabled();
        this.mode0ActionPerformed(null);
        this.mode1ActionPerformed(null);
    }

    public void confirmButtonActionPreformed(ActionEvent e) {
        Object o1;
        this.modifyButton.setEnabled(true);
        this.setCompEnabled();
        String mode = "0";
        String sample = "100";
        if (this.mode0.isSelected()) {
            mode = "0";
        } else if (this.mode1.isSelected()) {
            mode = "1";
        }
        if (this.sample0.isSelected()) {
            sample = "-1";
        } else if (this.sample1.isSelected()) {
            sample = "0";
        } else if (this.sampleRatio.isSelected() && (o1 = this.daemonRatioField.getValue()) != null) {
            sample = o1.toString();
        }
        String sql = "UPDATE STATISTICS SET " + GuiUt.getIDString(this.table_owner) + "." + GuiUt.getIDString(this.table_name) + " MODE=" + mode + ", SAMPLE=" + sample;
        DatabaseConnection.executeSQL(DbFrame.frame, sql);
        this.tableinfo.releaseTabbedPanel();
        this.getTableStatistics();
        this.absColumnStatTableModel.fireTableChanged(new TableModelEvent(this.absColumnStatTableModel));
        this.tableStatTableModel.fireTableChanged(new TableModelEvent(this.tableStatTableModel));
    }

    public void cancelButtonActionPreformed(ActionEvent e) {
        this.modifyButton.setEnabled(true);
        this.setCompEnabled();
        this.tableinfo.releaseTabbedPanel();
        this.getTableStatistics();
        this.absColumnStatTableModel.fireTableChanged(new TableModelEvent(this.absColumnStatTableModel));
        this.tableStatTableModel.fireTableChanged(new TableModelEvent(this.tableStatTableModel));
    }

    private Object[] getColumnStatRowInfo(String name, int distinct_value, int average_length, String low_value, String high_value) {
        Object[] data = new Object[5];
        data[0] = name.trim();
        data[1] = distinct_value == -1 ? "N/A" : distinct_value + "";
        data[3] = low_value != null ? low_value.trim() : "";
        data[4] = high_value != null ? high_value.trim() : "";
        data[2] = new Integer(average_length);
        return data;
    }
}

