/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.TreeNode.TableListTreeNode;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class TableList
extends DbaTabbedPane
implements ComponentPrivilege {
    private DbaTableModel model = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private DbaButton Table_Create_Button;
    private DbaButton Table_Drop_Button;
    private final int COLUMN_COUNT = 10;
    private final int OWNER = 0;
    private final int NAME = 1;
    private final int TABLESPACE = 2;
    private final int NUM_OF_ROW = 3;
    private final int NUM_OF_PAGE = 4;
    private final int NUM_OF_INDEX = 5;
    private final int NUM_OF_COLUMN = 6;
    private final int NUM_OF_INDIRECT = 7;
    private final int NUM_OF_BLOB_FRAME = 8;
    private final int CREATE_TIME = 9;
    TableListTreeNode node;

    public TableList(TableListTreeNode node) {
        this.Table_Create_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Table_Create_Button_actionPerformed"));
        this.Table_Drop_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Table_Drop_Button_actionPerformed"));
        this.COLUMN_COUNT = 10;
        this.OWNER = 0;
        this.NAME = 1;
        this.TABLESPACE = 2;
        this.NUM_OF_ROW = 3;
        this.NUM_OF_PAGE = 4;
        this.NUM_OF_INDEX = 5;
        this.NUM_OF_COLUMN = 6;
        this.NUM_OF_INDIRECT = 7;
        this.NUM_OF_BLOB_FRAME = 8;
        this.CREATE_TIME = 9;
        this.node = null;
        this.node = node;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DbaPanel jPanel3 = new DbaPanel(DbFrame.helpres, "table.list");
        String[] columnNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Tablespace"), DbFrame.frame.res.getString("_of_row"), DbFrame.frame.res.getString("_of_page"), DbFrame.frame.res.getString("_of_index"), DbFrame.frame.res.getString("_of_column"), "# of indirect row", "# of blob frame", DbFrame.frame.res.getString("Creation_Time")};
        this.model = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table1 = new JTable(this.absModel);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        this.setPreferredSize(new Dimension(300, 300));
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel3.setLayout(new BorderLayout());
        this.table1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableList.this.table1_mouseClicked(e);
            }
        });
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel3, DbFrame.frame.res.getTitle("Tables"));
        jPanel3.add((Component)jScrollPane1, "Center");
        jPanel3.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.Table_Create_Button, null);
        jPanel2.add((Component)this.Table_Drop_Button, null);
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.table1.setAutoResizeMode(4);
        this.table1.getSelectionModel().setSelectionMode(0);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        this.initColumnSizes(this.table1);
        this.getTableList();
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
        this.setName("TablesTabbedPane");
        jPanel2.setName("TablesButtonPanel");
        this.Table_Create_Button.setName("CreateButton");
        this.Table_Drop_Button.setName("DropButton");
        this.table1.setName("TablesTable");
    }

    @Override
    public int getComponentType() {
        return 1;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Table_Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Table_Drop_Button.setEnabled(enabled);
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table1.getSelectedRow();
            Object value = this.table1.getValueAt(r, 0);
            String owner = (String)value;
            this.authority.authorise(owner);
        }
    }

    private void getTableList() {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            boolean insystbl = DbFrame.frame.treePanel.getOption("INSYSTBL");
            query = "select TABLE_OWNER, TABLE_NAME, TS_NAME, NUM_ROW, NUM_PAGE, NUM_INDEX, NUM_COL, DWTOSTR(CREATE_TIME), NUM_INDIRECT_ROW, NUM_FRAME ";
            query = query + "from SYSTEM.SYSTABLE where ";
            if (this.node.owner != null) {
                query = query + "TABLE_OWNER like '%" + this.node.owner + "%' and ";
            }
            if (this.node.name != null) {
                query = query + "TABLE_NAME like '%" + this.node.name + "%' and ";
            }
            query = insystbl ? query + "TABLE_TYPE in ('TABLE','SYSTEM TABLE') ORDER BY TABLE_TYPE, TABLE_OWNER, TABLE_NAME" : query + "TABLE_TYPE = 'TABLE' ORDER BY TABLE_OWNER, TABLE_NAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model.addValue(new DBARowInfo(this.getRowInfo(rs.getString(1), rs.getString(2), rs.wasNull() ? "" : GuiUt.rightTrim(rs.getString(3)), rs.getInt(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getInt(9), rs.getInt(10), rs.getString(8))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Number_of_tables") + " " + this.model.getRowCount());
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            System.out.println("query=" + query);
            sqle.printStackTrace();
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        DefaultTableCellRenderer renderer = null;
        int RIGHT = 4;
        int LEFT = 2;
        int[] sizes = new int[]{100, 140, 120, 60, 60, 60, 60, 60, 60, 120};
        int[] alignments = new int[]{LEFT, LEFT, LEFT, RIGHT, RIGHT, RIGHT, RIGHT, RIGHT, RIGHT, LEFT};
        for (int i = 0; i < sizes.length; ++i) {
            column = table.getColumnModel().getColumn(i);
            renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(table.getColumnName(i));
            renderer.setHorizontalAlignment(alignments[i]);
            column.setCellRenderer(renderer);
            column.setPreferredWidth(sizes[i]);
        }
    }

    private Object[] getRowInfo(String table_owner, String table_name, String ts_name, int num_row, int num_page, int num_index, int num_col, int num_indirect_row, int num_frame, String create_time) {
        Object[] data = new Object[10];
        data[0] = GuiUt.rightTrim(table_owner);
        data[1] = GuiUt.rightTrim(table_name);
        data[2] = ts_name;
        data[3] = num_row == -1 ? new String("N/A") : Integer.toString(num_row);
        data[4] = num_page == -1 ? new String("N/A") : Integer.toString(num_page);
        data[5] = new Integer(num_index);
        data[6] = new Integer(num_col);
        data[9] = create_time;
        data[7] = num_indirect_row == -1 ? new String("N/A") : Integer.toString(num_indirect_row);
        data[8] = num_frame == -1 ? new String("N/A") : Integer.toString(num_frame);
        return data;
    }

    public void Table_Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(1);
        DbFrame.frame.treePanel.refreshTableTree();
        DbFrame.frame.treePanel.tree_valueChanged(null);
    }

    public void Table_Drop_Button_actionPerformed(ActionEvent e) {
        String table_name;
        int row = this.table1.getSelectedRow();
        if (row >= this.table1.getRowCount() || row < 0) {
            return;
        }
        String table_owner = (String)this.model.getValueAt(row, 0);
        if (DbFrame.conn_DatabaseConnection.dropTable(table_owner, table_name = (String)this.model.getValueAt(row, 1))) {
            DbFrame.frame.treePanel.afterDropObject(1);
        }
    }

    private void table1_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.table1.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            String table_owner = (String)this.absModel.getValueAt(row, 0);
            String table_name = (String)this.absModel.getValueAt(row, 1);
            DbFrame.frame.treePanel.openTableTree(table_owner, table_name);
        }
    }
}

