/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Table;

import dbatool.DbFrame;
import dbatool.Table.DependencyListNode;
import dbatool.Table.HeadRender;
import dbatool.Table.LinePanel;
import dbatool.Table.Resizable;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.table.DefaultTableModel;

public class DependencyScrollPane
extends JPanel
implements MouseMotionListener {
    DBAResourceBundle res = null;
    private ImageIcon img_file;
    private ImageIcon img_BLOB;
    private ImageIcon img_char;
    private ImageIcon img_CLOB;
    private ImageIcon img_data;
    private ImageIcon img_datetime;
    private ImageIcon img_key;
    private ImageIcon img_table;
    private ArrayList<Resizable> rect;
    private MouseInputListener Listener;
    private Map<String, Line2D.Float> saveLine = new HashMap<String, Line2D.Float>();
    private String tbowner;
    private String tbname;
    private int dependNumber;
    private int beDependedNumber;
    private ArrayList<DependencyListNode> dependModel;
    private ArrayList<DependencyListNode> beDependedModel;
    private JPopupMenu popup = new JPopupMenu();
    private JLabel label = new JLabel();
    private int paintFlag = 0;
    private BackgroundPanel backgroundPanel;
    public static final int BACKGROUND_COLOR_WHITE = 0;
    public static final int BACKGROUND_COLOR_LIGHTGRAY = 1;
    public static final int BACKGROUND_COLOR_GRAY = 2;
    public static final int BACKGROUND_COLOR_DARKGRAY = 3;
    public static final int BACKGROUND_FORM_BLANK = 0;
    public static final int BACKGROUND_FORM_PIONT = 1;
    public static final int BACKGROUND_FORM_GRID = 2;

    public DependencyScrollPane(String tbowner, String tbname, int dependNumber, int beDependedNumber, ArrayList<DependencyListNode> dependModel, ArrayList<DependencyListNode> beDependedModel, DBAResourceBundle res) {
        this.readyImage();
        this.tbowner = tbowner;
        this.tbname = tbname;
        this.dependModel = dependModel;
        this.beDependedModel = beDependedModel;
        this.beDependedNumber = beDependedNumber;
        this.dependNumber = dependNumber;
        this.res = res;
        this.rect = new ArrayList();
        this.drawRect();
        this.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                ((Resizable)DependencyScrollPane.this.rect.get(DependencyScrollPane.this.rect.size() - 1)).transferFocus();
                ((Resizable)DependencyScrollPane.this.rect.get(DependencyScrollPane.this.rect.size() - 1)).repaint();
            }
        });
        this.backgroundPanel = new BackgroundPanel();
        this.addMouseMotionListener(this);
        this.popup.setBackground(new Color(Integer.decode("#FEF9B3")));
        this.popup.add(this.label);
        this.initLocation();
    }

    public void initLocation() {
        this.setLayout(null);
        int leftH = 100;
        int rightH = 100;
        Resizable rMiddle = null;
        for (int i = 0; i < this.rect.size(); ++i) {
            Resizable r = this.rect.get(i);
            if (r.getPanelLocation() == 1) {
                r.setLocation(400, 200);
                this.add(r);
                rMiddle = r;
                continue;
            }
            if (r.getPanelLocation() == 2) {
                r.setLocation(750, rightH);
                this.add(r.getLinePanel());
                this.add(r);
                rightH = rightH + r.getHeight() + 20;
                continue;
            }
            r.setLocation(50, leftH);
            this.add(r.getLinePanel());
            this.add(r);
            leftH = leftH + r.getHeight() + 20;
        }
        rMiddle.MousePress();
        rMiddle.MouseDrag();
    }

    @Override
    public void paint(Graphics g) {
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g);
        if (this.rect.get(this.rect.size() - 1).getPanelLocation() == 1) {
            Resizable r;
            int i;
            for (i = this.rect.size() - 2; i >= 0; --i) {
                r = this.rect.get(i);
                if (r.getPanelLocation() != 3) continue;
                this.add(r.getLinePanel());
                this.add(r);
            }
            for (i = this.rect.size() - 2; i >= 0; --i) {
                r = this.rect.get(i);
                if (r.getPanelLocation() != 2) continue;
                this.add(r.getLinePanel());
                this.add(r);
            }
        } else {
            LinePanel linePanel = this.rect.get(this.rect.size() - 1).getLinePanel();
            this.add(linePanel);
            g.translate(linePanel.getX(), linePanel.getY());
            linePanel.paint(g);
            for (int i = this.rect.size() - 2; i >= 0; --i) {
                Resizable r = this.rect.get(i);
                this.add(r.getLinePanel());
                this.add(r);
            }
        }
        this.add(this.backgroundPanel);
        this.backgroundPanel.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.scrollRectToVisible(this.getVisibleRect());
        ++this.paintFlag;
        if (this.paintFlag < 3) {
            this.repaint();
        } else {
            this.paintFlag = 0;
        }
    }

    private Resizable getView(String[] fk, String tbowner2, String tbname2, ArrayList<Vector> tableColumns, int location) {
        int i;
        Object[][] data = new Object[tableColumns.size()][3];
        Vector<String> pkColumn = this.getPrimaryKeyInfo(tbowner2, tbname2);
        String column_type = "";
        String column_name = "";
        int k = pkColumn.size();
        block0: for (i = 0; i < tableColumns.size(); ++i) {
            column_name = (String)tableColumns.get(i).get(0);
            column_type = (String)tableColumns.get(i).get(1);
            for (int j = 0; j < pkColumn.size(); ++j) {
                if (!column_name.equalsIgnoreCase(pkColumn.get(j))) continue;
                data[j][1] = tableColumns.get(i).get(0);
                data[j][2] = tableColumns.get(i).get(1);
                data[j][0] = this.img_key;
                continue block0;
            }
            data[k][1] = tableColumns.get(i).get(0);
            data[k][2] = tableColumns.get(i).get(1);
            ++k;
        }
        for (i = 0; i < tableColumns.size(); ++i) {
            if (data[i][0] == null) {
                if (data[i][2].toString().equalsIgnoreCase("integer") || data[i][2].toString().equalsIgnoreCase("short") || data[i][2].toString().equalsIgnoreCase("bigint") || data[i][2].toString().equalsIgnoreCase("decimal") || data[i][2].toString().equalsIgnoreCase("double") || data[i][2].toString().equalsIgnoreCase("float") || data[i][2].toString().equalsIgnoreCase("real") || data[i][2].toString().equalsIgnoreCase("smallint") || data[i][2].toString().equalsIgnoreCase("serial")) {
                    data[i][0] = this.img_data;
                } else if (data[i][2].toString().equalsIgnoreCase("long varchar")) {
                    data[i][2] = "CLOB";
                    data[i][0] = this.img_CLOB;
                } else if (data[i][2].toString().equalsIgnoreCase("long varbinary")) {
                    data[i][2] = "BLOB";
                    data[i][0] = this.img_BLOB;
                } else {
                    data[i][0] = data[i][2].toString().equalsIgnoreCase("nclob") ? this.img_CLOB : (data[i][2].toString().equalsIgnoreCase("binary") ? this.img_BLOB : (data[i][2].toString().equalsIgnoreCase("char") || data[i][2].toString().equalsIgnoreCase("varchar") || data[i][2].toString().equalsIgnoreCase("nchar") || data[i][2].toString().equalsIgnoreCase("nvarchar") ? this.img_char : (data[i][2].toString().equalsIgnoreCase("file") ? this.img_file : (data[i][2].toString().equalsIgnoreCase("time") || data[i][2].toString().equalsIgnoreCase("date") || data[i][2].toString().equalsIgnoreCase("timestamp") ? this.img_datetime : this.img_data))));
                }
            }
            data[i][1] = data[i][1] + " : " + data[i][2];
            data[i][2] = null;
        }
        Object[] columnNames = new Object[]{null, null};
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        JTable table = new JTable(model){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }
        };
        table.getColumnModel().getColumn(0).setHeaderRenderer(new HeadRender());
        table.getColumnModel().getColumn(0).setHeaderValue(new JLabel(this.img_table, 0));
        table.getColumnModel().getColumn(1).setHeaderRenderer(new HeadRender());
        JLabel headColumn2 = new JLabel(tbowner2 + "." + tbname2);
        headColumn2.setFont(new Font("Dialog", 1, 15));
        table.getColumnModel().getColumn(1).setHeaderValue(headColumn2);
        table.getTableHeader().setReorderingAllowed(false);
        table.getTableHeader().setResizingAllowed(false);
        if (location == 1) {
            table.getTableHeader().setBackground(new Color(Integer.decode("#C8DDF2")));
        } else {
            table.getTableHeader().setBackground(new Color(Integer.decode("#FEF9B3")));
        }
        table.getColumnModel().getColumn(0).setMaxWidth(30);
        table.setEnabled(false);
        table.setRowHeight(24);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)table.getTableHeader(), "North");
        panel.add((Component)table, "Center");
        JScrollPane tablePanel = new JScrollPane();
        tablePanel.setVerticalScrollBarPolicy(21);
        tablePanel.setHorizontalScrollBarPolicy(31);
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        tablePanel.getViewport().add(panel);
        tablePanel.setBorder(null);
        Resizable r = new Resizable(fk, tablePanel, location, this.rect, tableColumns, this.res, this.saveLine, pkColumn.size());
        r.setName(tbname2);
        int height = 60 + 10 * table.getRowHeight() - 1;
        if (tableColumns.size() <= 10) {
            height = tableColumns.size() * table.getRowHeight() + 10 + 10 + 20;
        }
        if (r.getPanelLocation() == 1) {
            r.setBounds(400, 200, 243, height);
        } else if (r.getPanelLocation() == 2) {
            r.setBounds(750, 100, 243, height);
        } else {
            r.setBounds(50, 100, 243, height);
        }
        return r;
    }

    private void drawRect() {
        String[] fk;
        int i;
        ArrayList<Vector> tableColumns = this.getTableColumnMetaData(this.tbowner, this.tbname);
        this.rect.add(this.getView(new String[2], this.tbowner, this.tbname, tableColumns, 1));
        for (i = 0; i < this.dependNumber; ++i) {
            fk = new String[5];
            String rightTableOwner = this.dependModel.get((int)i).pk_tbl_owner;
            String rightTableName = this.dependModel.get((int)i).pk_tbl_name;
            fk[0] = this.dependModel.get((int)i).fk_name;
            fk[1] = this.dependModel.get((int)i).fk_col_order_str;
            fk[2] = this.dependModel.get((int)i).pk_col_order_str;
            fk[3] = this.dependModel.get((int)i).upd_act;
            fk[4] = this.dependModel.get((int)i).del_act;
            ArrayList<Vector> tableColumnRight = this.getTableColumnMetaData(rightTableOwner, rightTableName);
            this.rect.add(this.getView(fk, rightTableOwner, rightTableName, tableColumnRight, 2));
        }
        for (i = 0; i < this.beDependedNumber; ++i) {
            fk = new String[5];
            String leftTableOwner = this.beDependedModel.get((int)i).fk_tbl_owner;
            String leftTableName = this.beDependedModel.get((int)i).fk_tbl_name;
            fk[0] = this.beDependedModel.get((int)i).fk_name;
            fk[1] = this.beDependedModel.get((int)i).fk_col_order_str;
            fk[2] = this.beDependedModel.get((int)i).pk_col_order_str;
            fk[3] = this.beDependedModel.get((int)i).upd_act;
            fk[4] = this.beDependedModel.get((int)i).del_act;
            ArrayList<Vector> tableColumnleft = this.getTableColumnMetaData(leftTableOwner, leftTableName);
            this.rect.add(this.getView(fk, leftTableOwner, leftTableName, tableColumnleft, 3));
        }
    }

    private ArrayList<Vector> getTableColumnMetaData(String tbowner, String tbname) {
        Statement stmt = null;
        ResultSet rs = null;
        ResultSetMetaData rsmd = null;
        ArrayList<Vector> midTableColumns = new ArrayList<Vector>();
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select COLUMN_ORDER, COLUMN_NAME,TYPE_NAME,SCALE,NULLABLE,PRECISION from SYSTEM.SYSCOLUMN where TABLE_OWNER = '" + GuiUt.singleQuoteHandle(tbowner) + "' and TABLE_NAME = '" + GuiUt.singleQuoteHandle(tbname) + "' order by COLUMN_ORDER";
            rs = stmt.executeQuery(query);
            rsmd = rs.getMetaData();
            String column_name = null;
            String type_name = null;
            short nullAble = 0;
            String nullAbleToString = "";
            while (rs.next()) {
                Vector<String> v = new Vector<String>();
                column_name = GuiUt.rightTrim(rs.getString(2));
                type_name = rs.getString(3).trim();
                nullAble = rs.getShort(5);
                nullAbleToString = nullAble == 0 ? "not null" : "default null";
                v.addElement(column_name);
                v.addElement(type_name);
                v.addElement(nullAbleToString);
                midTableColumns.add(v);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            e.printStackTrace();
        }
        return midTableColumns;
    }

    private void readyImage() {
        this.img_file = DBAImageResource.getResource(this.getClass(), "/jdbaimages/file.gif");
        this.img_BLOB = DBAImageResource.getResource(this.getClass(), "/jdbaimages/BLOB.gif");
        this.img_CLOB = DBAImageResource.getResource(this.getClass(), "/jdbaimages/CLOB.gif");
        this.img_char = DBAImageResource.getResource(this.getClass(), "/jdbaimages/char.gif");
        this.img_data = DBAImageResource.getResource(this.getClass(), "/jdbaimages/data.gif");
        this.img_key = DBAImageResource.getResource(this.getClass(), "/jdbaimages/key.gif");
        this.img_datetime = DBAImageResource.getResource(this.getClass(), "/jdbaimages/datetime.gif");
        this.img_table = DBAImageResource.getResource(this.getClass(), "/jdbaimages/table.gif");
    }

    private Vector<String> getPrimaryKeyInfo(String tbowner, String tbname) {
        Vector<String> pk = new Vector<String>();
        Connection conn = DbFrame.conn_DatabaseConnection.getDbConnection();
        String pkname = "";
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getPrimaryKeys(null, tbowner, tbname);
            while (rs.next()) {
                pkname = rs.getString("PK_NAME");
                if (pkname == null || pkname.equals("")) continue;
                String columnName = GuiUt.rightTrim(rs.getString("COLUMN_NAME"));
                pk.addElement(columnName);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pk;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        float x = e.getX();
        float y = e.getY();
        this.popup.setVisible(false);
        Point2D.Float point = new Point2D.Float(x, y);
        for (Map.Entry<String, Line2D.Float> entry : this.saveLine.entrySet()) {
            String msg = entry.getKey();
            int nameLength = Integer.valueOf(msg.substring(0, msg.indexOf("_")));
            msg = msg.substring(msg.indexOf("_") + nameLength + 2);
            Line2D.Float line = entry.getValue();
            double distance = line.ptLineDist(point);
            float x1 = Math.min(line.x1, line.x2);
            float x2 = Math.max(line.x1, line.x2);
            float y1 = Math.min(line.y1, line.y2);
            float y2 = Math.max(line.y1, line.y2);
            if ((x2 - x1 <= 5.0f || y2 - y1 <= 5.0f) && distance <= 5.0) {
                this.label.setText("<html>" + msg + "</html>");
                this.popup.show(e.getComponent(), (int)x, (int)y);
                break;
            }
            if (!(x >= x1) || !(y >= y1) || !(x <= x2) || !(y <= y2) || !(distance <= 5.0)) continue;
            this.label.setText("<html>" + msg + "</html>");
            this.popup.show(e.getComponent(), (int)x, (int)y);
            break;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        for (Resizable r : this.rect) {
            width = r.getX() + r.getWidth() > width ? r.getX() + r.getWidth() : width;
            height = r.getY() + r.getHeight() > height ? r.getY() + r.getHeight() : height;
        }
        return new Dimension(width + 200, height + 200);
    }

    public void newBackground(int color, int form) {
        this.backgroundPanel.setColorAndForm(color, form);
        this.repaint();
    }

    private class BackgroundPanel
    extends JPanel {
        private int form = 0;
        private int color = 2;

        private BackgroundPanel() {
        }

        public void setColorAndForm(int color, int form) {
            this.color = color;
            this.form = form;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Color bkcolor = Color.GRAY;
            switch (this.color) {
                case 0: {
                    bkcolor = Color.WHITE;
                    break;
                }
                case 1: {
                    bkcolor = new Color(245, 245, 245);
                    break;
                }
                case 2: {
                    bkcolor = new Color(220, 220, 220);
                    this.setOpaque(false);
                    break;
                }
                case 3: {
                    bkcolor = new Color(185, 185, 185);
                }
            }
            this.setBackground(bkcolor);
            switch (this.form) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int x = 15; x < this.getWidth(); x += 15) {
                        for (int y = 15; y < this.getHeight(); y += 15) {
                            g.fillOval(x, y, 2, 2);
                        }
                    }
                    break;
                }
                case 2: {
                    g.setColor(new Color(175, 175, 175));
                    for (int x = 15; x < this.getWidth(); x += 15) {
                        g.drawLine(x, 0, x, this.getHeight());
                    }
                    for (int y = 15; y < this.getHeight(); y += 15) {
                        g.drawLine(0, y, this.getWidth(), y);
                    }
                    break;
                }
            }
        }
    }
}

