/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Schedule;

import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class ScheduleList
extends DbaTabbedPane {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.ScheduleRes", LocaleManager.getLocale());
    private int SVRNAME = 0;
    private int SVRTYPE = 1;
    private int USER_NAME = 2;
    private int STATUS = 3;
    private int BEGTIME = 4;
    private int INTERVAL = 5;
    private int RETRY = 6;
    private int TIME_SLEEP = 7;
    private int STOP_ON_ERR = 8;
    private int NOCHECK = 9;
    private DbaButton Drop_Button = new DbaButton(new Dimension(80, 24), this.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
    private DbaTableModel model = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table = null;

    public ScheduleList() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("ReplicationSchedulesTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "schedule.list");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        String[] columnNames = new String[]{this.res.getString("Remote_DB"), this.res.getString("DB_Type"), this.res.getString("Accout"), this.res.getString("Status"), this.res.getString("Begin_Time"), this.res.getString("Interval")};
        this.model = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model);
        this.table = new JTable(this.absModel);
        this.table.setName("RepScheduleListTable");
        jPanel1.setLayout(new BorderLayout());
        DbaButton Create_Button = new DbaButton(new Dimension(80, 24), this.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ScheduleList.this.table_mouseClicked(e);
            }
        });
        this.add((Component)jPanel1, this.res.getString("Replication_Schedule"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.setName("RepScheduleButtonPanel");
        Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        jPanel2.add((Component)Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        jPanel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table, null);
        this.initColumnSizes();
        this.getScheduleList();
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        this.Drop_Button.setEnabled(false);
        this.absModel.addMouseListenerToHeaderInTable(this.table);
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.Drop_Button.setEnabled(false);
        } else {
            this.Drop_Button.setEnabled(true);
        }
    }

    private void initColumnSizes() {
        int[] sizes = new int[]{100, 100, 80, 80, 120, 100};
        TableColumn column = null;
        for (int i = 0; i < sizes.length; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
        }
    }

    private void getScheduleList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model.removeAll();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select SVRNAME, SVRTYPE, USER_NAME, STATUS, BEGTIME, \"INTERVAL\", RETRY, TIME_SLEEP, ASCII(STOP_ON_ERR), NOCHECK from SYSTEM.SYSTRPDEST order by SVRNAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                this.model.addValue(new DBARowInfo(this.getRowInfo(rs.getString(1), rs.getInt(2), rs.getString(3), rs.getString(4), rs.getInt(5), rs.getInt(6), rs.getInt(7), rs.getInt(8), rs.getInt(9), rs.getInt(10))));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(DbFrame.frame.getResourceBundle().getString("The_number_of_schedule_is"), Integer.toString(this.model.getRowCount())));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    private Object[] getRowInfo(String svrname, int svrtype, String user_name, String status, int begtime, int interval, int retry, int time_sleep, int stop_on_err, int nocheck) {
        Object[] data = new Object[10];
        data[this.SVRNAME] = GuiUt.rightTrim(svrname);
        String dbbrand = "DBMaker";
        if (!LocaleManager.getIsDBMaker()) {
            dbbrand = "DBMaster";
        }
        switch (svrtype) {
            case 0: {
                data[this.SVRTYPE] = new String(dbbrand);
                break;
            }
            case 1: {
                data[this.SVRTYPE] = new String("Informix");
                break;
            }
            case 2: {
                data[this.SVRTYPE] = new String("Microsoft");
                break;
            }
            case 3: {
                data[this.SVRTYPE] = new String("Oracle");
                break;
            }
            case 4: {
                data[this.SVRTYPE] = new String("Sybase");
                break;
            }
            case 5: {
                data[this.SVRTYPE] = new String("DBMakerX");
                break;
            }
            case 6: {
                data[this.SVRTYPE] = new String("DB2");
                break;
            }
            case 7: {
                data[this.SVRTYPE] = new String("MySQL");
                break;
            }
            case 8: {
                data[this.SVRTYPE] = new String("PostgreSQL");
                break;
            }
            case 9: {
                data[this.SVRTYPE] = new String("ODBCX");
                break;
            }
            default: {
                data[this.SVRTYPE] = new String("Unknown");
            }
        }
        data[this.USER_NAME] = GuiUt.rightTrim(user_name);
        data[this.STATUS] = status.equals("0") ? "OK" : "SUSPEND";
        data[this.BEGTIME] = begtime < 0 ? "" : GuiUt.convertTimeToStr(begtime);
        data[this.INTERVAL] = new Integer(interval);
        data[this.RETRY] = new Integer(retry);
        data[this.TIME_SLEEP] = new Integer(time_sleep);
        data[this.STOP_ON_ERR] = stop_on_err == 0 ? new String(this.res.getString("No")) : new String(this.res.getString("Yes"));
        data[this.NOCHECK] = nocheck == 0 ? new String(this.res.getString("Check")) : new String(this.res.getString("No"));
        return data;
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(11);
        this.getScheduleList();
        DbFrame.frame.treePanel.refreshScheduleTree();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        String name = (String)this.model.getValueAt(row, this.SVRNAME);
        if (DbFrame.conn_DatabaseConnection.dropSchedule(name)) {
            DbFrame.frame.treePanel.afterDropObject(19);
        }
    }

    private void table_mouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            int row = this.table.getSelectedRow();
            if (row < 0 || row >= this.absModel.getRowCount()) {
                return;
            }
            String name = (String)this.absModel.getValueAt(row, this.SVRNAME);
            DbFrame.frame.treePanel.openScheduleTree(name);
        }
    }
}

