/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import com.borland.jbcl.layout.BoxLayout2;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.Monitor.AffinitySettingDlg;
import dbatool.Monitor.ColorRenderer;
import dbatool.Monitor.LockGraphScrollPane;
import dbatool.Monitor.LockTableModel;
import dbatool.Monitor.MonitorTableModel;
import dbatool.Monitor.PrioritySettingDlg;
import dbatool.Monitor.SQLCommandDlg;
import dbatool.Monitor.SessionTableModel;
import dbatool.Monitor.UtForSessionAndLock;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.alarm.Alarm2;
import dbaut.alarm.Sleeper;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SessionInfo
extends DbaTabbedPane
implements Sleeper {
    private static boolean loginSelected = true;
    private static boolean transactionSelected = true;
    private static boolean waitingSelected = true;
    private static boolean statisticsSelected = true;
    private static boolean executionSelected = true;
    private static boolean lockSelected = false;
    public static boolean selectBlank = true;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.MonitorRes", LocaleManager.getLocale());
    private SessionTableModel model1 = new SessionTableModel();
    private DBAToolAbstractTableModel absModel = new DBAToolAbstractTableModel(this.model1);
    private JTable table1 = new JTable(this.absModel);
    private JCheckBox Login_Information = new JCheckBox();
    private JCheckBox Statistics_Information = new JCheckBox();
    private JCheckBox Transaction_Information = new JCheckBox();
    private JCheckBox Execution_Information = new JCheckBox();
    private JCheckBox LockGraph_checkBox = new JCheckBox();
    private JSplitPane splitPane = new JSplitPane(0);
    private LockGraphScrollPane drawLockGraph = null;
    private LockTableModel lockModel = new LockTableModel();
    private Vector login_info = new Vector();
    private Vector execution_info = new Vector();
    private Vector statistics_info = new Vector();
    private Vector transaction_info = new Vector();
    private Vector waiting_info = new Vector();
    private int login_col_num = 4;
    private int execution_col_num = 2;
    private int statistics_col_num = 6;
    private int transaction_col_num = 4;
    private int waiting_col_num = 2;
    private Alarm2 clock = null;
    private boolean isRefreshing = false;
    private DbaButton Kill_Button = new DbaButton(new Dimension(120, 24), this.res.getString("Kill_Connection"), 'K', DBAImageResource.getResource(this.getClass(), "/jdbaimages/kill_connection.gif"), new ReflectionAction(this, "Kill_Button_actionPerformed"));
    private JCheckBox Waiting_Information = new JCheckBox();
    private DbaButton setAffinityButton = new DbaButton(new Dimension(120, 24), this.res.getString("Set_Affinity"), 'A', DBAImageResource.getResource(this.getClass(), "/jdbaimages/edit.gif"), new ReflectionAction(this, "setAffinityActionPerformed"));
    private DbaButton setPriorityButton = new DbaButton(new Dimension(120, 24), this.res.getString("Set_Priority"), 'P', DBAImageResource.getResource(this.getClass(), "/jdbaimages/edit.gif"), new ReflectionAction(this, "setPriorityActionPerformed"));
    private int cpunumbers = 1;
    private JCheckBox Auto_Refresh_Checkbox = new JCheckBox();

    public SessionTableModel getModel1() {
        return this.model1;
    }

    public JTable getTable1() {
        return this.table1;
    }

    public SessionInfo() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("SessionInfoTabbedPane");
        this.Auto_Refresh_Checkbox.setName("AutoRefreshCheckbox");
        this.Kill_Button.setName("KillButton");
        this.setAffinityButton.setName("SetAffinityButton");
        this.setPriorityButton.setName("SetPriorityButton");
        this.Login_Information.setName("LoginInfoCheckbox");
        this.Execution_Information.setName("ExecuteInfoCheckBox");
        this.Statistics_Information.setName("StatisticsInfoCheckBox");
        this.Transaction_Information.setName("TransactionInfoCheckbox");
        this.Waiting_Information.setName("WaitingInfoCheckBox");
        this.LockGraph_checkBox.setName("LockGraphcheckBox");
        this.table1.setName("SessionInfoTable");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "session.info");
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jToolBar1 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        this.model1.setSessionInfo(this);
        this.table1.setAutoResizeMode(4);
        this.table1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SessionInfo.this.table1_mouseClicked(e);
            }
        });
        jPanel1.setLayout(new BorderLayout());
        jPanel2.setLayout((LayoutManager)new BoxLayout2());
        this.LockGraph_checkBox.setSelected(false);
        this.LockGraph_checkBox.setText(this.res.getString("Lock_Graph"));
        this.LockGraph_checkBox.addActionListener(new ReflectionAction(this, "LockGraph_actionPreform"));
        this.Login_Information.setSelected(true);
        this.Login_Information.setText(this.res.getString("Login_Info_"));
        this.Login_Information.addActionListener(new ReflectionAction(this, "Login_Information_actionPerformed"));
        this.Statistics_Information.setSelected(true);
        this.Statistics_Information.setText(this.res.getString("Statistics_Info_"));
        this.Statistics_Information.addActionListener(new ReflectionAction(this, "Statistics_Information_actionPerformed"));
        this.Transaction_Information.setSelected(true);
        this.Transaction_Information.setText(this.res.getString("Transaction_Info_"));
        this.Transaction_Information.addActionListener(new ReflectionAction(this, "Transaction_Information_actionPerformed"));
        this.Execution_Information.setSelected(true);
        this.Execution_Information.setText(this.res.getString("Execution_Info_"));
        this.Execution_Information.addActionListener(new ReflectionAction(this, "Execution_Information_actionPerformed"));
        jPanel2.setMaximumSize(new Dimension(559, 27));
        jPanel3.setLayout(new BorderLayout());
        DbaButton Refresh_Button = new DbaButton(new Dimension(120, 24), this.res.getString("Refresh"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/refresh.gif"), new ReflectionAction(this, "Refresh_Button_actionPerformed"));
        Refresh_Button.setName("RefreshButton");
        this.Kill_Button.setEnabled(false);
        this.setAffinityButton.setEnabled(false);
        this.setPriorityButton.setEnabled(false);
        this.Waiting_Information.setSelected(true);
        this.Waiting_Information.setText(this.res.getString("Waiting_Info_"));
        this.Waiting_Information.addActionListener(new ReflectionAction(this, "Waiting_Information_actionPerformed"));
        jPanel4.setLayout(new BorderLayout());
        this.Auto_Refresh_Checkbox.setText(this.res.getString("Auto_Refresh"));
        this.Auto_Refresh_Checkbox.addActionListener(new ReflectionAction(this, "Auto_Refresh_Checkbox_actionPerformed"));
        if (DbFrame.frame.px.getAutoRefresh()) {
            this.Auto_Refresh_Checkbox.setSelected(true);
        } else {
            this.Auto_Refresh_Checkbox.setSelected(false);
        }
        jPanel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table1, null);
        jPanel1.add((Component)jPanel3, "North");
        jPanel3.add((Component)jPanel2, "South");
        jPanel2.setName("SessionInfoButtonPanel2");
        jPanel2.add((Component)this.Login_Information, null);
        jPanel2.add((Component)this.Execution_Information, null);
        jPanel2.add((Component)this.Statistics_Information, null);
        jPanel2.add((Component)this.Transaction_Information, null);
        jPanel2.add((Component)this.Waiting_Information, null);
        jPanel2.add((Component)this.LockGraph_checkBox, null);
        jPanel3.add((Component)jPanel4, "North");
        jPanel4.setName("SessionInfoButtonPanel1");
        jPanel4.add((Component)jToolBar1, "Center");
        jToolBar1.setName("SessionInfoToolBar");
        jToolBar1.add((Component)Refresh_Button, null);
        jToolBar1.add((Component)this.Kill_Button, null);
        jToolBar1.add((Component)this.setAffinityButton, null);
        jToolBar1.add((Component)this.setPriorityButton, null);
        jPanel4.add((Component)this.Auto_Refresh_Checkbox, "East");
        boolean result = this.getSessionInfo();
        this.initColumnSizes(this.table1, this.model1);
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        if (result) {
            this.clock = new Alarm2();
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
        }
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        jPanel1.setPreferredSize(new Dimension(600, 300));
        this.splitPane.setDividerSize(7);
        this.splitPane.setLeftComponent(jPanel1);
        this.add((Component)this.splitPane, this.res.getTitle("Session_Information"));
        this.initCheckBoxStates();
    }

    private void initCheckBoxStates() {
        int i;
        int position;
        this.Login_Information.setSelected(loginSelected);
        this.Statistics_Information.setSelected(statisticsSelected);
        this.Waiting_Information.setSelected(waitingSelected);
        this.Transaction_Information.setSelected(transactionSelected);
        this.Execution_Information.setSelected(executionSelected);
        this.LockGraph_checkBox.setSelected(lockSelected);
        TableColumn column = null;
        if (!loginSelected) {
            for (int i2 = 0; i2 < this.login_col_num; ++i2) {
                column = this.table1.getColumnModel().getColumn(1);
                this.table1.removeColumn(column);
                this.login_info.addElement(column);
            }
        }
        if (!executionSelected) {
            position = 1 + (loginSelected ? this.login_col_num : 0);
            for (i = 0; i < this.execution_col_num; ++i) {
                column = this.table1.getColumnModel().getColumn(position);
                this.table1.removeColumn(column);
                this.execution_info.addElement(column);
            }
        }
        if (!statisticsSelected) {
            position = 1 + (loginSelected ? this.login_col_num : 0) + (executionSelected ? this.execution_col_num : 0);
            for (i = 0; i < this.statistics_col_num; ++i) {
                column = this.table1.getColumnModel().getColumn(position);
                this.table1.removeColumn(column);
                this.statistics_info.addElement(column);
            }
        }
        if (!transactionSelected) {
            position = 1 + (loginSelected ? this.login_col_num : 0) + (executionSelected ? this.execution_col_num : 0) + (statisticsSelected ? this.statistics_col_num : 0);
            for (i = 0; i < this.transaction_col_num; ++i) {
                column = this.table1.getColumnModel().getColumn(position);
                this.table1.removeColumn(column);
                this.transaction_info.addElement(column);
            }
        }
        if (!waitingSelected) {
            position = 1 + (loginSelected ? this.login_col_num : 0) + (executionSelected ? this.execution_col_num : 0) + (statisticsSelected ? this.statistics_col_num : 0) + (transactionSelected ? this.transaction_col_num : 0);
            for (i = 0; i < this.waiting_col_num; ++i) {
                column = this.table1.getColumnModel().getColumn(position);
                this.table1.removeColumn(column);
                this.waiting_info.addElement(column);
            }
        }
        this.LockGraph_actionPreform(null);
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        if (this.isRefreshing) {
            return;
        }
        if (this.table1.getSelectionModel().isSelectionEmpty()) {
            this.Kill_Button.setEnabled(false);
            this.setAffinityButton.setEnabled(false);
            this.setPriorityButton.setEnabled(false);
            return;
        }
        int[] rows = this.table1.getSelectedRows();
        this.Kill_Button.setEnabled(false);
        for (int row : rows) {
            String connection_id = (String)this.model1.getValueAt(row, 0);
            if (connection_id.indexOf(42) > 0) continue;
            this.Kill_Button.setEnabled(true);
            break;
        }
        this.setPriorityButton.setEnabled(true);
        String cpuSql = "call GETCPUNUMBER(?)";
        Connection con = DbFrame.conn_DatabaseConnection.getDbConnection();
        CallableStatement cstmt = null;
        try {
            cstmt = con.prepareCall(cpuSql);
            cstmt.registerOutParameter(1, 4);
            cstmt.execute();
            this.cpunumbers = cstmt.getInt(1);
            cstmt.close();
        }
        catch (SQLException e1) {
            this.setAffinityButton.setEnabled(false);
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
            e1.printStackTrace();
        }
        if (this.cpunumbers == 1) {
            this.setAffinityButton.setEnabled(false);
        } else {
            this.setAffinityButton.setEnabled(true);
        }
    }

    private synchronized boolean getSessionInfo() {
        Statement stmt = null;
        Statement stmt2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        try {
            this.model1.removeAll();
            stmt2 = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query2 = "select CONNECTION_ID from SYSTEM.SYSCONINFO ";
            rs2 = stmt2.executeQuery(query2);
            int current_connection_id = 0;
            if (rs2.next()) {
                current_connection_id = rs2.getInt(1);
            }
            rs2.close();
            stmt2.close();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select CONNECTION_ID, USER_NAME, LOGIN_TIME, LOGIN_IP_ADDR, LOGIN_HOST, SQL_CMD, TIME_OF_SQL_CMD, NUM_SCAN, NUM_INSERT, NUM_UPDATE, NUM_DELETE, NUM_TRANX, NUM_JBYTE_PER_TRAN, FIRST_W_JNR_FN, FIRST_W_JNR_BN, NUM_BYTE_JNR_DATA, NUM_J_BLOCK_DURATN, AFFINITY_MASK, PRIORITY_LEVEL, CPU_USAGE from SYSUSER";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                int connection_id = rs.getInt(1);
                Object[] data = new Object[]{connection_id == current_connection_id ? new String(connection_id + "*") : new String(connection_id + ""), GuiUt.rightTrim(rs.getString(2)), GuiUt.rightTrim(rs.getString(3)), GuiUt.rightTrim(rs.getString(4)), GuiUt.rightTrim(rs.getString(5)), GuiUt.rightTrim(rs.getString(6)), GuiUt.rightTrim(rs.getString(7)), new Integer(rs.getInt(8)), new Integer(rs.getInt(9)), new Integer(rs.getInt(10)), new Integer(rs.getInt(11)), new Integer(rs.getInt(12)), new Integer(rs.getInt(13)), new Integer(rs.getInt(14)), new Integer(rs.getInt(15)), new Integer(rs.getInt(16)), new Integer(rs.getInt(17)), new String(""), new String(""), GuiUt.rightTrim(rs.getString(18)), new Integer(rs.getInt(19)), GuiUt.rightTrim(rs.getString(20))};
                this.model1.addValue(data);
            }
            rs.close();
            query = "select WAITING_CONNECTION, WAITED_CONNECTION from SYSTEM.SYSWAIT";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String waiting = rs.getString(1);
                String waited = rs.getString(2);
                this.model1.setWaitInfo(waiting, waited);
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            this.table1_valueChanged(null);
            return true;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            DbaObject.close(rs2);
            DbaObject.close(stmt2);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            return false;
        }
    }

    private void initColumnSizes(JTable table, TableModel model) {
        TableColumn column = null;
        ColorRenderer renderer = null;
        int[] sizes = new int[]{80, 100, 120, 100, 100, 160, 120, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 80, 80, 80, 80, 80};
        for (int i = 0; i < sizes.length; ++i) {
            renderer = new ColorRenderer((MonitorTableModel)((Object)model));
            renderer.setToolTipText(table.getColumnName(i));
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
            column.setCellRenderer(renderer);
        }
    }

    public void LockGraph_actionPreform(ActionEvent e) {
        boolean isSelected;
        lockSelected = isSelected = this.LockGraph_checkBox.isSelected();
        if (isSelected) {
            this.updateLockGraph();
            this.splitPane.setDividerLocation(200);
            this.drawLockGraph.setVisible(true);
            this.drawLockGraph.validate();
        } else if (this.drawLockGraph != null) {
            this.drawLockGraph.setVisible(false);
            this.drawLockGraph.validate();
        }
    }

    public void Login_Information_actionPerformed(ActionEvent e) {
        boolean isSelected;
        loginSelected = isSelected = this.Login_Information.isSelected();
        TableColumn column = null;
        if (!isSelected) {
            for (int i = 0; i < this.login_col_num; ++i) {
                column = this.table1.getColumnModel().getColumn(1);
                this.table1.removeColumn(column);
                this.login_info.addElement(column);
            }
        } else {
            int column_count = this.table1.getColumnCount();
            for (int i = 0; i < this.login_col_num; ++i) {
                this.table1.addColumn((TableColumn)this.login_info.elementAt(i));
                this.table1.moveColumn(column_count + i, 1 + i);
            }
            this.login_info.removeAllElements();
        }
    }

    public void Execution_Information_actionPerformed(ActionEvent e) {
        boolean isSelected = this.Execution_Information.isSelected();
        boolean with_Login_info = this.Login_Information.isSelected();
        executionSelected = isSelected;
        int position = 1 + (with_Login_info ? this.login_col_num : 0);
        TableColumn column = null;
        if (!isSelected) {
            for (int i = 0; i < this.execution_col_num; ++i) {
                column = this.table1.getColumnModel().getColumn(position);
                this.table1.removeColumn(column);
                this.execution_info.addElement(column);
            }
        } else {
            int column_count = this.table1.getColumnCount();
            for (int i = 0; i < this.execution_col_num; ++i) {
                this.table1.addColumn((TableColumn)this.execution_info.elementAt(i));
                this.table1.moveColumn(column_count + i, position + i);
            }
            this.execution_info.removeAllElements();
        }
    }

    public void Statistics_Information_actionPerformed(ActionEvent e) {
        boolean isSelected = this.Statistics_Information.isSelected();
        boolean with_Execution_info = this.Execution_Information.isSelected();
        boolean with_Login_info = this.Login_Information.isSelected();
        statisticsSelected = isSelected;
        int position = 1 + (with_Login_info ? this.login_col_num : 0) + (with_Execution_info ? this.execution_col_num : 0);
        TableColumn column = null;
        if (!isSelected) {
            for (int i = 0; i < this.statistics_col_num; ++i) {
                column = this.table1.getColumnModel().getColumn(position);
                this.table1.removeColumn(column);
                this.statistics_info.addElement(column);
            }
        } else {
            int column_count = this.table1.getColumnCount();
            for (int i = 0; i < this.statistics_col_num; ++i) {
                this.table1.addColumn((TableColumn)this.statistics_info.elementAt(i));
                this.table1.moveColumn(column_count + i, position + i);
            }
            this.statistics_info.removeAllElements();
        }
    }

    public void Transaction_Information_actionPerformed(ActionEvent e) {
        boolean isSelected = this.Transaction_Information.isSelected();
        boolean with_Login_info = this.Login_Information.isSelected();
        boolean with_Execution_info = this.Execution_Information.isSelected();
        boolean with_statistics_info = this.Statistics_Information.isSelected();
        transactionSelected = isSelected;
        int position = 1 + (with_Login_info ? this.login_col_num : 0) + (with_Execution_info ? this.execution_col_num : 0) + (with_statistics_info ? this.statistics_col_num : 0);
        TableColumn column = null;
        if (!isSelected) {
            for (int i = 0; i < this.transaction_col_num; ++i) {
                column = this.table1.getColumnModel().getColumn(position);
                this.table1.removeColumn(column);
                this.transaction_info.addElement(column);
            }
        } else {
            int column_count = this.table1.getColumnCount();
            for (int i = 0; i < this.transaction_col_num; ++i) {
                this.table1.addColumn((TableColumn)this.transaction_info.elementAt(i));
                this.table1.moveColumn(column_count + i, position + i);
            }
            this.transaction_info.removeAllElements();
        }
    }

    public void Waiting_Information_actionPerformed(ActionEvent e) {
        boolean isSelected = this.Waiting_Information.isSelected();
        boolean with_Login_info = this.Login_Information.isSelected();
        boolean with_Execution_info = this.Execution_Information.isSelected();
        boolean with_statistics_info = this.Statistics_Information.isSelected();
        boolean with_tranx_info = this.Transaction_Information.isSelected();
        waitingSelected = isSelected;
        int position = 1 + (with_Login_info ? this.login_col_num : 0) + (with_Execution_info ? this.execution_col_num : 0) + (with_statistics_info ? this.statistics_col_num : 0) + (with_tranx_info ? this.transaction_col_num : 0);
        TableColumn column = null;
        if (!isSelected) {
            for (int i = 0; i < this.waiting_col_num; ++i) {
                column = this.table1.getColumnModel().getColumn(position);
                this.table1.removeColumn(column);
                this.waiting_info.addElement(column);
            }
        } else {
            int column_count = this.table1.getColumnCount();
            for (int i = 0; i < this.waiting_col_num; ++i) {
                this.table1.addColumn((TableColumn)this.waiting_info.elementAt(i));
                this.table1.moveColumn(column_count + i, position + i);
            }
            this.waiting_info.removeAllElements();
        }
    }

    private int getRealCol(int col) {
        if (col == 0) {
            return col;
        }
        int real_col = col;
        int acu_col = this.login_col_num;
        if (this.Login_Information.isSelected() && real_col <= acu_col) {
            return real_col;
        }
        if (!this.Login_Information.isSelected()) {
            real_col += this.login_col_num;
        }
        if (this.Execution_Information.isSelected() && real_col <= (acu_col += this.execution_col_num)) {
            return real_col;
        }
        if (!this.Execution_Information.isSelected()) {
            real_col += this.execution_col_num;
        }
        if (this.Statistics_Information.isSelected() && real_col <= (acu_col += this.statistics_col_num)) {
            return real_col;
        }
        if (!this.Statistics_Information.isSelected()) {
            real_col += this.statistics_col_num;
        }
        if (this.Transaction_Information.isSelected() && real_col <= (acu_col += this.transaction_col_num)) {
            return real_col;
        }
        if (!this.Transaction_Information.isSelected()) {
            real_col += this.transaction_col_num;
        }
        return real_col;
    }

    private void updateLockGraph() {
        if (this.LockGraph_checkBox.isSelected()) {
            if (this.drawLockGraph == null) {
                this.drawLockGraph = new LockGraphScrollPane(this.lockModel, this.res, this);
                this.splitPane.setRightComponent(this.drawLockGraph);
            }
            UtForSessionAndLock.getLockInfo(this.lockModel);
            this.drawLockGraph.setModel(this.lockModel);
            this.drawLockGraph.removeAll();
            this.drawLockGraph.drawPanel();
            this.drawLockGraph.repaint();
        }
    }

    @Override
    public synchronized void wakeUp() {
        if (this.isRefreshing) {
            System.out.println("It's refreshing already.");
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
            return;
        }
        if (this.isShowing() && DbFrame.frame.px.getAutoRefresh()) {
            this.isRefreshing = true;
            boolean result = this.getSessionInfo();
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            this.isRefreshing = false;
            if (result) {
                this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
            }
            this.table1_valueChanged(null);
            this.updateLockGraph();
        }
    }

    public void Refresh_Button_actionPerformed(ActionEvent e) {
        if (this.isRefreshing) {
            System.out.println("It's refreshing already.");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.isRefreshing = true;
        boolean result = this.getSessionInfo();
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.isRefreshing = false;
        this.table1_valueChanged(null);
        this.updateLockGraph();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void Kill_Button_actionPerformed(ActionEvent e) {
        Statement stmt = null;
        try {
            int[] rows = this.table1.getSelectedRows();
            String msg = "";
            this.Kill_Button.setEnabled(false);
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            for (int row : rows) {
                String connection_id = (String)this.model1.getValueAt(row, 0);
                String query = "KILL CONNECTION " + connection_id;
                stmt.execute(query);
                if (row != 0) {
                    msg = msg + ",";
                }
                msg = msg + connection_id;
            }
            stmt.close();
            DbFrame.frame.setStatusDisc(this.res.getString("Connection") + msg + this.res.getString("has_been_killed"));
            this.table1.clearSelection();
            this.model1.removeAll();
            this.isRefreshing = true;
            this.getSessionInfo();
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            this.isRefreshing = false;
            this.table1_valueChanged(null);
            this.updateLockGraph();
        }
        catch (SQLException sqle) {
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void setAffinityActionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        String connectionID = (String)this.model1.getValueAt(row, 0);
        int index = -1;
        index = connectionID.indexOf("*");
        if (index >= 0) {
            connectionID = connectionID.substring(0, index);
        }
        String affinityMask = (String)this.model1.getValueAt(row, 19);
        new AffinitySettingDlg((Frame)DbFrame.frame, connectionID, this.cpunumbers, affinityMask);
        this.model1.removeAll();
        this.isRefreshing = true;
        this.getSessionInfo();
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.isRefreshing = false;
        this.table1_valueChanged(null);
    }

    public void setPriorityActionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        String connectionID = (String)this.model1.getValueAt(row, 0);
        int index = -1;
        index = connectionID.indexOf("*");
        if (index >= 0) {
            connectionID = connectionID.substring(0, index);
        }
        int priorityLevel = (Integer)this.model1.getValueAt(row, 20);
        new PrioritySettingDlg((Frame)DbFrame.frame, connectionID, priorityLevel);
        this.model1.removeAll();
        this.isRefreshing = true;
        this.getSessionInfo();
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        this.isRefreshing = false;
        this.table1_valueChanged(null);
    }

    private void table1_mouseClicked(MouseEvent e) {
        if (this.isRefreshing) {
            System.out.println("It's refreshing the monitor data right now.");
            return;
        }
        int row = this.table1.getSelectedRow();
        int col = this.table1.getSelectedColumn();
        if (row < 0 || row >= this.table1.getRowCount() || col < 0 || col >= this.table1.getColumnCount()) {
            return;
        }
        int real_col = this.getRealCol(col);
        if (real_col == 5) {
            SQLCommandDlg dlg = DbFrame.isWindows ? new SQLCommandDlg((Frame)DbFrame.frame, "") : new SQLCommandDlg((Frame)DbFrame.frame, "", true, "");
            dlg.setSQLCommandText((String)this.model1.getValueAt(row, real_col));
            GuiUt.setCenterLocation(DbFrame.frame, dlg);
            dlg.setModal(true);
            dlg.show();
        }
    }

    public void Auto_Refresh_Checkbox_actionPerformed(ActionEvent e) {
        if (this.Auto_Refresh_Checkbox.isSelected()) {
            DbFrame.frame.px.updateVariables(3, "true");
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
        } else {
            DbFrame.frame.px.updateVariables(3, "false");
        }
    }
}

