/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.alarm.Alarm2;
import dbaut.alarm.Sleeper;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.dbalib;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class PendingTranxInfo
extends DbaTabbedPane
implements Sleeper {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.MonitorRes", LocaleManager.getLocale());
    private DbaTableModel model1 = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private Alarm2 clock = null;
    private Color current_color = Color.black;
    private DbaButton Commit_Button = new DbaButton(new Dimension(120, 24), this.res.getString("Commit"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "Commit_Button_actionPerformed"));
    private DbaButton Abort_Button = new DbaButton(new Dimension(120, 24), this.res.getString("Abort"), 'A', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Abort_Button_actionPerformed"));

    public PendingTranxInfo() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("TransactionInfoTabbedPane");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "pendingtransaction.info");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel2 = new JPanel();
        String[] columnNames = new String[]{this.res.getString("Transaction_Format"), this.res.getString("Prepared_Time"), this.res.getString("Global_Transaction_ID")};
        this.model1 = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model1);
        this.table1 = new JTable(this.absModel);
        this.table1.setName("PendingTransactionTable");
        this.table1.getTableHeader().setReorderingAllowed(false);
        jPanel1.setLayout(new BorderLayout());
        DbaButton Refresh_Button = new DbaButton(new Dimension(120, 24), this.res.getString("Refresh"), 'R', DBAImageResource.getResource(this.getClass(), "/jdbaimages/refresh.gif"), new ReflectionAction(this, "Refresh_Button_actionPerformed"));
        Refresh_Button.setName("RefreshButton");
        jPanel2.setLayout(new FlowLayout(0));
        jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel1, this.res.getTitle("Pending_Transaction"));
        jPanel1.add((Component)jScrollPane1, "Center");
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.setName("PendingTransactionButtonPanel");
        jPanel2.add((Component)Refresh_Button, null);
        jPanel2.add((Component)this.Commit_Button, null);
        jPanel2.add((Component)this.Abort_Button, null);
        jScrollPane1.getViewport().add((Component)this.table1, null);
        boolean result = this.getPendingTranxInfo();
        this.initColumnSizes(this.table1);
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        if (DbFrame.frame.px.getAutoRefresh() && result) {
            this.clock = new Alarm2();
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
        }
        this.table1.setSelectionMode(0);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        this.Abort_Button.setName("AborButton");
        this.Abort_Button.setEnabled(false);
        this.Commit_Button.setName("CommitButton");
        this.Commit_Button.setEnabled(false);
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.Abort_Button.setEnabled(false);
            this.Commit_Button.setEnabled(false);
        } else {
            this.Abort_Button.setEnabled(true);
            this.Commit_Button.setEnabled(true);
        }
    }

    private synchronized boolean getPendingTranxInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select XIDFORMAT, PREPAREDTIME, GLBTRANXID from SYSTEM.SYSPENDTRANX";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                Object[] data;
                data = new Object[]{new Integer(rs.getInt(1)), rs.getString(2), new globalID((Integer)data[0], rs.getBytes(3))};
                this.model1.addValue(new DBARowInfo(data));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            return true;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
            return false;
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        DefaultTableCellRenderer renderer = null;
        column = table.getColumnModel().getColumn(0);
        renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(table.getColumnName(0));
        column.setCellRenderer(renderer);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(1);
        renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(table.getColumnName(1));
        column.setCellRenderer(renderer);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(2);
        renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(table.getColumnName(2));
        column.setCellRenderer(renderer);
        column.setPreferredWidth(120);
    }

    @Override
    public synchronized void wakeUp() {
        if (this.isShowing() && DbFrame.frame.px.getAutoRefresh()) {
            this.model1.removeAll();
            this.getPendingTranxInfo();
            this.current_color = this.current_color == Color.black ? Color.blue : Color.black;
            this.table1.setForeground(this.current_color);
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
            this.clock.setAlarm(this, DbFrame.frame.px.getAutoRefreshTime());
        }
    }

    public void Refresh_Button_actionPerformed(ActionEvent e) {
        this.model1.removeAll();
        this.getPendingTranxInfo();
        this.current_color = this.current_color == Color.black ? Color.blue : Color.black;
        this.table1.setForeground(this.current_color);
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
    }

    public void Commit_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        globalID g = (globalID)this.model1.getValueAt(row, 2);
        Connection conn = DbFrame.conn_DatabaseConnection.getDbConnection();
        try {
            ((JdbcOdbcConnection)conn).setOption(1413, g.getOptionValue());
            this.Refresh_Button_actionPerformed(null);
        }
        catch (Exception e2) {
            GuiUt.showErrorDlg(DbFrame.frame, e2.getMessage(), null);
        }
    }

    public void Abort_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        globalID g = (globalID)this.model1.getValueAt(row, 2);
        Connection conn = DbFrame.conn_DatabaseConnection.getDbConnection();
        try {
            ((JdbcOdbcConnection)conn).setOption(1414, g.getOptionValue());
            this.Refresh_Button_actionPerformed(null);
        }
        catch (Exception e2) {
            GuiUt.showErrorDlg(DbFrame.frame, e2.getMessage(), null);
        }
    }

    private class globalID {
        private int XID_FORMATID = 22873;
        String s = "";
        Integer formatID;
        byte[] value;

        public globalID(Integer formatID, byte[] b) {
            this.formatID = formatID;
            this.value = b;
            if (formatID == this.XID_FORMATID) {
                this.s = new String(this.value);
                return;
            }
            try {
                int i;
                DataInputStream din = new DataInputStream(new ByteArrayInputStream(this.value));
                while ((i = din.readInt()) != 0) {
                    this.s = this.s + Integer.toHexString(i);
                }
                din.close();
            }
            catch (EOFException eofe) {
                System.out.println(eofe.getMessage());
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }

        public String toString() {
            return this.s;
        }

        public byte[] getOptionValue() {
            byte[] buffer = new byte[140];
            dbalib lib = new dbalib();
            lib.getXID(buffer, this.formatID, this.value[128], this.value[129], this.value);
            return buffer;
        }
    }
}

