/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Monitor;

import dbatool.DbFrame;
import dbatool.Monitor.LockInfo;
import dbatool.Monitor.LockTableModel;
import dbatool.Monitor.Resizable;
import dbatool.Monitor.SessionInfo;
import dbatool.Monitor.UtForSessionAndLock;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class LockGraphScrollPane
extends JPanel {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.MonitorRes", LocaleManager.getLocale());
    private Font linefont = new Font("Dialog", 0, 12);
    private ArrayList<Resizable> rect = new ArrayList();
    private ArrayList<Vector> list = new ArrayList();
    private ArrayList<Vector> lt1 = new ArrayList();
    private ArrayList<Vector> rectlist = new ArrayList();
    private LockTableModel model;
    private Object obj;
    private int paintFlag = 0;
    public static Point leftOriginPoint = new Point(30, 60);
    public static final int MID_RECT_WIDTH = 170;
    public static final int MID_RECT_HEIGHT = 100;
    public static final int PER_PIE = 520;
    public static final int DEFAULT_X_SPACE = 230;
    public static final int DEFAULT_Y_SPACE = 20;
    public static final int DEFAULT_OVAL_Y_SPACE = 30;
    public static final int DEFAULT_X_PIE = 30;
    public static final int OVAL_OUTER_RECT_HEIGHT = 100;
    public static final int PER_PIE_WIDTH = 530;
    private ArrayList<Vector> waitSet = new ArrayList();
    private ArrayList<Vector> lockSet = new ArrayList();
    private ArrayList<Vector> holdSet = new ArrayList();
    private ArrayList<Vector> forDrawLine = new ArrayList();
    private ArrayList<Vector> ovalSet = new ArrayList();
    private static Color redLine = new Color(Integer.decode("#2778ec")).brighter();
    private static Color greenLine = new Color(Integer.decode("#ffa800")).darker();
    private static Color blackLine = Color.BLACK;
    private JRadioButton background1 = new JRadioButton();
    private JRadioButton background2 = new JRadioButton();
    private JLabel background = new JLabel();
    private BackgroundPanel backgroundPanel = new BackgroundPanel();
    private JPanel optionPanel = new JPanel();
    private static final int BACKGROUND_COLOR_WHITE = 0;
    private static final int BACKGROUND_COLOR_LIGHTGRAY = 1;
    private static final int BACKGROUND_COLOR_GRAY = 2;
    private static final int BACKGROUND_COLOR_DARKGRAY = 3;
    private static final int BACKGROUND_FORM_BLANK = 0;
    private static final int BACKGROUND_FORM_PIONT = 1;
    private static final int BACKGROUND_FORM_GRID = 2;

    public LockTableModel getModel() {
        return this.model;
    }

    public void setModel(LockTableModel model) {
        this.model = model;
    }

    public LockGraphScrollPane(LockTableModel model, DBAResourceBundle res, SessionInfo session) {
        this.model = model;
        this.obj = session;
        this.drawPanel();
    }

    public LockGraphScrollPane(LockTableModel model, DBAResourceBundle res, LockInfo lockPane) {
        this.model = model;
        this.res = res;
        this.obj = lockPane;
        this.drawPanel();
    }

    public void drawPanel() {
        this.forDrawLine.clear();
        this.lt1.clear();
        this.waitSet.clear();
        this.lockSet.clear();
        this.holdSet.clear();
        this.ovalSet.clear();
        this.list.clear();
        this.rectlist.clear();
        this.rect.clear();
        this.dealLockDataInfo(this.model);
        if (this.waitSet.size() > 0) {
            this.drawRect();
            this.drawOval();
            this.groupRectSet();
        }
        this.initLocation();
        MouseWheelListener mwl = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int direction = 0;
                JScrollPane j = (JScrollPane)DbFrame.frame.getContentPanel().getParent().getParent();
                direction = e.getWheelRotation() == 1 ? 20 : -20;
                j.getVerticalScrollBar().setValue(j.getVerticalScrollBar().getValue() + direction);
            }
        };
        this.addMouseWheelListener(mwl);
        this.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (LockGraphScrollPane.this.rect.size() <= 0) {
                    return;
                }
                ((Resizable)LockGraphScrollPane.this.rect.get(LockGraphScrollPane.this.rect.size() - 1)).transferFocus();
                ((Resizable)LockGraphScrollPane.this.rect.get(LockGraphScrollPane.this.rect.size() - 1)).repaint();
            }
        });
        this.background.setHorizontalAlignment(4);
        this.background.setText(this.res.getString("Background"));
        this.background1.setText(this.res.getString("Blank"));
        this.background1.addActionListener(new ReflectionAction(this, "selectBackground1"));
        ButtonGroup background_radiobuttons = new ButtonGroup();
        background_radiobuttons.add(this.background1);
        background_radiobuttons.add(this.background2);
        if (this.obj instanceof LockInfo) {
            LockInfo cfr_ignored_0 = (LockInfo)this.obj;
            if (LockInfo.selectBlank) {
                this.background1.setSelected(true);
                this.backgroundPanel.setColorAndForm(2, 0);
            } else {
                this.background2.setSelected(true);
                this.backgroundPanel.setColorAndForm(2, 2);
            }
        } else {
            SessionInfo cfr_ignored_1 = (SessionInfo)this.obj;
            if (SessionInfo.selectBlank) {
                this.background1.setSelected(true);
                this.backgroundPanel.setColorAndForm(2, 0);
            } else {
                this.background2.setSelected(true);
                this.backgroundPanel.setColorAndForm(2, 2);
            }
        }
        this.background2.setText(this.res.getString("Grid"));
        this.background2.addActionListener(new ReflectionAction(this, "selectBackground2"));
        this.background.setBounds(10, 3, 150, 20);
        this.background1.setBounds(this.background.getX() + this.background.getWidth(), 3, 80, 20);
        this.background2.setBounds(this.background1.getX() + this.background1.getWidth() + 20, 3, 80, 20);
        this.optionPanel.setLayout(null);
        this.optionPanel.setPreferredSize(new Dimension(this.getWidth(), 25));
        this.optionPanel.add(this.background);
        this.optionPanel.add(this.background1);
        this.optionPanel.add(this.background2);
        this.optionPanel.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(Color.gray);
                g.fillRect(0, height - 1, width, height - 1);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(1, 1, 1, 1);
            }
        });
    }

    private void dealLockDataInfo(LockTableModel model2) {
        this.waitSetData(model2);
        this.lockSetData();
        this.holdSetData(model2);
        this.ovalSet();
        this.forDrawLineSet();
    }

    private void groupRectSet() {
        int i;
        int i2;
        ArrayList<Resizable> midRect = new ArrayList<Resizable>();
        ArrayList<Resizable> leftOval = new ArrayList<Resizable>();
        for (i2 = 0; i2 < this.rect.size(); ++i2) {
            Resizable resi = this.rect.get(i2);
            if (resi.getRectlocation() == 1) {
                midRect.add(resi);
                continue;
            }
            leftOval.add(resi);
        }
        for (i2 = 0; i2 < midRect.size(); ++i2) {
            Resizable ri = (Resizable)midRect.get(i2);
            String riName = ri.getName();
            Vector<String> v = new Vector<String>();
            this.list.add(v);
            v.addElement(riName);
            for (int j = 0; j < this.waitSet.size(); ++j) {
                String connid = (String)this.waitSet.get(j).get(2);
                String obj_gran = (String)this.waitSet.get(j).get(0) + this.waitSet.get(j).get(1);
                if (!obj_gran.equals(riName)) continue;
                for (int k = 0; k < leftOval.size(); ++k) {
                    Resizable rk = (Resizable)leftOval.get(k);
                    String rkName = rk.getName();
                    if (!rkName.equals(connid)) continue;
                    v.addElement(rkName);
                }
            }
        }
        ArrayList holdlist = new ArrayList();
        for (int i3 = 0; i3 < midRect.size(); ++i3) {
            Resizable ri = (Resizable)midRect.get(i3);
            String riName = ri.getName();
            Vector<String> v = new Vector<String>();
            holdlist.add(v);
            v.addElement(riName);
            for (int j = 0; j < this.holdSet.size(); ++j) {
                String connid = (String)this.holdSet.get(j).get(2);
                String obj_gran = (String)this.holdSet.get(j).get(0) + this.holdSet.get(j).get(1);
                if (!obj_gran.equals(riName)) continue;
                for (int k = 0; k < leftOval.size(); ++k) {
                    Resizable rk = (Resizable)leftOval.get(k);
                    String rkName = rk.getName();
                    if (!rkName.equals(connid)) continue;
                    v.addElement(rkName);
                }
            }
        }
        ArrayList<Vector> lt = new ArrayList<Vector>();
        for (i = 0; i < this.list.size(); ++i) {
            lt.add(this.list.get(i));
        }
        for (i = 0; i < holdlist.size(); ++i) {
            lt.add((Vector)holdlist.get(i));
        }
        int size = -1;
        while (true) {
            int sum = lt.size() - 1;
            for (int i4 = 0; i4 < sum; ++i4) {
                Vector vk2;
                Vector vi = (Vector)lt.get(0);
                if (this.compareVector(vi, vk2 = (Vector)lt.get(lt.size() - 1))) {
                    for (int j = 0; j < vk2.size(); ++j) {
                        if (vi.contains(vk2.get(j))) continue;
                        vi.addElement(vk2.get(j));
                    }
                    if (lt.size() <= 1) continue;
                    lt.remove(lt.size() - 1);
                    continue;
                }
                lt.add(1, vk2);
                if (lt.size() <= 1) continue;
                lt.remove(lt.size() - 1);
            }
            if (lt.size() == size) {
                this.lt1.add((Vector)lt.get(0));
                lt.remove(0);
                if (lt.size() == 0) break;
            }
            size = lt.size();
        }
    }

    private boolean compareVector(Vector vi, Vector vk2) {
        for (int i = 0; i < vi.size(); ++i) {
            if (!vk2.contains(vi.get(i))) continue;
            return true;
        }
        return false;
    }

    private void forDrawLineSet() {
        for (int i = 0; i < this.waitSet.size(); ++i) {
            String cid = (String)this.waitSet.get(i).get(2);
            String obj = (String)this.waitSet.get(i).get(0);
            for (int j = 0; j < this.holdSet.size(); ++j) {
                String conn = (String)this.holdSet.get(j).get(2);
                String obj2 = (String)this.holdSet.get(j).get(0);
                if (!conn.equals(cid) || !obj.equals(obj2)) continue;
                Vector<Object> v = new Vector<Object>();
                v.addElement(conn);
                v.addElement(i);
                this.forDrawLine.add(v);
            }
        }
    }

    private void waitSetData(LockTableModel model2) {
        for (int i = 0; i < model2.getRowCount(); ++i) {
            Vector<Object> v = new Vector<Object>();
            String lock_states = (String)model2.getValueAt(i, 7);
            if (lock_states.trim().equalsIgnoreCase("GRANTED")) continue;
            String LK_NEW_MODE = (String)model2.getValueAt(i, 6);
            String hold_connection = String.valueOf(model2.getValueAt(i, 4));
            String tbowner = (String)model2.getValueAt(i, 3);
            String objName = (String)model2.getValueAt(i, 0);
            v.addElement(model2.getValueAt(i, 2));
            v.addElement(model2.getValueAt(i, 1));
            v.addElement(hold_connection);
            v.addElement(LK_NEW_MODE);
            v.addElement(tbowner);
            v.addElement(objName);
            UtForSessionAndLock.executeSqlStr(v, hold_connection);
            this.waitSet.add(v);
        }
    }

    private void lockSetData() {
        this.lockSet = (ArrayList)this.waitSet.clone();
        if (this.lockSet.size() > 1) {
            for (int i = 0; i < this.lockSet.size(); ++i) {
                String oid = (String)this.lockSet.get(i).get(0);
                String gran = (String)this.lockSet.get(i).get(1);
                for (int j = this.lockSet.size() - 1; j > i; --j) {
                    String post_oid = (String)this.lockSet.get(j).get(0);
                    String post_gran = (String)this.lockSet.get(j).get(1);
                    if (!post_oid.equals(oid) || !post_gran.equals(gran)) continue;
                    this.lockSet.remove(j);
                }
            }
        }
    }

    private void holdSetData(LockTableModel model2) {
        for (int i = 0; i < model2.getRowCount(); ++i) {
            String objid = (String)model2.getValueAt(i, 2);
            String lk_gran = (String)model2.getValueAt(i, 1);
            String hold_connection = String.valueOf(model2.getValueAt(i, 4));
            String lk_current_model = (String)model2.getValueAt(i, 5);
            String objName = (String)model2.getValueAt(i, 0);
            String tbowner = (String)model2.getValueAt(i, 3);
            Vector<String> v = new Vector<String>();
            v.addElement(objid);
            v.addElement(lk_gran);
            v.addElement(hold_connection);
            v.addElement(lk_current_model);
            if (lk_current_model.equalsIgnoreCase("NONE.NONE")) continue;
            for (int j = 0; j < this.lockSet.size(); ++j) {
                String oid = (String)this.lockSet.get(j).get(0);
                String gran = (String)this.lockSet.get(j).get(1);
                if (!objid.equalsIgnoreCase(oid) || !lk_gran.equalsIgnoreCase(gran)) continue;
                v.addElement(objName);
                v.addElement(tbowner);
                UtForSessionAndLock.executeSqlStr(v, hold_connection);
                this.holdSet.add(v);
            }
        }
    }

    private void ovalSet() {
        this.ovalSet.addAll(this.waitSet);
        this.ovalSet.addAll(this.holdSet);
        if (this.ovalSet.size() > 1) {
            for (int i = 0; i < this.ovalSet.size(); ++i) {
                String connid = (String)this.ovalSet.get(i).get(2);
                for (int j = this.ovalSet.size() - 1; j > i; --j) {
                    String pre_cid = (String)this.ovalSet.get(j).get(2);
                    if (!connid.equals(pre_cid)) continue;
                    this.ovalSet.remove(j);
                }
            }
        }
    }

    private void drawRect() {
        for (int i = 0; i < this.lockSet.size(); ++i) {
            this.getRectView(this.lockSet.get(i), 1, 120 * i);
        }
    }

    private void getRectView(Vector vector, int location, int space) {
        Object[][] data = new Object[4][1];
        data[0][0] = ((String)vector.get(1)).substring(0, 1) + ((String)vector.get(1)).substring(1).toLowerCase() + " Lock";
        data[1][0] = "Object Id: " + vector.get(0);
        data[2][0] = "Object Name: " + vector.get(5);
        data[3][0] = "Table Owner: " + vector.get(4);
        String header = (String)data[0][0];
        Object[] columnNames = new Object[]{null};
        DefaultTableModel modeltable = new DefaultTableModel(data, columnNames);
        JTable table = new JTable(modeltable);
        DefaultTableCellRenderer render = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setHorizontalAlignment(0);
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        };
        table.getColumnModel().getColumn(0).setCellRenderer(render);
        table.setEnabled(false);
        table.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        table.setRowHeight(24);
        JPanel panel = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.drawLine(0, 20, this.getWidth(), 20);
            }
        };
        panel.setLayout(new BorderLayout());
        panel.add((Component)table, "Center");
        table.setShowVerticalLines(false);
        table.setShowHorizontalLines(false);
        String mark = (String)vector.get(0) + vector.get(1);
        for (int i = 0; i < this.rect.size(); ++i) {
            String rname = this.rect.get(i).getName();
            if (!rname.equalsIgnoreCase(mark)) continue;
            return;
        }
        panel.setPreferredSize(new Dimension(170, 100));
        Resizable r = new Resizable(panel, this.rect, this.res, 1, this.waitSet, this.holdSet, null, this.obj);
        r.setBounds(300, space + 50, 170, 100);
        r.setName(mark);
        this.rect.add(r);
    }

    private void drawOval() {
        for (int j = 0; j < this.ovalSet.size(); ++j) {
            Resizable r = new Resizable(null, this.rect, this.res, 3, this.waitSet, this.holdSet, (String)this.ovalSet.get(j).get(2), this.obj);
            r.setBounds(30, j * 120, 100, 100);
            r.setName((String)this.ovalSet.get(j).get(2));
            this.rect.add(r);
        }
    }

    public void initLocation() {
        HashMap<Integer, Integer> mp = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.lt1.size(); ++i) {
            Vector vii = this.lt1.get(i);
            int objnum = 0;
            for (int j = 0; j < vii.size(); ++j) {
                String element = vii.get(j).toString();
                if (element.length() <= 5) continue;
                ++objnum;
            }
            int totalHeight = (vii.size() - objnum) * 100 + (vii.size() - objnum - 1) * 30;
            int oft = (totalHeight - objnum * 100) / (objnum + 1);
            mp.put(i, oft);
        }
        this.setLayout(null);
        Resizable r = null;
        int count = -1;
        for (int i = 0; i < this.lt1.size(); ++i) {
            Vector<Resizable> vre = new Vector<Resizable>();
            this.rectlist.add(vre);
            ++count;
            Vector v = this.lt1.get(i);
            int md = 0;
            int le = -1;
            int oft = (Integer)mp.get(i);
            for (int j = 0; j < this.rect.size(); ++j) {
                r = this.rect.get(j);
                String name = r.getName();
                for (int k = 0; k < v.size(); ++k) {
                    if (!name.equals(v.get(k))) continue;
                    vre.add(r);
                    if (r.getRectlocation() == 1) {
                        r.setBounds(LockGraphScrollPane.leftOriginPoint.x + 100 + 230 + 520 * count, LockGraphScrollPane.leftOriginPoint.y + ++md * (oft + 100) - 100, 170, 100);
                    } else if (r.getRectlocation() == 3) {
                        r.setBounds(LockGraphScrollPane.leftOriginPoint.x + 520 * count, LockGraphScrollPane.leftOriginPoint.y + ++le * 130, 100, 100);
                    }
                    this.add(r);
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        for (Resizable r : this.rect) {
            width = r.getX() + r.getWidth() > width ? r.getX() + r.getWidth() : width;
            height = r.getY() + r.getHeight() > height ? r.getY() + r.getHeight() : height;
        }
        return new Dimension(width + 100, height + 100);
    }

    @Override
    public void paint(Graphics g) {
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g);
        for (int i = 0; i < this.rectlist.size(); ++i) {
            Vector vec = this.rectlist.get(i);
            this.drawAllLine(vec, g);
        }
        this.add(this.optionPanel);
        this.optionPanel.setBounds(0, 0, this.getWidth(), 30);
        this.add(this.backgroundPanel);
        this.backgroundPanel.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.scrollRectToVisible(this.getVisibleRect());
        ++this.paintFlag;
        if (this.paintFlag < 3) {
            this.repaint();
        } else {
            this.paintFlag = 0;
        }
    }

    private void drawAllLine(Vector vec, Graphics g) {
        String name;
        Point pointRect;
        Point pointOval;
        String lkmode;
        int i;
        int ovalCount = vec.size() - 1;
        Graphics2D g2D = (Graphics2D)g;
        block0: for (i = 0; i < this.waitSet.size(); ++i) {
            String obj_gran = (String)this.waitSet.get(i).get(0) + this.waitSet.get(i).get(1);
            String connid = (String)this.waitSet.get(i).get(2);
            lkmode = (String)this.waitSet.get(i).get(3);
            pointOval = null;
            pointRect = null;
            for (int j = 0; j < vec.size(); ++j) {
                Resizable re = (Resizable)vec.get(j);
                name = re.getName();
                if (connid.equals(name)) {
                    pointOval = new Point(re.getLocation().x + 100 - 5, re.getLocation().y + 50);
                    continue;
                }
                if (!obj_gran.equals(name)) continue;
                pointRect = new Point(re.getLocation().x + 5, re.getLocation().y + 50);
            }
            if (pointRect == null || pointOval == null) continue;
            for (int k = 0; k < this.forDrawLine.size(); ++k) {
                if (!this.forDrawLine.get(k).get(0).equals(connid)) continue;
                this.drawSpecialLine(g2D, pointRect, pointOval, lkmode, (Integer)this.forDrawLine.get(k).get(1));
                continue block0;
            }
            g2D.setColor(redLine);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Line2D.Float line = new Line2D.Float(pointRect, pointOval);
            g2D.draw(line);
            g2D.fillOval(pointOval.x - 3, pointOval.y - 3, 6, 6);
            double angle = this.calcAngel(pointOval, pointRect);
            this.drawArrowhead(g2D, pointRect, angle);
            g2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2D.setColor(blackLine);
            g2D.translate(pointOval.x, pointOval.y);
            g2D.rotate(angle - 1.5707963267948966);
            g2D.setFont(this.linefont);
            g2D.drawString(lkmode + "(Waiting)", 20, -2);
            g2D.rotate(-(angle - 1.5707963267948966));
            g2D.translate(-pointOval.x, -pointOval.y);
        }
        block3: for (i = 0; i < this.holdSet.size(); ++i) {
            String connid = (String)this.holdSet.get(i).get(2);
            String obj_gran = (String)this.holdSet.get(i).get(0) + this.holdSet.get(i).get(1);
            lkmode = (String)this.holdSet.get(i).get(3);
            pointOval = null;
            pointRect = null;
            for (int k = 0; k < this.forDrawLine.size(); ++k) {
                if (this.forDrawLine.get(k).get(0).equals(connid)) continue block3;
            }
            for (int j = 0; j < vec.size(); ++j) {
                Resizable re = (Resizable)vec.get(j);
                name = re.getName();
                if (connid.equals(name)) {
                    pointOval = new Point(re.getLocation().x + 100 - 5, re.getLocation().y + 50);
                    continue;
                }
                if (!obj_gran.equals(name)) continue;
                pointRect = new Point(re.getLocation().x + 5, re.getLocation().y + 50);
            }
            if (pointRect == null || pointOval == null) continue;
            g2D.setColor(greenLine);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Line2D.Float line = new Line2D.Float(pointRect, pointOval);
            g2D.draw(line);
            g2D.fillOval(pointRect.x - 3, pointRect.y - 3, 6, 6);
            double angle = this.calcAngel(pointRect, pointOval);
            this.drawArrowhead(g2D, pointOval, angle);
            g2D.setColor(blackLine);
            g2D.translate(pointOval.x, pointOval.y);
            g2D.rotate(angle + 1.5707963267948966);
            g2D.setFont(this.linefont);
            g2D.drawString(lkmode + "(Hold)", 30, -2);
            g2D.rotate(-(angle + 1.5707963267948966));
            g2D.translate(-pointOval.x, -pointOval.y);
        }
    }

    private void drawSpecialLine(Graphics2D g2D, Point rectP3, Point ovalP4, String lkmode, int k) {
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        Point2D.Float p = new Point2D.Float((ovalP4.x + rectP3.x) / 2 - 10, (ovalP4.y + rectP3.y) / 2 - 15);
        Point2D.Float p2 = new Point2D.Float((ovalP4.x + rectP3.x) / 2, (ovalP4.y + rectP3.y) / 2 + 15);
        Line2D.Float line = new Line2D.Float(ovalP4, p);
        Line2D.Float line2 = new Line2D.Float(rectP3, p);
        Line2D.Float line3 = new Line2D.Float(ovalP4, p2);
        Line2D.Float line4 = new Line2D.Float(rectP3, p2);
        double angle = this.calcAngel(p, ovalP4);
        double angle2 = this.calcAngel(p2, rectP3);
        g2D.setColor(greenLine);
        g2D.draw(line);
        g2D.draw(line2);
        this.drawArrowhead(g2D, ovalP4, angle);
        g2D.setColor(redLine);
        g2D.draw(line3);
        g2D.draw(line4);
        this.drawArrowhead(g2D, rectP3, angle2);
        g2D.setColor(blackLine);
        g2D.setFont(this.linefont);
        g2D.drawString(lkmode + "(Hold)", (int)((Point2D)p).getX(), (int)((Point2D)p).getY());
        g2D.drawString((String)this.waitSet.get(k).get(3) + "(Waiting)", (int)((Point2D)p2).getX(), (int)((Point2D)p2).getY());
    }

    public void drawArrowhead(Graphics2D g2D, Point p, double angle) {
        int bottomWidth = 6;
        int height = 16;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int[] x = new int[]{p.x, p.x - bottomWidth / 2, p.x + bottomWidth / 2};
        int[] y = new int[]{p.y, p.y + height, p.y + height};
        int nPoints = 3;
        g2D.rotate(angle, p.x, p.y);
        g2D.fillPolygon(x, y, nPoints);
        g2D.rotate(-angle, p.x, p.y);
    }

    public double calcAngel(Point2D point2d, Point2D point2d2) {
        double x = (point2d.getX() - point2d2.getX()) / (point2d2.getY() - point2d.getY());
        double angle = Math.atan(x);
        if (point2d.getY() <= point2d2.getY()) {
            angle = Math.PI + angle;
        }
        return angle;
    }

    public void selectBackground1(ActionEvent e) {
        if (this.obj instanceof LockInfo) {
            LockInfo cfr_ignored_0 = (LockInfo)this.obj;
            LockInfo.selectBlank = true;
        } else {
            SessionInfo cfr_ignored_1 = (SessionInfo)this.obj;
            SessionInfo.selectBlank = true;
        }
        this.newBackground(2, 0);
    }

    public void selectBackground2(ActionEvent e) {
        if (this.obj instanceof LockInfo) {
            LockInfo cfr_ignored_0 = (LockInfo)this.obj;
            LockInfo.selectBlank = false;
        } else {
            SessionInfo cfr_ignored_1 = (SessionInfo)this.obj;
            SessionInfo.selectBlank = false;
        }
        this.newBackground(2, 2);
    }

    public void newBackground(int color, int form) {
        this.backgroundPanel.setColorAndForm(color, form);
        this.repaint();
    }

    class BackgroundPanel
    extends JPanel {
        private int form = 0;
        private int color = 2;

        BackgroundPanel() {
        }

        public void setColorAndForm(int color, int form) {
            this.color = color;
            this.form = form;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Color bkcolor = Color.GRAY;
            switch (this.color) {
                case 0: {
                    bkcolor = Color.WHITE;
                    break;
                }
                case 1: {
                    bkcolor = new Color(245, 245, 245);
                    break;
                }
                case 2: {
                    bkcolor = new Color(220, 220, 220);
                    this.setOpaque(false);
                    break;
                }
                case 3: {
                    bkcolor = new Color(185, 185, 185);
                }
            }
            this.setBackground(bkcolor);
            switch (this.form) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int x = 15; x < this.getWidth(); x += 15) {
                        for (int y = 15; y < this.getHeight(); y += 15) {
                            g.fillOval(x, y, 2, 2);
                        }
                    }
                    break;
                }
                case 2: {
                    g.setColor(new Color(175, 175, 175));
                    for (int x = 15; x < this.getWidth(); x += 15) {
                        g.drawLine(x, 0, x, this.getHeight());
                    }
                    for (int y = 15; y < this.getHeight(); y += 15) {
                        g.drawLine(0, y, this.getWidth(), y);
                    }
                    break;
                }
            }
        }
    }
}

