/*
 * Decompiled with CFR 0.152.
 */
package dbatool.IVFTextIndex;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.IVFTextIndex.RebuildIVFTextIndexDlg;
import dbatool.tableModel.ColumnSorting;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class IVFTextIndexList
extends DbaTabbedPane
implements ComponentPrivilege {
    private TextIndexCols model1 = null;
    private DBAToolAbstractTableModel absModel1 = null;
    private JTable table1 = null;
    private TextIndexStatCols model2 = null;
    private DBAToolAbstractTableModel absModel2 = null;
    private JTable table2 = null;
    private DbaButton Prop_Create_Bottun;
    private DbaButton Prop_Rebuild_Button;
    private DbaButton Prop_Drop_Button;
    private String table_owner;
    private String table_name;
    private static boolean isDesc = false;

    public IVFTextIndexList(String table_owner, String table_name) {
        this.Prop_Create_Bottun = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Prop_Create_Bottun_actionPerformed"));
        this.Prop_Rebuild_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Rebuild"), 'B', DBAImageResource.getResource(this.getClass(), "/jdbaimages/rebuild.gif"), new ReflectionAction(this, "Prop_Rebuild_Button_actionPerformed"));
        this.Prop_Drop_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Prop_Drop_Button_actionPerformed"));
        this.table_owner = null;
        this.table_name = null;
        this.table_owner = table_owner;
        this.table_name = table_name;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IVFTextIndexList() {
        this.Prop_Create_Bottun = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Prop_Create_Bottun_actionPerformed"));
        this.Prop_Rebuild_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Rebuild"), 'B', DBAImageResource.getResource(this.getClass(), "/jdbaimages/rebuild.gif"), new ReflectionAction(this, "Prop_Rebuild_Button_actionPerformed"));
        this.Prop_Drop_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Prop_Drop_Button_actionPerformed"));
        this.table_owner = null;
        this.table_name = null;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "ivftextindex.list.properties");
        DbaPanel jPanel2 = new DbaPanel(DbFrame.helpres, "ivftextindex.list.statistics");
        JScrollPane jScrollPane1 = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JLabel jLabel1 = new JLabel();
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        this.model1 = new TextIndexCols();
        this.absModel1 = new DBAToolAbstractTableModel(this.model1);
        this.table1 = new JTable(this.absModel1);
        this.table1.setAutoResizeMode(4);
        this.model2 = new TextIndexStatCols();
        this.absModel2 = new DBAToolAbstractTableModel(this.model2);
        this.table2 = new JTable(this.absModel2);
        jPanel1.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        jLabel1.setText(DbFrame.frame.res.getString("Statistics_for_IVF_Text"));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Properties"));
        jPanel1.add((Component)jPanel4, "North");
        jPanel4.setName("IVFTextIndexesButtonPanel");
        jPanel4.add((Component)this.Prop_Create_Bottun, null);
        jPanel4.add((Component)this.Prop_Drop_Button, null);
        jPanel4.add((Component)this.Prop_Rebuild_Button, null);
        jPanel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.add((Component)jPanel2, DbFrame.frame.res.getTitle("Statistics"));
        jPanel2.add((Component)jScrollPane2, "Center");
        jPanel2.add((Component)jLabel1, "North");
        jScrollPane2.getViewport().add((Component)this.table2, null);
        this.table1.setSelectionMode(0);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table1_valueChanged"));
        this.getTextIndexInfo();
        this.absModel1.addMouseListenerToHeaderInTable(this.table1);
        this.absModel2.addMouseListenerToHeaderInTable(this.table2);
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
        this.table1.setName("PropertiesIVFTextIndexesTable");
        this.setName("IVFTextIndexesTabbedPane");
        this.Prop_Create_Bottun.setName("CreateButton");
        this.Prop_Drop_Button.setName("DropButton");
        this.Prop_Rebuild_Button.setName("RebuildButton");
    }

    @Override
    public int getComponentType() {
        return 21;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Prop_Create_Bottun.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Prop_Drop_Button.setEnabled(enabled);
        this.Prop_Rebuild_Button.setEnabled(enabled);
    }

    public void table1_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table1.getSelectedRow();
            Object value = this.table1.getValueAt(r, 0);
            String owner = (String)value;
            this.authority.authorise(owner);
        }
    }

    public static String getColumns(String name, String tb_owner, String tb_name, byte[] reserve_bytes, boolean order) {
        Statement stmt = null;
        ResultSet rs = null;
        String query = null;
        StringBuffer sb = new StringBuffer();
        int column_num = 0;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            int count = 0;
            while ((column_num = reserve_bytes[count]) != 0) {
                if (column_num < 0) {
                    column_num += 128;
                    isDesc = true;
                } else {
                    isDesc = false;
                }
                query = "select COLUMN_NAME from SYSTEM.SYSCOLUMN where TABLE_OWNER = '" + tb_owner + "' and TABLE_NAME = '" + tb_name + "' and COLUMN_ORDER =" + column_num;
                rs = stmt.executeQuery(query);
                if (rs.next()) {
                    sb.append(sb.length() > 0 ? ", " : "").append(rs.getString(1).trim());
                }
                if (order) {
                    sb.append(isDesc ? "desc" : "asc");
                }
                rs.close();
                ++count;
            }
            stmt.close();
        }
        catch (SQLException E) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            System.out.println("Transaction failed: " + E.getMessage());
        }
        return sb.toString();
    }

    private void getTextIndexInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model1.removeAll();
            this.model2.removeAll();
            System.gc();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "SELECT TABLE_OWNER, TABLE_NAME, TEXTINDEX_NAME, RESERVE2, FACTOR1, FACTOR2, FACTOR3, FACTOR4, FACTOR5, FACTOR6 FROM SYSTEM.SYSTEXTINDEX WHERE TYPE = 2";
            if (this.table_name != null) {
                query = query + " and TABLE_OWNER = '" + this.table_owner + "'" + " and TABLE_NAME = '" + this.table_name + "'";
            }
            query = query + " order by TEXTINDEX_NAME";
            rs = stmt.executeQuery(query);
            String column_name = null;
            byte[] reserve2 = null;
            TextIndexRowInfo aRow = null;
            TextIndexStatInfo aStatRow = null;
            short cluster_width = 0;
            int avg_text_size = 0;
            while (rs.next()) {
                String tb_owner = GuiUt.rightTrim(rs.getString(1));
                String tb_name = GuiUt.rightTrim(rs.getString(2));
                String index_name = GuiUt.rightTrim(rs.getString(3));
                reserve2 = rs.getBytes(4);
                column_name = IVFTextIndexList.getColumns(index_name, tb_owner, tb_name, reserve2, false);
                short text_block_size = rs.getShort(5);
                short basic_bit_length = rs.getShort(6);
                short ext_bit_length = rs.getShort(7);
                cluster_width = rs.getShort(8);
                int num_text_block = rs.getInt(9);
                avg_text_size = rs.getInt(10);
                aRow = new TextIndexRowInfo(tb_owner, tb_name, index_name, column_name, text_block_size, basic_bit_length, ext_bit_length, cluster_width, isDesc);
                this.model1.addValue(aRow);
                aStatRow = new TextIndexStatInfo(tb_owner, tb_name, index_name, num_text_block, avg_text_size);
                this.model2.addValue(aStatRow);
            }
            if (this.model1.getRowCount() == 0) {
                DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("No_data_found"));
            } else {
                DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(DbFrame.frame.res.getString("The_number_of_ivf_text_indexes_is"), Integer.toString(this.model1.getRowCount())));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
    }

    public void Prop_Drop_Button_actionPerformed(ActionEvent e) {
        String name;
        String tb_owner;
        int row = this.table1.getSelectedRow();
        if (row >= this.table1.getRowCount() || row < 0) {
            return;
        }
        String tb_name = null;
        if (this.table_name == null) {
            tb_owner = (String)this.absModel1.getValueAt(row, 0);
            tb_name = (String)this.absModel1.getValueAt(row, 1);
            name = (String)this.absModel1.getValueAt(row, 2);
        } else {
            name = (String)this.absModel1.getValueAt(row, 0);
            tb_owner = this.table_owner;
            tb_name = this.table_name;
        }
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_drop_ivf_textindex");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, DbFrame.frame.res.getString("Drop_IVF_Text_Index"), str2 + " ?");
        if (reply != 0) {
            return;
        }
        String query = "DROP TEXT INDEX \"" + name + "\" FROM \"" + tb_owner + "\".\"" + tb_name + "\"";
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Text_Index") + name + DbFrame.frame.res.getString("has_been_droped"));
            this.getTextIndexInfo();
            this.absModel1.fireTableChanged(new TableModelEvent(this.absModel1));
            this.absModel2.fireTableChanged(new TableModelEvent(this.absModel2));
            if (row >= this.absModel1.getRowCount()) {
                this.table1.clearSelection();
                this.Prop_Drop_Button.setEnabled(false);
                this.Prop_Rebuild_Button.setEnabled(false);
            }
        }
    }

    public void Prop_Rebuild_Button_actionPerformed(ActionEvent e) {
        String name;
        String tb_owner;
        int row = this.table1.getSelectedRow();
        if (row >= this.table1.getRowCount() || row < 0) {
            return;
        }
        String tb_name = null;
        if (this.table_name == null) {
            tb_owner = (String)this.absModel1.getValueAt(row, 0);
            tb_name = (String)this.absModel1.getValueAt(row, 1);
            name = (String)this.absModel1.getValueAt(row, 2);
        } else {
            name = (String)this.absModel1.getValueAt(row, 0);
            tb_owner = this.table_owner;
            tb_name = this.table_name;
        }
        RebuildIVFTextIndexDlg dlg = new RebuildIVFTextIndexDlg((Frame)DbFrame.frame, DbFrame.frame.res.getString("Rebuild"), true, name);
        GuiUt.setCenterLocation(DbFrame.frame, dlg);
        dlg.show();
        if (!dlg.result) {
            return;
        }
        String query = "REBUILD TEXT INDEX " + GuiUt.getIDString(name) + " FOR " + GuiUt.getIDString(tb_owner) + "." + GuiUt.getIDString(tb_name) + " ";
        boolean result = DatabaseConnection.executeSQL(query = query + (dlg.fullrb ? "FULL" : "INCREMENTAL"));
        if (result) {
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Rebuild_ivf_text_index") + name + ".");
            GuiUt.showInformationDlg(DbFrame.frame, DbFrame.frame.res.getString("Ivf_Text_Index") + " " + name + " " + DbFrame.frame.res.getString("rebuild_successfully") + " !");
            this.getTextIndexInfo();
            this.absModel1.fireTableChanged(new TableModelEvent(this.absModel1));
            this.absModel2.fireTableChanged(new TableModelEvent(this.absModel2));
        }
    }

    public void Prop_Create_Bottun_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(18, this.table_owner, this.table_name);
        this.getTextIndexInfo();
        this.absModel1.fireTableChanged(new TableModelEvent(this.absModel1));
        this.absModel2.fireTableChanged(new TableModelEvent(this.absModel2));
    }

    public class TextIndexStatCols
    extends AbstractTableModel
    implements ColumnSorting {
        private String[] columnAllNames;
        private String[] columnNames;
        private Vector data;

        public TextIndexStatCols() {
            this.columnAllNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Table_Name"), DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Num_Text_Block"), DbFrame.frame.res.getString("Average_Block_Size")};
            this.columnNames = new String[]{DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Num_Text_Block"), DbFrame.frame.res.getString("Average_Block_Size")};
            this.data = new Vector();
        }

        @Override
        public int getColumnCount() {
            if (IVFTextIndexList.this.table_name != null) {
                return this.columnNames.length;
            }
            return this.columnAllNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            if (IVFTextIndexList.this.table_name != null) {
                return this.columnNames[col];
            }
            return this.columnAllNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            TextIndexStatInfo rowData = (TextIndexStatInfo)this.data.elementAt(row);
            return rowData.getValueAt(col);
        }

        public Class getColumnClass(int c) {
            TextIndexStatInfo rowData = (TextIndexStatInfo)this.data.elementAt(0);
            return rowData.getValueAt(c).getClass();
        }

        public void addValue(TextIndexStatInfo newData) {
            this.data.addElement(newData);
        }

        public void removeAll() {
            this.data.removeAllElements();
        }

        @Override
        public void switchOrder(int godown, int goup) {
            Object downRow = this.data.elementAt(godown);
            Object upRow = this.data.elementAt(goup);
            this.data.setElementAt(downRow, goup);
            this.data.setElementAt(upRow, godown);
        }
    }

    private class TextIndexStatInfo {
        Object[] data = new Object[5];

        public TextIndexStatInfo(String tb_owner, String tb_name, String name, int num_text_block, int avg_text_size) {
            this.data[0] = tb_owner;
            this.data[1] = tb_name;
            this.data[2] = name;
            this.data[3] = new Integer(num_text_block);
            this.data[4] = new Integer(avg_text_size);
        }

        public Object getValueAt(int index) {
            if (IVFTextIndexList.this.table_name != null) {
                return this.data[index + 2];
            }
            return this.data[index];
        }

        public void setValueAt(Object value, int index) {
            this.data[index] = value;
        }
    }

    private class TextIndexCols
    extends AbstractTableModel
    implements ColumnSorting {
        private String[] columnAllNames;
        private String[] columnNames;
        private Vector data;

        public TextIndexCols() {
            this.columnAllNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Table_Name"), DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Column"), DbFrame.frame.res.getString("Text_Block_Size")};
            this.columnNames = new String[]{DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Column"), DbFrame.frame.res.getString("Text_Block_Size")};
            this.data = new Vector();
        }

        @Override
        public int getColumnCount() {
            if (IVFTextIndexList.this.table_name != null) {
                return this.columnNames.length;
            }
            return this.columnAllNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            if (IVFTextIndexList.this.table_name != null) {
                return this.columnNames[col];
            }
            return this.columnAllNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            TextIndexRowInfo rowData = (TextIndexRowInfo)this.data.elementAt(row);
            return rowData.getValueAt(col);
        }

        public Class getColumnClass(int c) {
            TextIndexRowInfo rowData = (TextIndexRowInfo)this.data.elementAt(0);
            return rowData.getValueAt(c).getClass();
        }

        public void addValue(TextIndexRowInfo newData) {
            this.data.addElement(newData);
        }

        public void removeAll() {
            this.data.removeAllElements();
        }

        @Override
        public void switchOrder(int godown, int goup) {
            Object downRow = this.data.elementAt(godown);
            Object upRow = this.data.elementAt(goup);
            this.data.setElementAt(downRow, goup);
            this.data.setElementAt(upRow, godown);
        }
    }

    private class TextIndexRowInfo {
        Object[] data = new Object[9];

        public TextIndexRowInfo(String tb_owner, String tb_name, String name, String column, short text_block_size, short basic_bit_length, short ext_bit_length, short cluster_width, boolean isDesc) {
            this.data[0] = tb_owner;
            this.data[1] = tb_name;
            this.data[2] = name;
            this.data[3] = column;
            this.data[4] = new Short(text_block_size);
            this.data[5] = new Short(basic_bit_length);
            this.data[6] = new Short(ext_bit_length);
            this.data[7] = new Short(cluster_width);
            this.data[8] = isDesc ? Boolean.FALSE : Boolean.TRUE;
        }

        public Object getValueAt(int index) {
            if (IVFTextIndexList.this.table_name != null) {
                return this.data[index + 2];
            }
            return this.data[index];
        }

        public void setValueAt(Object value, int index) {
            this.data[index] = value;
        }
    }
}

