/*
 * Decompiled with CFR 0.152.
 */
package dbatool.ForeignKey;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableModel.ColumnSorting;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.resource.DBAImageResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ForeignKeyList
extends DbaTabbedPane
implements ComponentPrivilege {
    private ForeignKeyTableModel foreignkeyTableModel = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table = null;
    private DbaButton Prop_Create_Button;
    private DbaButton Prop_Drop_Button;
    private String table_owner;
    private String table_name;

    public ForeignKeyList(String table_owner, String table_name) {
        this.Prop_Create_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Prop_Create_Button_actionPerformed"));
        this.Prop_Drop_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Prop_Drop_Button_actionPerformed"));
        this.table_owner = null;
        this.table_name = null;
        this.table_owner = table_owner;
        this.table_name = table_name;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ForeignKeyList() {
        this.Prop_Create_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Prop_Create_Button_actionPerformed"));
        this.Prop_Drop_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Prop_Drop_Button_actionPerformed"));
        this.table_owner = null;
        this.table_name = null;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "foreignkey.list");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JScrollPane jScrollPane1 = new JScrollPane();
        this.foreignkeyTableModel = new ForeignKeyTableModel();
        this.absModel = new DBAToolAbstractTableModel(this.foreignkeyTableModel);
        this.table = new JTable(this.absModel);
        jPanel1.setLayout(new BorderLayout());
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Properties"));
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.Prop_Create_Button, null);
        jPanel2.add((Component)this.Prop_Drop_Button, null);
        jPanel1.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add((Component)this.table, null);
        this.table.setAutoResizeMode(4);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        this.getForeignKeyInfo();
        this.absModel.addMouseListenerToHeaderInTable(this.table);
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
        this.setName("ForeighKeysTabbedPane");
        jPanel2.setName("ForeignKeyButtonPanel");
        this.Prop_Create_Button.setName("CreateButton");
        this.Prop_Drop_Button.setName("DropButton");
        this.table.setName("ForeignKeysTable");
    }

    @Override
    public int getComponentType() {
        return 14;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Prop_Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Prop_Drop_Button.setEnabled(enabled);
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table.getSelectedRow();
            Object value = this.table.getValueAt(r, 0);
            String owner = (String)value;
            this.authority.authorise(owner);
        }
    }

    public static String getColumnOrder(String tb_owner, String tb_name, byte[] col_order_bytes) {
        String column_order = "";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = null;
            String query = null;
            int count = 0;
            byte litterBit = 0;
            byte highBit = 0;
            while (true) {
                litterBit = col_order_bytes[count * 2];
                highBit = col_order_bytes[count * 2 + 1];
                int temp = 0;
                temp |= highBit;
                temp <<= 8;
                int column_num = temp |= litterBit;
                if (column_num <= 0) break;
                query = "select COLUMN_NAME from SYSTEM.SYSCOLUMN where TABLE_OWNER = '" + tb_owner + "' and TABLE_NAME = '" + tb_name + "' and COLUMN_ORDER =" + column_num;
                rs = stmt.executeQuery(query);
                if (rs.next()) {
                    column_order = column_order.length() == 0 ? rs.getString(1).trim() : column_order + ", " + rs.getString(1).trim();
                }
                rs.close();
                ++count;
            }
            stmt.close();
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(DbFrame.frame, null, sqle);
        }
        return column_order;
    }

    private void getForeignKeyInfo() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.foreignkeyTableModel.removeAll();
            System.gc();
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            String query = "select FK_NAME, FK_TBL_OWNER, FK_TBL_NAME, FK_COL_ORDER, PK_TBL_OWNER, PK_TBL_NAME, PK_COL_ORDER, UPD_ACT, DEL_ACT from SYSTEM.SYSFOREIGNKEY ";
            if (this.table_name != null) {
                query = this.table_owner != null ? query + "WHERE FK_TBL_OWNER = '" + this.table_owner + "' " + "AND FK_TBL_NAME = '" + this.table_name + "' " : query + "WHERE FK_TBL_NAME = '" + this.table_name + "' ";
            }
            String pk_tbl_name = null;
            byte[] pk_col_order_bytes = null;
            short del_act = 0;
            String pk_col_order = null;
            RowInfo aRow = null;
            query = query + "ORDER BY FK_TBL_OWNER, FK_TBL_NAME, FK_NAME";
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String fk_name = GuiUt.rightTrim(rs.getString(1));
                String fk_tbl_owner = GuiUt.rightTrim(rs.getString(2));
                String fk_tbl_name = GuiUt.rightTrim(rs.getString(3));
                String pk_tbl_owner = GuiUt.rightTrim(rs.getString(5));
                pk_tbl_name = GuiUt.rightTrim(rs.getString(6));
                byte[] fk_col_order_bytes = rs.getBytes(4);
                pk_col_order_bytes = rs.getBytes(7);
                short upd_act = rs.getShort(8);
                del_act = rs.getShort(9);
                String fk_col_order = ForeignKeyList.getColumnOrder(fk_tbl_owner, fk_tbl_name, fk_col_order_bytes);
                pk_col_order = ForeignKeyList.getColumnOrder(pk_tbl_owner, pk_tbl_name, pk_col_order_bytes);
                aRow = new RowInfo(fk_tbl_owner, fk_tbl_name, fk_name, fk_col_order, pk_tbl_owner, pk_tbl_name, pk_col_order, upd_act, del_act);
                this.foreignkeyTableModel.addValue(aRow);
            }
            if (this.foreignkeyTableModel.getRowCount() == 0) {
                DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("No_data_found"));
            }
            rs.close();
            stmt.close();
            rs = null;
            stmt = null;
            DbFrame.frame.setStatusDisc(GuiUt.mapStringForProperty(DbFrame.frame.res.getString("The_number_of_foreign_keys_is"), Integer.toString(this.foreignkeyTableModel.getRowCount())));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
    }

    public void Prop_Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        String tb_owner = null;
        String tb_name = null;
        String name = null;
        if (this.table_name != null) {
            tb_owner = this.table_owner;
            tb_name = this.table_name;
            name = (String)this.foreignkeyTableModel.getValueAt(row, 0);
        } else {
            tb_owner = (String)this.absModel.getValueAt(row, 0);
            tb_name = (String)this.absModel.getValueAt(row, 1);
            name = (String)this.foreignkeyTableModel.getValueAt(row, 2);
        }
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_drop_foreignKey");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int reply = GuiUt.showOptionDlg(DbFrame.frame, DbFrame.frame.res.getString("Drop_Foreign_Key"), str2 + " ?");
        if (reply != 0) {
            return;
        }
        String query = "ALTER TABLE \"" + tb_owner + "\".\"" + tb_name + "\" DROP FOREIGN KEY \"" + name + "\"";
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("Foreign_Key") + name + DbFrame.frame.res.getString("has_been_droped"));
            this.getForeignKeyInfo();
            if (row >= this.table.getRowCount()) {
                this.table.clearSelection();
                this.Prop_Drop_Button.setEnabled(false);
            }
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        }
    }

    public void Prop_Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(2, this.table_owner, this.table_name);
        this.foreignkeyTableModel.removeAll();
        System.gc();
        this.getForeignKeyInfo();
        this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
    }

    public class ForeignKeyTableModel
    extends AbstractTableModel
    implements ColumnSorting {
        private String[] allColumnNames;
        private String[] columnNames;
        private Vector data;

        public ForeignKeyTableModel() {
            this.allColumnNames = new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Table_Name"), DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Columns"), DbFrame.frame.res.getString("Referenced_Table"), DbFrame.frame.res.getString("Referenced_Keys"), DbFrame.frame.res.getString("Update_Action"), DbFrame.frame.res.getString("Delete_Action")};
            this.columnNames = new String[]{DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Columns"), DbFrame.frame.res.getString("Referenced_Table"), DbFrame.frame.res.getString("Referenced_Keys"), DbFrame.frame.res.getString("Update_Action"), DbFrame.frame.res.getString("Delete_Action")};
            this.data = new Vector();
        }

        @Override
        public int getColumnCount() {
            if (ForeignKeyList.this.table_name != null) {
                return this.columnNames.length;
            }
            return this.allColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            if (ForeignKeyList.this.table_name != null) {
                return this.columnNames[col];
            }
            return this.allColumnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            RowInfo rowData = (RowInfo)this.data.elementAt(row);
            return rowData.getValueAt(col);
        }

        public Class getColumnClass(int c) {
            RowInfo rowData = (RowInfo)this.data.elementAt(0);
            return rowData.getValueAt(c).getClass();
        }

        public void addValue(RowInfo newData) {
            this.data.addElement(newData);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            RowInfo rowData = (RowInfo)this.data.elementAt(row);
            rowData.setValueAt(value, col);
        }

        public void removeAll() {
            this.data.removeAllElements();
        }

        @Override
        public void switchOrder(int godown, int goup) {
            Object downRow = this.data.elementAt(godown);
            Object upRow = this.data.elementAt(goup);
            this.data.setElementAt(downRow, goup);
            this.data.setElementAt(upRow, godown);
        }
    }

    private class RowInfo {
        Object[] data = new Object[8];

        public RowInfo(String fk_tbl_owner, String fk_tbl_name, String fk_name, String fk_col_order, String pk_tbl_owner, String pk_tbl_name, String pk_col_order, short upd_act, short del_act) {
            this.data[0] = fk_tbl_owner;
            this.data[1] = fk_tbl_name;
            this.data[2] = fk_name;
            this.data[3] = fk_col_order;
            this.data[4] = pk_tbl_owner + "." + pk_tbl_name;
            this.data[5] = pk_col_order;
            switch (upd_act) {
                case 0: {
                    this.data[6] = new String("No Action");
                    break;
                }
                case 1: {
                    this.data[6] = new String("Set Null");
                    break;
                }
                case 2: {
                    this.data[6] = new String("Cascade");
                    break;
                }
                case 3: {
                    this.data[6] = new String("Set Default");
                }
            }
            switch (del_act) {
                case 0: {
                    this.data[7] = new String("No Action");
                    break;
                }
                case 1: {
                    this.data[7] = new String("Set Null");
                    break;
                }
                case 2: {
                    this.data[7] = new String("Cascade");
                    break;
                }
                case 3: {
                    this.data[7] = new String("Set Default");
                }
            }
        }

        public Object getValueAt(int index) {
            if (ForeignKeyList.this.table_name != null) {
                return this.data[index + 2];
            }
            return this.data[index];
        }

        public void setValueAt(Object value, int index) {
            this.data[index] = value;
        }
    }
}

