/*
 * Decompiled with CFR 0.152.
 */
package dbatool.Domain;

import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthorityFactory;
import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.DbaTabbedPane;
import dbatool.tableCell.BooleanRenderer;
import dbatool.tableModel.DBARowInfo;
import dbatool.tableModel.DBAToolAbstractTableModel;
import dbatool.tableModel.DbaTableModel;
import dbaut.DbaObject;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaPanel;
import dbaut.comp.ReflectionAction;
import dbaut.comp.ReflectionListSelection;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;

public class DomainList
extends DbaTabbedPane
implements ComponentPrivilege {
    private DbaTableModel model1 = null;
    private DBAToolAbstractTableModel absModel = null;
    private JTable table1 = null;
    private DbaButton Create_Button;
    private DbaButton Drop_Button;
    private DBAResourceBundle res;

    public DomainList() {
        this.Create_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Create"), 'C', DBAImageResource.getResource(this.getClass(), "/jdbaimages/create.gif"), new ReflectionAction(this, "Create_Button_actionPerformed"));
        this.Drop_Button = new DbaButton(new Dimension(80, 24), DbFrame.frame.res.getString("Drop"), 'D', DBAImageResource.getResource(this.getClass(), "/jdbaimages/drop.gif"), new ReflectionAction(this, "Drop_Button_actionPerformed"));
        this.res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.dbatool.TableRes", LocaleManager.getLocale());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName("DomainsTabbedPane");
        String[] columnNames = null;
        columnNames = DbFrame.conn_DatabaseConnection.isDBTDE() ? new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("Size"), DbFrame.frame.res.getString("Scale"), DbFrame.frame.res.getString("Constraint"), DbFrame.frame.res.getString("Default"), this.res.getString("Default_Attri1"), this.res.getString("Encrypt")} : new String[]{DbFrame.frame.res.getString("Schema_Name_Big"), DbFrame.frame.res.getString("Name"), DbFrame.frame.res.getString("Type"), DbFrame.frame.res.getString("Size"), DbFrame.frame.res.getString("Scale"), DbFrame.frame.res.getString("Constraint"), DbFrame.frame.res.getString("Default"), this.res.getString("Default_Attri1")};
        this.model1 = new DbaTableModel(columnNames);
        this.absModel = new DBAToolAbstractTableModel(this.model1);
        this.table1 = new JTable(this.absModel);
        this.table1.setName("DomainsListTable");
        DbaPanel jPanel1 = new DbaPanel(DbFrame.helpres, "domain.list");
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setName("DomainsButtonPanel");
        this.Create_Button.setName("CreateButton");
        this.Drop_Button.setName("DropButton");
        jPanel1.setLayout(new BorderLayout());
        jScrollPane1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.table1.setSelectionMode(0);
        this.add((Component)jPanel1, DbFrame.frame.res.getTitle("Domain"));
        jPanel1.add((Component)jScrollPane1, "Center");
        jPanel1.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.Create_Button, null);
        jPanel2.add((Component)this.Drop_Button, null);
        jScrollPane1.getViewport().add((Component)this.table1, null);
        this.getDomainList();
        this.table1.setAutoResizeMode(4);
        this.initColumnSizes(this.table1);
        this.absModel.addMouseListenerToHeaderInTable(this.table1);
        this.table1.getSelectionModel().addListSelectionListener(new ReflectionListSelection(this, "table_valueChanged"));
        this.authority = DbaAuthorityFactory.create(this);
        this.authority.authoriseOnce();
        this.grant(false);
    }

    @Override
    public int getComponentType() {
        return 11;
    }

    @Override
    public void grantOnce(boolean enabled) {
        this.Create_Button.setEnabled(enabled);
    }

    @Override
    public void grant(boolean enabled) {
        this.Drop_Button.setEnabled(enabled);
    }

    public void table_valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.grant(false);
        } else {
            int r = this.table1.getSelectedRow();
            Object value = this.model1.getValueAt(r, 0);
            String owner = (String)value;
            this.authority.authorise(owner);
        }
    }

    private void getDomainList() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.model1.removeAll();
            String constraint = null;
            int reserve3 = 0;
            String query = "SELECT DOMAIN_OWNER, DOMAIN_NAME, TYPE_NAME, DATA_LEN,  PRECISION, SCALE, CONSTR, ASCII_DEF, RESERVE3 FROM SYSTEM.SYSDOMAIN";
            stmt = DbFrame.conn_DatabaseConnection.getDbConnection().createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String def = rs.getString(8);
                def = rs.wasNull() ? "" : def;
                constraint = rs.getString(7);
                constraint = rs.wasNull() ? "" : constraint;
                String name = rs.getString(2);
                reserve3 = rs.getInt(9);
                this.model1.addValue(new DBARowInfo(this.getRowInfo(GuiUt.rightTrim(rs.getString(1)), GuiUt.rightTrim(rs.getString(2)), rs.getString(3).trim(), rs.getShort(4), rs.getShort(5), rs.getShort(6), constraint, def, reserve3)));
            }
            rs.close();
            stmt.close();
            DbFrame.frame.setStatusDisc(DbFrame.frame.res.getString("The_number_of_domain") + " " + this.model1.getRowCount());
            this.absModel.fireTableChanged(new TableModelEvent(this.absModel));
        }
        catch (SQLException sqle) {
            DbaObject.close(rs);
            DbaObject.close(stmt);
            GuiUt.showSQLException(this, null, sqle);
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        BooleanRenderer renderer = null;
        int[] sizes = new int[]{80, 80, 80, 50, 50, 160, 120, 60, 60};
        int length = table.getColumnCount();
        for (int i = 0; i < length; ++i) {
            column = table.getColumnModel().getColumn(i);
            column.setPreferredWidth(sizes[i]);
            if (i != 8) continue;
            renderer = new BooleanRenderer();
            column.setCellRenderer(renderer);
        }
    }

    private Object[] getRowInfo(String owner, String name, String type, short size, short precision, short scale, String constraint, String def, int reserve3) {
        Object[] data = new Object[9];
        data[0] = GuiUt.rightTrim(owner);
        data[1] = GuiUt.rightTrim(name);
        data[2] = type;
        data[3] = type.equalsIgnoreCase("BINARY") || type.equalsIgnoreCase("CHAR") || type.equalsIgnoreCase("VARCHAR") || type.equalsIgnoreCase("NCHAR") || type.equalsIgnoreCase("NVARCHAR") ? Short.toString(size) : (type.equalsIgnoreCase("DECIMAL") ? Short.toString(precision) : new String(""));
        data[4] = type.equalsIgnoreCase("decimal") ? Short.toString(scale) : new String("");
        data[5] = constraint.trim();
        data[6] = def.trim();
        if ((reserve3 & 1) > 0) {
            data[7] = (reserve3 & 2) > 0 ? "SYSTEM/ON UPDATE" : "SYSTEM";
        } else if ((reserve3 & 2) > 0) {
            data[7] = "ON UPDATE";
        }
        data[8] = (reserve3 & 8) > 0 ? Boolean.TRUE : Boolean.FALSE;
        return data;
    }

    public void Create_Button_actionPerformed(ActionEvent e) {
        DbFrame.frame.menubar.CreateObjectChoice(9);
        this.getDomainList();
    }

    public void Drop_Button_actionPerformed(ActionEvent e) {
        int row = this.table1.getSelectedRow();
        String name = (String)this.model1.getValueAt(row, 1);
        String str1 = DbFrame.frame.res.getString("Do_you_want_to_drop_domain");
        String str2 = GuiUt.mapStringForProperty(str1, name);
        int[] option = new int[1];
        String[] optionStr = new String[]{"", "RESTRICT", "CASCADE"};
        int reply = GuiUt.showDropOptionsDlg(DbFrame.frame, DbFrame.frame.res.getString("Drop_Domain"), str2 + "?", option);
        if (reply != 0) {
            return;
        }
        String query = "DROP DOMAIN \"" + name + "\" " + optionStr[option[0]];
        boolean result = DatabaseConnection.executeSQL(query);
        if (result) {
            this.getDomainList();
            if (row >= this.model1.getRowCount()) {
                this.table1.clearSelection();
            }
        }
    }
}

