/*
 * Decompiled with CFR 0.152.
 */
package datatransfer;

import datatransfer.dttlib;
import dttwizard.importXML.XmlElement;

public class XmlFile {
    private String fname = null;
    public XmlElement root = null;
    private XmlElement curelm = null;

    public XmlFile(String filename) {
        this.fname = filename;
        try {
            System.loadLibrary("dmdttut");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("java.library.path=" + System.getProperty("java.library.path"));
            System.out.println("error loadlibrary dmdttut =" + e.getMessage());
        }
    }

    public int getFileContent() {
        if (this.fname == null) {
            return -1;
        }
        dttlib lib = new dttlib();
        int rc = lib.getFileContent(this, this.fname.getBytes());
        if (rc != 0) {
            this.root = null;
            this.curelm = null;
        }
        return rc;
    }

    public XmlElement startElement(byte[] name, int type, int quant) {
        XmlElement elm = new XmlElement(new String(name), type, quant, this.curelm, false);
        elm.parent = this.curelm;
        if (this.root == null) {
            this.root = elm;
        }
        if (this.curelm != null) {
            this.curelm.addChild(elm);
        }
        this.curelm = elm;
        return this.curelm;
    }

    public void characterData(byte[] data, int size) {
        if (this.curelm == null) {
            return;
        }
        this.curelm.addData(new String(data, 0, size));
    }

    public void endElement(byte[] name) {
        if (this.curelm != null) {
            this.curelm.trimData();
            this.curelm = this.curelm.parent;
        }
    }

    public void print() {
        if (this.root == null) {
            return;
        }
        this.root.print(0);
    }
}

