/*
 * Decompiled with CFR 0.152.
 */
package datatransfer;

import datatransfer.DataTransferButton;
import datatransfer.DataTransferMenuBar;
import datatransfer.PreferencesXml;
import dbaut.AboutBox;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleChangeEvent;
import dbaut.locale.LocaleChangeListener;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.resource.HelpResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataTransferFrame
extends JFrame
implements LocaleChangeListener {
    private static final long serialVersionUID = -6200609703253482833L;
    public static DataTransferFrame frame = null;
    DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Export.dtt_ExportTextRes", LocaleManager.getLocale());
    DataTransferMenuBar menubar = null;
    String local_address = null;
    String local_ip = null;
    String configfilename = null;
    private DataTransferButton Import_Text_Button = null;
    private DataTransferButton Export_Xml_Button = null;
    private DataTransferButton Export_Text_Button = null;
    private DataTransferButton Import_Xml_Button = null;
    private DataTransferButton Import_ODBC_Button = null;
    private DataTransferButton Import_Json_Button = null;
    private DataTransferButton Export_Json_Button = null;
    public static HelpResourceBundle helpres = new HelpResourceBundle("jdbaproperties.help");
    public static String helpsetName = "JDBA2.hs";
    public static HelpSet mainHS = null;
    public static DefaultHelpBroker mainHB = null;
    public PreferencesXml px = PreferencesXml.getPreferencesXml();

    public DataTransferFrame() {
        try {
            frame = this;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initHelpSet(Component comp) {
        try {
            mainHS = null;
            mainHB = null;
            helpres = new HelpResourceBundle("jdbaproperties.help");
            ClassLoader cl = DataTransferFrame.class.getClassLoader();
            helpsetName = DataTransferFrame.getHelpSetName();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)helpsetName);
            if (url != null) {
                mainHS = new HelpSet(cl, url);
                mainHB = (DefaultHelpBroker)mainHS.createHelpBroker();
                mainHB.enableHelpKey(comp, helpres.getString("home_Datatransfer"), null);
            }
        }
        catch (Exception ex) {
            System.out.println("Help Set " + helpsetName + " not found");
            ex.printStackTrace();
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println("initialization error:");
            ex.getException().printStackTrace();
        }
    }

    private static String getHelpSetName() {
        String s = "JDBA.hs";
        switch (LocaleManager.getHelpFileLanguage()) {
            default: 
        }
        s = "JDBA.hs";
        return s;
    }

    private void jbInit() throws Exception {
        JPanel centerpanel = new JPanel(new GridLayout(4, 2, 0, 0));
        ImageIcon i = DBAImageResource.getResource(this.getClass(), "/dttimages/logo16.gif");
        this.setIconImage(i.getImage());
        DataTransferFrame.initHelpSet(this.getContentPane());
        this.menubar = new DataTransferMenuBar();
        String imagepath = "/dttimages/";
        this.Import_Text_Button = new DataTransferButton(DBAImageResource.getResource(this.getClass(), imagepath + "import_from_text_in.gif"), DBAImageResource.getResource(this.getClass(), imagepath + "import_from_text_out.gif"), this.res.getString("Import_from_text"));
        this.Export_Xml_Button = new DataTransferButton(DBAImageResource.getResource(this.getClass(), imagepath + "export_to_xml_in.gif"), DBAImageResource.getResource(this.getClass(), imagepath + "export_to_xml_out.gif"), this.res.getString("Export_to_XML"));
        this.Export_Text_Button = new DataTransferButton(DBAImageResource.getResource(this.getClass(), imagepath + "export_to_text_in.gif"), DBAImageResource.getResource(this.getClass(), imagepath + "export_to_text_out.gif"), this.res.getString("Export_to_text"));
        this.Import_Xml_Button = new DataTransferButton(DBAImageResource.getResource(this.getClass(), imagepath + "import_from_xml_in.gif"), DBAImageResource.getResource(this.getClass(), imagepath + "import_from_xml_out.gif"), this.res.getString("Import_from_XML"));
        this.Import_ODBC_Button = new DataTransferButton(DBAImageResource.getResource(this.getClass(), imagepath + "import_from_odbc_in.gif"), DBAImageResource.getResource(this.getClass(), imagepath + "import_from_odbc_out.gif"), this.res.getString("Import_from_ODBC"));
        this.Import_Json_Button = new DataTransferButton(DBAImageResource.getResource(this.getClass(), imagepath + "import_from_json_in.gif"), DBAImageResource.getResource(this.getClass(), imagepath + "import_from_json_out.gif"), this.res.getString("Import_from_JSON"));
        this.Export_Json_Button = new DataTransferButton(DBAImageResource.getResource(this.getClass(), imagepath + "export_to_json_in.gif"), DBAImageResource.getResource(this.getClass(), imagepath + "export_to_json_out.gif"), this.res.getString("Export_to_JSON"));
        this.setTitle(this.res.getString("Data_transfer_tool"));
        this.setJMenuBar(this.menubar);
        centerpanel.setBackground(Color.white);
        this.Import_Text_Button.addActionListener(new ReflectionAction(this, "Import_Text_Button_actionPerformed"));
        this.Export_Xml_Button.addActionListener(new ReflectionAction(this, "Export_Xml_Button_actionPerformed"));
        this.Export_Text_Button.addActionListener(new ReflectionAction(this, "Export_Text_Button_actionPerformed"));
        this.Import_Xml_Button.addActionListener(new ReflectionAction(this, "Import_Xml_Button_actionPerformed"));
        this.Import_ODBC_Button.addActionListener(new ReflectionAction(this, "Import_ODBC_Button_actionPerformed"));
        this.Import_Json_Button.addActionListener(new ReflectionAction(this, "Import_Json_Button_actionPerformed"));
        this.Export_Json_Button.addActionListener(new ReflectionAction(this, "Export_Json_Button_actionPerformed"));
        centerpanel.add((Component)this.Import_Text_Button, null);
        centerpanel.add((Component)this.Export_Text_Button, null);
        centerpanel.add((Component)this.Import_Xml_Button, null);
        centerpanel.add((Component)this.Export_Xml_Button, null);
        centerpanel.add((Component)this.Import_Json_Button, null);
        centerpanel.add((Component)this.Export_Json_Button, null);
        centerpanel.add((Component)this.Import_ODBC_Button, null);
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JLabel(DBAImageResource.getResource(this.getClass(), "/dttimages/left.gif")), "West");
        this.getContentPane().add((Component)centerpanel, "Center");
        JdmConfig config = new JdmConfig();
        this.local_address = JdmConfig.localHostName;
        this.configfilename = config.filePath("dmconfig.ini").trim();
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    public void fileExit_actionPerformed(ActionEvent e) {
        try {
            this.px.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    public void setHelpID(Component comp, String id) {
        if (mainHB == null) {
            return;
        }
        String helpid2 = helpres.getString(id);
        try {
            CSH.setHelpIDString((Component)comp, (String)helpid2);
            mainHB.enableHelpKey((Component)this.menubar.Help_Menuitem, helpid2, null);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void enableDialogHelp(Component comp, JButton button, String id, HelpSet hs) {
        if (mainHB == null) {
            DataTransferFrame.initHelpSet(comp);
            if (mainHB == null) {
                return;
            }
        }
        String helpid2 = helpres.getString(id);
        if (comp != null) {
            mainHB.enableHelpKey(comp, helpid2, hs);
        }
        if (button != null) {
            mainHB.enableHelpOnButton((Component)button, helpid2, hs);
        }
    }

    public void helpAbout_actionPerformed(ActionEvent e) {
        AboutBox dlg = null;
        dlg = DataTransferFrame.isWindows() ? new AboutBox((Frame)this, 3) : new AboutBox((Frame)this, "", true, 3);
        GuiUt.setCenterLocation(this, dlg);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.fileExit_actionPerformed(null);
        }
    }

    public static boolean isWindows() {
        String fileseparator = System.getProperty("file.separator");
        return fileseparator.equals("\\");
    }

    public static boolean isWindowsNT() {
        if (DataTransferFrame.isWindows()) {
            String osname = System.getProperty("os.name");
            return osname.equalsIgnoreCase("Windows NT") || osname.equalsIgnoreCase("Windows 2000") || osname.equalsIgnoreCase("Windows XP");
        }
        return false;
    }

    public void Import_Text_Button_actionPerformed(ActionEvent e) {
        this.menubar.Import_Text_Menuitem_actionPerformed(null);
    }

    public void Import_Xml_Button_actionPerformed(ActionEvent e) {
        this.menubar.Import_Xml_Menuitem_actionPerformed(null);
    }

    public void Export_Text_Button_actionPerformed(ActionEvent e) {
        this.menubar.Export_Text_Menuitem_actionPerformed(null);
    }

    public void Export_Xml_Button_actionPerformed(ActionEvent e) {
        this.menubar.Export_Xml_Menuitem_actionPerformed(null);
    }

    public void Import_ODBC_Button_actionPerformed(ActionEvent e) {
        this.menubar.Import_ODBC_Menuitem_actionPerformed(null);
    }

    public void Import_Json_Button_actionPerformed(ActionEvent e) {
        this.menubar.Import_JSON_Menuitem_actionPerformed(e);
    }

    public void Export_Json_Button_actionPerformed(ActionEvent e) {
        this.menubar.Export_JSON_Menuitem_actionPerformed(e);
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = e != null ? DBAResourceBundle.getDBAResourceBundle("dttproperties.Export.dtt_ExportTextRes", e.getLocale()) : DBAResourceBundle.getDBAResourceBundle("dttproperties.Export.dtt_ExportTextRes", LocaleManager.getLocale());
        this.Import_Text_Button.setText(this.res.getString("Import_from_text"));
        this.Export_Xml_Button.setText(this.res.getString("Export_to_XML"));
        this.Export_Text_Button.setText(this.res.getString("Export_to_text"));
        this.Import_Xml_Button.setText(this.res.getString("Import_from_XML"));
        this.Import_ODBC_Button.setText(this.res.getString("Import_from_ODBC"));
        this.Import_Json_Button.setText(this.res.getString("Import_from_JSON"));
        this.Export_Json_Button.setText(this.res.getString("Export_to_JSON"));
        this.setTitle(this.res.getString("Data_transfer"));
        this.menubar.localeChanged(e);
    }
}

