/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.dm.dba.sca.role;

import com.syscom.dm.dba.sca.AbstractDbaAuthority;
import com.syscom.dm.dba.sca.ComponentPrivilege;
import com.syscom.dm.dba.sca.DbaAuthority;
import com.syscom.dm.dba.sca.role.Role;

public class Resource
extends AbstractDbaAuthority
implements Role,
DbaAuthority {
    public Resource(ComponentPrivilege privilege) {
        super(privilege);
        super.setRole(this);
    }

    @Override
    public boolean isAuthorisedOnce(String owner, String name) {
        boolean result = false;
        switch (this.getComponentPrivilege().getComponentType()) {
            case 1: {
                result = true;
                break;
            }
            case 101: {
                result = this.getPrivilege().isOwner(owner);
                break;
            }
            case 201: {
                result = true;
                break;
            }
            case 301: {
                if (this.isSystem(owner)) break;
                result = this.getPrivilege().isOwner(owner) || this.getPrivilege().hasAlterAllPrivilege(owner, name);
                break;
            }
            case 401: 
            case 601: 
            case 701: {
                if (this.isSystem(owner)) break;
                result = this.getPrivilege().isOwner(owner);
                break;
            }
            case 2: {
                result = true;
                break;
            }
            case 102: {
                result = this.getPrivilege().isOwner(owner);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                result = true;
                break;
            }
            case 116: {
                result = this.getPrivilege().isOwner(owner);
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 20: {
                result = true;
                break;
            }
            case 108: {
                result = this.getComponentRole().isAuthorised();
                break;
            }
            case 22: {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean isAuthorised(String owner, String name) {
        boolean result = false;
        switch (this.getComponentPrivilege().getComponentType()) {
            case 1: {
                result = this.getPrivilege().isOwner(owner);
                break;
            }
            case 201: {
                if (this.isSystem(owner)) break;
                result = this.getPrivilege().isOwner(owner) || this.getPrivilege().hasAlterAllPrivilege(owner, name);
                break;
            }
            case 701: {
                if (this.isSystem(owner)) break;
                result = this.getPrivilege().isOwner(owner);
                break;
            }
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 102: 
            case 116: {
                result = this.getPrivilege().isOwner(owner);
                break;
            }
            case 20: {
                result = true;
                break;
            }
            case 10: 
            case 11: {
                result = this.getPrivilege().isOwner(owner);
                break;
            }
            case 22: {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean isResource() {
        return true;
    }
}

