/*
 * Decompiled with CFR 0.152.
 */
package DmEditor;

import DmEditor.MainFrame;
import DmEditor.Preferences.Preferences;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.dbalib;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.util.PlatformUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class NewSectionDlg
extends JDialog {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale());
    private CharField sectionName_TextField = new CharField(128, true);
    private DbaButton ok_Button = new DbaButton();
    private DbaButton cancel_Button = new DbaButton();
    private DbaButton helpButton = new DbaButton();
    private Component comp = null;

    public NewSectionDlg(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.comp = frame;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public NewSectionDlg(Frame frame) {
        super(frame);
        this.setModal(true);
        try {
            this.comp = frame;
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public NewSectionDlg() {
        this((Frame)null, "", false);
    }

    void jbInit() throws Exception {
        this.setName("NewSectionDialog");
        this.sectionName_TextField.setName("SectionNameTextField");
        this.ok_Button.setName("OKButton");
        this.cancel_Button.setName("CancelButton");
        this.helpButton.setName("HelpButton");
        try {
            if (Preferences.mainHB != null) {
                Preferences.mainHB.enableHelpKey((Component)this.getRootPane(), Preferences.helpres.getString("home"), null);
            }
        }
        catch (Exception ex) {
            System.out.println("Error Message is : " + ex.getMessage());
            return;
        }
        catch (ExceptionInInitializerError ex) {
            System.err.println("initialization error:");
            ex.getException().printStackTrace();
        }
        JPanel panel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.setTitle(this.res.getString("New_Database_Section"));
        panel1.setLayout((LayoutManager)new XYLayout(300, 100));
        panel1.setBorder(BorderFactory.createRaisedBevelBorder());
        panel1.setMinimumSize(new Dimension(420, 260));
        panel1.setPreferredSize(new Dimension(300, 100));
        jLabel1.setText(this.res.getString("New_Section_Name_"));
        this.ok_Button.setMnemonic('O');
        this.ok_Button.setText(this.res.getString("Ok"));
        this.ok_Button.addActionListener(new ReflectionAction(this, "ok_Button_actionPerformed"));
        this.cancel_Button.setMnemonic('C');
        this.cancel_Button.setText(this.res.getString("Cancel"));
        this.cancel_Button.addActionListener(new ReflectionAction(this, "cancel_Button_actionPerformed"));
        this.sectionName_TextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    NewSectionDlg.this.sectionName_TextField_keyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                NewSectionDlg.this.sectionName_TextField_keyReleased(e);
            }
        });
        this.helpButton.setText(this.res.getString("Help"));
        this.helpButton.setMnemonic('H');
        this.ok_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        this.cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        this.helpButton.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/help.gif"));
        this.getContentPane().add(panel1);
        if (Preferences.mainHB == null) {
            this.helpButton.setEnabled(false);
        } else {
            this.helpButton.addActionListener((ActionListener)new CSH.DisplayHelpFromSource((HelpBroker)Preferences.mainHB));
        }
        panel1.add((Component)jLabel1, new XYConstraints(24, 7, 130, -1));
        panel1.add((Component)this.sectionName_TextField, new XYConstraints(23, 25, 251, 22));
        panel1.add((Component)this.helpButton, new XYConstraints(211, 62, 80, 20));
        panel1.add((Component)this.cancel_Button, new XYConstraints(129, 62, 80, 20));
        panel1.add((Component)this.ok_Button, new XYConstraints(47, 62, 80, 20));
    }

    public void cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void ok_Button_actionPerformed(ActionEvent e) {
        String s = this.sectionName_TextField.getText();
        if (s.length() == 0) {
            GuiUt.showInformationDlg(this, this.res.getString("Please_enter_new"));
        } else {
            dbalib lib = new dbalib();
            int xy = lib.utchkid(s.getBytes(), s.length());
            if (xy == 1) {
                GuiUt.showErrorDlg(this, this.res.getString("Invalid_Database_Name"), null);
            } else {
                ArrayList<String> dbNameList = JdmConfig.getAllDBNames();
                if (dbNameList != null && !dbNameList.isEmpty()) {
                    for (String dbName : dbNameList) {
                        if (!s.equalsIgnoreCase(dbName)) continue;
                        String s1 = this.res.getString("Database_section_name_cannot_has_the_same_with");
                        String s2 = GuiUt.mapStringForProperty(s1, s, true);
                        GuiUt.showErrorDlg(this, s2, null);
                        return;
                    }
                }
                JdmConfig dmconfig = new JdmConfig();
                dmconfig.create("dmconfig.ini", s.toUpperCase());
                DefaultMutableTreeNode sectionNode = new DefaultMutableTreeNode(s.toUpperCase(), false);
                MainFrame.frame.dmconfigNode.add(sectionNode);
                MainFrame.frame.treeModel.reload(MainFrame.frame.dmconfigNode);
                MainFrame.frame.tree.setSelectionPath(new TreePath(sectionNode.getPath()));
                this.dispose();
            }
        }
    }

    void sectionName_TextField_keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.sectionName_TextField.getText().length() > 0) {
            this.ok_Button_actionPerformed(null);
        }
    }
}

