/*
 * Decompiled with CFR 0.152.
 */
package DmEditor;

import DmEditor.ConfigComponent;
import DmEditor.MainFrame;
import DmEditor.Preferences.Preferences;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.comp.DbaFileChooser;
import dbaut.comp.LockedJFileChooser;
import dbaut.comp.ReflectionAction;
import dbaut.dbalib;
import dbaut.io.FileOperation;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dbaut.textField.CharField;
import dbaut.util.PlatformUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ConfigFilePathField
extends JPanel
implements ConfigComponent {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale());
    CharField File_Path = new CharField(255, true);
    JButton Browse_Button = new JButton();
    boolean isDirectorlyOnly = false;
    public String initStr = null;
    String orderStr = "";
    String shareddir = "";
    String fileseparator = System.getProperty("file.separator");

    public ConfigFilePathField(boolean isDirectoryOnly, String inStr) {
        this.isDirectorlyOnly = isDirectoryOnly;
        this.orderStr = inStr;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ConfigFilePathField(boolean isDirectoryOnly) {
        this(isDirectoryOnly, "");
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.Browse_Button.setBorder(BorderFactory.createRaisedBevelBorder());
        this.Browse_Button.setMargin(new Insets(2, 2, 2, 2));
        this.Browse_Button.setText("...");
        this.Browse_Button.addActionListener(new ReflectionAction(this, "Browse_Button_actionPerformed"));
        this.add((Component)this.File_Path, "Center");
        this.add((Component)this.Browse_Button, "East");
        if (this.orderStr.length() != 0 && this.getInstDir() == null) {
            this.Browse_Button.setEnabled(false);
            this.Browse_Button.setVisible(false);
        }
        this.File_Path.setName("FilePathTextField");
        this.File_Path.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (PlatformUtil.isKeyTypedEnabled()) {
                    this.File_PathKeyReleased(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.File_PathKeyReleased(e);
            }

            private void File_PathKeyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ConfigFilePathField.this.saveFiledText();
                }
            }
        });
        this.File_Path.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ConfigFilePathField.this.saveFiledText();
            }
        });
    }

    public void setText(String text) {
        this.File_Path.setText(text);
    }

    public boolean isEmpty() {
        String txt = this.File_Path.getText();
        return txt == null || txt.trim().length() == 0;
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.File_Path.addKeyListener(listener);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.File_Path.addMouseListener(listener);
    }

    public String getText() {
        String textContent = this.File_Path.getText();
        if (textContent.indexOf(32) >= 0 && !textContent.startsWith("\"") && !textContent.endsWith("\"")) {
            textContent = "\"" + textContent + "\"";
        }
        return textContent;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.File_Path.setEnabled(enable);
        this.Browse_Button.setEnabled(enable);
    }

    @Override
    public void setInitValue(Object value) {
        if (value != null) {
            this.initStr = ((String)value).trim();
            this.File_Path.setText((String)value);
        }
    }

    public int save(JdmConfig config, String keyword) {
        int rc = 0;
        String txt = this.getText().trim();
        rc = txt.length() == 0 ? config.procDelete(keyword, 0) : config.insertPara(keyword, txt, 4096);
        return rc;
    }

    @Override
    public boolean isChanged() {
        String curStr = this.File_Path.getText().trim();
        if (curStr == null) {
            return false;
        }
        return !curStr.equals(this.initStr);
    }

    public String getInstDir() {
        dbalib lib = new dbalib();
        byte[] ba = new byte[255];
        int rc = lib.utInstDir(ba);
        boolean b = true;
        if (rc == 0) {
            return new String(ba).trim();
        }
        return null;
    }

    public void Browse_Button_actionPerformed(ActionEvent e) {
        DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("configproperties.DmEditorRes", LocaleManager.getLocale());
        String curDir = this.orderStr;
        if (curDir == null || curDir.length() == 0) {
            curDir = JdmConfig.getDBDir(Preferences.selectedSection);
        }
        if (curDir == null || curDir.length() == 0) {
            curDir = this.getInstDir();
        }
        if (curDir == null || curDir.length() == 0) {
            curDir = System.getProperty("user.dir");
        }
        if (this.orderStr.length() != 0) {
            File f;
            int state;
            String s = null;
            if (this.orderStr.equalsIgnoreCase("db_order")) {
                s = this.getInstDir() + "shared" + this.fileseparator + "codeorder";
            } else if (this.orderStr.equalsIgnoreCase("db_stpwd")) {
                s = this.getInstDir() + "shared" + this.fileseparator + "stopword";
            }
            LockedJFileChooser chooser = new LockedJFileChooser();
            chooser.setCurrentDirectory(s);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileHidingEnabled(false);
            if (this.isDirectorlyOnly) {
                chooser.setFileSelectionMode(1);
                state = chooser.showDialog(this, res.getString("Select_Path"));
            } else {
                chooser.setFileSelectionMode(0);
                state = chooser.showDialog(this, res.getString("Select_File"));
            }
            if (state == 0 && (f = chooser.getSelectedFile()) != null) {
                this.File_Path.setText(f.getPath());
            }
        } else {
            File f;
            int state;
            DbaFileChooser chooser = new DbaFileChooser();
            String path = this.File_Path.getText();
            if (path != null && path.length() > 0) {
                chooser.setCurrentDirectory(path);
            } else {
                chooser.setCurrentDirectory(curDir);
            }
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileHidingEnabled(false);
            if (this.isDirectorlyOnly) {
                chooser.setFileSelectionMode(1);
                File file = chooser.getCurrentDirectory();
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                chooser.setCurrentDirectory(file);
                state = chooser.showDialog(this, res.getString("Select_Path"));
            } else {
                chooser.setFileSelectionMode(0);
                state = chooser.showDialog(this, res.getString("Select_File"));
            }
            if (state == 0 && (f = chooser.getSelectedFile()) != null) {
                this.File_Path.setText(f.getPath());
            }
        }
    }

    @Override
    public void setToolTipText(String str) {
        super.setToolTipText(str);
        this.File_Path.setToolTipText(str);
    }

    public void saveFiledText() {
        String path = this.File_Path.getText();
        FileOperation.getInstance();
        boolean x_ret = FileOperation.isFilePath(path, this.isDirectorlyOnly);
        if (!x_ret) {
            this.setText(null);
            GuiUt.showErrorDlg(MainFrame.frame, this.res.getString("Error_with_file_path_from_textfield"), null);
        }
    }

    public CharField getFilePath() {
        return this.File_Path;
    }

    public void setFilePath(CharField file_Path) {
        this.File_Path = file_Path;
    }
}

