/*
 * Decompiled with CFR 0.152.
 */
package DmEditor.AllSectionInfo.backup;

import DmEditor.Preferences.Preferences;
import ServerMgr.IntegerFieldEditor;
import ServerMgr.IntegerFieldRenderer;
import ServerMgr.SmFrame;
import dbatool.DbFrame;
import dbatool.tableCell.DBAAbstractCellEditor;
import dbatool.tableCell.PhysicalEditor;
import dbatool.tableCell.PhysicalRenderer;
import dbaut.CommonUt.DbaBkTableModel;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.String_array;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.util.JavaTypeUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class BkDirDlg
extends JDialog {
    public boolean result = false;
    public static final int DB_BKDIR = 0;
    public static final int DB_BKODR = 1;
    private int option = -1;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dbautproperties.dbaut.Res", LocaleManager.getLocale());
    private String_array saBkdir = null;
    private String strBkdir = null;
    private DbaBkTableModel model = new DbaBkTableModel();
    private JTable table = new JTable(this.model);
    private String default_dir = System.getProperty("user.dir");
    private DbaButton OK_Button = new DbaButton(new Dimension(80, 20), this.res.getString("OK"), 'O', DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"), new ReflectionAction(this, "OK_Button_actionPerformed"));
    private DbaButton helpButton = new DbaButton(new Dimension(80, 20), this.res.getString("Help"), 'H', DBAImageResource.getResource(this.getClass(), "/dbautimages/help.gif"), null);
    private DefaultHelpBroker mainHB = null;

    public BkDirDlg(Frame frame, String_array sa, int option) {
        super(frame);
        this.saBkdir = sa;
        this.option = option;
        try {
            this.mainHB = Preferences.mainHB;
            if (this.mainHB == null || Preferences.helpres == null) {
                this.helpButton.setEnabled(false);
            } else {
                this.mainHB.enableHelpKey((Component)this.getRootPane(), Preferences.helpres.getString("jconfigurationtool.backup"), null);
            }
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BkDirDlg(Dialog dlg, String_array sa, int option) {
        super(dlg);
        this.saBkdir = sa;
        this.option = option;
        try {
            this.mainHB = Preferences.mainHB;
            if (this.mainHB == null || Preferences.helpres == null) {
                this.helpButton.setEnabled(false);
            } else {
                this.mainHB.enableHelpKey((Component)this.getRootPane(), Preferences.helpres.getString("jconfigurationtool.backup"), null);
            }
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BkDirDlg(Dialog dlg, String bkdir, int option) {
        super(dlg);
        this.strBkdir = bkdir;
        this.option = option;
        try {
            if (SmFrame.frame != null) {
                SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Runtime_Setting_Backup", null);
            } else if (DbFrame.frame != null) {
                DbFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Runtime_Setting_Backup", null);
            }
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setModal(true);
        this.setSize(new Dimension(350, 450));
        switch (this.option) {
            case 0: {
                this.setTitle(this.res.getString("Backup_Directory_Setting"));
                break;
            }
            case 1: {
                this.setTitle(this.res.getString("Previous_Backup_Directory_Setting"));
            }
        }
        JPanel bottomPanel = new JPanel();
        DbaButton Cancel_Button = new DbaButton(new Dimension(80, 20), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        bottomPanel.add(this.OK_Button);
        bottomPanel.add(Cancel_Button);
        bottomPanel.add(this.helpButton);
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.table);
        this.getContentPane().add((Component)scroll, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (BkDirDlg.this.table.getEditingColumn() < 0 || BkDirDlg.this.table.getEditingRow() < 0) {
                    return;
                }
                if (BkDirDlg.this.table.getCellEditor(BkDirDlg.this.table.getEditingRow(), BkDirDlg.this.table.getEditingColumn()) != null) {
                    BkDirDlg.this.table.getCellEditor().stopCellEditing();
                }
            }
        });
        if (this.mainHB != null) {
            this.helpButton.addActionListener((ActionListener)new CSH.DisplayHelpFromSource((HelpBroker)this.mainHB));
        }
        this.setUpColumns();
        this.initColumnSizes();
        this.initTableContent();
        this.setName("BkDirDlg");
        this.table.setName("BkDirDlgTable");
        this.OK_Button.setName("OKButton");
        Cancel_Button.setName("CancelButton");
    }

    private void initColumnSizes() {
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(this.model.BACKUP_DIRECTORY);
        column.setPreferredWidth(300);
        column = this.table.getColumnModel().getColumn(this.model.SIZE);
        column.setPreferredWidth(40);
    }

    private void initTableContent() {
        String[] strArrayBkdir = null;
        if (this.saBkdir != null) {
            strArrayBkdir = this.saBkdir.content;
        } else if (this.strBkdir != null) {
            strArrayBkdir = JdmConfig.getBkdirStringArray(this.strBkdir);
        }
        List<String> tempList = Arrays.asList(strArrayBkdir);
        List<String> stringList = this.filterEmptyInteger(tempList);
        if (stringList != null && stringList.size() != 0) {
            String path = "";
            for (int i = 0; i < stringList.size(); i += 2) {
                path = stringList.get(i);
                if (path.length() == 0) continue;
                this.model.setValueAt(path, i / 2, 0);
                try {
                    int size = Integer.parseInt(stringList.get(i + 1));
                    this.model.setValueAt(size, i / 2, 1);
                    continue;
                }
                catch (Exception e) {
                    this.model.setValueAt("", i / 2, 1);
                }
            }
        }
    }

    private List<String> filterEmptyInteger(List<String> strArray) {
        ArrayList<String> list = new ArrayList<String>();
        if (strArray != null && strArray.size() > 0) {
            for (int i = 0; i < strArray.size(); ++i) {
                if (strArray.get(i).length() == 0) continue;
                boolean bool = JavaTypeUtil.isInteger(strArray.get(i));
                if (bool) {
                    list.remove(list.size() - 1);
                    list.add(strArray.get(i));
                    continue;
                }
                list.add(strArray.get(i));
                list.add("");
            }
        }
        return list;
    }

    public String getBackUpPath() {
        String bk_dir = "";
        String s1 = "";
        String s2 = "";
        for (int i = 0; i < this.model.MAX; ++i) {
            s1 = this.model.getValueAt(i, 0).toString().trim();
            s2 = this.model.getValueAt(i, 1).toString().trim();
            if (s1.length() <= 0 && s2.length() <= 0) continue;
            if (s1.indexOf(32) >= 0 && !s1.startsWith("\"") && !s1.endsWith("\"")) {
                s1 = "\"" + s1 + "\"";
            }
            bk_dir = bk_dir + s1 + " " + s2 + " ";
        }
        bk_dir = bk_dir.trim();
        return bk_dir;
    }

    public String[] getContent4SA() {
        Vector<String> v = new Vector<String>();
        String s1 = "";
        String s2 = "";
        for (int i = 0; i < this.model.MAX; ++i) {
            s1 = this.model.getValueAt(i, 0).toString().trim();
            s2 = this.model.getValueAt(i, 1).toString().trim();
            if (s1.length() <= 0 && s2.length() <= 0) continue;
            if (s1.length() > 0) {
                v.add(s1);
            }
            if (s2.length() < 0) continue;
            v.add(s2);
        }
        String[] sa = new String[v.size()];
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            sa[i] = v.elementAt(i).toString().trim();
        }
        return sa;
    }

    private void setUpColumns() {
        TableColumn column = this.table.getColumnModel().getColumn(this.model.BACKUP_DIRECTORY);
        JComponent renderer = null;
        DBAAbstractCellEditor editor = null;
        int dmBackupLen = 255 - "dmBackup.his".length();
        if (this.saBkdir != null && this.saBkdir.content != null && this.saBkdir.content.length > 0 && this.saBkdir.content[0] != null && this.saBkdir.content[0].length() > 0) {
            renderer = new PhysicalRenderer((Component)this, this.saBkdir.content[0], dmBackupLen);
            editor = new PhysicalEditor(this, this.saBkdir.content[0], dmBackupLen);
        } else {
            renderer = new PhysicalRenderer((Component)this, this.default_dir, dmBackupLen);
            editor = new PhysicalEditor(this, this.default_dir, dmBackupLen);
        }
        column.setCellRenderer((TableCellRenderer)((Object)renderer));
        column.setCellEditor(editor);
        column = this.table.getColumnModel().getColumn(this.model.SIZE);
        renderer = new IntegerFieldRenderer();
        editor = new IntegerFieldEditor();
        column.setCellRenderer((TableCellRenderer)((Object)renderer));
        column.setCellEditor(editor);
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        this.table.editingStopped(null);
        String newBkdir = this.getBackUpPath();
        if (!JdmConfig.isLegalBkdir(newBkdir)) {
            System.out.println("illegal backup path: " + newBkdir);
            GuiUt.showErrorDlg(this, this.res.getString("Please_input_correct_backup_directory_format"), null);
            return;
        }
        this.result = true;
        this.setVisible(false);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.result = false;
        this.setVisible(false);
    }
}

