/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.msgpack.MessagePackable;
import org.msgpack.MessageTypeException;
import org.msgpack.template.AnyTemplate;
import org.msgpack.template.BigDecimalTemplate;
import org.msgpack.template.BigIntegerTemplate;
import org.msgpack.template.BooleanArrayTemplate;
import org.msgpack.template.BooleanTemplate;
import org.msgpack.template.ByteArrayTemplate;
import org.msgpack.template.ByteBufferTemplate;
import org.msgpack.template.ByteTemplate;
import org.msgpack.template.CharacterTemplate;
import org.msgpack.template.CollectionTemplate;
import org.msgpack.template.DateTemplate;
import org.msgpack.template.DoubleArrayTemplate;
import org.msgpack.template.DoubleTemplate;
import org.msgpack.template.FieldList;
import org.msgpack.template.FloatArrayTemplate;
import org.msgpack.template.FloatTemplate;
import org.msgpack.template.GenericCollectionTemplate;
import org.msgpack.template.GenericMapTemplate;
import org.msgpack.template.GenericTemplate;
import org.msgpack.template.IntegerArrayTemplate;
import org.msgpack.template.IntegerTemplate;
import org.msgpack.template.ListTemplate;
import org.msgpack.template.LongArrayTemplate;
import org.msgpack.template.LongTemplate;
import org.msgpack.template.MapTemplate;
import org.msgpack.template.MessagePackableTemplate;
import org.msgpack.template.SetTemplate;
import org.msgpack.template.ShortArrayTemplate;
import org.msgpack.template.ShortTemplate;
import org.msgpack.template.StringTemplate;
import org.msgpack.template.Template;
import org.msgpack.template.TemplateReference;
import org.msgpack.template.ValueTemplate;
import org.msgpack.template.builder.TemplateBuilder;
import org.msgpack.template.builder.TemplateBuilderChain;
import org.msgpack.type.Value;

public class TemplateRegistry {
    private TemplateRegistry b = null;
    private TemplateBuilderChain c;
    Map<Type, Template<Type>> a;
    private Map<Type, GenericTemplate> d;

    private TemplateRegistry() {
        this.b = null;
        this.c = this.createTemplateBuilderChain();
        this.d = new HashMap<Type, GenericTemplate>();
        this.a = new HashMap<Type, Template<Type>>();
        TemplateRegistry templateRegistry = this;
        templateRegistry.register(Boolean.TYPE, BooleanTemplate.getInstance());
        templateRegistry.register((Type)((Object)Boolean.class), BooleanTemplate.getInstance());
        templateRegistry.register(Byte.TYPE, ByteTemplate.getInstance());
        templateRegistry.register((Type)((Object)Byte.class), ByteTemplate.getInstance());
        templateRegistry.register(Short.TYPE, ShortTemplate.getInstance());
        templateRegistry.register((Type)((Object)Short.class), ShortTemplate.getInstance());
        templateRegistry.register(Integer.TYPE, IntegerTemplate.getInstance());
        templateRegistry.register((Type)((Object)Integer.class), IntegerTemplate.getInstance());
        templateRegistry.register(Long.TYPE, LongTemplate.getInstance());
        templateRegistry.register((Type)((Object)Long.class), LongTemplate.getInstance());
        templateRegistry.register(Float.TYPE, FloatTemplate.getInstance());
        templateRegistry.register((Type)((Object)Float.class), FloatTemplate.getInstance());
        templateRegistry.register(Double.TYPE, DoubleTemplate.getInstance());
        templateRegistry.register((Type)((Object)Double.class), DoubleTemplate.getInstance());
        templateRegistry.register((Type)((Object)BigInteger.class), BigIntegerTemplate.getInstance());
        templateRegistry.register(Character.TYPE, CharacterTemplate.getInstance());
        templateRegistry.register((Type)((Object)Character.class), CharacterTemplate.getInstance());
        templateRegistry.register((Type)((Object)boolean[].class), BooleanArrayTemplate.getInstance());
        templateRegistry.register((Type)((Object)short[].class), ShortArrayTemplate.getInstance());
        templateRegistry.register((Type)((Object)int[].class), IntegerArrayTemplate.getInstance());
        templateRegistry.register((Type)((Object)long[].class), LongArrayTemplate.getInstance());
        templateRegistry.register((Type)((Object)float[].class), FloatArrayTemplate.getInstance());
        templateRegistry.register((Type)((Object)double[].class), DoubleArrayTemplate.getInstance());
        templateRegistry.register((Type)((Object)String.class), StringTemplate.getInstance());
        templateRegistry.register((Type)((Object)byte[].class), ByteArrayTemplate.getInstance());
        templateRegistry.register((Type)((Object)ByteBuffer.class), ByteBufferTemplate.getInstance());
        templateRegistry.register((Type)((Object)Value.class), ValueTemplate.getInstance());
        templateRegistry.register((Type)((Object)BigDecimal.class), BigDecimalTemplate.getInstance());
        templateRegistry.register((Type)((Object)Date.class), DateTemplate.getInstance());
        templateRegistry.registerTemplatesWhichRefersRegistry();
        this.a = Collections.unmodifiableMap(this.a);
    }

    /*
     * WARNING - void declaration
     */
    public TemplateRegistry(TemplateRegistry registry) {
        void var1_1;
        this.b = registry != null ? var1_1 : new TemplateRegistry();
        this.c = this.createTemplateBuilderChain();
        this.a = new HashMap<Type, Template<Type>>();
        this.d = new HashMap<Type, GenericTemplate>();
        this.registerTemplatesWhichRefersRegistry();
    }

    protected TemplateBuilderChain createTemplateBuilderChain() {
        return new TemplateBuilderChain(this);
    }

    /*
     * WARNING - void declaration
     */
    public void setClassLoader(ClassLoader cl) {
        void var1_1;
        this.c = new TemplateBuilderChain(this, (ClassLoader)var1_1);
    }

    protected void registerTemplatesWhichRefersRegistry() {
        AnyTemplate anyTemplate = new AnyTemplate(this);
        this.register((Type)((Object)List.class), new ListTemplate(anyTemplate));
        this.register((Type)((Object)Set.class), new SetTemplate(anyTemplate));
        this.register((Type)((Object)Collection.class), new CollectionTemplate(anyTemplate));
        AnyTemplate anyTemplate2 = anyTemplate;
        this.register((Type)((Object)Map.class), new MapTemplate(anyTemplate2, anyTemplate2));
        this.registerGeneric((Type)((Object)List.class), new GenericCollectionTemplate(this, ListTemplate.class));
        this.registerGeneric((Type)((Object)Set.class), new GenericCollectionTemplate(this, SetTemplate.class));
        this.registerGeneric((Type)((Object)Collection.class), new GenericCollectionTemplate(this, CollectionTemplate.class));
        this.registerGeneric((Type)((Object)Map.class), new GenericMapTemplate(this, MapTemplate.class));
    }

    /*
     * WARNING - void declaration
     */
    public void register(Class<?> targetClass) {
        void var1_1;
        this.a(null, (Class)var1_1, false, null);
    }

    /*
     * WARNING - void declaration
     */
    public void register(Class<?> targetClass, FieldList flist) {
        void var2_2;
        void var1_1;
        if (flist == null) {
            throw new NullPointerException("FieldList object is null");
        }
        this.a(null, (Class)var1_1, false, (FieldList)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void register(Type targetType, Template tmpl) {
        void var2_2;
        void var1_1;
        if (tmpl == null) {
            throw new NullPointerException("Template object is null");
        }
        if (targetType instanceof ParameterizedType) {
            this.a.put(((ParameterizedType)targetType).getRawType(), tmpl);
            return;
        }
        this.a.put((Type)var1_1, (Template<Type>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void registerGeneric(Type targetType, GenericTemplate tmpl) {
        void var2_2;
        void var1_1;
        if (targetType instanceof ParameterizedType) {
            this.d.put(((ParameterizedType)targetType).getRawType(), tmpl);
            return;
        }
        this.d.put((Type)var1_1, (GenericTemplate)var2_2);
    }

    public synchronized boolean unregister(Type targetType) {
        Template<Type> template;
        return (template = this.a.remove(template)) != null;
    }

    public synchronized void unregister() {
        this.a.clear();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Template lookup(Type targetType) {
        Template<MessagePackable> template;
        Type type;
        if (targetType instanceof ParameterizedType) {
            type = (ParameterizedType)targetType;
            template = this.a((ParameterizedType)type);
            if (template != null) {
                return template;
            }
            targetType = type.getRawType();
        }
        if ((template = this.a(targetType)) != null) {
            return template;
        }
        template = this.b(targetType);
        if (template != null) {
            return template;
        }
        if (targetType instanceof WildcardType || targetType instanceof TypeVariable) {
            template = new AnyTemplate<Type>(this);
            this.register(targetType, template);
            return template;
        }
        type = (Class)targetType;
        if (MessagePackable.class.isAssignableFrom((Class<?>)type)) {
            template = new MessagePackableTemplate((Class<?>)type);
            this.register(type, template);
            return template;
        }
        if (((Class)type).isInterface()) {
            void var1_1;
            template = new AnyTemplate(this);
            this.register((Type)var1_1, template);
            return template;
        }
        template = this.a((Class)type);
        if (template != null) {
            return template;
        }
        template = this.b((Class)type);
        if (template != null) {
            return template;
        }
        template = this.c((Class)type);
        if (template != null) {
            return template;
        }
        template = this.d((Class)type);
        if (template != null) {
            return template;
        }
        throw new MessageTypeException("Cannot find template for " + type + " class.  Try to add @Message annotation to the class or call MessagePack.register(Type).");
    }

    private Template<Type> a(ParameterizedType parameterizedType) {
        Template<Type> template = this.b(parameterizedType);
        if (template != null) {
            return template;
        }
        try {
            template = this.b.b(parameterizedType);
            if (template != null) {
                return template;
            }
        }
        catch (NullPointerException nullPointerException) {}
        template = this.c(parameterizedType);
        if (template != null) {
            return template;
        }
        template = this.d(parameterizedType);
        if (template != null) {
            return template;
        }
        return null;
    }

    private Template b(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getRawType();
        return this.a(parameterizedType, type);
    }

    private Template a(ParameterizedType typeArray, Type object) {
        if ((object = this.d.get(object)) == null) {
            return null;
        }
        typeArray = typeArray.getActualTypeArguments();
        Template[] templateArray = new Template[typeArray.length];
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            templateArray[i2] = this.lookup(typeArray[i2]);
        }
        return object.build(templateArray);
    }

    private <T> Template<T> c(ParameterizedType parameterizedType) {
        Class<?>[] classArray = parameterizedType.getRawType();
        Template template = null;
        try {
            Class<?>[] classArray2 = ((Class)classArray).getInterfaces();
            classArray = classArray2;
            classArray = classArray2;
            int n2 = classArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz = classArray[i2];
                template = this.a(parameterizedType, clazz);
                if (template == null) continue;
                return template;
            }
        }
        catch (ClassCastException classCastException) {}
        return template;
    }

    private <T> Template<T> d(ParameterizedType parameterizedType) {
        Class clazz = parameterizedType.getRawType();
        Template template = null;
        try {
            if (clazz == null) {
                return null;
            }
            for (clazz = ((Class)clazz).getSuperclass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                template = this.a(parameterizedType, clazz);
                if (template == null) continue;
                this.register(parameterizedType, template);
                return template;
            }
        }
        catch (ClassCastException classCastException) {}
        return template;
    }

    private Template<Type> a(Type type) {
        if (!(type instanceof GenericArrayType)) {
            return null;
        }
        Template template = this.a((GenericArrayType)(type = (GenericArrayType)type));
        if (template != null) {
            return template;
        }
        try {
            template = this.b.a((GenericArrayType)type);
            if (template != null) {
                return template;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    private Template a(GenericArrayType clazz) {
        String string = "" + clazz;
        int n2 = string.split("\\[").length - 1;
        if (n2 <= 0) {
            throw new MessageTypeException(String.format("fatal error: type=", string));
        }
        if (n2 > 1) {
            throw new UnsupportedOperationException(String.format("Not implemented template generation of %s", string));
        }
        clazz = "" + clazz.getGenericComponentType();
        string = clazz;
        boolean bl = ((String)((Object)clazz)).equals("byte") || string.equals("short") || string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("boolean") || string.equals("char");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append('[');
        }
        if (!bl) {
            stringBuffer.append('L');
            Class<?> clazz2 = clazz;
            stringBuffer.append(((String)((Object)clazz2)).substring(6));
            stringBuffer.append(';');
        } else {
            String string2;
            Class<?> clazz3 = clazz;
            if (((String)((Object)clazz3)).equals("byte")) {
                string2 = "B";
            } else if (((String)((Object)clazz3)).equals("short")) {
                string2 = "S";
            } else if (((String)((Object)clazz3)).equals("int")) {
                string2 = "I";
            } else if (((String)((Object)clazz3)).equals("long")) {
                string2 = "J";
            } else if (((String)((Object)clazz3)).equals("float")) {
                string2 = "F";
            } else if (((String)((Object)clazz3)).equals("double")) {
                string2 = "D";
            } else if (((String)((Object)clazz3)).equals("boolean")) {
                string2 = "Z";
            } else if (((String)((Object)clazz3)).equals("char")) {
                string2 = "C";
            } else {
                throw new MessageTypeException(String.format("fatal error: type=%s", clazz3));
            }
            stringBuffer.append(string2);
        }
        String string3 = stringBuffer.toString();
        try {
            clazz = Thread.currentThread().getContextClassLoader();
            if (clazz != null && (clazz = ((ClassLoader)((Object)clazz)).loadClass(string3)) != null) {
                return this.a(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        try {
            clazz = this.getClass().getClassLoader();
            if (clazz != null && (clazz = ((ClassLoader)((Object)clazz)).loadClass(string3)) != null) {
                return this.a(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        try {
            clazz = Class.forName(string3);
            if (clazz != null) {
                return this.a(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        throw new MessageTypeException(String.format("cannot find template of %s", string3));
    }

    private Template<Type> b(Type type) {
        Template<Type> template = this.a.get(type);
        if (template != null) {
            return template;
        }
        try {
            template = this.b.b(type);
        }
        catch (NullPointerException nullPointerException) {}
        return template;
    }

    private <T> Template<T> a(Class<T> clazz) {
        TemplateBuilder templateBuilder = this.c.select(clazz, true);
        Template template = null;
        if (templateBuilder != null) {
            template = this.c.getForceBuilder().loadTemplate(clazz);
            if (template != null) {
                this.register(clazz, template);
                return template;
            }
            template = this.a(templateBuilder, clazz, true, null);
        }
        return template;
    }

    private <T> Template<T> b(Class<T> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        Template<Type> template = null;
        for (Class<?> clazz2 : classArray) {
            template = this.a.get(clazz2);
            if (template != null) {
                this.register(clazz, template);
                return template;
            }
            try {
                template = this.b.b((Type)clazz2);
                if (template == null) continue;
                this.register(clazz, template);
                return template;
            }
            catch (NullPointerException nullPointerException) {}
        }
        return template;
    }

    private <T> Template<T> c(Class<T> clazz) {
        Class<T> clazz2;
        Template<Type> template = null;
        if (clazz2 != null) {
            for (clazz2 = clazz.getSuperclass(); clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                template = this.a.get(clazz2);
                if (template != null) {
                    this.register(clazz, template);
                    return template;
                }
                try {
                    template = this.b.b((Type)clazz2);
                    if (template != null) {
                        this.register(clazz, template);
                        return template;
                    }
                    continue;
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        return template;
    }

    private <T> Template<T> d(Class<T> clazz) {
        Class<T> clazz2;
        Template<Object> template = null;
        if (clazz2 != null) {
            for (clazz2 = clazz.getSuperclass(); clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                template = this.b(clazz2);
                if (template != null) {
                    this.register(clazz, template);
                    return template;
                }
                try {
                    template = this.b.b((Type)clazz2);
                    if (template != null) {
                        this.register(clazz, template);
                        return template;
                    }
                    continue;
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        return template;
    }

    private synchronized Template a(TemplateBuilder object, Class clazz, boolean bl, FieldList fieldList) {
        Template template = null;
        Template<Type> template2 = null;
        try {
            if (this.a.containsKey(clazz)) {
                template2 = this.a.get(clazz);
            }
            template = new TemplateReference(this, clazz);
            this.a.put(clazz, template);
            if (object == null) {
                object = this.c.select(clazz, bl);
            }
            template = fieldList != null ? object.buildTemplate(clazz, fieldList) : object.buildTemplate(clazz);
            object = template;
            return object;
        }
        catch (Exception exception) {
            if (template2 != null) {
                this.a.put(clazz, template2);
            } else {
                this.a.remove(clazz);
            }
            template = null;
            if (exception instanceof MessageTypeException) {
                throw (MessageTypeException)exception;
            }
            throw new MessageTypeException(exception);
        }
        finally {
            if (template != null) {
                this.a.put(clazz, template);
            }
        }
    }
}

