/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineBicubic2OpImage;
import com.sun.media.jai.opimage.AffineBicubicOpImage;
import com.sun.media.jai.opimage.AffineBilinearOpImage;
import com.sun.media.jai.opimage.AffineGeneralOpImage;
import com.sun.media.jai.opimage.AffineNearestBinaryOpImage;
import com.sun.media.jai.opimage.AffineNearestOpImage;
import com.sun.media.jai.opimage.CopyOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.ScaleBicubicOpImage;
import com.sun.media.jai.opimage.ScaleBilinearBinaryOpImage;
import com.sun.media.jai.opimage.ScaleBilinearOpImage;
import com.sun.media.jai.opimage.ScaleGeneralOpImage;
import com.sun.media.jai.opimage.ScaleNearestBinaryOpImage;
import com.sun.media.jai.opimage.ScaleNearestOpImage;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.TileCache;

public class AffineCRIF
extends CRIFImpl {
    private static final float TOLERANCE = 0.01f;

    public AffineCRIF() {
        super("affine");
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        Object object = parameterBlock.getObjectParameter(0);
        AffineTransform affineTransform = (AffineTransform)object;
        Object object2 = parameterBlock.getObjectParameter(1);
        Interpolation interpolation = (Interpolation)object2;
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3);
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (dArray[0] == 1.0 && dArray[3] == 1.0 && dArray[2] == 0.0 && dArray[1] == 0.0 && dArray[4] == 0.0 && dArray[5] == 0.0) {
            return new CopyOpImage(renderedImage, renderingHints, imageLayout);
        }
        if (dArray[0] == 1.0 && dArray[3] == 1.0 && dArray[2] == 0.0 && dArray[1] == 0.0 && Math.abs(dArray[4] - (double)((int)dArray[4])) < (double)0.01f && Math.abs(dArray[5] - (double)((int)dArray[5])) < (double)0.01f) {
            return new TranslateIntOpImage(renderedImage, (int)dArray[4], (int)dArray[5]);
        }
        if (dArray[0] > 0.0 && dArray[2] == 0.0 && dArray[1] == 0.0 && dArray[3] > 0.0) {
            if (interpolation instanceof InterpolationNearest) {
                if (bl) {
                    return new ScaleNearestBinaryOpImage(renderedImage, borderExtender, renderingHints, imageLayout, (float)dArray[0], (float)dArray[3], (float)dArray[4], (float)dArray[5], interpolation);
                }
                return new ScaleNearestOpImage(renderedImage, borderExtender, renderingHints, imageLayout, (float)dArray[0], (float)dArray[3], (float)dArray[4], (float)dArray[5], interpolation);
            }
            if (interpolation instanceof InterpolationBilinear) {
                if (bl) {
                    return new ScaleBilinearBinaryOpImage(renderedImage, borderExtender, renderingHints, imageLayout, (float)dArray[0], (float)dArray[3], (float)dArray[4], (float)dArray[5], interpolation);
                }
                return new ScaleBilinearOpImage(renderedImage, borderExtender, renderingHints, imageLayout, (float)dArray[0], (float)dArray[3], (float)dArray[4], (float)dArray[5], interpolation);
            }
            if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
                return new ScaleBicubicOpImage(renderedImage, borderExtender, renderingHints, imageLayout, (float)dArray[0], (float)dArray[3], (float)dArray[4], (float)dArray[5], interpolation);
            }
            return new ScaleGeneralOpImage(renderedImage, borderExtender, renderingHints, imageLayout, (float)dArray[0], (float)dArray[3], (float)dArray[4], (float)dArray[5], interpolation);
        }
        if (interpolation instanceof InterpolationNearest) {
            if (bl) {
                return new AffineNearestBinaryOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
            }
            return new AffineNearestOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new AffineBilinearOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic) {
            return new AffineBicubicOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic2) {
            return new AffineBicubic2OpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        return new AffineGeneralOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
    }

    public RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        return parameterBlock.getRenderedSource(0);
    }

    public RenderContext mapRenderContext(int n, RenderContext renderContext, ParameterBlock parameterBlock, RenderableImage renderableImage) {
        Object object = parameterBlock.getObjectParameter(0);
        AffineTransform affineTransform = (AffineTransform)object;
        RenderContext renderContext2 = (RenderContext)renderContext.clone();
        AffineTransform affineTransform2 = renderContext2.getTransform();
        affineTransform2.concatenate(affineTransform);
        renderContext2.setTransform(affineTransform2);
        return renderContext2;
    }

    public Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        float f;
        float f2;
        RenderableImage renderableImage = parameterBlock.getRenderableSource(0);
        Object object = parameterBlock.getObjectParameter(0);
        AffineTransform affineTransform = (AffineTransform)object;
        Object object2 = parameterBlock.getObjectParameter(1);
        Interpolation interpolation = (Interpolation)object2;
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        if (dArray[0] == 1.0 && dArray[3] == 1.0 && dArray[2] == 0.0 && dArray[1] == 0.0 && dArray[4] == 0.0 && dArray[5] == 0.0) {
            return new Rectangle2D.Float(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
        }
        if (dArray[0] == 1.0 && dArray[3] == 1.0 && dArray[2] == 0.0 && dArray[1] == 0.0 && Math.abs(dArray[4] - (double)((int)dArray[4])) < (double)0.01f && Math.abs(dArray[5] - (double)((int)dArray[5])) < (double)0.01f) {
            return new Rectangle2D.Float(renderableImage.getMinX() + (float)dArray[4], renderableImage.getMinY() + (float)dArray[5], renderableImage.getWidth(), renderableImage.getHeight());
        }
        if (dArray[0] > 0.0 && dArray[2] == 0.0 && dArray[1] == 0.0 && dArray[3] > 0.0) {
            float f3 = renderableImage.getMinX();
            float f4 = renderableImage.getMinY();
            float f5 = renderableImage.getWidth();
            float f6 = renderableImage.getHeight();
            float f7 = f3 * (float)dArray[0] + (float)dArray[4];
            float f8 = f4 * (float)dArray[3] + (float)dArray[5];
            float f9 = f5 * (float)dArray[0];
            float f10 = f6 * (float)dArray[3];
            return new Rectangle2D.Float(f7, f8, f9, f10);
        }
        float f11 = renderableImage.getMinX();
        float f12 = renderableImage.getMinY();
        float f13 = renderableImage.getWidth();
        float f14 = renderableImage.getHeight();
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f11, f12), new Point2D.Float(f11 + f13, f12), new Point2D.Float(f11 + f13, f12 + f14), new Point2D.Float(f11, f12 + f14)};
        affineTransform.transform(point2DArray, 0, point2DArray, 0, 4);
        float f15 = Float.MAX_VALUE;
        float f16 = Float.MAX_VALUE;
        float f17 = -3.4028235E38f;
        float f18 = -3.4028235E38f;
        int n = 0;
        while (n < 4) {
            f2 = (float)point2DArray[n].getX();
            f = (float)point2DArray[n].getY();
            f15 = Math.min(f15, f2);
            f16 = Math.min(f16, f);
            f17 = Math.max(f17, f2);
            f18 = Math.max(f18, f);
            ++n;
        }
        f2 = f17 - f15;
        f = f18 - f16;
        return new Rectangle2D.Float(f15, f16, f2, f);
    }
}

