/*
 * Decompiled with CFR 0.152.
 */
package dbmaster.sql;

import dbmaster.sql.JdbcOdbc;
import dbmaster.sql.JdbcOdbcClassLoader;
import dbmaster.sql.JdbcOdbcXid;
import dbmaster.sql.ODBCDef;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

class JdbcOdbcAPI
extends JdbcOdbc {
    protected boolean fgDBrollback = false;
    private Calendar calendar = Calendar.getInstance();
    public long[] SQLFunc_t = new long[95];
    private ResourceBundle rb = null;
    private String errlcode = "en";

    public JdbcOdbcAPI() {
        this.trace("new Odbc API object");
    }

    public long jdbcAllocEnv(long[] lArray, int n, long[] lArray2, boolean bl) throws SQLException {
        int n2 = 0;
        long[] lArray3 = new long[]{0L};
        if (this.needTrace) {
            this.trace("API.jdbcAllocEnv");
        }
        if ((n2 = this.sqlAllocHandleEnv(1, 0L, lArray3, this.SQLFunc_t, n, lArray2)) != 0) {
            if (n2 == -1000) {
                if (bl) {
                    throw new SQLException("cannot connect to database in java SP");
                }
                throw new SQLException("fail to load " + ODBCDef.getProductName() + " client library");
            }
            if (n2 == -1001) {
                throw new SQLException("fail to load " + ODBCDef.getProductName() + " udf library");
            }
            if (n2 == -1002) {
                throw new SQLException("fail to load " + ODBCDef.getProductName() + " library for server");
            }
            throw new SQLException("fail to allocate a environment");
        }
        if (System.getProperty("java.vm.version").charAt(0) == '1' && System.getProperty("java.vm.version").charAt(2) == '2') {
            String string = new String("temp");
            ODBCDef.DM_UNICODE = new String("UnicodeLittle");
            try {
                byte[] byArray = string.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        } else {
            ODBCDef.DM_UNICODE = new String("UTF-16LE");
        }
        return lArray3[0];
    }

    public void jdbcFreeEnv(long l) throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcFreeEnv");
        }
        n = this.sqlFreeHandle(1, l, this.SQLFunc_t[78]);
        this.checkError(n, 1, l);
    }

    public long jdbcAllocConnect(long l) throws SQLException {
        int n = 0;
        long[] lArray = new long[]{0L};
        if (this.needTrace) {
            this.trace("API.jdbcAllocConnect");
        }
        n = this.sqlAllocHandle(2, l, lArray, this.SQLFunc_t[73]);
        this.checkError(n, 1, l);
        return lArray[0];
    }

    public void jdbcFreeConnect(long l) throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcFreeConnect");
        }
        n = this.sqlFreeHandle(2, l, this.SQLFunc_t[78]);
        this.checkError(n, 2, l);
    }

    public long jdbcAllocStmt(long l) throws SQLException {
        int n = 0;
        long[] lArray = new long[]{0L};
        if (this.needTrace) {
            this.trace("API.jdbcAllocStmt");
        }
        n = this.sqlAllocHandle(3, l, lArray, this.SQLFunc_t[73]);
        this.checkError(n, 2, l);
        return lArray[0];
    }

    public void jdbcFreeStmt(long l, int n) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcFreeStmt");
        }
        n2 = n == 1 ? this.sqlFreeHandle(3, l, this.SQLFunc_t[78]) : this.sqlFreeStmt(l, n, this.SQLFunc_t[16]);
        this.checkError(n2, 3, l);
    }

    public void jdbcConnect(long l, String string, String string2, String string3) throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcConnect");
        }
        byte[] byArray = JdbcOdbc.convert(string);
        byte[] byArray2 = JdbcOdbc.convert(string2);
        byte[] byArray3 = JdbcOdbc.convert(string3);
        n = this.sqlConnect(l, byArray, byArray2, byArray3, this.SQLFunc_t[7]);
        this.checkError(n, 2, l);
    }

    public void jdbcDisconnect(long l) throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcDisconnect");
        }
        n = this.sqlDisconnect(l, this.SQLFunc_t[9]);
        this.checkError(n, 2, l);
    }

    public void jdbcSetEnvAttr(long l, int n, int n2) throws SQLException {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcSetEnvAttr (" + n + ", " + n2 + ")");
        }
        n3 = this.sqlSetEnvAttr(l, n, n2, this.SQLFunc_t[91]);
        this.checkError(n3, 1, l);
    }

    public int jdbcGetEnvAttr(long l, int n) throws SQLException {
        int n2 = 0;
        int[] nArray = new int[]{0};
        if (this.needTrace) {
            this.trace("API.jdbcGetEnvAttr (" + n + ")");
        }
        n2 = this.sqlGetEnvAttr(l, n, nArray, this.SQLFunc_t[84]);
        this.checkError(n2, 1, l);
        return nArray[0];
    }

    public long jdbcGetEnvAttrLong(long l, int n) throws SQLException {
        int n2 = 0;
        long[] lArray = new long[]{0L};
        if (this.needTrace) {
            this.trace("API.jdbcGetEnvAttrLong (" + n + ")");
        }
        n2 = this.sqlGetEnvAttrLong(l, n, lArray, this.SQLFunc_t[84]);
        this.checkError(n2, 1, l);
        return lArray[0];
    }

    public void jdbcSetConnectAttrInt(long l, int n, int n2) throws SQLException {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcSetConnectAttrInt (" + n + ", " + n2 + ")");
        }
        n3 = this.sqlSetConnectAttrInt(l, n, n2, this.SQLFunc_t[88]);
        this.checkError(n3, 2, l);
    }

    public void jdbcSetConnectAttrInt(long l, int n, int n2, int n3) throws SQLException {
        int n4 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcSetConnectAttrInt (" + n + ", " + n2 + ", " + n3 + ")");
        }
        n4 = this.sqlSetConnectAttrInt2(l, n, n2, n3, this.SQLFunc_t[88]);
        this.checkError(n4, 2, l);
    }

    public void jdbcSetConnectAttrString(long l, int n, String string) throws SQLException {
        if (this.needTrace) {
            this.trace("API.jdbcSetConnectAttrString (" + n + ", " + string + ")");
        }
        int n2 = 0;
        byte[] byArray = JdbcOdbc.convert(string);
        n2 = this.sqlSetConnectAttrString(l, n, byArray, this.SQLFunc_t[88]);
        this.checkError(n2, 2, l);
    }

    public void jdbcSetConnectAttrBytes(long l, int n, byte[] byArray) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcSetConnectAttrString (" + n + ", " + byArray + ")");
        }
        n2 = this.sqlSetConnectAttrString(l, n, byArray, this.SQLFunc_t[88]);
        this.checkError(n2, 2, l);
    }

    public int jdbcGetConnectAttrInt(long l, int n) throws SQLException {
        int n2 = 0;
        int[] nArray = new int[]{0};
        if (this.needTrace) {
            this.trace("API.jdbcGetConnectAttrInt (" + n + ")");
        }
        n2 = this.sqlGetConnectAttrInt(l, n, nArray, this.SQLFunc_t[79]);
        this.checkError(n2, 2, l);
        return nArray[0];
    }

    public int jdbcGetConnectAttrInt(long l, int n, int[] nArray) throws SQLException {
        int n2 = 0;
        int[] nArray2 = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetConnectAttrInt (" + n + ")");
        }
        n2 = this.sqlGetConnectAttrInt2(l, n, nArray2, nArray, this.SQLFunc_t[79]);
        this.checkError(n2, 2, l);
        return nArray2[0];
    }

    public String jdbcGetConnectAttrString(long l, int n) throws SQLException {
        String string;
        int n2 = 0;
        byte[] byArray = new byte[512];
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetConnectAttrString (" + n + ")");
        }
        n2 = this.sqlGetConnectAttrString(l, n, byArray, nArray, this.SQLFunc_t[79]);
        this.checkError(n2, 2, l);
        try {
            string = new String(byArray, 0, nArray[0], ODBCDef.DM_UNICODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("encoding unsupported");
        }
        return string;
    }

    public byte[] jdbcGetConnectAttrBytes(long l, int n) throws SQLException {
        int n2 = 0;
        byte[] byArray = new byte[2048];
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetConnectAttrBytes (" + n + ")");
        }
        n2 = this.sqlGetConnectAttrString(l, n, byArray, nArray, this.SQLFunc_t[79]);
        this.checkError(n2, 2, l);
        byte[] byArray2 = new byte[nArray[0]];
        int n3 = 0;
        while (n3 < nArray[0]) {
            byArray2[n3] = byArray[n3];
            ++n3;
        }
        return byArray2;
    }

    public void jdbcSetStmtAttrInt(long l, int n, int n2) throws SQLException {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcSetStmtAttrInt (" + n + ", " + n2 + ")");
        }
        n3 = this.sqlSetStmtAttrInt(l, n, n2, this.SQLFunc_t[92]);
        this.checkError(n3, 3, l);
    }

    public void jdbcSetStmtAttrString(long l, int n, String string) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcSetStmtAttrString (" + n + ", " + string + ")");
        }
        byte[] byArray = JdbcOdbc.convert(string);
        n2 = this.sqlSetStmtAttrString(l, n, byArray, this.SQLFunc_t[92]);
        this.checkError(n2, 3, l);
    }

    public void jdbcSetStmtAttrBytes(long l, int n, byte[] byArray) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcSetStmtAttrBytes (" + n + ", " + byArray + ")");
        }
        n2 = this.sqlSetStmtAttrString(l, n, byArray, this.SQLFunc_t[92]);
        this.checkError(n2, 3, l);
    }

    public int jdbcGetStmtAttrInt(long l, int n) throws SQLException {
        int n2 = 0;
        int[] nArray = new int[]{0};
        if (this.needTrace) {
            this.trace("API.jdbcGetStmtAttrInt (" + n + ")");
        }
        n2 = this.sqlGetStmtAttrInt(l, n, nArray, this.SQLFunc_t[86]);
        this.checkError(n2, 3, l);
        return nArray[0];
    }

    public long jdbcGetStmtAttrLong(long l, int n) throws SQLException {
        int n2 = 0;
        long[] lArray = new long[]{0L};
        if (this.needTrace) {
            this.trace("API.jdbcGetStmtAttrLong (" + n + ")");
        }
        n2 = this.sqlGetStmtAttrLong(l, n, lArray, this.SQLFunc_t[86]);
        this.checkError(n2, 3, l);
        return lArray[0];
    }

    public String jdbcGetStmtAttrString(long l, int n) throws SQLException {
        String string;
        int n2 = 0;
        byte[] byArray = new byte[512];
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetStmtAttrString (" + n + ")");
        }
        n2 = this.sqlGetStmtAttrString(l, n, byArray, nArray, this.SQLFunc_t[86]);
        this.checkError(n2, 3, l);
        try {
            string = new String(byArray, ODBCDef.DM_UNICODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("encoding unsupported");
        }
        return string;
    }

    public byte[] jdbcGetStmtAttrBytes(long l, int n) throws SQLException {
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[2048];
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetStmtAttrBytes (" + n + ")");
        }
        nArray[0] = byArray.length;
        if (n == 1105) {
            n2 = this.sqlGetStmtAttrInt(l, 1106, nArray, this.SQLFunc_t[86]);
            if (nArray[0] > byArray.length) {
                byArray = new byte[nArray[0]];
            }
        }
        n2 = this.sqlGetStmtAttrString(l, n, byArray, nArray, this.SQLFunc_t[86]);
        this.checkError(n2, 3, l);
        byte[] byArray2 = new byte[nArray[0]];
        n3 = 0;
        while (n3 < nArray[0]) {
            byArray2[n3] = byArray[n3];
            ++n3;
        }
        return byArray2;
    }

    public void jdbcTransact(long l, long l2, int n) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcTransact");
        }
        n2 = this.sqlTransact(l, l2, n, this.SQLFunc_t[23]);
        this.checkError(n2, 2, l2);
    }

    public void jdbcPrepare(long l, String string) throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcPrepare");
        }
        byte[] byArray = JdbcOdbc.convert(string);
        n = this.sqlPrepare(l, byArray, this.SQLFunc_t[19]);
        this.checkError(n, 3, l);
    }

    public void jdbcExecDirect(long l, String string) throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcExecDirect");
        }
        byte[] byArray = JdbcOdbc.convert(string);
        n = this.sqlExecDirect(l, byArray, this.SQLFunc_t[11]);
        this.checkError(n, 3, l);
    }

    public boolean jdbcExecute(long l) throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcExecute");
        }
        if ((n = this.sqlExecute(l, this.SQLFunc_t[12])) == 99) {
            return true;
        }
        this.checkError(n, 3, l);
        return false;
    }

    public int jdbcNumParams(long l) throws SQLException {
        int n = 0;
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcNumParams");
        }
        n = this.sqlNumParams(l, nArray, this.SQLFunc_t[63]);
        this.checkError(n, 3, l);
        return nArray[0];
    }

    public void jdbcBindInParameterNull(long l, int n, int n2, long[] lArray, long[] lArray2) throws SQLException {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterNull (" + n + ", " + n2 + ")");
        }
        lArray[0] = -1L;
        n3 = this.sqlBindInParameterNull(l, n, n2, lArray, lArray2, this.SQLFunc_t[58], this.SQLFunc_t[72]);
        this.checkError(n3, 3, l);
    }

    public void jdbcBindInParameterString(long l, int n, int n2, byte[] byArray, byte[] byArray2, long[] lArray, long[] lArray2) throws SQLException {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterString (" + n + ", " + n2 + ", " + byArray + ")");
        }
        n3 = this.sqlBindInParameterString(l, n, n2, byArray, byArray2, lArray, lArray2, this.SQLFunc_t[58], this.SQLFunc_t[72]);
        this.checkError(n3, 3, l);
    }

    public void jdbcBindInParameterBinary(long l, int n, int n2, byte[] byArray, byte[] byArray2, long[] lArray, long[] lArray2) throws SQLException {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterBinary (" + n + ", " + n2 + ", " + byArray + ")");
        }
        n3 = this.sqlBindInParameterBinary(l, n, n2, byArray, byArray2, lArray, lArray2, this.SQLFunc_t[58], this.SQLFunc_t[72]);
        this.checkError(n3, 3, l);
    }

    public void jdbcBindInParameterInt(long l, int n, int n2, int n3, byte[] byArray, long[] lArray) throws SQLException {
        int n4 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterInt (" + n + ", " + n2 + ", " + n3 + ")");
        }
        n4 = this.sqlBindInParameterInt(l, n, n2, n3, byArray, lArray, this.SQLFunc_t[58], this.SQLFunc_t[72]);
        this.checkError(n4, 3, l);
    }

    public void jdbcBindInParameterLong(long l, int n, int n2, long l2, byte[] byArray, long[] lArray) throws SQLException {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterLong (" + n + ", " + n2 + ", " + l2 + ")");
        }
        n3 = this.sqlBindInParameterLong(l, n, n2, l2, byArray, lArray, this.SQLFunc_t[58], this.SQLFunc_t[72]);
        this.checkError(n3, 3, l);
    }

    public void jdbcBindInParameterFloat(long l, int n, int n2, float f, byte[] byArray, long[] lArray) throws SQLException {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterFloat (" + n + ", " + n2 + ", " + f + ")");
        }
        n3 = this.sqlBindInParameterFloat(l, n, n2, f, byArray, lArray, this.SQLFunc_t[58], this.SQLFunc_t[72]);
        this.checkError(n3, 3, l);
    }

    public void jdbcBindInParameterDouble(long l, int n, double d, byte[] byArray, long[] lArray) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterDouble (" + n + ", " + d + ")");
        }
        n2 = this.sqlBindInParameterDouble(l, n, d, byArray, lArray, this.SQLFunc_t[58], this.SQLFunc_t[72]);
        this.checkError(n2, 3, l);
    }

    public void jdbcBindInParameterDate(long l, int n, Date date, byte[] byArray, long[] lArray) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterDate (" + n + ", " + date + ")");
        }
        this.calendar.setTime(date);
        n2 = this.sqlBindInParameterDate(l, n, this.calendar.get(1), this.calendar.get(2) + 1, this.calendar.get(5), byArray, lArray, this.SQLFunc_t[58], this.SQLFunc_t[72]);
        this.checkError(n2, 3, l);
    }

    public void jdbcBindInParameterTime(long l, int n, Time time, byte[] byArray, long[] lArray) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterTime (" + n + ", " + time + ")");
        }
        this.calendar.setTime(time);
        n2 = this.sqlBindInParameterTime(l, n, this.calendar.get(11), this.calendar.get(12), this.calendar.get(13), byArray, lArray, this.SQLFunc_t[58], this.SQLFunc_t[72]);
        this.checkError(n2, 3, l);
    }

    public void jdbcBindInParameterTimestamp(long l, int n, Timestamp timestamp, byte[] byArray, long[] lArray) throws SQLException {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterTimestamp (" + n + ", " + timestamp + ")");
        }
        this.calendar.setTime(timestamp);
        n2 = this.sqlBindInParameterTimestamp(l, n, this.calendar.get(1), this.calendar.get(2) + 1, this.calendar.get(5), this.calendar.get(11), this.calendar.get(12), this.calendar.get(13), timestamp.getNanos(), byArray, lArray, this.SQLFunc_t[58], this.SQLFunc_t[72]);
        this.checkError(n2, 3, l);
    }

    public void jdbcBindInParameterDefault(long l, int n, int n2, byte[] byArray, long[] lArray, long[] lArray2) throws SQLException {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterDefault(" + n + ", " + n2 + ")");
        }
        n3 = this.sqlBindInParameterDefault(l, n, n2, byArray, lArray, lArray2, this.SQLFunc_t[72]);
        this.checkError(n3, 3, l);
    }

    public int jdbcNumResultCol(long l) throws SQLException {
        int n = 0;
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcNumResultCol");
        }
        n = this.sqlNumResultCol(l, nArray, this.SQLFunc_t[18]);
        this.checkError(n, 3, l);
        return nArray[0];
    }

    public long jdbcRowCount(long l) throws SQLException {
        int n = 0;
        long[] lArray = new long[1];
        if (this.needTrace) {
            this.trace("API.jdbcRowCount");
        }
        n = this.sqlRowCount(l, lArray, this.SQLFunc_t[20]);
        this.checkError(n, 3, l);
        return lArray[0];
    }

    public void jdbcCancel(long l) throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcCancel");
        }
        n = this.sqlCancel(l, this.SQLFunc_t[5]);
        this.checkError(n, 3, l);
    }

    public void jdbcSetCursorName(long l, String string) throws SQLException {
        if (this.needTrace) {
            this.trace("API.jdbcSetCursorName (" + string + ")");
        }
        int n = 0;
        byte[] byArray = JdbcOdbc.convert(string);
        n = this.sqlSetCursorName(l, byArray, this.SQLFunc_t[21]);
        this.checkError(n, 3, l);
    }

    public int jdbcGetParamPrec(long l, int n) throws SQLException {
        int n2 = 0;
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetParamPrec (" + n + ")");
        }
        n2 = this.sqlGetParamPrec(l, n, nArray, this.SQLFunc_t[58]);
        this.checkError(n2, 3, l);
        return nArray[0];
    }

    public int jdbcGetParamType(long l, int n) throws SQLException {
        int n2 = 0;
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetParamPrec (" + n + ")");
        }
        n2 = this.sqlGetParamType(l, n, nArray, this.SQLFunc_t[58]);
        this.checkError(n2, 3, l);
        return nArray[0];
    }

    public void jdbcBindOutParameter(long l, int n, int n2, int n3, byte[] byArray, long[] lArray, long[] lArray2) throws SQLException {
        int n4 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindOutParameter (" + n + ", " + n3 + ")");
        }
        n4 = this.sqlBindOutParameter(l, n, n2, n3, byArray, lArray, lArray2, this.SQLFunc_t[72]);
        this.checkError(n4, 3, l);
    }

    public void jdbcBindInOutParameter(long l, int n, int n2, int n3, byte[] byArray, long[] lArray, long[] lArray2) throws SQLException {
        int n4 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInOutParameter (" + n + ", " + n3 + ")");
        }
        n4 = this.sqlBindInOutParameter(l, n, n2, n3, byArray, lArray, lArray2, this.SQLFunc_t[72]);
        this.checkError(n4, 3, l);
    }

    public void jdbcBindInOutParameterNull(long l, int n, int n2, int n3, byte[] byArray, long[] lArray, long[] lArray2) throws SQLException {
        int n4 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInOutParameterNull (" + n + ", " + n3 + ")");
        }
        n4 = this.sqlBindInOutParameterNull(l, n, n2, n3, byArray, lArray, lArray2, this.SQLFunc_t[72]);
        this.checkError(n4, 3, l);
    }

    public long jdbcGetParameterInd(long l, int n, long l2) throws SQLException {
        int n2 = 0;
        long[] lArray = new long[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetParameterInd (" + n + ")");
        }
        n2 = this.sqlGetParameterInd(l, n, l2, lArray);
        this.checkError(n2, 3, l);
        return lArray[0];
    }

    public byte[] jdbcGetParameterDatabuf(long l, int n, int n2, long l2) throws SQLException {
        int n3 = 0;
        byte[] byArray = new byte[n2];
        if (this.needTrace) {
            this.trace("API.jdbcGetParameterDatabuf (" + n + ")");
        }
        n3 = this.sqlGetParameterDatabuf(l, n, l2, byArray, n2);
        this.checkError(n3, 3, l);
        return byArray;
    }

    public Date jdbcGetParameterDate(long l, int n, long l2) throws SQLException {
        byte[] byArray = new byte[11];
        if (this.needTrace) {
            this.trace("API.jdbcGetParameterDate (" + n + ")");
        }
        this.sqlGetParameterDate(l, n, l2, byArray);
        return Date.valueOf(new String(byArray).trim());
    }

    public Time jdbcGetParameterTime(long l, int n, long l2) throws SQLException {
        byte[] byArray = new byte[9];
        if (this.needTrace) {
            this.trace("API.jdbcGetParameterTime (" + n + ")");
        }
        this.sqlGetParameterTime(l, n, l2, byArray);
        return Time.valueOf(new String(byArray).trim());
    }

    public Timestamp jdbcGetParameterTimestamp(long l, int n, long l2) throws SQLException {
        byte[] byArray = new byte[30];
        if (this.needTrace) {
            this.trace("API.jdbcGetParameterTimestamp (" + n + ")");
        }
        this.sqlGetParameterTimestamp(l, n, l2, byArray);
        return Timestamp.valueOf(new String(byArray).trim());
    }

    public void jdbcBindInParameterAtexec(long l, int n, int n2, int n3, byte[] byArray, long[] lArray, long[] lArray2) throws SQLException {
        int n4 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindInParameterAtexec (" + n + ", " + n2 + ")");
        }
        n4 = this.sqlBindInParameterAtexec(l, n, n2, n3, byArray, lArray, lArray2, this.SQLFunc_t[72]);
        this.checkError(n4, 3, l);
    }

    public int jdbcParamData(long l) throws SQLException {
        int n = 0;
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcParamData");
        }
        if ((n = this.sqlParamData(l, nArray, this.SQLFunc_t[48])) == 99) {
            return nArray[0];
        }
        this.checkError(n, 3, l);
        return 0;
    }

    public void jdbcPutData(long l, byte[] byArray, long l2) throws SQLException {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcPutData (" + byArray + ", " + l2 + ")");
        }
        n = this.sqlPutData(l, byArray, l2, this.SQLFunc_t[49]);
        this.checkError(n, 3, l);
    }

    public int jdbcGetInfoShort(long l, int n) throws SQLException {
        int n2 = 0;
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetInfoShort(" + n + ")");
        }
        n2 = this.sqlGetInfoShort(l, n, nArray, this.SQLFunc_t[45]);
        this.checkError(n2, 2, l);
        return nArray[0];
    }

    public int jdbcGetInfoInt(long l, int n) throws SQLException {
        int n2 = 0;
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetInfoInt(" + n + ")");
        }
        n2 = this.sqlGetInfoInt(l, n, nArray, this.SQLFunc_t[45]);
        this.checkError(n2, 2, l);
        return nArray[0];
    }

    public String jdbcGetInfoStr(long l, int n) throws SQLException {
        String string;
        int n2 = 0;
        byte[] byArray = new byte[512];
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetInfoStr(" + n + ")");
        }
        n2 = this.sqlGetInfoStr(l, n, byArray, 512, nArray, this.SQLFunc_t[45]);
        this.checkError(n2, 2, l);
        try {
            string = new String(byArray, 0, nArray[0], ODBCDef.DM_UNICODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("encoding unsupported");
        }
        return string;
    }

    public void jdbcProcedures(long l, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (this.needTrace) {
            this.trace("API.jdbcProcedures(" + string + "," + string2 + "," + string3 + ")");
        }
        int n = 0;
        byte[] byArray = JdbcOdbc.convert(string);
        byte[] byArray2 = JdbcOdbc.convert(string2);
        byte[] byArray3 = JdbcOdbc.convert(string3);
        n = this.sqlProcedures(l, byArray, byArray != null ? byArray.length / 2 : 0, byArray2, byArray2 != null ? byArray2.length / 2 : 0, byArray3, byArray3 != null ? byArray3.length / 2 : 0, this.SQLFunc_t[67]);
        this.checkError(n, 3, l);
    }

    public void jdbcProcedureColumns(long l, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (this.needTrace) {
            this.trace("API.jdbcProcedureColumns(" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        int n = 0;
        byte[] byArray = JdbcOdbc.convert(string);
        byte[] byArray2 = JdbcOdbc.convert(string2);
        byte[] byArray3 = JdbcOdbc.convert(string3);
        byte[] byArray4 = JdbcOdbc.convert(string4);
        n = this.sqlProcedureColumns(l, byArray, byArray != null ? byArray.length / 2 : 0, byArray2, byArray2 != null ? byArray2.length / 2 : 0, byArray3, byArray3 != null ? byArray3.length / 2 : 0, byArray4, byArray4 != null ? byArray4.length / 2 : 0, this.SQLFunc_t[66]);
        this.checkError(n, 3, l);
    }

    public void jdbcTables(long l, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (this.needTrace) {
            this.trace("API.jdbcTables(" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        int n = 0;
        byte[] byArray = JdbcOdbc.convert(string);
        byte[] byArray2 = JdbcOdbc.convert(string2);
        byte[] byArray3 = JdbcOdbc.convert(string3);
        byte[] byArray4 = JdbcOdbc.convert(string4);
        n = this.sqlTables(l, byArray, byArray != null ? byArray.length / 2 : -1, byArray2, byArray2 != null ? byArray2.length / 2 : -1, byArray3, byArray3 != null ? byArray3.length / 2 : -1, byArray4, byArray4 != null ? byArray4.length / 2 : -1, this.SQLFunc_t[54]);
        this.checkError(n, 3, l);
    }

    public void jdbcColumns(long l, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        int n = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (this.needTrace) {
            this.trace("API.jdbcColumns(" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        if (string != null) {
            try {
                byArray = string.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string2 != null) {
            try {
                byArray2 = string2.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string3 != null) {
            try {
                byArray3 = string3.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string4 != null) {
            try {
                byArray4 = string4.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        n = this.sqlColumns(l, byArray, byArray != null ? byArray.length / 2 : 0, byArray2, byArray2 != null ? byArray2.length / 2 : 0, byArray3, byArray3 != null ? byArray3.length / 2 : 0, byArray4, byArray4 != null ? byArray4.length / 2 : 0, this.SQLFunc_t[40]);
        this.checkError(n, 3, l);
    }

    public void jdbcSpecialColumns(long l, int n, String string, String string2, String string3, int n2, boolean bl) throws SQLException, SQLWarning {
        int n3 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (this.needTrace) {
            this.trace("API.jdbcSpecialColumns(" + string + "," + string2 + "," + string3 + "," + n2 + "," + bl + ")");
        }
        if (string != null) {
            try {
                byArray = string.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string2 != null) {
            try {
                byArray2 = string2.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string3 != null) {
            try {
                byArray3 = string3.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        int n4 = bl ? 1 : 0;
        n3 = this.sqlSpecialColumns(l, n, byArray, byArray != null ? byArray.length / 2 : 0, byArray2, byArray2 != null ? byArray2.length / 2 : 0, byArray3, byArray3 != null ? byArray3.length / 2 : 0, n2, n4, this.SQLFunc_t[52]);
        this.checkError(n3, 3, l);
    }

    public void jdbcPrimaryKeys(long l, String string, String string2, String string3) throws SQLException, SQLWarning {
        int n = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (this.needTrace) {
            this.trace("API.jdbcPrimaryKeys(" + string + "," + string2 + "," + string3 + ")");
        }
        if (string != null) {
            try {
                byArray = string.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string2 != null) {
            try {
                byArray2 = string2.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string3 != null) {
            try {
                byArray3 = string3.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        n = this.sqlPrimaryKeys(l, byArray, byArray != null ? byArray.length / 2 : 0, byArray2, byArray2 != null ? byArray2.length / 2 : 0, byArray3, byArray3 != null ? byArray3.length / 2 : 0, this.SQLFunc_t[65]);
        this.checkError(n, 3, l);
    }

    public void jdbcForeignKeys(long l, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException, SQLWarning {
        int n = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        if (this.needTrace) {
            this.trace("API.jdbcForeignKeys(" + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + ")");
        }
        if (string != null) {
            try {
                byArray = string.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string2 != null) {
            try {
                byArray2 = string2.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string3 != null) {
            try {
                byArray3 = string3.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string4 != null) {
            try {
                byArray4 = string4.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string5 != null) {
            try {
                byArray5 = string5.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        if (string6 != null) {
            try {
                byArray6 = string6.getBytes(ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
        }
        n = this.sqlForeignKeys(l, byArray, byArray != null ? byArray.length / 2 : 0, byArray2, byArray2 != null ? byArray2.length / 2 : 0, byArray3, byArray3 != null ? byArray3.length / 2 : 0, byArray4, byArray4 != null ? byArray4.length / 2 : 0, byArray5, byArray5 != null ? byArray5.length / 2 : 0, byArray6, byArray6 != null ? byArray6.length / 2 : 0, this.SQLFunc_t[60]);
        this.checkError(n, 3, l);
    }

    public void jdbcGetTypeInfo(long l, int n) throws SQLException, SQLWarning {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcTypeInfo(" + n + ")");
        }
        n2 = this.sqlGetTypeInfo(l, n, this.SQLFunc_t[47]);
        this.checkError(n2, 3, l);
    }

    public void jdbcStatistics(long l, String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException, SQLWarning {
        if (this.needTrace) {
            this.trace("API.jdbcStatistics(" + string + "," + string2 + "," + string3 + "," + bl + "," + bl2 + ")");
        }
        int n = 0;
        byte[] byArray = JdbcOdbc.convert(string);
        byte[] byArray2 = JdbcOdbc.convert(string2);
        byte[] byArray3 = JdbcOdbc.convert(string3);
        int n2 = bl ? 0 : 1;
        int n3 = bl2 ? 0 : 1;
        n = this.sqlStatistics(l, byArray, byArray != null ? byArray.length / 2 : 0, byArray2, byArray2 != null ? byArray2.length / 2 : 0, byArray3, byArray3 != null ? byArray3.length / 2 : 0, n2, n3, this.SQLFunc_t[53]);
        this.checkError(n, 3, l);
    }

    public int jdbcColAttributeInt(long l, int n, int n2) throws SQLException, SQLWarning {
        int n3 = 0;
        long[] lArray = new long[1];
        if (this.needTrace) {
            this.trace("API.jdbcColAttributeInt(" + n + "," + n2 + ")");
        }
        n3 = this.sqlColAttributeLong(l, n, n2, lArray, this.SQLFunc_t[6]);
        this.checkError(n3, 3, l);
        return (int)lArray[0];
    }

    public String jdbcColAttributeStr(long l, int n, int n2) throws SQLException, SQLWarning {
        String string;
        int n3 = 0;
        byte[] byArray = new byte[512];
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcColAttributeStr(" + n + "," + n2 + ")");
        }
        n3 = this.sqlColAttributeStr(l, n, n2, byArray, 512, nArray, this.SQLFunc_t[6]);
        this.checkError(n3, 3, l);
        try {
            string = new String(byArray, 0, nArray[0], ODBCDef.DM_UNICODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("encoding unsupported");
        }
        return string;
    }

    public boolean jdbcFetch(long l) throws SQLException, SQLWarning {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcFetch()");
        }
        if ((n = this.sqlFetch(l, this.SQLFunc_t[13])) == 100) {
            return false;
        }
        this.checkError(n, 3, l);
        return true;
    }

    public String jdbcGetDataAscii(long l, int n, int n2) throws SQLException, SQLWarning {
        long[] lArray;
        byte[] byArray;
        int n3;
        if (this.needTrace) {
            this.trace("API.jdbcGetDataAscii(" + n + "," + n2 + ")");
        }
        if ((n3 = this.sqlGetDataStr(l, n, 1, byArray = new byte[n2], n2, lArray = new long[1], this.SQLFunc_t[43])) != 0 && n3 != 1) {
            this.checkError(n3, 3, l);
        }
        if (lArray[0] == -1L) {
            return null;
        }
        return new String(byArray, 0, (int)lArray[0]);
    }

    public String jdbcGetDataStr(long l, int n, int n2, byte[] byArray, long[] lArray) throws SQLException, SQLWarning {
        int n3;
        if (this.needTrace) {
            this.trace("API.jdbcGetDataStr(" + n + "," + n2 + ")");
        }
        if ((n3 = this.sqlGetDataStr(l, n, -8, byArray, n2, lArray, this.SQLFunc_t[43])) != 0 && n3 != 1) {
            this.checkError(n3, 3, l);
        }
        if (lArray[0] == -1L) {
            return null;
        }
        try {
            return new String(byArray, 0, (int)lArray[0], ODBCDef.DM_UNICODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("encoding unsupported");
        }
    }

    public int jdbcGetDataInt(long l, int n, int[] nArray, long[] lArray) throws SQLException, SQLWarning {
        if (this.needTrace) {
            this.trace("API.jdbcGetDataInt(" + n + ")");
        }
        int n2 = this.sqlGetDataInt(l, n, nArray, lArray, this.SQLFunc_t[43]);
        this.checkError(n2, 3, l);
        if (lArray[0] == -1L) {
            lArray[0] = 0L;
            return 0;
        }
        return nArray[0];
    }

    public long jdbcGetDataLong(long l, int n, long[] lArray, long[] lArray2) throws SQLException, SQLWarning {
        if (this.needTrace) {
            this.trace("API.jdbcGetDataLong(" + n + ")");
        }
        int n2 = this.sqlGetDataLong(l, n, lArray, lArray2, this.SQLFunc_t[43]);
        this.checkError(n2, 3, l);
        if (lArray2[0] == -1L) {
            lArray2[0] = 0L;
            return 0L;
        }
        return lArray[0];
    }

    public double jdbcGetDataDouble(long l, int n, double[] dArray, long[] lArray) throws SQLException, SQLWarning {
        if (this.needTrace) {
            this.trace("API.jdbcGetDataDouble(" + n + ")");
        }
        int n2 = this.sqlGetDataDouble(l, n, dArray, lArray, this.SQLFunc_t[43]);
        this.checkError(n2, 3, l);
        if (lArray[0] == -1L) {
            lArray[0] = 0L;
            return 0.0;
        }
        return dArray[0];
    }

    public byte[] jdbcGetDataBinary(long l, int n, int n2, byte[] byArray, long[] lArray) throws SQLException, SQLWarning {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcGetDataBinary(" + n + "," + n2 + ")");
        }
        if ((n3 = this.sqlGetDataStr(l, n, -2, byArray, n2, lArray, this.SQLFunc_t[43])) != 0 && n3 != 1) {
            this.checkError(n3, 3, l);
        }
        if (lArray[0] == -1L) {
            return null;
        }
        if (lArray[0] == (long)n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[(int)lArray[0]];
        System.arraycopy(byArray, 0, byArray2, 0, (int)lArray[0]);
        return byArray2;
    }

    public String jdbcGetDataStringDateTime(long l, int n, byte[] byArray, long[] lArray) throws SQLException, SQLWarning {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcGetDataStringTime(" + n + ")");
        }
        n2 = this.sqlGetDataStr(l, n, 1, byArray, 512, lArray, this.SQLFunc_t[43]);
        this.checkError(n2, 3, l);
        if (lArray[0] == -1L) {
            return null;
        }
        return new String(byArray, 0, (int)lArray[0]);
    }

    public String jdbcGetCursorName(long l) throws SQLException, SQLWarning {
        String string;
        int n = 0;
        byte[] byArray = new byte[512];
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetCursorName()");
        }
        n = this.sqlGetCursorName(l, byArray, 512, nArray, this.SQLFunc_t[17]);
        this.checkError(n, 3, l);
        if (nArray[0] == -1) {
            return null;
        }
        try {
            string = new String(byArray, 0, nArray[0], ODBCDef.DM_UNICODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("encoding unsupported");
        }
        return string;
    }

    public int jdbcNumResultCols(long l) throws SQLException, SQLWarning {
        int n = 0;
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcNumResultCols()");
        }
        n = this.sqlNumResultCols(l, nArray, this.SQLFunc_t[18]);
        this.checkError(n, 3, l);
        return nArray[0];
    }

    public boolean jdbcFetchScroll(long l, int n, long l2) throws SQLException, SQLWarning {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcFetchScroll(" + n + "," + l2 + ")");
        }
        if ((n2 = this.sqlFetchScroll(l, n, l2, this.SQLFunc_t[93])) == 100) {
            return false;
        }
        this.checkError(n2, 3, l);
        return true;
    }

    public boolean jdbcSetPos(long l, int n, int n2) throws SQLException, SQLWarning {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcSetPos(" + n + "," + n2 + ")");
        }
        if ((n3 = this.sqlSetPos(l, n, n2, 0, this.SQLFunc_t[68])) == 99) {
            return true;
        }
        this.checkError(n3, 3, l);
        return false;
    }

    public boolean jdbcBulkOperations(long l, int n) throws SQLException, SQLWarning {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBulkOperations(" + n + ")");
        }
        if ((n2 = this.sqlBulkOperations(l, n, this.SQLFunc_t[24])) == 99) {
            return true;
        }
        this.checkError(n2, 3, l);
        return false;
    }

    public void jdbcBindColInt(long l, int n, int n2, int n3, byte[] byArray, long[] lArray) throws SQLException, SQLWarning {
        int n4 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindColInt(" + n + "," + n2 + "," + n3 + ")");
        }
        n4 = this.sqlBindColInt(l, n, n2, n3, byArray, lArray, this.SQLFunc_t[4]);
        this.checkError(n4, 3, l);
    }

    public void jdbcBindColLong(long l, int n, int n2, long l2, byte[] byArray, long[] lArray) throws SQLException, SQLWarning {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindColLong(" + n + "," + n2 + "," + l2 + ")");
        }
        n3 = this.sqlBindColLong(l, n, n2, l2, byArray, lArray, this.SQLFunc_t[4]);
        this.checkError(n3, 3, l);
    }

    public void jdbcBindColShort(long l, int n, int n2, short s, byte[] byArray, long[] lArray) throws SQLException, SQLWarning {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindColInt(" + n + "," + n2 + "," + s + ")");
        }
        n3 = this.sqlBindColShort(l, n, n2, s, byArray, lArray, this.SQLFunc_t[4]);
        this.checkError(n3, 3, l);
    }

    public void jdbcBindColDouble(long l, int n, double d, byte[] byArray, long[] lArray) throws SQLException, SQLWarning {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindColDouble(" + n + "," + d + ")");
        }
        n2 = this.sqlBindColDouble(l, n, d, byArray, lArray, this.SQLFunc_t[4]);
        this.checkError(n2, 3, l);
    }

    public void jdbcBindColFloat(long l, int n, float f, byte[] byArray, long[] lArray) throws SQLException, SQLWarning {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindColFloat(" + n + "," + f + ")");
        }
        n2 = this.sqlBindColFloat(l, n, f, byArray, lArray, this.SQLFunc_t[4]);
        this.checkError(n2, 3, l);
    }

    public void jdbcBindColStr(long l, int n, String string, byte[] byArray, long[] lArray, long[] lArray2) throws SQLException, SQLWarning {
        int n2 = 0;
        byte[] byArray2 = null;
        if (this.needTrace) {
            this.trace("API.jdbcBindColStr(" + n + "," + string + ")");
        }
        if (string != null) {
            byte[] byArray3 = JdbcOdbc.convert(string);
            int n3 = byArray3.length + 2;
            byArray2 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            byArray2[n3 - 2] = 0;
            byArray2[n3 - 1] = 0;
        }
        n2 = this.sqlBindColStr(l, n, byArray2, byArray, lArray, lArray2, this.SQLFunc_t[4]);
        this.checkError(n2, 3, l);
    }

    public void jdbcBindColBinary(long l, int n, int n2, byte[] byArray, byte[] byArray2, long[] lArray, long[] lArray2) throws SQLException, SQLWarning {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindColBinary(" + n + "," + n2 + ")");
        }
        n3 = this.sqlBindColBinary(l, n, n2, byArray, byArray2, lArray, lArray2, this.SQLFunc_t[4]);
        this.checkError(n3, 3, l);
    }

    public void jdbcCloseCursor(long l) throws SQLException, SQLWarning {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcCloseCursor()");
        }
        n = this.sqlCloseCursor(l, this.SQLFunc_t[75]);
        this.checkError(n, 3, l);
    }

    public void jdbcBindColNull(long l, int n, byte[] byArray, long[] lArray, long[] lArray2) throws SQLException, SQLWarning {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindColNull(" + n + ")");
        }
        n2 = this.sqlBindColNull(l, n, byArray, lArray, lArray2, this.SQLFunc_t[4]);
        this.checkError(n2, 3, l);
    }

    public void jdbcBindColIgnore(long l, int n, byte[] byArray, long[] lArray, long[] lArray2) throws SQLException, SQLWarning {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindColIgnore(" + n + ")");
        }
        n2 = this.sqlBindColIgnore(l, n, byArray, lArray, lArray2, this.SQLFunc_t[4]);
        this.checkError(n2, 3, l);
    }

    public long jdbcGetDataStream(long l, int n, int n2, byte[] byArray, int n3) throws SQLException, SQLWarning {
        int n4 = 0;
        long[] lArray = new long[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetDataStream(" + n + "," + n2 + "," + n3 + ")");
        }
        if ((n4 = this.sqlGetDataStream(l, n, n2, byArray, n3, lArray, this.SQLFunc_t[43])) == 100) {
            return -1L;
        }
        if (n4 == 1) {
            return lArray[0];
        }
        this.checkError(n4, 3, l);
        return lArray[0];
    }

    public void jdbcBindColAtExec(long l, int n, int n2, byte[] byArray, long[] lArray, long[] lArray2) throws SQLException, SQLWarning {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcBindColAtExec(" + n + ")");
        }
        n3 = this.sqlBindColAtExec(l, n, n2, byArray, lArray, lArray2, this.SQLFunc_t[4]);
        this.checkError(n3, 3, l);
    }

    public long jdbcGetDataFile(long l, int n, byte[] byArray, int n2) throws SQLException, SQLWarning {
        int n3 = 0;
        long[] lArray = new long[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetDataFile(" + n + "," + n2 + ")");
        }
        if ((n3 = this.sqlGetDataStr(l, n, 301, byArray, n2, lArray, this.SQLFunc_t[43])) == 100) {
            return -1L;
        }
        if (n3 == 1) {
            return lArray[0];
        }
        this.checkError(n3, 3, l);
        return lArray[0];
    }

    public void jdbcDescribeCol(long l, int n, byte[] byArray, int n2, int[] nArray, int[] nArray2, long[] lArray, int[] nArray3, int[] nArray4) throws SQLException, SQLWarning {
        int n3 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcDescribeCol(" + n + ")");
        }
        n3 = this.sqlDescribeCol(l, n, byArray, 0, nArray, nArray2, lArray, nArray3, nArray4, this.SQLFunc_t[8]);
        this.checkError(n3, 3, l);
    }

    public void jdbcDescribeParam(long l, int n, int[] nArray, long[] lArray, int[] nArray2, int[] nArray3) throws SQLException, SQLWarning {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcDescribeParam(" + n + ")");
        }
        n2 = this.sqlDescribeParam(l, n, nArray, lArray, nArray2, nArray3, this.SQLFunc_t[58]);
        this.checkError(n2, 3, l);
    }

    public String jdbcDescParamTypename(long l, int n) throws SQLException, SQLWarning {
        int n2 = 0;
        byte[] byArray = new byte[64];
        int[] nArray = new int[1];
        String string = null;
        if (this.needTrace) {
            this.trace("API.jdbcDescribeParam(" + n + ")");
        }
        n2 = this.sqlDescribeParamTypeName(l, n, byArray, nArray, this.SQLFunc_t[86], this.SQLFunc_t[80]);
        this.checkError(n2, 3, l);
        try {
            string = new String(byArray, 0, nArray[0], ODBCDef.DM_UNICODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("encoding unsupported");
        }
        return string;
    }

    public long jdbcGetBlobHandle(long l, int n) throws SQLException, SQLWarning {
        int n2 = 0;
        long[] lArray = new long[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetBlobHandle(" + n + ")");
        }
        n2 = this.sqlGetBlobHandle(l, n, lArray, this.SQLFunc_t[25]);
        this.checkError(n2, 3, l);
        return lArray[0];
    }

    public long jdbcGetBlobSize(long l) throws SQLException, SQLWarning {
        int n = 0;
        long[] lArray = new long[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetBlobSize");
        }
        n = this.sqlGetBlobSize(l, lArray, this.SQLFunc_t[94]);
        this.checkError(n, 5, l);
        return lArray[0];
    }

    public byte[] jdbcGetBlob(long l, long l2, int n) throws SQLException, SQLWarning {
        int n2 = 0;
        byte[] byArray = new byte[n];
        int[] nArray = new int[1];
        if (this.needTrace) {
            this.trace("API.jdbcGetBlob(" + l2 + ", " + n + ")");
        }
        n2 = this.sqlGetBlob(l, l2, byArray, n, nArray, this.SQLFunc_t[26]);
        this.checkError(n2, 5, l);
        if (nArray[0] < n) {
            byte[] byArray2 = new byte[nArray[0]];
            System.arraycopy(byArray, 0, byArray2, 0, nArray[0]);
            byArray = byArray2;
        }
        return byArray;
    }

    protected byte[] jdbcGetBlob(long l, long l2, int n, byte[] byArray, int[] nArray) throws SQLException, SQLWarning {
        int n2 = 0;
        if (this.needTrace) {
            this.trace("API.jdbcGetBlob(" + l2 + ", " + n + ")");
        }
        n2 = this.sqlGetBlob(l, l2, byArray, n, nArray, this.SQLFunc_t[26]);
        this.checkError(n2, 5, l);
        return byArray;
    }

    public String jdbcutErrTable(String string) throws SQLException, SQLWarning {
        this.trace("API.jdbcutErrTable()");
        int n = 0;
        byte[] byArray = new byte[256];
        int[] nArray = new int[1];
        if (this.SQLFunc_t[36] == 0L) {
            throw new SQLException("fail to get properties file(SQLFunc not initialized yet)");
        }
        n = this.sqlutErrTable(string.getBytes(), byArray, nArray, this.SQLFunc_t[36]);
        if (n != 0) {
            throw new SQLException("fail to get properties file");
        }
        String string2 = new String(byArray);
        return string2.substring(0, nArray[0] - 1);
    }

    public void jdbcDropBlobHandle(long l) throws SQLException, SQLWarning {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcDropBlobHandle");
        }
        n = this.sqlDropBlobHandle(l, this.SQLFunc_t[37]);
        this.checkError(n, 5, l);
    }

    public long jdbcConstructXAResource(long l) throws XAException {
        int n = 0;
        long[] lArray = new long[1];
        if (this.needTrace) {
            this.trace("API.jdbcConstructXAResource(" + l + ")");
        }
        if ((n = this.sqlTXSOURCEConstructor(l, lArray, this.SQLFunc_t[27])) != 0) {
            throw new XAException(n);
        }
        return lArray[0];
    }

    public void jdbcDestructXAResource(long l) throws XAException {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcDestructXAResource(" + l + ")");
        }
        if ((n = this.sqlTXSOURCEDestructor(l, this.SQLFunc_t[28])) != 0) {
            throw new XAException(n);
        }
    }

    public void jdbcTXSOURCE_commit(long l, Xid xid, boolean bl) throws XAException {
        int n = 0;
        this.trace("API.jdbcTXSOURCE_commit(long pConstructor, Xid xid, boolean onePhase)");
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = bl ? 1 : 0;
        n = this.sqlTXSOURCEcommit(l, n2, byArray, byArray2, n3, this.SQLFunc_t[29]);
        if (n != 0) {
            throw new XAException(n);
        }
    }

    public void jdbcTXSOURCE_end(long l, Xid xid, int n) throws XAException {
        int n2 = 0;
        this.trace("API.jdbcTXSOURCE_end(long pConstructor, Xid xid, int flags))");
        int n3 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        n2 = this.sqlTXSOURCEend(l, n3, byArray, byArray2, n, this.SQLFunc_t[31]);
        if (n2 != 0) {
            throw new XAException(n2);
        }
    }

    public boolean jdbcTXSOURCE_isSameRM(long l, long l2) throws XAException {
        int n = 0;
        this.trace("API.jdbcTXSOURCE_isSameRM(long pConstructor1, long pConstructor2)");
        n = this.sqlTXSOURCEisSameRM(l, l2, this.SQLFunc_t[35]);
        return n != 0;
    }

    public int jdbcTXSOURCE_prepare(long l, Xid xid) throws XAException {
        int n = 0;
        this.trace("API.jdbcTXSOURCE_prepare(long pConstructor, Xid xid)");
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        n = this.sqlTXSOURCEprepare(l, n2, byArray, byArray2, this.SQLFunc_t[32]);
        if (n != 0) {
            throw new XAException(n);
        }
        return 0;
    }

    public Xid[] jdbcTXSOURCE_recover(long l, int n) throws XAException {
        int[] nArray = new int[1];
        int n2 = 0;
        int n3 = 0;
        this.trace("API.jdbcTXSOURCE_recover(long pConstructor, Xid[] xidArray,int flag)");
        n3 = this.sqlTXSOURCErecoverNum(l, n, nArray, this.SQLFunc_t[34]);
        if (n3 != 0) {
            throw new XAException(n3);
        }
        n2 = nArray[0];
        if (n2 < 0) {
            throw new XAException(n2);
        }
        Xid[] xidArray = new Xid[n2];
        int[] nArray2 = new int[n2];
        byte[] byArray = new byte[64 * n2];
        int[] nArray3 = new int[n2];
        byte[] byArray2 = new byte[64 * n2];
        int[] nArray4 = new int[n2];
        n3 = this.sqlTXSOURCErecoverData(l, n2, nArray2, byArray, nArray3, byArray2, nArray4, n, this.SQLFunc_t[34]);
        if (n3 != 0) {
            throw new XAException(n3);
        }
        String string = new String(byArray);
        String string2 = new String(byArray2);
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            byArray3 = string.substring(n4, n4 + nArray3[n6]).getBytes();
            byArray4 = string2.substring(n5, n5 + nArray4[n6]).getBytes();
            xidArray[n6] = new JdbcOdbcXid(nArray2[n6], byArray3, byArray4);
            n4 += 64;
            n5 += 64;
            ++n6;
        }
        return xidArray;
    }

    public void jdbcTXSOURCE_rollback(long l, Xid xid) throws XAException {
        int n = 0;
        this.trace("API.jdbcTXSOURCE_rollback(long pConstructor,Xid xid)");
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        n = this.sqlTXSOURCErollback(l, n2, byArray, byArray2, this.SQLFunc_t[33]);
        if (n != 0) {
            throw new XAException(n);
        }
    }

    public void jdbcTXSOURCE_start(long l, Xid xid, int n) throws XAException {
        int n2 = 0;
        this.trace("API.jdbcTXSOURCE_start(long pConstructor,Xid xid, int flags)");
        int n3 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        n2 = this.sqlTXSOURCEstart(l, n3, byArray, byArray2, n, this.SQLFunc_t[30]);
        if (n2 != 0) {
            throw new XAException(n2);
        }
    }

    public boolean jdbcMoreResults(long l) throws SQLException, SQLWarning {
        int n = 0;
        if (this.needTrace) {
            this.trace("API.jdbcMoreResults");
        }
        if ((n = this.sqlMoreResults(l, this.SQLFunc_t[61])) == 0 || n == 1) {
            return true;
        }
        if (n == 100) {
            return false;
        }
        this.checkError(n, 3, l);
        return false;
    }

    protected native int sqlAllocHandle(int var1, long var2, long[] var4, long var5);

    protected native int sqlFreeHandle(int var1, long var2, long var4);

    protected native int sqlFreeStmt(long var1, int var3, long var4);

    protected native int sqlConnect(long var1, byte[] var3, byte[] var4, byte[] var5, long var6);

    protected native int sqlDisconnect(long var1, long var3);

    protected native int sqlSetEnvAttr(long var1, int var3, int var4, long var5);

    protected native int sqlGetEnvAttr(long var1, int var3, int[] var4, long var5);

    protected native int sqlGetEnvAttrLong(long var1, int var3, long[] var4, long var5);

    protected native int sqlSetConnectAttrInt(long var1, int var3, int var4, long var5);

    protected native int sqlSetConnectAttrString(long var1, int var3, byte[] var4, long var5);

    protected native int sqlGetConnectAttrInt(long var1, int var3, int[] var4, long var5);

    protected native int sqlGetConnectAttrString(long var1, int var3, byte[] var4, int[] var5, long var6);

    protected native int sqlSetStmtAttrInt(long var1, int var3, int var4, long var5);

    protected native int sqlSetStmtAttrString(long var1, int var3, byte[] var4, long var5);

    protected native int sqlGetStmtAttrInt(long var1, int var3, int[] var4, long var5);

    protected native int sqlGetStmtAttrLong(long var1, int var3, long[] var4, long var5);

    protected native int sqlGetStmtAttrString(long var1, int var3, byte[] var4, int[] var5, long var6);

    protected native int sqlTransact(long var1, long var3, int var5, long var6);

    protected native int sqlPrepare(long var1, byte[] var3, long var4);

    protected native int sqlExecute(long var1, long var3);

    protected native int sqlExecDirect(long var1, byte[] var3, long var4);

    protected native int sqlGetDiagFieldInt(int var1, long var2, int var4, int var5, int[] var6, long var7);

    protected native int sqlGetDiagRec(int var1, long var2, int var4, byte[] var5, int[] var6, byte[] var7, int[] var8, long var9);

    protected native int sqlNumParams(long var1, int[] var3, long var4);

    protected native int sqlBindInParameterString(long var1, int var3, int var4, byte[] var5, byte[] var6, long[] var7, long[] var8, long var9, long var11);

    protected native int sqlBindInParameterNull(long var1, int var3, int var4, long[] var5, long[] var6, long var7, long var9);

    protected native int sqlBindInParameterBinary(long var1, int var3, int var4, byte[] var5, byte[] var6, long[] var7, long[] var8, long var9, long var11);

    protected native int sqlBindInParameterInt(long var1, int var3, int var4, int var5, byte[] var6, long[] var7, long var8, long var10);

    protected native int sqlBindInParameterLong(long var1, int var3, int var4, long var5, byte[] var7, long[] var8, long var9, long var11);

    protected native int sqlBindInParameterFloat(long var1, int var3, int var4, float var5, byte[] var6, long[] var7, long var8, long var10);

    protected native int sqlBindInParameterDouble(long var1, int var3, double var4, byte[] var6, long[] var7, long var8, long var10);

    protected native int sqlBindInParameterDate(long var1, int var3, int var4, int var5, int var6, byte[] var7, long[] var8, long var9, long var11);

    protected native int sqlBindInParameterTime(long var1, int var3, int var4, int var5, int var6, byte[] var7, long[] var8, long var9, long var11);

    protected native int sqlBindInParameterTimestamp(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, byte[] var11, long[] var12, long var13, long var15);

    protected native int sqlNumResultCol(long var1, int[] var3, long var4);

    protected native int sqlRowCount(long var1, long[] var3, long var4);

    protected native int sqlCancel(long var1, long var3);

    protected native int sqlSetCursorName(long var1, byte[] var3, long var4);

    protected native int sqlGetParamPrec(long var1, int var3, int[] var4, long var5);

    protected native int sqlGetParamType(long var1, int var3, int[] var4, long var5);

    protected native int sqlBindOutParameter(long var1, int var3, int var4, int var5, byte[] var6, long[] var7, long[] var8, long var9);

    protected native int sqlBindInOutParameter(long var1, int var3, int var4, int var5, byte[] var6, long[] var7, long[] var8, long var9);

    protected native int sqlBindInOutParameterNull(long var1, int var3, int var4, int var5, byte[] var6, long[] var7, long[] var8, long var9);

    protected native int sqlGetParameterInd(long var1, int var3, long var4, long[] var6);

    protected native int sqlGetParameterDatabuf(long var1, int var3, long var4, byte[] var6, int var7);

    protected native void sqlGetParameterDate(long var1, int var3, long var4, byte[] var6);

    protected native void sqlGetParameterTime(long var1, int var3, long var4, byte[] var6);

    protected native void sqlGetParameterTimestamp(long var1, int var3, long var4, byte[] var6);

    protected native int sqlGetParameterInt(long var1, int var3, long var4);

    protected native long sqlGetParameterLong(long var1, int var3, long var4);

    protected native float sqlGetParameterFloat(long var1, int var3, long var4);

    protected native double sqlGetParameterDouble(long var1, int var3, long var4);

    protected native int sqlBindInParameterAtexec(long var1, int var3, int var4, int var5, byte[] var6, long[] var7, long[] var8, long var9);

    protected native int sqlPutData(long var1, byte[] var3, long var4, long var6);

    protected native int sqlParamData(long var1, int[] var3, long var4);

    protected native void ReleaseGlobalPtr(long var1, long var3);

    protected native int sqlGetBlobHandle(long var1, int var3, long[] var4, long var5);

    protected native int sqlGetBlob(long var1, long var3, byte[] var5, int var6, int[] var7, long var8);

    protected native int sqlGetBlobSize(long var1, long[] var3, long var4);

    protected native int sqlGetInfoShort(long var1, int var3, int[] var4, long var5);

    protected native int sqlGetInfoInt(long var1, int var3, int[] var4, long var5);

    protected native int sqlGetInfoStr(long var1, int var3, byte[] var4, int var5, int[] var6, long var7);

    protected native int sqlProcedures(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, long var9);

    protected native int sqlProcedureColumns(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, long var11);

    protected native int sqlTables(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, long var11);

    protected native int sqlColumns(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, long var11);

    protected native int sqlSpecialColumns(long var1, int var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9, int var10, int var11, long var12);

    protected native int sqlPrimaryKeys(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, long var9);

    protected native int sqlForeignKeys(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, byte[] var13, int var14, long var15);

    protected native int sqlGetTypeInfo(long var1, int var3, long var4);

    protected native int sqlStatistics(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9, int var10, long var11);

    protected native int sqlColAttributeLong(long var1, int var3, int var4, long[] var5, long var6);

    protected native int sqlColAttributeStr(long var1, int var3, int var4, byte[] var5, int var6, int[] var7, long var8);

    protected native int sqlFetch(long var1, long var3);

    protected native int sqlGetCursorName(long var1, byte[] var3, int var4, int[] var5, long var6);

    protected native int sqlNumResultCols(long var1, int[] var3, long var4);

    protected native int sqlFetchScroll(long var1, int var3, long var4, long var6);

    protected native int sqlSetPos(long var1, int var3, int var4, int var5, long var6);

    protected native int sqlBulkOperations(long var1, int var3, long var4);

    protected native int sqlGetDataInt(long var1, int var3, int[] var4, long[] var5, long var6);

    protected native int sqlGetDataStr(long var1, int var3, int var4, byte[] var5, int var6, long[] var7, long var8);

    protected native int sqlGetDataLong(long var1, int var3, long[] var4, long[] var5, long var6);

    protected native int sqlGetDataDouble(long var1, int var3, double[] var4, long[] var5, long var6);

    protected native int sqlBindColInt(long var1, int var3, int var4, int var5, byte[] var6, long[] var7, long var8);

    protected native int sqlBindColLong(long var1, int var3, int var4, long var5, byte[] var7, long[] var8, long var9);

    protected native int sqlBindColShort(long var1, int var3, int var4, short var5, byte[] var6, long[] var7, long var8);

    protected native int sqlBindColDouble(long var1, int var3, double var4, byte[] var6, long[] var7, long var8);

    protected native int sqlBindColFloat(long var1, int var3, float var4, byte[] var5, long[] var6, long var7);

    protected native int sqlBindColStr(long var1, int var3, byte[] var4, byte[] var5, long[] var6, long[] var7, long var8);

    protected native int sqlBindColBinary(long var1, int var3, int var4, byte[] var5, byte[] var6, long[] var7, long[] var8, long var9);

    protected native int sqlBindColNull(long var1, int var3, byte[] var4, long[] var5, long[] var6, long var7);

    protected native int sqlBindColIgnore(long var1, int var3, byte[] var4, long[] var5, long[] var6, long var7);

    protected native int sqlCloseCursor(long var1, long var3);

    protected native void releaseStoredBytes(long var1, long var3);

    protected native int sqlGetDataStream(long var1, int var3, int var4, byte[] var5, int var6, long[] var7, long var8);

    protected native int sqlBindColAtExec(long var1, int var3, int var4, byte[] var5, long[] var6, long[] var7, long var8);

    protected native int sqlDescribeCol(long var1, int var3, byte[] var4, int var5, int[] var6, int[] var7, long[] var8, int[] var9, int[] var10, long var11);

    protected native int sqlAllocHandleEnv(int var1, long var2, long[] var4, long[] var5, int var6, long[] var7);

    protected native int sqlGetConnectAttrInt2(long var1, int var3, int[] var4, int[] var5, long var6);

    protected native int sqlSetConnectAttrInt2(long var1, int var3, int var4, int var5, long var6);

    protected native int sqlBindInParameterDefault(long var1, int var3, int var4, byte[] var5, long[] var6, long[] var7, long var8);

    protected native int sqlDescribeParamTypeName(long var1, int var3, byte[] var4, int[] var5, long var6, long var8);

    protected native int sqlDescribeParam(long var1, int var3, int[] var4, long[] var5, int[] var6, int[] var7, long var8);

    protected native int sqlTXSOURCEConstructor(long var1, long[] var3, long var4);

    protected native int sqlTXSOURCEDestructor(long var1, long var3);

    protected native int sqlTXSOURCEcommit(long var1, int var3, byte[] var4, byte[] var5, int var6, long var7);

    protected native int sqlTXSOURCEend(long var1, int var3, byte[] var4, byte[] var5, int var6, long var7);

    protected native int sqlTXSOURCEisSameRM(long var1, long var3, long var5);

    protected native int sqlTXSOURCEprepare(long var1, int var3, byte[] var4, byte[] var5, long var6);

    protected native int sqlTXSOURCErecoverNum(long var1, int var3, int[] var4, long var5);

    protected native int sqlTXSOURCErecoverData(long var1, int var3, int[] var4, byte[] var5, int[] var6, byte[] var7, int[] var8, int var9, long var10);

    protected native int sqlTXSOURCErollback(long var1, int var3, byte[] var4, byte[] var5, long var6);

    protected native int sqlTXSOURCEstart(long var1, int var3, byte[] var4, byte[] var5, int var6, long var7);

    protected native int sqlutErrTable(byte[] var1, byte[] var2, int[] var3, long var4);

    protected native int sqlDropBlobHandle(long var1, long var3);

    protected native int sqlMoreResults(long var1, long var3);

    public void jdbcReleaseGlobalPtr(long l, long l2) throws SQLException {
        if (this.needTrace) {
            this.trace("API.jdbcReleaseGlobalPtr");
        }
        this.ReleaseGlobalPtr(l, l2);
    }

    private SQLWarning createSQLWarning(long l, int n) throws SQLException, SQLWarning {
        int n2 = 0;
        int n3 = 0;
        SQLWarning sQLWarning = null;
        SQLWarning sQLWarning2 = null;
        int[] nArray = new int[1];
        byte[] byArray = new byte[10];
        int[] nArray2 = new int[1];
        byte[] byArray2 = new byte[512];
        int[] nArray3 = new int[1];
        nArray[0] = 0;
        nArray2[0] = 0;
        nArray3[0] = 0;
        n3 = this.sqlGetDiagFieldInt(n, l, 0, 2, nArray, this.SQLFunc_t[82]);
        if (n3 != 0 || nArray[0] <= 0) {
            return new SQLWarning("get error count fail", "HY000");
        }
        n2 = 0;
        while (n2 < nArray[0]) {
            String string;
            String string2;
            SQLWarning sQLWarning3 = null;
            n3 = this.sqlGetDiagRec(n, l, n2 + 1, byArray, nArray2, byArray2, nArray3, this.SQLFunc_t[83]);
            if (n3 != 0) {
                return new SQLWarning("get error fail", "HY000");
            }
            try {
                string2 = new String(byArray2, ODBCDef.DM_UNICODE);
                string = new String(byArray, ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
            sQLWarning3 = new SQLWarning(string2.trim(), string, nArray2[0]);
            if (sQLWarning == null) {
                sQLWarning = sQLWarning3;
            } else {
                sQLWarning2.setNextWarning(sQLWarning3);
            }
            sQLWarning2 = sQLWarning3;
            ++n2;
        }
        return sQLWarning;
    }

    private SQLException createSQLException(long l, int n) throws SQLException {
        String string;
        String string2;
        int n2 = 0;
        int n3 = 0;
        SQLException sQLException = null;
        SQLException sQLException2 = null;
        SQLException sQLException3 = null;
        int[] nArray = new int[1];
        byte[] byArray = new byte[10];
        int[] nArray2 = new int[1];
        byte[] byArray2 = new byte[512];
        int[] nArray3 = new int[1];
        nArray[0] = 0;
        nArray2[0] = 0;
        nArray3[0] = 0;
        n3 = this.sqlGetDiagRec(n, l, 1, byArray, nArray2, byArray2, nArray3, this.SQLFunc_t[83]);
        if (n3 != 0) {
            return new SQLException("get error fail", "HY000");
        }
        if (nArray2[0] >= 10000) {
            this.fgDBrollback = true;
        }
        try {
            string2 = new String(byArray2, ODBCDef.DM_UNICODE);
            string = new String(byArray, ODBCDef.DM_UNICODE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("encoding unsupported");
        }
        sQLException = sQLException2 = (sQLException3 = new SQLException(string2.trim(), string, nArray2[0]));
        n3 = this.sqlGetDiagFieldInt(n, l, 0, 2, nArray, this.SQLFunc_t[82]);
        if (n3 != 0 || nArray[0] <= 0) {
            return sQLException;
        }
        n2 = 1;
        while (n2 < nArray[0]) {
            n3 = this.sqlGetDiagRec(n, l, n2 + 1, byArray, nArray2, byArray2, nArray3, this.SQLFunc_t[83]);
            if (n3 != 0) {
                return new SQLException("get error fail", "HY000");
            }
            try {
                string2 = new String(byArray2, ODBCDef.DM_UNICODE);
                string = new String(byArray, ODBCDef.DM_UNICODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException("encoding unsupported");
            }
            sQLException3 = new SQLException(string2.trim(), string, nArray2[0]);
            sQLException2.setNextException(sQLException3);
            sQLException2 = sQLException3;
            ++n2;
        }
        return sQLException;
    }

    private void checkError(int n, int n2, long l) throws SQLException, SQLWarning {
        if (this.needTrace) {
            this.trace("API.checkError (" + n2 + ")");
        }
        this.fgDBrollback = false;
        if (n == 0) {
            return;
        }
        switch (n) {
            case 1: {
                throw this.createSQLWarning(l, n2);
            }
            case 100: {
                throw new SQLWarning("no more data", "01000");
            }
            case -2: {
                throw new SQLException("invalid handle", "HY000");
            }
            case -1: {
                throw this.createSQLException(l, n2);
            }
        }
    }

    protected ResourceBundle getResourceBundle() {
        return this.getResourceBundle(this.errlcode);
    }

    protected ResourceBundle getResourceBundle(String string) {
        if (this.errlcode.compareTo(string) != 0) {
            this.rb = null;
        }
        String string2 = null;
        if (this.rb == null) {
            try {
                string2 = this.jdbcutErrTable(string);
                JdbcOdbcClassLoader jdbcOdbcClassLoader = new JdbcOdbcClassLoader(string2);
                this.rb = ResourceBundle.getBundle("dmJdbc", Locale.getDefault(), jdbcOdbcClassLoader);
            }
            catch (Exception exception) {
                this.rb = ResourceBundle.getBundle("dbmaster.sql.dmJdbc");
            }
            this.errlcode = string;
        }
        return this.rb;
    }

    static {
        System.loadLibrary("dmjdbc54");
    }
}

