/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.output.OutputBase;
import org.apache.xalan.xsltc.runtime.output.StreamOutput;

public class StreamXMLOutput
extends StreamOutput {
    private static final String BEGCDATA = "<![CDATA[";
    private static final String ENDCDATA = "]]>";
    private static final String CNTCDATA = "]]]]><![CDATA[>";
    private static final String BEGCOMM = "<!--";
    private static final String ENDCOMM = "-->";
    private static final String CDATA_ESC_START = "]]>&#";
    private static final String CDATA_ESC_END = ";<![CDATA[";
    private String _elementName;

    public StreamXMLOutput(Writer writer, String encoding) {
        super(writer, encoding);
        this.initCDATA();
        this.initNamespaces();
    }

    public StreamXMLOutput(OutputStream out, String encoding) throws IOException {
        super(out, encoding);
        this.initCDATA();
        this.initNamespaces();
    }

    public void startDocument() throws TransletException {
        if (!this._omitHeader) {
            StringBuffer header = new StringBuffer("<?xml version=\"");
            header.append(this._version).append("\" encoding=\"").append(this._encoding);
            if (this._standalone != null) {
                header.append("\" standalone=\"").append(this._standalone);
            }
            header.append("\"?>\n");
            this._buffer.insert(0, header.toString());
        }
    }

    public void endDocument() throws TransletException {
        this.outputBuffer();
    }

    public void startElement(String elementName) throws TransletException {
        if (this._startTagOpen) {
            this.closeStartTag();
        } else if (this._cdataTagOpen) {
            this.endCDATA();
        }
        if (this._firstElement) {
            if (this._doctypeSystem != null) {
                this.appendDTD(elementName);
            }
            this._firstElement = false;
        }
        if (this._indent) {
            this.indent(this._lineFeedNextStartTag);
            this._lineFeedNextStartTag = true;
            this._indentNextEndTag = false;
            ++this._indentLevel;
        }
        this._buffer.append('<').append(elementName);
        ++this._depth;
        this._startTagOpen = true;
        this._elementName = elementName;
    }

    public void endElement(String elementName) throws TransletException {
        if (this._cdataTagOpen) {
            this.endCDATA();
        }
        if (this._startTagOpen) {
            this.appendAttributes();
            this._buffer.append("/>");
            this._startTagOpen = false;
            if (this._indent) {
                --this._indentLevel;
                this._indentNextEndTag = true;
            }
        } else {
            if (this._indent) {
                --this._indentLevel;
                if (this._indentNextEndTag) {
                    this.indent(this._indentNextEndTag);
                    this._indentNextEndTag = true;
                    this._lineFeedNextStartTag = true;
                }
            }
            this._buffer.append("</").append(elementName).append('>');
            this._indentNextEndTag = true;
        }
        if ((Integer)this._cdataStack.peek() == this._depth) {
            this._cdataStack.pop();
        }
        this.popNamespaces();
        --this._depth;
    }

    public void characters(String characters) throws TransletException {
        this.characters(characters.toCharArray(), 0, characters.length());
    }

    public void characters(char[] characters, int offset, int length) throws TransletException {
        Integer I;
        if (length <= 0) {
            return;
        }
        if (this._startTagOpen) {
            this.closeStartTag();
        }
        if ((I = (Integer)this._cdataStack.peek()) == this._depth && !this._cdataTagOpen) {
            this.startCDATA(characters, offset, length);
        } else if (this._escaping) {
            if (this._cdataTagOpen) {
                this.escapeCDATA(characters, offset, length);
            } else {
                this.escapeCharacters(characters, offset, length);
            }
        } else {
            this._buffer.append(characters, offset, length);
        }
    }

    public void attribute(String name, String value) throws TransletException {
        if (this._startTagOpen) {
            StreamOutput.Attribute attr = new StreamOutput.Attribute(OutputBase.patchName(name), this.escapeString(value));
            int k = this._attributes.indexOf(attr);
            if (k >= 0) {
                this._attributes.setElementAt(attr, k);
            } else {
                this._attributes.add(attr);
            }
        }
    }

    public void comment(String comment) throws TransletException {
        if (this._startTagOpen) {
            this.closeStartTag();
        } else if (this._cdataTagOpen) {
            this.endCDATA();
        }
        this.appendComment(comment);
    }

    public void processingInstruction(String target, String data) throws TransletException {
        if (this._startTagOpen) {
            this.closeStartTag();
        } else if (this._cdataTagOpen) {
            this.endCDATA();
        }
        this._buffer.append("<?").append(target).append(' ').append(data).append("?>");
    }

    public boolean setEscaping(boolean escape) throws TransletException {
        boolean temp = this._escaping;
        this._escaping = escape;
        return temp;
    }

    public void namespace(String prefix, String uri) throws TransletException {
        String escaped = this.escapeString(uri);
        if (this._startTagOpen) {
            if (this.pushNamespace(prefix, escaped)) {
                this._buffer.append(' ').append("xmlns");
                if (prefix != null && prefix != "") {
                    this._buffer.append(':').append(prefix);
                }
                this._buffer.append("=\"").append(escaped).append('\"');
            }
        } else if (prefix != "" || uri != "") {
            BasisLibrary.runTimeError(11, prefix, escaped);
        }
    }

    protected void closeStartTag() throws TransletException {
        super.closeStartTag();
        if (this._cdata != null) {
            StringBuffer expandedName;
            String localName = OutputBase.getLocalName(this._elementName);
            String uri = this.getNamespaceURI(this._elementName, true);
            StringBuffer stringBuffer = expandedName = uri == "" ? new StringBuffer(this._elementName) : new StringBuffer(uri).append(':').append(localName);
            if (this._cdata.containsKey(expandedName.toString())) {
                this._cdataStack.push(new Integer(this._depth));
            }
        }
    }

    private void startCDATA(char[] ch, int off, int len) {
        int limit = off + len;
        int offset = off;
        this._buffer.append(BEGCDATA);
        int i = offset;
        while (i < limit - 2) {
            if (ch[i] == ']' && ch[i + 1] == ']' && ch[i + 2] == '>') {
                this._buffer.append(ch, offset, i - offset).append(CNTCDATA);
                offset = i + 3;
                i += 2;
            }
            ++i;
        }
        if (offset < limit) {
            this._buffer.append(ch, offset, limit - offset);
        }
        this._cdataTagOpen = true;
    }

    public void startCDATA() throws TransletException {
        this._buffer.append(BEGCDATA);
        this._cdataTagOpen = true;
    }

    public void endCDATA() throws TransletException {
        this._buffer.append(ENDCDATA);
        this._cdataTagOpen = false;
    }

    private void escapeCDATA(char[] ch, int off, int len) {
        int offset = off;
        int limit = off + len;
        if (limit > ch.length) {
            limit = ch.length;
        }
        int i = off;
        while (i < limit) {
            char current = ch[i];
            if (current > '\u00ff') {
                this._buffer.append(ch, offset, i - offset).append(CDATA_ESC_START).append(Integer.toString(current)).append(CDATA_ESC_END);
                offset = i + 1;
            }
            ++i;
        }
        if (offset < limit) {
            this._buffer.append(ch, offset, limit - offset);
        }
    }

    private String escapeString(String value) {
        char[] ch = value.toCharArray();
        int limit = ch.length;
        StringBuffer result = new StringBuffer();
        int offset = 0;
        int i = 0;
        while (i < limit) {
            switch (ch[i]) {
                case '&': {
                    result.append(ch, offset, i - offset).append("&amp;");
                    offset = i + 1;
                    break;
                }
                case '\"': {
                    result.append(ch, offset, i - offset).append("&quot;");
                    offset = i + 1;
                    break;
                }
                case '<': {
                    result.append(ch, offset, i - offset).append("&lt;");
                    offset = i + 1;
                    break;
                }
                case '>': {
                    result.append(ch, offset, i - offset).append("&gt;");
                    offset = i + 1;
                    break;
                }
                case '\n': {
                    result.append(ch, offset, i - offset).append("&#xA;");
                    offset = i + 1;
                }
            }
            ++i;
        }
        if (offset < limit) {
            result.append(ch, offset, limit - offset);
        }
        return result.toString();
    }

    protected void escapeCharacters(char[] ch, int off, int len) {
        int limit = off + len;
        int offset = off;
        if (limit > ch.length) {
            limit = ch.length;
        }
        int i = off;
        while (i < limit) {
            char current = ch[i];
            switch (current) {
                case '&': {
                    this._buffer.append(ch, offset, i - offset).append("&amp;");
                    offset = i + 1;
                    break;
                }
                case '<': {
                    this._buffer.append(ch, offset, i - offset).append("&lt;");
                    offset = i + 1;
                    break;
                }
                case '>': {
                    this._buffer.append(ch, offset, i - offset).append("&gt;");
                    offset = i + 1;
                    break;
                }
                default: {
                    if ((current < '\u007f' || current >= '\u00a0') && (!this._is8859Encoded || current <= '\u00ff')) break;
                    this._buffer.append(ch, offset, i - offset).append("&#").append(Integer.toString(ch[i])).append(';');
                    offset = i + 1;
                }
            }
            ++i;
        }
        if (offset < limit) {
            this._buffer.append(ch, offset, limit - offset);
        }
    }
}

