/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import org.apache.xalan.xsltc.runtime.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class DefaultSAXOutputHandler
implements ContentHandler,
LexicalHandler {
    private Writer _writer;
    private Hashtable _endTags = new Hashtable();
    private Hashtable _attributeTemplates = new Hashtable();
    private Hashtable _emptyElements = new Hashtable();
    private String _element = null;
    private int _outputType = 0;
    private String _encoding = "UTF-8";
    private String _version = "1.0";
    private String _standalone = null;
    private boolean _indent = false;
    private boolean _omitHeader = false;
    private boolean _startTagOpen = false;
    private static final char[] BEGPI = "<?".toCharArray();
    private static final char[] ENDPI = "?>".toCharArray();
    private static final char[] GT_CR = ">".toCharArray();
    private static final char[] GT_LT_SL = "></".toCharArray();
    private static final char[] SL_GT = "/>".toCharArray();
    private static final char[] XMLNS = " xmlns".toCharArray();
    private static final char[] INDENT = "                    ".toCharArray();
    private static final int MAX_INDENT_LEVEL = INDENT.length >> 1;
    private static final int MAX_INDENT = INDENT.length;
    private static final String EMPTYSTRING = "";
    private boolean _lineFeedNextStartTag = false;
    private boolean _linefeedNextEndTag = false;
    private boolean _indentNextEndTag = false;
    private int _indentLevel = 0;
    private Vector _namespaceDecls = null;

    public DefaultSAXOutputHandler(Writer writer, String encoding) throws IOException {
        this._writer = writer;
        this._encoding = encoding;
        this.init();
    }

    public DefaultSAXOutputHandler(Writer writer) throws IOException {
        this(writer, "UTF-8");
    }

    public DefaultSAXOutputHandler(OutputStream out, String encoding) throws IOException {
        OutputStreamWriter writer;
        try {
            this._encoding = encoding;
            writer = new OutputStreamWriter(out, this._encoding);
        }
        catch (UnsupportedEncodingException e) {
            this._encoding = "UTF-8";
            writer = new OutputStreamWriter(out, "UTF-8");
        }
        this._writer = new BufferedWriter(writer);
        this.init();
    }

    public DefaultSAXOutputHandler(String filename, String encoding) throws IOException {
        this(new FileOutputStream(filename), encoding);
    }

    private void init() throws IOException {
        String[] tags = new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};
        int i = 0;
        while (i < tags.length) {
            this._emptyElements.put(tags[i], tags[i]);
            ++i;
        }
        this._endTags.clear();
        this._outputType = 0;
        this._indent = false;
        this._indentNextEndTag = false;
        this._indentLevel = 0;
        this._startTagOpen = false;
    }

    public void close() {
        try {
            if (this._writer != null) {
                this._writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void emitHeader() throws SAXException {
        if (this._omitHeader) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"");
        buffer.append(this._version);
        buffer.append("\" encoding=\"");
        buffer.append(this._encoding);
        if (this._standalone != null) {
            buffer.append("\" standalone=\"");
            buffer.append(this._standalone);
        }
        buffer.append("\"?>\n");
        this.characters(buffer.toString());
    }

    private void determineOutputType(String element) throws SAXException {
        if (element != null && element.toLowerCase().equals("html")) {
            this._outputType = 2;
        } else {
            this._outputType = 1;
            this.emitHeader();
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        try {
            this._writer.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localname, String elementName, Attributes attrs) throws SAXException {
        try {
            int i;
            if (this._outputType == 0) {
                this.determineOutputType(elementName);
            }
            if (this._startTagOpen) {
                this.closeStartTag(true);
            }
            this._element = elementName;
            if (this._indent) {
                if (!this._emptyElements.containsKey(elementName.toLowerCase())) {
                    this.indent(this._lineFeedNextStartTag);
                    this._lineFeedNextStartTag = true;
                    this._indentNextEndTag = false;
                }
                ++this._indentLevel;
            }
            this._writer.write(60);
            this._writer.write(elementName);
            this._startTagOpen = true;
            this._indentNextEndTag = false;
            if (this._namespaceDecls != null) {
                int nDecls = this._namespaceDecls.size();
                i = 0;
                while (i < nDecls) {
                    String prefix = (String)this._namespaceDecls.elementAt(i++);
                    this._writer.write(XMLNS);
                    if (prefix != null && prefix != EMPTYSTRING) {
                        this._writer.write(58);
                        this._writer.write(prefix);
                    }
                    this._writer.write(61);
                    this._writer.write(34);
                    this._writer.write((String)this._namespaceDecls.elementAt(i));
                    this._writer.write(34);
                    ++i;
                }
                this._namespaceDecls.clear();
            }
            int attrCount = attrs.getLength();
            i = 0;
            while (i < attrCount) {
                this._writer.write(32);
                this._writer.write(attrs.getQName(i));
                this._writer.write(61);
                this._writer.write(34);
                this._writer.write(attrs.getValue(i));
                this._writer.write(34);
                ++i;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localname, String elementName) throws SAXException {
        try {
            if (this._indent) {
                --this._indentLevel;
            }
            if (this._startTagOpen) {
                this.closeStartTag(false);
            } else {
                char[] endTag;
                if (this._indent && this._indentNextEndTag) {
                    this.indent(this._indentNextEndTag);
                    this._indentNextEndTag = true;
                }
                if ((endTag = (char[])this._endTags.get(elementName)) == null) {
                    int len = elementName.length();
                    char[] src = elementName.toCharArray();
                    endTag = new char[len + 3];
                    System.arraycopy(src, 0, endTag, 2, len);
                    endTag[0] = 60;
                    endTag[1] = 47;
                    endTag[len + 2] = 62;
                    this._endTags.put(elementName, endTag);
                }
                this._writer.write(endTag);
            }
            this._indentNextEndTag = true;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void characters(String str) throws SAXException {
        char[] ch = str.toCharArray();
        this.characters(ch, 0, ch.length);
    }

    private void characters(char[] ch) throws SAXException {
        this.characters(ch, 0, ch.length);
    }

    public void characters(char[] ch, int off, int len) throws SAXException {
        try {
            if (this._outputType == 0) {
                this.determineOutputType(null);
            }
            if (len == 0) {
                return;
            }
            if (this._startTagOpen) {
                this.closeStartTag(true);
            }
            this._writer.write(ch, off, len);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag(true);
            }
            this._writer.write(BEGPI);
            this._writer.write(target);
            this._writer.write(32);
            this._writer.write(data);
            if (this._outputType == 2) {
                this._writer.write(62);
            } else {
                this._writer.write(ENDPI);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int len) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String uri) {
        if (this._namespaceDecls == null) {
            this._namespaceDecls = new Vector(2);
        }
        this._namespaceDecls.addElement(prefix);
        this._namespaceDecls.addElement(uri);
    }

    public void endPrefixMapping(String prefix) {
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void comment(char[] ch, int start, int length) {
    }

    public void startEntity(String name) {
    }

    public void endDTD() {
    }

    public void endEntity(String name) {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            StringBuffer buf = new StringBuffer("<!DOCTYPE ");
            buf.append(name);
            if (publicId == null) {
                buf.append(" SYSTEM");
            } else {
                buf.append(" PUBLIC \"");
                buf.append(publicId);
                buf.append("\"");
            }
            if (systemId != null) {
                buf.append(" \"");
                buf.append(systemId);
                buf.append("\">\n");
            } else {
                buf.append(">\n");
            }
            this._writer.write(buf.toString());
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void indent(boolean linefeed) throws IOException {
        if (linefeed) {
            this._writer.write(10);
        }
        if (this._indentLevel < MAX_INDENT_LEVEL) {
            this._writer.write(INDENT, 0, this._indentLevel + this._indentLevel);
        } else {
            this._writer.write(INDENT, 0, MAX_INDENT);
        }
    }

    private void closeStartTag(boolean content) throws SAXException {
        try {
            if (!content) {
                if (this._outputType == 2) {
                    if (!this._emptyElements.containsKey(this._element.toLowerCase())) {
                        this._writer.write(GT_LT_SL);
                        this._writer.write(this._element);
                        this._writer.write(62);
                    } else {
                        this._writer.write(GT_CR);
                    }
                } else {
                    this._writer.write(SL_GT);
                }
            } else {
                this._writer.write(62);
            }
            this._startTagOpen = false;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void setIndent(boolean indent) {
        this._indent = indent;
    }

    public void setVersion(String version2) {
        this._version = version2;
    }

    public void setStandalone(String standalone) {
        this._standalone = standalone;
    }

    public void omitHeader(boolean value) {
        this._omitHeader = value;
    }

    public void setOutputType(int type) throws SAXException {
        this._outputType = type;
        if (this._outputType == 1) {
            this.emitHeader();
        }
    }
}

