/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import java.util.StringTokenizer;
import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.dom.BitArray;
import org.apache.xalan.xsltc.runtime.Hashtable;

public class KeyIndex
implements NodeIterator {
    private Hashtable _index = new Hashtable();
    private BitArray _nodes = null;
    private int _pos = 0;
    private int _mark = 0;
    private int _save = 0;
    private int _start = 0;
    private int _arraySize = 0;
    private int _node = -1;

    public KeyIndex(int size) {
        this._arraySize = size;
    }

    public void setRestartable(boolean flag) {
    }

    public void add(Object value, int node) {
        this._nodes = (BitArray)this._index.get(value);
        if (this._nodes == null) {
            this._nodes = new BitArray(this._arraySize);
            this._nodes.setMask(node & 0xFF000000);
            this._index.put(value, this._nodes);
        }
        this._nodes.setBit(node & 0xFFFFFF);
    }

    public void merge(KeyIndex other) {
        if (other != null && other._nodes != null) {
            this._nodes = this._nodes == null ? other._nodes : this._nodes.merge(other._nodes);
        }
    }

    public void lookupId(Object value) {
        String string;
        if (value instanceof String && (string = (String)value).indexOf(32) > -1) {
            StringTokenizer values = new StringTokenizer(string);
            while (values.hasMoreElements()) {
                BitArray nodes = (BitArray)this._index.get(values.nextElement());
                if (nodes == null) continue;
                this._nodes = this._nodes == null ? nodes : this._nodes.merge(nodes);
            }
            return;
        }
        this._nodes = (BitArray)this._index.get(value);
    }

    public void lookupKey(Object value) {
        this._nodes = (BitArray)this._index.get(value);
    }

    public int next() {
        if (this._nodes == null) {
            return 0;
        }
        if ((this._node = this._nodes.getNextBit(++this._node)) == 0) {
            return 0;
        }
        ++this._pos;
        return this._node | this._nodes.getMask();
    }

    public int containsID(int node, Object value) {
        String string;
        if (value instanceof String && (string = (String)value).indexOf(32) > -1) {
            StringTokenizer values = new StringTokenizer(string);
            while (values.hasMoreElements()) {
                BitArray nodes = (BitArray)this._index.get(values.nextElement());
                if (nodes == null || !nodes.getBit(node)) continue;
                return 1;
            }
            return 0;
        }
        BitArray nodes = (BitArray)this._index.get(value);
        if (nodes != null && nodes.getBit(node)) {
            return 1;
        }
        return 0;
    }

    public int containsKey(int node, Object value) {
        BitArray nodes = (BitArray)this._index.get(value);
        if (nodes != null && nodes.getBit(node)) {
            return 1;
        }
        return 0;
    }

    public NodeIterator reset() {
        this._pos = this._start;
        this._node = this._start - 1;
        return this;
    }

    public int getLast() {
        if (this._nodes == null) {
            return 0;
        }
        return this._nodes.size();
    }

    public int getPosition() {
        return this._pos;
    }

    public void setMark() {
        this._mark = this._pos;
        this._save = this._node;
    }

    public void gotoMark() {
        this._pos = this._mark;
        this._node = this._save;
    }

    public NodeIterator setStartNode(int start) {
        if (start == 0) {
            this._nodes = null;
        } else if (this._nodes != null) {
            this._start = this._nodes.getBitNumber(start - 1);
            this._node = this._start - 1;
        }
        return this;
    }

    public boolean isReverse() {
        return false;
    }

    public NodeIterator cloneIterator() {
        KeyIndex other = new KeyIndex(this._arraySize);
        other._index = this._index;
        other._nodes = this._nodes.cloneArray();
        other._pos = this._pos;
        other._start = this._start;
        other._node = this._node;
        return other;
    }
}

