/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.xml.node;

import com.syscom.datatransfer.XTTDatatransfer;
import com.syscom.misc.QueryParser;
import com.syscom.misc.XMLImageResource;
import com.syscom.misc.XTTUt;
import com.syscom.preferences.PreferencesXml;
import com.syscom.undo.DisplaySettingUndoEdit;
import com.syscom.ut.GuiUt;
import com.syscom.ut.comp.ReflectionAction;
import com.syscom.ut.locale.LocaleChangeEvent;
import com.syscom.ut.locale.LocaleChangeListener;
import com.syscom.ut.locale.LocaleManager;
import com.syscom.xml.node.QueryElement;
import com.syscom.xml.node.Template;
import com.syscom.xml.node.display.AbstractDisplayPanel;
import com.syscom.xml.node.display.AttributeDisplayPanel;
import com.syscom.xml.node.display.AttributeMainPanel;
import com.syscom.xml.xtt.console.XTTFrame;
import com.syscom.xml.xtt.xttobjects.ColumnObject;
import com.syscom.xml.xtt.xttobjects.InvalidElementObject;
import com.syscom.xml.xttinterface.DisplaySettingInterface;
import com.syscom.xml.xttinterface.XTTTreeNodeInterface;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Attribute
extends XTTDatatransfer
implements XTTTreeNodeInterface,
DisplaySettingInterface,
LocaleChangeListener {
    private ResourceBundle res = ResourceBundle.getBundle("com.syscom.xml.node.resource.Res", LocaleManager.getLocale());
    private static ImageIcon icon = null;
    private static ImageIcon disabled_icon = null;
    private static String imagefilename = "/xmlimages/attribute_display.gif";
    private static String disabledImageFile = "/xmlimages/attribute_at_gray.gif";
    private boolean isHidden = false;
    private XTTTreeNodeInterface parent = null;
    private Vector children = null;
    private Node node = null;
    private String name = "";
    private String value = "";
    private String null_handling = "";
    private String lo_mode = "";
    private String link_value = "";
    private DefaultMutableTreeNode defaultMutableTreeNode = null;
    public String xsdType = "xsd:string";

    public Attribute(Node node) {
        this.node = node;
        this.getAttributes();
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    public Attribute() {
        this.name = "";
        this.value = "";
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    public Attribute(String attName) {
        this(attName, "");
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    public Attribute(String attName, String attValue) {
        this.name = attName;
        this.value = attValue;
        LocaleManager.getLocaleManager().addLocaleChangeListener(this);
    }

    public void remove_menuitem_actionPerformed(ActionEvent e) {
        XTTFrame.frame.Remove_MenuItem_actionPerformed(null);
    }

    public void element_menuitem_actionPerformed(ActionEvent e) {
        if (this.defaultMutableTreeNode == null) {
            GuiUt.showErrorDlg(XTTFrame.frame, this.res.getString("Cannot_convert_to"), null);
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.defaultMutableTreeNode.getParent();
        DefaultMutableTreeNode parentParentNode = (DefaultMutableTreeNode)parentNode.getParent();
        QueryElement qe = new QueryElement();
        qe.setLocalName(this.name);
        qe.setTextValue(this.value);
        qe.setParent(this.parent);
        qe.setChildren(this.children);
        qe.setLinkTextValue(this.link_value);
        QueryElement parent_qe = (QueryElement)parentNode.getUserObject();
        int break_line = -1;
        int children_size = parent_qe.getChildren().size();
        XTTTreeNodeInterface childXTT = null;
        for (int i = 0; i < children_size; ++i) {
            childXTT = (XTTTreeNodeInterface)parent_qe.getChildren().elementAt(i);
            if (!(childXTT instanceof QueryElement)) continue;
            break_line = i;
            break;
        }
        int pos = parent_qe.getChildren().indexOf(this);
        if (break_line == -1) {
            parent_qe.remove(this);
            parent_qe.addChildAt(qe, children_size - 1);
        } else if (pos <= break_line) {
            parent_qe.addChildAt(qe, break_line);
            parent_qe.remove(this);
        }
        this.defaultMutableTreeNode.removeFromParent();
        DefaultMutableTreeNode dmtn = new DefaultMutableTreeNode(qe);
        qe.setDefaultMutableTreeNode(dmtn);
        int item_pos = parent_qe.getChildren().indexOf(qe);
        ((DefaultTreeModel)XTTFrame.frame.getTreeTable().getTree().getModel()).insertNodeInto(dmtn, parentNode, item_pos);
        XTTFrame.frame.refreshTree(parentNode, parentParentNode);
        XTTFrame.frame.refreshTree(dmtn, parentNode);
        TreePath p = new TreePath(dmtn.getPath());
        XTTFrame.frame.getTreeTable().getTree().makeVisible(p);
        int row = XTTFrame.frame.getTreeTable().getTree().getRowForPath(p);
        XTTFrame.frame.getTreeTable().getSelectionModel().setSelectionInterval(row, row);
        ((AbstractTableModel)XTTFrame.frame.getTreeTable().getModel()).fireTableChanged(new TableModelEvent(XTTFrame.frame.getTreeTable().getModel()));
    }

    @Override
    public void getAttributes() {
        String s = null;
        Element elm = (Element)this.node;
        s = PreferencesXml.getAttributeValue(elm, "name");
        if (s != null && s.length() > 0) {
            this.name = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "value")) != null && s.length() > 0) {
            this.value = s;
            this.link_value = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "null_handling")) != null && s.length() > 0) {
            this.null_handling = s;
        }
        if ((s = PreferencesXml.getAttributeValue(elm, "lo_mode")) != null && s.length() > 0) {
            this.lo_mode = s;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        XTTFrame.setXTTModified(true);
        XTTFrame.xttRefresh_xttCombo();
    }

    public void setXSDName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setAttributeValue(String value) {
        this.value = value;
        this.setLinkValue(value);
        XTTFrame.setXTTModified(true);
        XTTFrame.xttRefresh_xttCombo();
    }

    public String getNullHandling() {
        return this.null_handling;
    }

    public void setNullHandling(String null_handling) {
        this.null_handling = null_handling;
    }

    public String getLoMode() {
        return this.lo_mode;
    }

    public void setLoMode(String lo_mode) {
        this.lo_mode = lo_mode;
    }

    public String getLinkValue() {
        return this.link_value;
    }

    public void setLinkValue(String link_value) {
        this.link_value = link_value;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean b) {
        this.isHidden = b;
    }

    @Override
    public DefaultMutableTreeNode getDefaultMutableTreeNode() {
        return this.defaultMutableTreeNode;
    }

    @Override
    public ImageIcon getImageIcon() {
        if (icon == null) {
            icon = XMLImageResource.getResource(this.getClass(), imagefilename);
        }
        return icon;
    }

    @Override
    public ImageIcon getDisabledImageIcon() {
        if (disabled_icon == null) {
            disabled_icon = XMLImageResource.getResource(this.getClass(), disabledImageFile);
        }
        return disabled_icon;
    }

    @Override
    public boolean isFreeze() {
        return false;
    }

    @Override
    public void setDefaultMutableTreeNode(DefaultMutableTreeNode current_node) {
        this.defaultMutableTreeNode = current_node;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String getFullDisplay() {
        return this.value;
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getToolTipText() {
        return "@" + this.name + " = \"" + this.value + "\"";
    }

    @Override
    public Vector getChildren() {
        return this.children;
    }

    @Override
    public void addChild(XTTTreeNodeInterface child) {
    }

    @Override
    public void addNextSibling(XTTTreeNodeInterface node) {
        int parent_children_size = this.parent.getChildren().size();
        int break_line = -1;
        XTTTreeNodeInterface childXTT = null;
        for (int i = 0; i < parent_children_size; ++i) {
            childXTT = (XTTTreeNodeInterface)this.parent.getChildren().elementAt(i);
            if (!(childXTT instanceof QueryElement)) continue;
            break_line = i;
            break;
        }
        Vector v = this.parent.getChildren();
        int index = v.indexOf(this);
        if (break_line == -1) {
            break_line = parent_children_size;
        }
        if (index > break_line) {
            if (node instanceof QueryElement) {
                v.add(index + 1, node);
            } else if (node instanceof Attribute) {
                v.add(break_line, node);
            }
        } else if (node instanceof QueryElement) {
            v.add(break_line, node);
        } else if (node instanceof Attribute) {
            v.add(index + 1, node);
        }
        node.setParent(this.parent);
    }

    @Override
    public void remove(XTTTreeNodeInterface node) {
        node.setParent(null);
        this.children.remove(node);
    }

    @Override
    public void setChildren(Vector v) {
        this.children = v;
    }

    @Override
    public XTTTreeNodeInterface getParent() {
        return this.parent;
    }

    @Override
    public void setParent(XTTTreeNodeInterface node) {
        this.parent = node;
    }

    @Override
    public XTTTreeNodeInterface shorten() {
        return this;
    }

    @Override
    public AbstractDisplayPanel[] getDisplayComponent() {
        AbstractDisplayPanel[] a0 = new AbstractDisplayPanel[]{new AttributeMainPanel(this), new AttributeDisplayPanel(this)};
        return a0;
    }

    @Override
    public String getValue(short variable) {
        switch (variable) {
            case 5: {
                return this.null_handling;
            }
            case 6: {
                return this.lo_mode;
            }
        }
        return "";
    }

    @Override
    public void setValue(short variable, String value) {
        boolean b = false;
        switch (variable) {
            case 5: {
                if (this.null_handling.equalsIgnoreCase(value)) break;
                String originalValue = this.null_handling;
                this.null_handling = value;
                b = true;
                DisplaySettingUndoEdit edit = new DisplaySettingUndoEdit(this, originalValue, "value", true, variable);
                XTTFrame.frame.undoSupport.postEdit(edit);
                XTTFrame.frame.menubar.setUndoEnabled(true);
                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
                break;
            }
            case 6: {
                if (this.lo_mode.equalsIgnoreCase(value)) break;
                String originalValue = this.lo_mode;
                this.lo_mode = value;
                b = true;
                DisplaySettingUndoEdit edit = new DisplaySettingUndoEdit(this, originalValue, "value", true, variable);
                XTTFrame.frame.undoSupport.postEdit(edit);
                XTTFrame.frame.menubar.setUndoEnabled(true);
                XTTFrame.frame.from = XTTFrame.frame.undoManager.getUndoQueueSize();
            }
        }
        if (b) {
            XTTFrame.setXTTModified(true);
            XTTFrame.xttRefresh_xttCombo();
        }
    }

    public void scanTree4Generate() {
        if (this.value != null && this.value.length() > 0) {
            Vector v = new Vector();
            this.getColumnData(v);
            int size = v.size();
            if (size > 0) {
                ColumnObject co = null;
                Object obj = null;
                String s = null;
                for (int i = 0; i < size; ++i) {
                    obj = v.elementAt(i);
                    if (obj instanceof ColumnObject) {
                        co = (ColumnObject)obj;
                        s = co.getQueryObject();
                    } else {
                        s = obj.toString();
                    }
                    if (!this.value.equals(s)) continue;
                    this.xsdType = XTTFrame.mapDB2XSD(co.getType());
                    break;
                }
            }
        }
    }

    public void getColumnData(Vector v, boolean scanTemplate, boolean isValidation) {
        XTTTreeNodeInterface xtt2 = this.getParent();
        if (xtt2 instanceof QueryElement) {
            ((QueryElement)xtt2).getColumnData(v, scanTemplate, isValidation);
        }
        if (scanTemplate && xtt2 instanceof Template) {
            ((Template)xtt2).getParameterObject(v);
        }
    }

    public void getColumnData(Vector v) {
        this.getColumnData(v, false, false);
    }

    @Override
    public String write(int space_count) {
        String attributeStr = "";
        attributeStr = attributeStr + XTTUt.buildSpaceString(space_count += 2) + "<xtt:attribute name=\"" + this.name + "\"";
        if (this.getValue().trim().length() > 0) {
            attributeStr = attributeStr + " value=\"" + XTTUt.mapXMLData(this.getValue(), true) + "\"";
        }
        if (this.null_handling.trim().length() > 0) {
            attributeStr = attributeStr + " xtt:null_handling=\"" + this.null_handling + "\"";
        }
        if (this.lo_mode.trim().length() > 0) {
            attributeStr = attributeStr + " xtt:lo_mode=\"" + this.lo_mode + "\"";
        }
        attributeStr = attributeStr + "/>\n";
        return attributeStr;
    }

    @Override
    public void buildLinkDataVector(Vector inputVector) {
        Vector v;
        if (!this.value.equalsIgnoreCase(this.link_value) && (v = QueryParser.getVariables(this.link_value)).size() > 0) {
            inputVector.addAll(v);
        }
        if (this.children == null) {
            return;
        }
        int children_size = this.children.size();
        XTTTreeNodeInterface childXTT = null;
        for (int j = 0; j < children_size; ++j) {
            childXTT = (XTTTreeNodeInterface)this.children.elementAt(j);
            childXTT.buildLinkDataVector(inputVector);
        }
    }

    @Override
    public void findInvalidNode(Vector errorVector) {
        if (this.value != null && this.value.length() > 0) {
            Vector v = QueryParser.getVariables(this.value);
            if (v.size() <= 0) {
                return;
            }
            Vector queryColumnVector = new Vector();
            this.getColumnData(queryColumnVector, true, true);
            if (queryColumnVector.size() <= 0) {
                String s1 = this.res.getString("is_not_matched_in_its");
                String s2 = GuiUt.mapStringForProperty(s1, this.getValue().trim().length() > 0 ? this.getValue() : this.toString());
                InvalidElementObject ioe = new InvalidElementObject(this, s2);
                errorVector.add(ioe);
            }
            int size = v.size();
            String vectorItemStr = null;
            String queryObjectStr = null;
            boolean found = true;
            int queryColumnVector_size = queryColumnVector.size();
            Object obj = null;
            for (int i = 0; i < size; ++i) {
                vectorItemStr = v.elementAt(i).toString();
                found = true;
                for (int j = 0; j < queryColumnVector_size; ++j) {
                    obj = queryColumnVector.elementAt(j);
                    queryObjectStr = obj instanceof ColumnObject ? ((ColumnObject)obj).getQueryObject() : obj.toString();
                    if (!vectorItemStr.equalsIgnoreCase(queryObjectStr)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                String s1 = this.res.getString("is_not_existed_in_its");
                String s2 = GuiUt.mapStringForProperty(s1, this.getValue().trim().length() > 0 ? this.getValue() : this.toString());
                InvalidElementObject ioe = new InvalidElementObject(this, s2);
                errorVector.add(ioe);
            }
        }
        if (this.children == null) {
            return;
        }
        int children_size = this.children.size();
        XTTTreeNodeInterface childXTT = null;
        for (int j = 0; j < children_size; ++j) {
            childXTT = (XTTTreeNodeInterface)this.children.elementAt(j);
            childXTT.findInvalidNode(errorVector);
        }
    }

    @Override
    public boolean isExpand() {
        return false;
    }

    @Override
    public void setExpand(boolean b) {
    }

    @Override
    public XTTTreeNodeInterface duplicateSelf() {
        Attribute attr = new Attribute();
        if (this.name != null && this.name.length() > 0) {
            attr.setName(this.name);
        }
        if (this.value != null && this.value.length() > 0) {
            attr.setAttributeValue(this.value);
        }
        if (this.link_value != null && this.link_value.length() > 0) {
            attr.setLinkValue(this.link_value);
        }
        if (this.null_handling != null && this.null_handling.length() > 0) {
            attr.setNullHandling(this.null_handling);
        }
        if (this.lo_mode != null && this.lo_mode.length() > 0) {
            attr.setLoMode(this.lo_mode);
        }
        if (this.parent != null) {
            attr.setParent(this.parent);
        }
        attr.setHidden(this.isHidden);
        attr.xsdType = this.xsdType;
        return attr;
    }

    public void copy_menuitem_actionPerformed(ActionEvent e) {
        XTTFrame.frame.Copy_MenuItem_actionPerformed(e);
    }

    public void cut_menuitem_actionPerformed(ActionEvent e) {
        XTTFrame.frame.Cut_MenuItem_actionPerformed(e);
    }

    @Override
    public void showPopup(MouseEvent e) {
        JPopupMenu att_popupmenu = new JPopupMenu();
        JMenuItem element_menuitem = new JMenuItem(this.res.getString("Change_to_ELEMENT"), XMLImageResource.getResource(this.getClass(), "/xmlimages/toolbar/new_element.gif"));
        JMenuItem remove_menuitem = new JMenuItem(this.res.getString("Remove"), XMLImageResource.getResource(this.getClass(), "/xmlimages/toolbar/remove_treenode.gif"));
        JMenuItem copy_menuitem = new JMenuItem(this.res.getString("Copy"), XMLImageResource.getResource(this.getClass(), "/xmlimages/Copy24.gif"));
        copy_menuitem.addActionListener(new ReflectionAction(this, "copy_menuitem_actionPerformed"));
        JMenuItem cut_menuitem = new JMenuItem(this.res.getString("Cut"), XMLImageResource.getResource(this.getClass(), "/xmlimages/Cut24.gif"));
        cut_menuitem.addActionListener(new ReflectionAction(this, "cut_menuitem_actionPerformed"));
        element_menuitem.addActionListener(new ReflectionAction(this, "element_menuitem_actionPerformed"));
        remove_menuitem.addActionListener(new ReflectionAction(this, "remove_menuitem_actionPerformed"));
        att_popupmenu.add(element_menuitem);
        att_popupmenu.addSeparator();
        att_popupmenu.add(cut_menuitem);
        att_popupmenu.add(copy_menuitem);
        att_popupmenu.addSeparator();
        att_popupmenu.add(remove_menuitem);
        att_popupmenu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public int getTabbedIndex(String property) {
        if (property.equals("name") || property.equals("attributeValue")) {
            return 0;
        }
        return 1;
    }

    @Override
    public void localeChanged(LocaleChangeEvent e) {
        this.res = ResourceBundle.getBundle("com.syscom.xml.node.resource.Res", LocaleManager.getLocale());
    }
}

