/*
 * Decompiled with CFR 0.152.
 */
package com.syscom.ut.preference;

import com.syscom.ut.JdmConfig;
import com.syscom.ut.locale.LocaleManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import startup.ToolInfo;

public class CorePreferences {
    public final int LANGUAGE_CHOICE = 0;
    public final int LOGIN_DB_NAME = 1;
    public final int LOGIN_ID_NAME = 2;
    private static CorePreferences self = null;
    private static short language_choice = LocaleManager.getDefaultSystemLanguage();
    private static String login_db_name = "";
    private static String login_id_name = "";
    public static final String CONFIGNAME = ToolInfo.getToolConfigName();

    public CorePreferences() {
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() {
        String path = CorePreferences.getWinInstallPath();
        this.init(path + CONFIGNAME);
    }

    public static String getConfigName() {
        String path = CorePreferences.getWinInstallPath();
        return path + CONFIGNAME;
    }

    private void init(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = factory.newDocumentBuilder();
            doc = builder.parse(new File(fileName));
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (Exception e) {
            doc = this.createXmlDocument(builder);
            e.printStackTrace();
        }
        String tmp = null;
        Node node = null;
        try {
            node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom");
            if (node != null && node.getNodeType() == 1) {
                Element elm = (Element)node;
                tmp = elm.getAttribute("login_db_name");
                if (tmp != null && tmp.length() > 0) {
                    login_db_name = tmp;
                }
                if ((tmp = elm.getAttribute("login_id")) != null && tmp.length() > 0) {
                    login_id_name = tmp;
                }
                if ((tmp = elm.getAttribute("language_choice")) != null && tmp.length() > 0) {
                    language_choice = Short.parseShort(tmp);
                    if (language_choice < 0) {
                        language_choice = 0;
                    }
                }
            } else {
                doc = this.createXmlDocument(builder);
            }
        }
        catch (Exception ee) {
            doc = this.createXmlDocument(builder);
            ee.printStackTrace();
        }
    }

    public void createRootElement(Document doc) {
        Element syscom = doc.createElement("syscom");
        doc.appendChild(syscom);
    }

    public Document createXmlDocument(DocumentBuilder builder) {
        Document doc = builder.newDocument();
        this.createRootElement(doc);
        return doc;
    }

    public void resetDOM(Document doc) {
        String temp = null;
        Node node = null;
        try {
            node = XPathAPI.selectSingleNode((Node)doc, (String)"/syscom");
            if (node != null && node.getNodeType() == 1) {
                temp = ((Element)node).getAttribute("language_choice");
                if (temp != null && temp.length() > 0) {
                    language_choice = Short.parseShort(temp);
                }
                if ((temp = ((Element)node).getAttribute("login_db_name")) != null && temp.length() > 0) {
                    login_db_name = temp;
                }
                if ((temp = ((Element)node).getAttribute("login_id_name")) != null && temp.length() > 0) {
                    login_id_name = temp;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LocaleManager.getLocaleManager(CorePreferences.getLanguageChoice());
    }

    public void setDOM(Document doc) {
        Element syscom = null;
        Element root = doc.getDocumentElement();
        if (root == null) {
            syscom = doc.createElement("syscom");
            doc.appendChild(syscom);
        } else if (!root.getNodeName().equals("syscom")) {
            syscom = doc.createElement("syscom");
            doc.replaceChild(syscom, root);
        } else {
            syscom = root;
        }
        syscom.setAttribute("language_choice", Short.toString(language_choice));
        if (login_db_name != null && login_db_name.length() > 0) {
            syscom.setAttribute("login_db_name", login_db_name);
        }
        if (login_id_name != null && login_id_name.length() > 0) {
            syscom.setAttribute("login_id_name", login_id_name);
        }
    }

    public static short getLanguageChoice() {
        return language_choice;
    }

    public static void setLanguageChoice(short language) {
        language_choice = language;
    }

    public static String getLoginDbName() {
        return login_db_name;
    }

    public static void setLoginDbName(String loginDbName) {
        login_db_name = loginDbName;
    }

    public static String getLoginIdName() {
        return login_id_name;
    }

    public static void setLoginIdName(String idName) {
        login_id_name = idName;
    }

    public static String getWinInstallPath() {
        String fileSeparator = System.getProperty("file.separator");
        JdmConfig config = new JdmConfig();
        String path = config.filePath("dmconfig.ini");
        int index = path.lastIndexOf(fileSeparator);
        if (index > 0) {
            return path.substring(0, index + 1);
        }
        return "";
    }

    public static void initCorePreferences() {
        if (self == null) {
            self = new CorePreferences();
        }
    }

    public static CorePreferences getCorePreferences() {
        if (self == null) {
            self = new CorePreferences();
        }
        return self;
    }

    public void updateAttributes(Document doc, String attributeData, int options, boolean fileExist) {
        Element element = null;
        if (fileExist) {
            NodeList nl = doc.getElementsByTagName("syscom");
            if (nl.getLength() > 0) {
                element = (Element)nl.item(0);
            }
            switch (options) {
                case 0: {
                    if (attributeData == null || attributeData.length() <= 0) break;
                    element.setAttribute("language_choice", attributeData);
                    language_choice = Short.parseShort(attributeData);
                    break;
                }
                case 1: {
                    if (attributeData == null || attributeData.length() <= 0) break;
                    element.setAttribute("login_db_name", attributeData);
                    login_db_name = attributeData;
                    break;
                }
                case 2: {
                    if (attributeData == null || attributeData.length() <= 0) break;
                    element.setAttribute("login_id_name", attributeData);
                    login_id_name = attributeData;
                }
            }
        } else {
            element = doc.createElement("syscom");
            switch (options) {
                case 0: {
                    element.setAttribute("language_choice", Short.toString(language_choice));
                    break;
                }
                case 1: {
                    if (login_db_name == null || login_db_name.length() <= 0) break;
                    element.setAttribute("login_db_name", login_db_name);
                    break;
                }
                case 2: {
                    if (login_id_name == null || login_id_name.length() <= 0) break;
                    element.setAttribute("login_id_name", login_id_name);
                }
            }
        }
    }

    private void save(String fileName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = null;
        Element syscom_element = null;
        File file = new File(fileName);
        if (file.exists()) {
            doc = builder.parse(file);
            NodeList nl = doc.getElementsByTagName("syscom");
            if (nl.getLength() > 0) {
                syscom_element = (Element)nl.item(0);
            }
        } else {
            doc = builder.newDocument();
            syscom_element = doc.createElement("syscom");
            doc.appendChild(syscom_element);
        }
        syscom_element.setAttribute("language_choice", Short.toString(language_choice));
        if (login_db_name != null && login_db_name.length() > 0) {
            syscom_element.setAttribute("login_db_name", login_db_name);
        }
        if (login_id_name != null && login_id_name.length() > 0) {
            syscom_element.setAttribute("login_id_name", login_id_name);
        }
        FileOutputStream fos = new FileOutputStream(file);
        DefaultSAXOutputHandler handler = new DefaultSAXOutputHandler((OutputStream)fos, "UTF-8");
        TreeWalker tw = new TreeWalker((ContentHandler)handler);
        tw.traverse((Node)doc);
        fos.close();
    }

    public void save() throws Exception {
        this.save(CorePreferences.getConfigName());
    }
}

