/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.ImageServer;
import com.sun.media.jai.rmi.JAIRMIImageServer;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class RenderableRMIServerProxy
implements RenderableImage {
    private String serverName;
    private String operationName;
    private ParameterBlock paramBlock;
    private ImageServer imageServer;
    public Long id;
    private static final Class NULL_PROPERTY_CLASS = JAIRMIImageServer.NULL_PROPERTY.getClass();

    public RenderableRMIServerProxy(String string, String string2, ParameterBlock parameterBlock, Long l) {
        this.serverName = string;
        this.operationName = string2;
        this.paramBlock = parameterBlock;
        this.imageServer = this.getImageServer(string);
        this.id = l;
    }

    public Vector getSources() {
        return null;
    }

    public Object getProperty(String string) throws RemoteImagingException {
        try {
            Object object = this.imageServer.getProperty(this.id, string);
            if (NULL_PROPERTY_CLASS.isInstance(object)) {
                object = Image.UndefinedProperty;
            }
            return object;
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public String[] getPropertyNames() throws RemoteImagingException {
        try {
            return this.imageServer.getPropertyNames(this.id);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public boolean isDynamic() throws RemoteImagingException {
        try {
            return this.imageServer.isDynamic(this.id);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public float getWidth() throws RemoteImagingException {
        try {
            return this.imageServer.getRenderableWidth(this.id);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public float getHeight() throws RemoteImagingException {
        try {
            return this.imageServer.getRenderableHeight(this.id);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public float getMinX() throws RemoteImagingException {
        try {
            return this.imageServer.getRenderableMinX(this.id);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public float getMinY() throws RemoteImagingException {
        try {
            return this.imageServer.getRenderableMinY(this.id);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public Long getRMIID() {
        return this.id;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) throws RemoteImagingException {
        SerializableState serializableState = SerializerFactory.getState(renderingHints, null);
        try {
            return this.imageServer.createScaledRendering(this.id, n, n2, serializableState);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public RenderedImage createDefaultRendering() throws RemoteImagingException {
        try {
            return this.imageServer.createDefaultRendering(this.id);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    public RenderedImage createRendering(RenderContext renderContext) throws RemoteImagingException {
        SerializableState serializableState = SerializerFactory.getState(renderContext, null);
        try {
            return this.imageServer.createRendering(this.id, serializableState);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
    }

    protected synchronized ImageServer getImageServer(String string) {
        if (this.imageServer == null) {
            if (string == null) {
                try {
                    string = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception exception) {
                    throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
                }
            }
            String string2 = new String("rmi://" + string + "/" + "JAIRMIRemoteServer1.1");
            this.imageServer = null;
            try {
                this.imageServer = (ImageServer)Naming.lookup(string2);
            }
            catch (Exception exception) {
                throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
            }
        }
        return this.imageServer;
    }
}

