/*
 * Decompiled with CFR 0.152.
 */
package wizard.tablespace;

import dbatool.DatabaseConnection;
import dbatool.DbFrame;
import dbatool.HelpButton;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.Logical_file;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import wizard.tablespace.Panel_ts1;
import wizard.tablespace.Panel_ts2;
import wizard.tablespace.Panel_ts3;
import wizard.tablespace.Panel_ts4;

public class Wizard_ts
extends JDialog {
    private static final long serialVersionUID = 8020393578923184678L;
    DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("jdbaproperties.wizard.ResWizard", LocaleManager.getLocale());
    JPanel jPanel1 = new JPanel();
    DbaButton Cancel_Button = new DbaButton();
    DbaButton Next_Button = new DbaButton();
    DbaButton previous_Button = new DbaButton();
    private Vector<JPanel> panels = new Vector();
    Color sysColor = UIManager.getColor(new UIManager());
    private int cur_step = 0;
    private HelpButton help_Button = new HelpButton();
    boolean isRegular = false;

    public Wizard_ts(Frame frame) {
        super(frame);
        this.setModal(true);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Wizard_ts(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String combineSqlString() {
        int currentRowCount = 0;
        Panel_ts2 tmpPanel_ts2 = (Panel_ts2)this.panels.elementAt(1);
        Panel_ts3 tmpPanel_ts3 = (Panel_ts3)this.panels.elementAt(2);
        currentRowCount = tmpPanel_ts3.jTable1.getRowCount();
        String sqlString = "Create ";
        String tsName = tmpPanel_ts2.tableSpace_TextField.getText();
        if (tmpPanel_ts2.autoExtended_RadioButton.isSelected()) {
            sqlString = sqlString + "autoextend ";
        }
        sqlString = sqlString + "tablespace " + GuiUt.getIDString(tsName) + " datafile ";
        if (tmpPanel_ts3.jTable1.getValueAt(currentRowCount - 1, 0).toString().equalsIgnoreCase("")) {
            --currentRowCount;
        }
        String tmpStr = "";
        for (int i = 0; i < currentRowCount; ++i) {
            String logName = tmpPanel_ts3.jTable1.getValueAt(i, 0).toString();
            String phyName = tmpPanel_ts3.jTable1.getValueAt(i, 1).toString();
            String size = tmpPanel_ts3.jTable1.getValueAt(i, 2).toString();
            String type = tmpPanel_ts3.jTable1.getValueAt(i, 3).toString();
            if (i > 0) {
                tmpStr = tmpStr + ", ";
            }
            tmpStr = tmpStr + GuiUt.getIDString(logName);
            if (type.equals("BLOB")) {
                tmpStr = tmpStr + " type=BLOB";
            }
            if (logName.length() > 0 && phyName.length() > 0 && size.length() > 0) {
                String offset;
                JdmConfig config = new JdmConfig();
                int rc = config.fileOpen("dmconfig.ini", DbFrame.conn_DatabaseConnection.dbname, "r+");
                if (rc != 0) {
                    System.out.println("error open dmconfig.ini for logical file " + logName);
                    continue;
                }
                Logical_file logfile = null;
                logfile = GuiUt.isWindows() ? new Logical_file(phyName, size) : ((offset = tmpPanel_ts3.jTable1.getValueAt(i, 3).toString()).trim().length() <= 0 ? new Logical_file(phyName, size) : new Logical_file(null, phyName, size, offset));
                rc = config.insertPara(logName, logfile, 53760);
                if (rc != 0) {
                    System.out.println("error write to dmconfig.ini for logical file " + logName + " phyname=" + logfile.getFilename() + " size=" + logfile.getPagenum());
                }
                config.fileClose();
                continue;
            }
            System.out.println("logName=" + logName + " phyName=" + phyName + " size=" + size + ".");
        }
        sqlString = sqlString + tmpStr;
        return sqlString;
    }

    void setHelpId(int step) {
        String[] ids = new String[]{"Wizard_ts_StepOneHelpIDInformation", "Wizard_ts_StepTwoHelpIDInformation", "Wizard_ts_StepThreeHelpIDInformation", "Wizard_ts_StepFourHelpIDInformation"};
        if (step < 0 || step >= ids.length) {
            return;
        }
        DbFrame.frame.enableDialogHelp(this.getRootPane(), this.help_Button, ids[step], null);
    }

    void jbInit() throws Exception {
        this.setName("TablespaceDialogWizard");
        this.Next_Button.setName("NextButton");
        this.Cancel_Button.setName("CancelButton");
        this.jPanel1.setLayout(new BorderLayout());
        this.Next_Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wizard_ts.this.Next_Button_actionPerformed(e);
                if (Wizard_ts.this.cur_step == 2) {
                    Panel_ts2 myTs2 = (Panel_ts2)Wizard_ts.this.panels.elementAt(Wizard_ts.this.cur_step - 1);
                    if (myTs2.tableSpace_TextField.getText().equalsIgnoreCase("")) {
                        Wizard_ts.this.Next_Button.setEnabled(false);
                    } else {
                        Wizard_ts.this.Next_Button.setEnabled(true);
                    }
                }
            }
        });
        this.previous_Button.addActionListener(new ReflectionAction(this, "previous_Button_actionPerformed"));
        this.Cancel_Button.addActionListener(new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        this.previous_Button.setMnemonic('P');
        this.Next_Button.setHorizontalTextPosition(2);
        this.Next_Button.setMnemonic('N');
        this.Cancel_Button.setMnemonic('C');
        this.help_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/help.gif"));
        this.getContentPane().add(this.jPanel1);
        this.setTitle(this.res.getString("Create_Tablespace_Wizard"));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setPreferredSize(new Dimension(640, 480));
        this.Cancel_Button.setText(this.res.getString("Cancel"));
        this.Next_Button.setText(this.res.getString("Next_"));
        this.previous_Button.setText(this.res.getString("_Previous"));
        this.previous_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/previous.gif"));
        this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/next.gif"));
        this.Cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/cancelwizard.gif"));
        if (this.cur_step == 0) {
            this.panels.add(this.cur_step, new Panel_ts1(this));
            this.jPanel1.add((Component)((Panel_ts1)this.panels.elementAt(this.cur_step)), "Center");
            this.previous_Button.setEnabled(false);
            this.setHelpId(this.cur_step);
            ++this.cur_step;
        }
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.add(this.previous_Button);
        bottomPanel.add(this.Next_Button);
        bottomPanel.add(this.Cancel_Button);
        bottomPanel.add(this.help_Button);
        this.jPanel1.add((Component)bottomPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Wizard_ts.this.Cancel_Button_actionPerformed(null);
            }
        });
    }

    private boolean checkTbl(Panel_ts3 paraTS3) {
        int i;
        boolean isReasonable = true;
        Panel_ts3 ts3 = paraTS3;
        for (i = ts3.model.getRowCount() - 1; i > 0; --i) {
            if (!ts3.model.getValueAt(i, 0).toString().trim().equalsIgnoreCase("") || !ts3.model.getValueAt(i, 1).toString().trim().equalsIgnoreCase("")) continue;
            ts3.model.removeValue(i);
        }
        for (i = 0; i <= ts3.model.getRowCount() - 1; ++i) {
            if (!ts3.model.getValueAt(i, 0).toString().trim().equalsIgnoreCase("") && !ts3.model.getValueAt(i, 1).toString().trim().equalsIgnoreCase("") && !ts3.model.getValueAt(i, 2).toString().trim().equalsIgnoreCase("")) continue;
            isReasonable = false;
            break;
        }
        return isReasonable;
    }

    private boolean checkLogicalName(Panel_ts3 paraTS3) {
        boolean isReasonable = true;
        Panel_ts3 ts3 = paraTS3;
        for (int i = 0; i <= ts3.model.getRowCount() - 1; ++i) {
            String logicalName = ts3.model.getValueAt(i, 0).toString().trim();
            Pattern pat = Pattern.compile("[\\w@#$&*]+");
            Matcher mat = pat.matcher(logicalName);
            if (mat.matches()) continue;
            isReasonable = false;
            break;
        }
        return isReasonable;
    }

    void Next_Button_actionPerformed(ActionEvent e) {
        JPanel cur_panel = this.panels.elementAt(this.cur_step - 1);
        if (cur_panel instanceof Panel_ts4) {
            Panel_ts4 tmp_Panel_ts4 = (Panel_ts4)cur_panel;
            String s = tmp_Panel_ts4.jEditorPane1.getText();
            if (DatabaseConnection.executeSQL(this, s, false)) {
                GuiUt.showInformationDlg(this, this.res.getString("Create_Tablespace_Success_"));
                this.setVisible(false);
                Panel_ts2 p = (Panel_ts2)this.panels.elementAt(1);
                p.tableSpace_TextField.getText();
                this.panels.removeAllElements();
                this.dispose();
            }
        } else {
            switch (this.cur_step) {
                case 1: {
                    if (this.cur_step == this.panels.size()) {
                        this.panels.add(this.cur_step, new Panel_ts2(this));
                    }
                    this.jPanel1.remove((Panel_ts1)this.panels.elementAt(this.cur_step - 1));
                    this.jPanel1.add((Component)((Panel_ts2)this.panels.elementAt(this.cur_step)), "Center");
                    this.setTitle(this.res.getString("Create_Tablespace_Wizard_Name_the_Tablespace"));
                    break;
                }
                case 2: {
                    Panel_ts2 TS2 = (Panel_ts2)this.panels.elementAt(this.cur_step - 1);
                    if (DbFrame.conn_DatabaseConnection.isTablespaceNameExist(TS2.tableSpace_TextField.getText().trim())) {
                        GuiUt.showWarningDlg(this, this.res.getString("Warning"), TS2.tableSpace_TextField.getText().trim() + " " + this.res.getString("already_exist"));
                        --this.cur_step;
                        break;
                    }
                    if (this.cur_step == this.panels.size()) {
                        this.panels.add(this.cur_step, new Panel_ts3(this));
                    }
                    this.jPanel1.remove((Panel_ts2)this.panels.elementAt(this.cur_step - 1));
                    this.jPanel1.add((Component)((Panel_ts3)this.panels.elementAt(this.cur_step)), "Center");
                    this.setTitle(this.res.getString("Create_Tablespace_Wizard_Add_file_to_the_Tablespace"));
                    break;
                }
                case 3: {
                    Panel_ts3 tmp_Panel_ts3 = (Panel_ts3)this.panels.elementAt(this.cur_step - 1);
                    tmp_Panel_ts3.jTable1.editingStopped(null);
                    tmp_Panel_ts3.parentWizard.isRegular = this.isRegular;
                    if (tmp_Panel_ts3.error) {
                        --this.cur_step;
                        tmp_Panel_ts3.error = false;
                        break;
                    }
                    if (!this.checkTbl(tmp_Panel_ts3)) {
                        GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("Please_enter_tablespace_information"));
                        --this.cur_step;
                        break;
                    }
                    if (!this.checkLogicalName(tmp_Panel_ts3)) {
                        GuiUt.showWarningDlg(this, this.res.getString("Warning"), this.res.getString("Please_input_legal_character"));
                        --this.cur_step;
                        break;
                    }
                    Panel_ts4 tmp_Panel_ts4 = null;
                    if (this.cur_step == this.panels.size()) {
                        tmp_Panel_ts4 = new Panel_ts4(this);
                        this.panels.add(this.cur_step, tmp_Panel_ts4);
                    } else {
                        tmp_Panel_ts4 = (Panel_ts4)this.panels.elementAt(this.cur_step);
                    }
                    tmp_Panel_ts4.jEditorPane1.setText(this.combineSqlString());
                    this.jPanel1.remove((Panel_ts3)this.panels.elementAt(this.cur_step - 1));
                    this.jPanel1.add((Component)((Panel_ts4)this.panels.elementAt(this.cur_step)), "Center");
                    this.Next_Button.setText(this.res.getString("Finish"));
                    this.Next_Button.setName("FinishButton");
                    this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"));
                    this.Next_Button.setMnemonic('F');
                    this.setTitle(this.res.getString("Create_Tablespace_Wizard_Final_review"));
                }
            }
            this.previous_Button.setEnabled(true);
            this.jPanel1.revalidate();
            this.jPanel1.repaint();
            this.setHelpId(this.cur_step);
            ++this.cur_step;
        }
    }

    public void previous_Button_actionPerformed(ActionEvent e) {
        --this.cur_step;
        this.setHelpId(this.cur_step - 1);
        if (this.cur_step == 1) {
            this.jPanel1.remove((Panel_ts2)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_ts1)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.previous_Button.setEnabled(false);
            this.Next_Button.setEnabled(true);
            this.setTitle(this.res.getString("Create_Tablespace_Wizard"));
        } else if (this.cur_step == 2) {
            this.jPanel1.remove((Panel_ts3)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_ts2)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.setTitle(this.res.getString("Create_Tablespace_Wizard_Name_the_Tablespace"));
        } else if (this.cur_step == 3) {
            this.jPanel1.remove((Panel_ts4)this.panels.elementAt(this.cur_step));
            this.jPanel1.add((Component)((Panel_ts3)this.panels.elementAt(this.cur_step - 1)), "Center");
            this.setTitle(this.res.getString("Create_Tablespace_Wizard_Add_file_to_the_Tablespace"));
        }
        this.Next_Button.setText(this.res.getString("Next_"));
        this.Next_Button.setName("NextButton");
        this.Next_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/jdbaimages/next.gif"));
        this.Next_Button.setMnemonic('N');
        this.jPanel1.revalidate();
        this.jPanel1.repaint();
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        if (this.panels.size() > 2) {
            Panel_ts3 tmp_ts3 = (Panel_ts3)this.panels.elementAt(2);
            int size = tmp_ts3.model.getRowCount();
            JdmConfig config = new JdmConfig();
            String logical_name = null;
            String physical_name = null;
            File f = null;
            int rc = config.fileOpen("dmconfig.ini", DbFrame.conn_DatabaseConnection.dbname, "r+");
            for (int i = 0; i < size && rc == 0; ++i) {
                logical_name = (String)tmp_ts3.model.getValueAt(i, 0);
                if (logical_name.length() > 0) {
                    rc = config.procDelete(logical_name, 0);
                }
                physical_name = (String)tmp_ts3.model.getValueAt(i, 1);
                f = new File(physical_name);
                f.delete();
            }
            config.fileClose();
        }
        this.setVisible(false);
        this.panels.removeAllElements();
        this.dispose();
    }
}

