/*
 * Decompiled with CFR 0.152.
 */
package svrmgrwizard.backup;

import ServerMgr.DatabaseConnection;
import ServerMgr.SmFrame;
import ServerMgr.SmHelpButton;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.DbaObject;
import dbaut.DbaUtDef;
import dbaut.GuiUt;
import dbaut.JBackupHistory;
import dbaut.JdmConfig;
import dbaut.String_array;
import dbaut.comp.DbaButton;
import dbaut.comp.DbaTable;
import dbaut.comp.ProgressDialog;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import dbaut.svrmgrlib;
import dbaut.system.BackupFile;
import dbaut.textField.FilePathField;
import dbaut.util.JavaTypeUtil;
import dbmaker.sql.JdbcOdbcConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import svrmgrwizard.backup.BackupConstants;
import svrmgrwizard.backup.BackupDlg;
import svrmgrwizard.backup.FullBackupTableModel;
import svrmgrwizard.backup.exception.CopyFileErrorException;
import svrmgrwizard.backup.exception.DeleteFileFailedException;
import svrmgrwizard.backup.exception.UserCancelException;

public class OnlineFullBackupPanel
extends AbstractWizardPanel {
    private static final long serialVersionUID = -2127470613766322757L;
    public static final short LOGICAL_NAME = 0;
    public static final short PHYSICAL_NAME = 1;
    public static final short DESTINATION = 2;
    public static final short FILE_TYPE = 3;
    public static final short DATA_FILE = 0;
    public static final short JOURNAL_FILE = 1;
    private BackupDlg parentDialog = null;
    private AbstractWizardPanel previousPanel = null;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("svrmgrproperties.svrmgr.BackupRes", LocaleManager.getLocale());
    private String title = null;
    private SmHelpButton helpButton = new SmHelpButton();
    private DbaButton cancelButton = new DbaButton(new Dimension(80, 24), this.res.getString("Cancel"), 'C', DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"), new ReflectionAction(this, "cancelButtonActionPerformed"));
    private DbaButton finishButton = new DbaButton(new Dimension(80, 24), this.res.getString("Finish"), 'F', DBAImageResource.getResource(this.getClass(), "/dbautimages/finish.gif"), new ReflectionAction(this, "finishButtonActionPerformed"));
    private DbaButton previousButton = new DbaButton(new Dimension(80, 24), this.res.getString("Previous"), 'P', DBAImageResource.getResource(this.getClass(), "/dbautimages/previous.gif"), new ReflectionAction(this, "previousButtonActionPerformed"));
    private JLabel backupDestinationLabel = new JLabel(this.res.getString("Backup_Directory_Colon"));
    private FilePathField backupDestinationField = new FilePathField(this, "", this.res.getString("Select_Path"), true);
    private JRadioButton nonBackup = new JRadioButton(this.res.getString("Turn_Off_Backup_Mode"));
    private JRadioButton backupData = new JRadioButton(this.res.getString("Backup_Data"));
    private JRadioButton backupDataBlob = new JRadioButton(this.res.getString("Backup_Data_And_Blob"));
    private JCheckBox isWriteToConfig = new JCheckBox(this.res.getString("Write_To_Dmconfig"));
    private FullBackupTableModel model = new FullBackupTableModel();
    private DbaTable table = new DbaTable(this.model);
    private DatabaseConnection connection = null;
    private ArrayList connectionInfo = null;
    private String dbName = null;
    private String db_bkdir = null;
    private Integer db_bkzip = null;
    private int option = -1;
    private int bmode = -1;
    private svrmgrlib cfun = new svrmgrlib();

    public OnlineFullBackupPanel(BackupDlg parentDialog, AbstractWizardPanel previousPanel, DatabaseConnection connection, ArrayList connectionInfo) {
        this.parentDialog = parentDialog;
        this.previousPanel = previousPanel;
        this.connection = connection;
        this.connectionInfo = connectionInfo;
        if (this.connectionInfo.size() <= 0) {
            System.out.println("No connection information." + this.getClass().getName());
            return;
        }
        this.dbName = (String)this.connectionInfo.get(0);
        try {
            CallableStatement cstmt = connection.dbconn.prepareCall("{call GETSYSTEMOPTION('bkzip', ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.execute();
            this.db_bkzip = JavaTypeUtil.valueOfInteger(cstmt.getString(1), this.parentDialog);
            cstmt.close();
            this.init();
        }
        catch (SQLException e) {
            GuiUt.showErrorDlg(this.parentDialog, e.getMessage(), "");
        }
    }

    private void init() throws SQLException {
        this.setName("OnlineFullBackupPanel");
        this.finishButton.setName("FinishButton");
        this.nonBackup.setName("NoBackupRadioButton");
        this.backupData.setName("BackupDataRadioButton");
        this.backupDataBlob.setName("BackupDataBlobButton");
        this.isWriteToConfig.setName("WriteToConfigCheckBox");
        JPanel jPanel1 = new JPanel();
        jPanel1.setPreferredSize(new Dimension(640, 440));
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        jPanel1.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        JPanel destinationPanel = new JPanel(new FlowLayout(0));
        destinationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Destination"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.backupDestinationField.setBorder(BorderFactory.createLoweredBevelBorder());
        this.backupDestinationField.setPreferredSize(new Dimension(440, 24));
        this.backupDestinationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OnlineFullBackupPanel.this.backupDestinationFieldKeyReleased();
            }
        });
        destinationPanel.add(this.backupDestinationLabel);
        destinationPanel.add(this.backupDestinationField);
        JPanel backupModePanel = new JPanel(new BorderLayout());
        backupModePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Backup_Mode"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JPanel tmpPanel = new JPanel(new FlowLayout(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.nonBackup);
        bg.add(this.backupData);
        bg.add(this.backupDataBlob);
        tmpPanel.add(this.nonBackup);
        tmpPanel.add(this.backupData);
        tmpPanel.add(this.backupDataBlob);
        backupModePanel.add((Component)tmpPanel, "Center");
        this.isWriteToConfig.setSelected(true);
        backupModePanel.add((Component)this.isWriteToConfig, "East");
        topPanel.add(destinationPanel);
        topPanel.add(backupModePanel);
        JPanel tableContentsPanel = new JPanel(new BorderLayout());
        tableContentsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1, true), this.res.getString("Backup_Contents"), 1, 2), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JScrollPane tableContentsScrollPane = new JScrollPane();
        tableContentsScrollPane.setBorder(BorderFactory.createEtchedBorder());
        tableContentsScrollPane.getViewport().add(this.table);
        tableContentsPanel.add(tableContentsScrollPane);
        jPanel1.add((Component)topPanel, "North");
        jPanel1.add((Component)tableContentsPanel, "Center");
        this.add((Component)jPanel1, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.finishButton.setHorizontalTextPosition(2);
        this.cancelButton.setHorizontalTextPosition(2);
        SmFrame.frame.enableDialogHelp(this.getRootPane(), this.helpButton, "Help_Backup_OnlineFullBackupPanel", null);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(this.finishButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        this.setButtonBar(buttonPanel);
        this.initBackupDir();
        this.initBackupMode();
        this.initColumnSizes(this.table);
        this.initTableContents();
        this.setFinishButtonStatus();
    }

    private void backupDestinationFieldKeyReleased() {
        this.table.editingStopped(null);
        String current_bkdir = this.backupDestinationField.getText();
        if (current_bkdir.endsWith(BackupConstants.FILE_SEPARATOR)) {
            current_bkdir = current_bkdir.substring(0, current_bkdir.length() - 1);
        }
        if (!current_bkdir.equals(this.db_bkdir)) {
            String bk_file = null;
            for (int j = 0; j < this.model.getRowCount(); ++j) {
                bk_file = (String)this.model.getValueAt(j, 2);
                bk_file = this.replacePath(bk_file, this.db_bkdir, current_bkdir);
                this.model.setValueAt(bk_file, j, 2);
            }
            this.model.fireTableChanged(new TableModelEvent(this.model));
            this.db_bkdir = current_bkdir;
        }
        this.setFinishButtonStatus();
    }

    private String replacePath(String filename, String origPath, String replacePath) {
        int i = filename.lastIndexOf(BackupConstants.FILE_SEPARATOR);
        String temp = filename.substring(0, i);
        if (temp.equals(origPath)) {
            return replacePath + filename.substring(i);
        }
        return filename;
    }

    private void initBackupDir() throws SQLException {
        this.db_bkdir = JdmConfig.getOnlineBackupDir(this.dbName, this.connection.dbconn);
        this.backupDestinationField.setText(this.db_bkdir);
    }

    private void initBackupMode() {
        try {
            this.bmode = ((JdbcOdbcConnection)this.connection.dbconn).getOptionInt(1120);
            if (this.bmode == 0) {
                this.nonBackup.setSelected(true);
            } else if (this.bmode == 1) {
                this.backupData.setSelected(true);
            } else {
                this.backupDataBlob.setSelected(true);
                this.backupData.setEnabled(false);
            }
        }
        catch (SQLException e) {
            GuiUt.showErrorDlg(this.parentDialog, e.getMessage(), "");
        }
    }

    public int getBackupMode() {
        int backupMode = -1;
        backupMode = this.nonBackup.isSelected() ? 0 : (this.backupData.isSelected() ? 1 : 2);
        return backupMode;
    }

    private void initTableContents() {
        this.getDmConfigBackupInfo("dmconfig.ini");
        this.getDataFileBackupInfo(this.db_bkzip);
        this.getJournalFileBackupInfo(this.dbName, this.db_bkzip);
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void getDmConfigBackupInfo(String fileName) {
        JdmConfig dmConfig = new JdmConfig();
        String dmConfigFilePath = dmConfig.filePath(fileName);
        String tmpFileName = null;
        if (dmConfigFilePath != null && dmConfigFilePath.length() > 0) {
            int index = dmConfigFilePath.lastIndexOf(BackupConstants.FILE_SEPARATOR);
            tmpFileName = dmConfigFilePath.substring(index + 1);
        }
        Object[] one_row = new Object[]{"CONFIG", dmConfigFilePath, this.db_bkdir + BackupConstants.FILE_SEPARATOR + tmpFileName, new Short(0)};
        this.model.addValue(one_row);
    }

    private String getFullBackupFileName(String fileName) {
        long nowMillis = System.currentTimeMillis();
        fileName = "F" + nowMillis + "_" + fileName;
        return fileName;
    }

    private void getDataFileBackupInfo(int db_bkzip) {
        String temp = null;
        Statement stmt = null;
        try {
            stmt = this.connection.dbconn.createStatement();
            String query = "select FILE_NAME, GETFILENAME(FILE_NAME) from SYSTEM.SYSFILE where FILE_NAME not in ('SYSJNL', 'DB_TMPDB', 'DB_TMPBB')";
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                Object[] one_row = new Object[4];
                temp = rs.getString(1);
                one_row[0] = rs.wasNull() ? "" : temp.trim();
                temp = rs.getString(2);
                String physical_name = rs.wasNull() ? "" : temp.trim();
                one_row[1] = physical_name;
                int index = physical_name.lastIndexOf(BackupConstants.FILE_SEPARATOR);
                if (index > 0) {
                    physical_name = new String(physical_name.substring(index + BackupConstants.FILE_SEPARATOR_LEN));
                }
                String tmpDes = this.db_bkdir + BackupConstants.FILE_SEPARATOR + physical_name;
                if (db_bkzip == 1) {
                    tmpDes = tmpDes + ".gz";
                }
                one_row[2] = tmpDes;
                one_row[3] = new Short(0);
                this.model.addValue(one_row);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException sqle) {
            GuiUt.showSQLException(this, null, sqle);
            DbaObject.close(stmt);
        }
    }

    private void getJournalFileBackupInfo(String dbName, int db_bkzip) {
        String dbDir = JdmConfig.getDBDir(dbName);
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen("dmconfig.ini", dbName, "r");
        if (rc != 0) {
            return;
        }
        String_array files = (String_array)config.getPara("DB_JNFIL", 53504);
        config.fileClose();
        for (int i = 0; i < files.size(); ++i) {
            String str = files.content[i];
            if (str.length() == 0) continue;
            int g = str.lastIndexOf(BackupConstants.FILE_SEPARATOR);
            String filename = g >= 0 ? new String(str.substring(g + 1)) : str;
            Object[] one_row = new Object[4];
            one_row[0] = "SYSJNL";
            one_row[1] = g >= 0 ? str : dbDir + BackupConstants.FILE_SEPARATOR + filename;
            String tmpDes = this.db_bkdir + BackupConstants.FILE_SEPARATOR + filename;
            if (db_bkzip == 1) {
                tmpDes = tmpDes + ".gz";
            }
            one_row[2] = tmpDes;
            one_row[3] = new Short(1);
            this.model.addValue(one_row);
        }
    }

    private void initColumnSizes(JTable table) {
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(200);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(300);
    }

    public void previousButtonActionPerformed(ActionEvent e) {
        this.parentDialog.next(this.previousPanel);
    }

    public void finishButtonActionPerformed(ActionEvent e) {
        int i;
        int rowCount = this.model.getRowCount();
        String fileFullPath = null;
        File tmpFile = null;
        long len = 0L;
        int j = this.model.getColumnCount();
        for (i = 0; i < j; ++i) {
            String str = (String)this.model.getValueAt(i, 1);
            String bkstr = (String)this.model.getValueAt(i, 2);
            if (1 != this.utOverlapPath(bkstr, str)) continue;
            GuiUt.showErrorDlg(this.parentDialog, this.res.getString("some_files_would_be_covered"), "");
            return;
        }
        for (i = 0; i < rowCount; ++i) {
            fileFullPath = (String)this.model.getValueAt(i, 1);
            tmpFile = new File(fileFullPath);
            len += tmpFile.length();
        }
        final long totalLen = len;
        Thread t1 = new Thread(){

            @Override
            public void run() {
                OnlineFullBackupPanel.this.runBackupTask(totalLen);
            }
        };
        t1.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBackupTask(long len) {
        String message;
        final ProgressDialog progressDialog = new ProgressDialog(this.parentDialog, this.res.getString("Online_Full_Backup"));
        JBackupHistory hist = null;
        BackupFile bf = null;
        Statement stmt = null;
        Statement stmt1 = null;
        try {
            int rc;
            this.table.editingStopped(null);
            String backupDir = this.backupDestinationField.getText().trim();
            File file = new File(backupDir);
            this.cleanBackupFile(file);
            if (!file.exists()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        OnlineFullBackupPanel.this.option = GuiUt.showOptionDlg(OnlineFullBackupPanel.this.parentDialog, OnlineFullBackupPanel.this.res.getString("Create_Directory"), OnlineFullBackupPanel.this.res.getString("Do_You_Want_Create_Backup_Directory_QuestionMark"));
                    }
                });
                if (this.option == 0) {
                    boolean isMkDirsSuccessful = file.mkdirs();
                    if (!isMkDirsSuccessful) {
                        System.out.println("Create backup dir failed!");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GuiUt.showErrorDlg(OnlineFullBackupPanel.this.parentDialog, OnlineFullBackupPanel.this.res.getString("Create_Backup_Directory_Failed_FullStop"), "");
                            }
                        });
                        return;
                    }
                } else {
                    return;
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressDialog.show();
                }
            });
            if (!this.isMasterDB()) {
                stmt1 = this.connection.dbconn.createStatement();
                String tmpBackupDir = null;
                if (backupDir.indexOf(" ") > 0) {
                    tmpBackupDir = "\"" + backupDir + "\"";
                }
                if (tmpBackupDir == null) {
                    stmt1.execute("call SETSYSTEMOPTION('BKDIR','" + backupDir + "')");
                } else {
                    stmt1.execute("call SETSYSTEMOPTION('BKDIR','" + tmpBackupDir + "')");
                }
            }
            stmt = this.connection.dbconn.createStatement();
            stmt.execute("begin backup");
            int newBMode = this.getBackupMode();
            if (newBMode != this.bmode) {
                ((JdbcOdbcConnection)this.connection.dbconn).setOption(1120, newBMode);
            }
            this.writeToDmConfig(newBMode, backupDir);
            bf = new BackupFile();
            String logical_name = null;
            String db_file = null;
            String dest_file = null;
            File tmpFile = null;
            long fileLen = -1L;
            long workLen = -1L;
            int rowCount = this.model.getRowCount();
            boolean flag = false;
            for (int i = 0; i < rowCount; ++i) {
                logical_name = (String)this.model.getValueAt(i, 0);
                db_file = (String)this.model.getValueAt(i, 1);
                tmpFile = new File(db_file);
                fileLen = tmpFile.length();
                workLen += fileLen;
                dest_file = (String)this.model.getValueAt(i, 2);
                if (logical_name.equalsIgnoreCase("SYSJNL") && !flag) {
                    stmt.execute("end backup datafile");
                    flag = true;
                }
                if (logical_name.equalsIgnoreCase("CONFIG")) {
                    rc = JdmConfig.copyDBSection(db_file, dest_file, this.dbName);
                    if (rc != 0) {
                        throw new CopyFileErrorException(this.res.getString("copy_dbsection_failed_excalmatorymark"));
                    }
                } else {
                    boolean isSuccessful = bf.copyFile(db_file, dest_file);
                    if (!isSuccessful) {
                        throw new CopyFileErrorException(bf.copyFileErrorMessage);
                    }
                }
                int percent = (int)((double)workLen / (double)len * 100.0);
                progressDialog.setProgressBarValue(percent);
                if (!progressDialog.isCanceling()) continue;
                ProgressDialog.sem.semaphoreWait();
                progressDialog.setIsCanceling(false);
                if (!progressDialog.isUserCanceled()) continue;
                throw new UserCancelException();
            }
            stmt.execute("end backup journal");
            hist = new JBackupHistory(SmFrame.frame);
            String backupHisFileFullPath = null;
            backupHisFileFullPath = backupDir.endsWith(BackupConstants.FILE_SEPARATOR) ? backupDir + "dmBackup.his" : backupDir + BackupConstants.FILE_SEPARATOR + "dmBackup.his";
            rc = hist.FileOpen(this.dbName, backupHisFileFullPath, "1");
            if (rc != DbaUtDef.RTN_OK) {
                System.out.println("Error open backup history file " + backupHisFileFullPath + ". And err no = " + rc);
                throw new UserCancelException();
            }
            int isSetBackupDataSuccessful = -1;
            for (int i = 0; i < rowCount; ++i) {
                logical_name = (String)this.model.getValueAt(i, 0);
                db_file = (String)this.model.getValueAt(i, 1);
                dest_file = (String)this.model.getValueAt(i, 2);
                isSetBackupDataSuccessful = i == 0 ? hist.setBackupData(0, 3, db_file, logical_name, dest_file, 1) : (i == rowCount - 1 ? hist.setBackupData(0, 3, db_file, logical_name, dest_file, 2) : hist.setBackupData(0, 3, db_file, logical_name, dest_file, 0));
                if (isSetBackupDataSuccessful == 0) continue;
                throw new UserCancelException();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressDialog.setVisible(false);
                    progressDialog.dispose();
                    GuiUt.showInformationDlg(OnlineFullBackupPanel.this.parentDialog, OnlineFullBackupPanel.this.res.getString("Backup_Successfully_FullStop"));
                    OnlineFullBackupPanel.this.cancelButtonActionPerformed(null);
                }
            });
        }
        catch (UserCancelException ex1) {
            System.out.println("User canceled.");
            this.abortBackup(stmt);
            this.clean(progressDialog);
        }
        catch (CopyFileErrorException e) {
            System.out.println("Copy file error.");
            this.abortBackup(stmt);
            this.clean(progressDialog, e.getMessage());
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted exception.");
            this.abortBackup(stmt);
            this.clean(progressDialog);
        }
        catch (InvocationTargetException e) {
            System.out.println("Invocation target exception.");
            this.abortBackup(stmt);
            this.clean(progressDialog);
        }
        catch (DeleteFileFailedException e) {
            message = e.getMessage();
            System.out.println(message);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiUt.showErrorDlg(OnlineFullBackupPanel.this.parentDialog, message, "");
                }
            });
        }
        catch (SQLException e) {
            this.abortBackup(stmt);
            message = e.getMessage();
            System.out.println(message);
            this.clean(progressDialog, message);
        }
        finally {
            if (hist != null) {
                hist.FileClose();
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stmt1 != null) {
                try {
                    stmt1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void clean(final ProgressDialog progressDialog) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
                OnlineFullBackupPanel.this.cancelButtonActionPerformed(null);
            }
        });
        try {
            this.cleanBackupFile();
        }
        catch (DeleteFileFailedException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void clean(final ProgressDialog progressDialog, final String str) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
                GuiUt.showErrorDlg(OnlineFullBackupPanel.this.parentDialog, str, "");
                OnlineFullBackupPanel.this.cancelButtonActionPerformed(null);
            }
        });
        try {
            this.cleanBackupFile();
        }
        catch (DeleteFileFailedException e1) {
            System.out.println(e1.getMessage());
            e1.printStackTrace();
        }
    }

    private void abortBackup(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.execute("abort backup");
            }
        }
        catch (SQLException e2) {
            System.out.println("About Backup execute exception.");
            e2.printStackTrace();
        }
    }

    private void writeToDmConfig(int newBMode, String backupDir) {
        int rcDmConfig = -1;
        if (this.isWriteToConfig.isSelected()) {
            JdmConfig dmconfig = new JdmConfig();
            rcDmConfig = dmconfig.fileOpen("dmconfig.ini", this.dbName, "r+");
            if (rcDmConfig != 0) {
                System.out.println("Open dmconfig.ini file failed!");
            }
            if ((rcDmConfig = dmconfig.insertPara("DB_BMODE", new Integer(newBMode), 8192)) != 0) {
                System.out.println("Insert keyword DB_BMODE with value " + newBMode + " to " + "dmconfig.ini" + " file failed!");
            }
            if ((rcDmConfig = dmconfig.insertPara("DB_BKDIR", backupDir, 4096)) != 0) {
                System.out.println("Insert keyword DB_BKDIR with value '" + backupDir + "' to " + "dmconfig.ini" + " file failed!");
            }
            if ((rcDmConfig = dmconfig.fileClose()) != 0) {
                System.out.println("Close dmconfig.ini file failed!");
            }
        }
    }

    private void cleanBackupFile() throws DeleteFileFailedException {
        String dest_file = null;
        File desFile = null;
        int rowCount = this.model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            dest_file = (String)this.model.getValueAt(i, 2);
            desFile = new File(dest_file);
            if (!desFile.exists() || desFile.delete()) continue;
            throw new DeleteFileFailedException(desFile.getAbsolutePath());
        }
    }

    private boolean isMasterDB() {
        String sql = "CALL GETSYSTEMOPTION('RPMODE',?)";
        try {
            CallableStatement stmt = this.connection.dbconn.prepareCall(sql);
            stmt.registerOutParameter(1, 12);
            stmt.execute();
            String rpMode = stmt.getString(1);
            stmt.close();
            return rpMode.equalsIgnoreCase("1");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private long getRPBkId() {
        String sql = "CALL GETSYSTEMOPTION('RPBKID',?)";
        try {
            CallableStatement stmt = this.connection.dbconn.prepareCall(sql);
            stmt.registerOutParameter(1, 12);
            stmt.execute();
            long id = JavaTypeUtil.parseLong(stmt.getString(1), this.parentDialog);
            stmt.close();
            return id;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    private void cleanBackupFile(File backupDir) throws DeleteFileFailedException, InterruptedException, InvocationTargetException, UserCancelException {
        File backupLogFile;
        if (!backupDir.exists()) {
            return;
        }
        String absolutePath = backupDir.getAbsolutePath();
        if (!absolutePath.endsWith(BackupConstants.FILE_SEPARATOR)) {
            absolutePath = absolutePath + BackupConstants.FILE_SEPARATOR;
        }
        if (!(backupLogFile = new File(absolutePath + "dmBackup.his")).exists()) {
            return;
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                OnlineFullBackupPanel.this.option = GuiUt.showOptionDlg(OnlineFullBackupPanel.this.parentDialog, OnlineFullBackupPanel.this.res.getString("Replace_File"), OnlineFullBackupPanel.this.res.getString("Replace_The_Existing_Files_QuestionMark"));
            }
        });
        if (this.option != 0) {
            throw new UserCancelException();
        }
        byte[] bErr = new byte[1024];
        JBackupHistory bHis = new JBackupHistory(SmFrame.frame);
        long id = -1L;
        id = this.isMasterDB() ? this.getRPBkId() + 1L : 0L;
        int rc = bHis.removeBackupSequence(backupLogFile.getAbsolutePath(), id, bErr);
        if (rc != 0) {
            String eMsg = new String(bErr).trim();
            throw new DeleteFileFailedException(eMsg);
        }
    }

    public void cancelButtonActionPerformed(ActionEvent e) {
        if (this.connection.isConnected()) {
            this.connection.disconnect();
        }
        this.parentDialog.setVisible(false);
        this.parentDialog.dispose();
    }

    @Override
    public void windowClosing() {
        this.cancelButtonActionPerformed(null);
    }

    @Override
    public String getTitle() {
        this.title = "Online_Full_Backup";
        return this.title;
    }

    private void setFinishButtonStatus() {
        if (this.backupDestinationField.getText() == null || this.backupDestinationField.getText().trim().length() == 0) {
            this.finishButton.setEnabled(false);
        } else {
            this.finishButton.setEnabled(true);
        }
    }

    public synchronized int utOverlapPath(String path1, String path2) {
        int rc = this.cfun.utOverlapPath(path1.getBytes(), path2.getBytes());
        return rc;
    }
}

