/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import com.borland.jbcl.control.GroupBox;
import com.borland.jbcl.layout.VerticalFlowLayout;
import dbaut.GuiUt;
import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.resource.DBAImageResource;
import dbaut.textField.IntegerRangeField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import monitor.ColorRenderer;
import monitor.DataSet;
import monitor.HelpButton;
import monitor.MonitorFrame;

public class PropertiesDialog
extends JDialog {
    private IntegerRangeField rangehi = new IntegerRangeField(9000000, 0);
    private IntegerRangeField rangelow = new IntegerRangeField(8999990, 0);
    private DataSet dataset = null;
    private JComboBox bgColorCombo = new JComboBox<Object>(new Object[]{Color.gray, Color.darkGray, Color.pink, Color.white, Color.orange, Color.red, Color.blue, Color.yellow, Color.magenta, Color.black, Color.green, Color.cyan, Color.lightGray, new Color(170, 170, 0), new Color(54, 133, 54), new Color(170, 0, 170)});
    private JComboBox lineColorCombo = new JComboBox<Object>(new Object[]{Color.gray, Color.darkGray, Color.pink, Color.white, Color.orange, Color.red, Color.blue, Color.yellow, Color.magenta, Color.black, Color.green, Color.cyan, Color.lightGray, new Color(170, 170, 0), new Color(54, 133, 54), new Color(170, 0, 170)});

    public PropertiesDialog(Frame frame, String title, boolean modal, DataSet dataset) {
        super(frame, title, modal);
        this.dataset = dataset;
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PropertiesDialog(Frame frame, DataSet dataset) {
        super(frame);
        this.setModal(true);
        this.dataset = dataset;
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        HelpButton Help_Button = new HelpButton();
        DbaButton Cancel_Button = new DbaButton(MonitorFrame.frame.res.getString("Cancel"), 'C', new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        DbaButton OK_Button = new DbaButton(MonitorFrame.frame.res.getString("OK"), 'O', new ReflectionAction(this, "OK_Button_actionPerformed"));
        GroupBox chartColorGroupBox = new GroupBox(MonitorFrame.frame.res.getString("Chart_Color"));
        GroupBox chartScopeGroupBox = new GroupBox(MonitorFrame.frame.res.getString("Chart_Scope"));
        OK_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        Cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        JPanel panel1 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 2, 2));
        JPanel jPanel2 = new JPanel();
        this.setSize(340, 300);
        this.setTitle(MonitorFrame.frame.res.getString("Properties"));
        panel1.setLayout(new BorderLayout());
        this.getContentPane().add(panel1);
        panel1.add((Component)jPanel4, "South");
        jPanel4.add((Component)OK_Button, null);
        jPanel4.add((Component)Cancel_Button, null);
        jPanel4.add((Component)Help_Button, null);
        panel1.add((Component)jPanel2, "North");
        jPanel2.setLayout((LayoutManager)new VerticalFlowLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel2.add((Component)jPanel3, null);
        this.bgColorCombo.setSelectedItem(this.dataset.background);
        this.lineColorCombo.setSelectedItem(this.dataset.gridline);
        this.rangehi.setValue(this.dataset.rangehi);
        this.rangelow.setValue(this.dataset.rangelow);
        this.bgColorCombo.setRenderer(new ColorRenderer());
        this.lineColorCombo.setRenderer(new ColorRenderer());
        chartColorGroupBox.setLayout((LayoutManager)new GridLayout(2, 2));
        chartScopeGroupBox.setLayout((LayoutManager)new GridLayout(2, 2));
        jPanel3.add((Component)chartColorGroupBox);
        jPanel3.add((Component)chartScopeGroupBox);
        chartColorGroupBox.add((Component)new JLabel(MonitorFrame.frame.res.getString("Background_color")));
        chartColorGroupBox.add((Component)this.bgColorCombo);
        chartColorGroupBox.add((Component)new JLabel(MonitorFrame.frame.res.getString("Grid_line_color")));
        chartColorGroupBox.add((Component)this.lineColorCombo);
        chartScopeGroupBox.add((Component)new JLabel(MonitorFrame.frame.res.getString("Maximum")));
        chartScopeGroupBox.add((Component)this.rangehi);
        chartScopeGroupBox.add((Component)new JLabel(MonitorFrame.frame.res.getString("Minimum")));
        chartScopeGroupBox.add((Component)this.rangelow);
        MonitorFrame.frame.enableHelpAction(this.getRootPane(), Help_Button, "monitor_PropertiesDialog", null);
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        if (this.rangehi.getValue() == null) {
            GuiUt.showErrorDlg(this, MonitorFrame.frame.res.getString("The_maximum_value_empty"), null);
            return;
        }
        if (this.rangelow.getValue() == null) {
            GuiUt.showErrorDlg(this, MonitorFrame.frame.res.getString("The_minimum_value_empty"), null);
            return;
        }
        if (this.rangehi.getValue() - this.rangelow.getValue() < 0) {
            GuiUt.showErrorDlg(this, MonitorFrame.frame.res.getString("The_maximum_value_less"), null);
            return;
        }
        if (this.rangehi.getValue() - this.rangelow.getValue() == 0) {
            GuiUt.showErrorDlg(this, MonitorFrame.frame.res.getString("The_maximum_value_equal"), null);
            return;
        }
        if (this.rangehi.getValue() - this.rangelow.getValue() < 10) {
            GuiUt.showErrorDlg(this, MonitorFrame.frame.res.getString("The_maximum_value_greater"), null);
            return;
        }
        if ((this.rangehi.getValue() - this.rangelow.getValue()) % 10 != 0) {
            GuiUt.showErrorDlg(this, MonitorFrame.frame.res.getString("The_maximum_value_substract"), null);
            int value = (this.rangehi.getValue() - this.rangelow.getValue()) % 10;
            if (value <= 4) {
                this.rangehi.setValue(this.rangehi.getInt() - value);
            } else {
                this.rangehi.setValue(this.rangehi.getInt() + (10 - value));
            }
            return;
        }
        this.dataset.background = (Color)this.bgColorCombo.getSelectedItem();
        this.dataset.gridline = (Color)this.lineColorCombo.getSelectedItem();
        if (this.rangehi.getValue() != null) {
            this.dataset.rangehi = this.rangehi.getValue();
        }
        if (this.rangelow.getValue() != null) {
            this.dataset.rangelow = this.rangelow.getValue();
        }
        this.setVisible(false);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }
}

