/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import dbaut.comp.DbaButton;
import dbaut.comp.ReflectionAction;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAImageResource;
import dbaut.resource.DBAResourceBundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import monitor.ColorRenderer;
import monitor.DataObject;
import monitor.HelpButton;
import monitor.LineRenderer;
import monitor.MonitorFrame;
import monitor.ProportionObject;

public class LineDialog
extends JDialog {
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("Monitorproperties.Monitor.MonitorRes", LocaleManager.getLocale());
    private DefaultComboBoxModel model2 = new DefaultComboBoxModel();
    private Color color = Color.red;
    DataObject result = null;
    DataObject current = null;
    private JComboBox line_ComboBox = new JComboBox();
    private JComboBox colorCombo = new JComboBox<Object>(new Object[]{Color.gray, Color.darkGray, Color.pink, Color.white, Color.orange, Color.red, Color.blue, Color.yellow, Color.magenta, Color.black, Color.green, Color.cyan, Color.lightGray, new Color(170, 170, 0), new Color(54, 133, 54), new Color(170, 0, 170)});
    private JComboBox proportionCombo = new JComboBox<Object>(new Object[]{new ProportionObject(" 1 : 0.0001 ", 1.0E-4), new ProportionObject(" 1 : 0.001 ", 0.001), new ProportionObject(" 1 : 0.01 ", 0.01), new ProportionObject(" 1 : 0.1 ", 0.1), new ProportionObject(" 1 : 1 ", 1.0), new ProportionObject(" 1 : 10 ", 10.0), new ProportionObject(" 1 : 100 ", 100.0), new ProportionObject(" 1 : 1000 ", 1000.0), new ProportionObject(" 1 : 10000 ", 10000.0), new ProportionObject(this.res.getString("auto"), 5.0)});

    public LineDialog(Frame frame, String title, boolean modal, DataObject obj) {
        super(frame, title, modal);
        this.current = obj;
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LineDialog(Frame frame, DataObject obj) {
        super(frame);
        this.setModal(true);
        this.current = obj;
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        HelpButton Help_Button = new HelpButton();
        DbaButton Cancel_Button = new DbaButton(this.res.getString("Cancel"), 'C', new ReflectionAction(this, "Cancel_Button_actionPerformed"));
        DbaButton OK_Button = new DbaButton(this.res.getString("OK"), 'O', new ReflectionAction(this, "OK_Button_actionPerformed"));
        JPanel panel1 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel2 = new JPanel();
        panel1.setLayout(new BorderLayout());
        this.setTitle(this.res.getString("Line_Style"));
        MonitorFrame.frame.enableHelpAction(this.getRootPane(), Help_Button, "monitor_LineDialog", null);
        OK_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/ok.gif"));
        Cancel_Button.setIcon(DBAImageResource.getResource(this.getClass(), "/dbautimages/cancel.gif"));
        panel1.setPreferredSize(new Dimension(300, 150));
        jPanel2.setLayout(new GridLayout(3, 2, 10, 3));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.colorCombo.addActionListener(new ReflectionAction(this, "colorCombo_actionPerformed"));
        this.line_ComboBox.setPreferredSize(new Dimension(80, 23));
        this.line_ComboBox.setRenderer(new LineRenderer());
        this.line_ComboBox.setModel(this.model2);
        this.getContentPane().add(panel1);
        panel1.add((Component)jPanel4, "South");
        jPanel4.add((Component)OK_Button, null);
        jPanel4.add((Component)Cancel_Button, null);
        jPanel4.add((Component)Help_Button, null);
        panel1.add((Component)jPanel2, "North");
        jPanel2.add(new JLabel(this.res.getString("LineDlg_Line")));
        jPanel2.add(this.line_ComboBox);
        jPanel2.add(new JLabel(this.res.getString("LineDlg_Color")));
        jPanel2.add(this.colorCombo);
        jPanel2.add(new JLabel(this.res.getString("LineDlg_Scale")));
        jPanel2.add(this.proportionCombo);
        this.color = this.current.color;
        this.model2.addElement(new DataObject(0, this.color, 1));
        this.model2.addElement(new DataObject(0, this.color, 2));
        this.model2.addElement(new DataObject(0, this.color, 3));
        this.model2.addElement(new DataObject(0, this.color, 4));
        this.colorCombo.setRenderer(new ColorRenderer());
        this.line_ComboBox.setSelectedIndex(this.current.linewidth - 1);
        this.colorCombo.setSelectedItem(this.color);
        this.proportionCombo.setSelectedIndex(this.current.proportion.getValueIndex());
    }

    public void OK_Button_actionPerformed(ActionEvent e) {
        this.result = (DataObject)this.model2.getSelectedItem();
        this.result.proportion = (ProportionObject)this.proportionCombo.getSelectedItem();
        this.result.color = (Color)this.colorCombo.getSelectedItem();
        this.setVisible(false);
    }

    public void Cancel_Button_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.result = null;
    }

    public void colorCombo_actionPerformed(ActionEvent e) {
        this.color = (Color)this.colorCombo.getSelectedItem();
        int size = this.model2.getSize();
        DataObject obj = null;
        for (int i = 0; i < size; ++i) {
            obj = (DataObject)this.model2.getElementAt(i);
            obj.color = this.color;
        }
        this.line_ComboBox.repaint();
    }
}

