/*
 * Decompiled with CFR 0.152.
 */
package framework;

import dbaut.JdmConfig;
import framework.SystemUt;
import org.junit.Assert;

public class DMConfigManager {
    private static String testDBHome = null;

    public static void main(String[] args) {
    }

    public static String getDBHome() {
        JdmConfig config = new JdmConfig();
        String path = config.filePath("dmconfig.ini");
        int index = path.lastIndexOf(SystemUt.getFileSeparator());
        path = path.substring(0, index + 1);
        System.out.println("use " + path + "dmconfig.ini");
        return path;
    }

    public static void writeRemoteDmConfig(String dbName, String testHome) {
        JdmConfig config = new JdmConfig();
        String str = config.filePath("dmconfig.ini");
        int rc = config.create("dmconfig.ini", dbName);
        if (rc != 0) {
            System.out.println("create new section " + dbName + " failed in file " + str + " !");
            return;
        }
        rc = config.fileOpen("dmconfig.ini", dbName, "r+");
        config.insertPara("DB_DBDIR", testHome, 4096);
        config.insertPara("DB_SVADR", "127.0.0.1", 4096);
        config.insertPara("DB_PTNUM", new Integer(4444), 8192);
        config.insertPara("DB_USRID", "SYSADM", 4096);
        config.insertPara("DB_ATRMD", "1", 4096);
        config.insertPara("DD_DDBMD", "1", 4096);
        config.insertPara("DB_LCODE", "10", 4096);
        config.fileClose();
    }

    public static void writeDefaultDmConfig(String dbName, String testHome) {
        JdmConfig config = new JdmConfig();
        String str = config.filePath("dmconfig.ini");
        System.out.println(str);
        int rc = config.create("dmconfig.ini", dbName);
        if (rc != 0) {
            System.out.println("create new section " + dbName + " failed in file " + str + " !");
            return;
        }
        rc = config.fileOpen("dmconfig.ini", dbName, "r+");
        config.insertPara("DB_DBDIR", testHome, 4096);
        config.insertPara("DB_SVADR", "127.0.0.1", 4096);
        config.insertPara("DB_PTNUM", new Integer(3333), 8192);
        config.insertPara("DB_USRID", "SYSADM", 4096);
        config.insertPara("DB_LCODE", "10", 4096);
        config.insertPara("DB_BKSVR", "1", 4096);
        if (SystemUt.getIsTestJdba()) {
            config.insertPara("DB_ATRMD", "1", 4096);
            config.insertPara("DD_DDBMD", "1", 4096);
            config.insertPara("DB_JNLSZ", "1G", 4096);
            config.insertPara("DB_JNFIL", "jnl1.jnl jnl2.jnl", 4096);
        }
        config.fileClose();
    }

    public static void writeIdSensitiveDmConfig(String dbName, String testHome) {
        JdmConfig config = new JdmConfig();
        String str = config.filePath("dmconfig.ini");
        System.out.println(str);
        int rc = config.create("dmconfig.ini", dbName);
        if (rc != 0) {
            System.out.println("create new section " + dbName + " failed in file " + str + " !");
            return;
        }
        rc = config.fileOpen("dmconfig.ini", dbName, "r+");
        config.insertPara("DB_DBDIR", testHome, 4096);
        config.insertPara("DB_SVADR", "127.0.0.1", 4096);
        config.insertPara("DB_PTNUM", new Integer(3333), 8192);
        config.insertPara("DB_USRID", "SYSADM", 4096);
        config.insertPara("DB_LCODE", "10", 4096);
        config.insertPara("DB_BKSVR", "1", 4096);
        config.insertPara("DB_IDCAP", "0", 4096);
        if (SystemUt.getIsTestJdba()) {
            config.insertPara("DB_ATRMD", "1", 4096);
            config.insertPara("DD_DDBMD", "1", 4096);
            config.insertPara("DB_JNLSZ", "1G", 4096);
            config.insertPara("DB_JNFIL", "jnl1.jnl jnl2.jnl", 4096);
        }
        config.fileClose();
    }

    public static void deleteDefaultDmConfig(String dbName) {
        JdmConfig config = new JdmConfig();
        String str = config.filePath("dmconfig.ini");
        int rc = config.fileOpen("dmconfig.ini", dbName, "r+");
        if (rc != 0) {
            System.out.println("Fail open config " + str + " .");
        } else {
            config.procDelete("", 0);
        }
        config.fileClose();
    }

    public static Object getKeywordValue(String dbName, String keyWord, int type) {
        return DMConfigManager.getKeywordValue("dmconfig.ini", dbName, keyWord, type);
    }

    public static Object getKeywordValue(String dmconfigfile, String dbName, String keyWord, int type) {
        if (dmconfigfile == null || dbName == null || keyWord == null) {
            return null;
        }
        if (dmconfigfile.length() < 1 || dbName.length() < 1 || keyWord.length() < 1) {
            return null;
        }
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen(dmconfigfile, dbName, "r");
        if (rc != 0) {
            Assert.fail();
        }
        Object value = config.getPara(keyWord, type);
        rc = config.fileClose();
        if (rc != 0) {
            Assert.fail();
        }
        return value;
    }

    public static void insertKeyword(String dbName, String keyWord, Object value, int type) {
        DMConfigManager.insertKeyword("dmconfig.ini", dbName, keyWord, value, type);
    }

    public static void insertKeyword(String dmconfigfile, String dbName, String keyWord, Object value, int type) {
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen(dmconfigfile, dbName, "r+");
        if (rc != 0) {
            Assert.fail();
        }
        if ((rc = config.insertPara(keyWord, value, type)) != 0) {
            Assert.fail();
        }
        if ((rc = config.fileClose()) != 0) {
            Assert.fail();
        }
    }

    public static void deleteKeyword(String dbName, String keyWord) {
        DMConfigManager.deleteKeyword("dmconfig.ini", dbName, keyWord);
    }

    public static void deleteKeyword(String dmconfigFile, String dbName, String keyWord) {
        JdmConfig config = new JdmConfig();
        int rc = config.fileOpen(dmconfigFile, dbName, "r+");
        if (rc != 0) {
            return;
        }
        config.procDelete(keyWord, 0);
        config.fileClose();
    }

    public static String getDBDir(String dbName) {
        return JdmConfig.getDBDir(dbName);
    }
}

