/*
 * Decompiled with CFR 0.152.
 */
package executionPlan;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class Arrow
extends JPanel {
    private static final long serialVersionUID = -8184199652974352063L;
    private final Point p = new Point(0, 3);
    private int width = 0;
    private int height = 0;

    public Arrow(Point previous, Point next) {
        if (previous.y == next.y) {
            this.setBounds(previous.x + 140, previous.y + 40, 50, 4);
        } else {
            this.setBounds(previous.x - 50, previous.y + 40 + 2, 50, next.y - previous.y);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.width = width;
        this.height = height;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.height == 4) {
            g.drawLine(0, 2, this.width, 2);
            this.drawArrowhead((Graphics2D)g, this.p, -1.6);
        } else {
            g.drawLine(this.width / 2, 0, this.width / 2, this.height - 2);
            g.drawLine(this.width / 2, this.height - 2, this.width, this.height - 2);
        }
    }

    public void drawArrowhead(Graphics2D g2D, Point p, double angle) {
        int bottomWidth = 6;
        int height = 16;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int[] x = new int[]{p.x, p.x - bottomWidth / 2, p.x + bottomWidth / 2};
        int[] y = new int[]{p.y, p.y + height, p.y + height};
        int nPoints = 3;
        g2D.rotate(angle, p.x, p.y);
        g2D.fillPolygon(x, y, nPoints);
        g2D.rotate(-angle, p.x, p.y);
    }
}

