/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importXML;

import dttwizard.importXML.XmlElement;
import java.util.Vector;

public class XmlDTD {
    public String name = null;
    public String sysid = null;
    public String publicid = null;
    public int has_internal_subset = 0;
    public Vector elements = new Vector();
    public XmlElement curelm = null;

    public native int getSchema(byte[] var1);

    public XmlDTD() {
        try {
            System.loadLibrary("dmdttut");
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("java.library.path=" + System.getProperty("java.library.path"));
            System.out.println("error loadlibrary dmdttut =" + e.getMessage());
        }
    }

    public void initDTD(byte[] name, byte[] sysid, byte[] publicid, int has_internal_subset) {
        try {
            this.name = new String(name, "UTF-8");
            this.sysid = new String(sysid, "UTF-8");
            this.publicid = new String(publicid, "UTF-8");
            this.has_internal_subset = has_internal_subset;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getSchema(String filename) {
        int rc = this.getSchema(filename.getBytes());
        if (rc != 0) {
            return rc;
        }
        int size = this.elements.size();
        int num_child = 0;
        XmlElement childelm = null;
        XmlElement curelm = null;
        XmlElement tempelm = null;
        for (int i = 0; i < size; ++i) {
            curelm = (XmlElement)this.elements.elementAt(i);
            num_child = curelm.child.size();
            for (int j = 0; j < num_child; ++j) {
                childelm = (XmlElement)curelm.child.elementAt(j);
                tempelm = this.searchElement(childelm.name);
                if (tempelm == null) continue;
                curelm.child.setElementAt(tempelm, j);
            }
        }
        return rc;
    }

    public XmlElement searchElement(String name) {
        XmlElement elm = null;
        int size = this.elements.size();
        for (int i = 0; i < size; ++i) {
            elm = (XmlElement)this.elements.elementAt(i);
            if (!elm.name.equals(name)) continue;
            return elm;
        }
        return null;
    }

    public void endElement(byte[] name) {
        if (this.curelm != null) {
            this.curelm = this.curelm.parent;
        }
    }

    public XmlElement startElement(byte[] name, int type, int quant) {
        try {
            String elmName = new String(name, "UTF-8");
            XmlElement elm = this.searchElement(elmName);
            if (elm == null) {
                elm = new XmlElement(elmName, type, quant, this.curelm);
                this.elements.addElement(elm);
            } else {
                elm.parent = this.curelm;
            }
            if (this.curelm != null) {
                this.curelm.addChild(elm);
            }
            this.curelm = elm;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.curelm;
    }

    public XmlElement addElement(byte[] name, int type, int quant) {
        XmlElement elm = null;
        try {
            elm = new XmlElement(new String(name, "UTF-8"), type, quant);
            this.elements.addElement(elm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return elm;
    }

    public void print(int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        int size = this.elements.size();
        for (int i = 0; i < size; ++i) {
            ((XmlElement)this.elements.elementAt(i)).print(indent + 1);
        }
    }

    public String toString() {
        return "name=" + this.name + " sysid=" + this.sysid + " publicid=" + this.publicid + " has_internal_subset=" + this.has_internal_subset;
    }
}

