/*
 * Decompiled with CFR 0.152.
 */
package dttwizard.importODBC;

import datatransfer.XmlFile;
import dbaut.CommonDatabaseConnectionInterface;
import dbaut.CommonUt.AbstractWizardPanel;
import dbaut.GuiUt;
import dbaut.JdmConfig;
import dbaut.SyscomCommonDatabaseConnection;
import dbaut.locale.LocaleManager;
import dbaut.resource.DBAResourceBundle;
import dttwizard.importODBC.Introduction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class odbcDialog
extends JDialog {
    private static final long serialVersionUID = 8733498668694350594L;
    public Brand brand = Brand.DBMAKER;
    private DBAResourceBundle res = DBAResourceBundle.getDBAResourceBundle("dttproperties.Import.dtt_ImportOdbcRes", LocaleManager.getLocale());
    private JPanel master = new JPanel(new BorderLayout());
    private AbstractWizardPanel current = null;
    String sourceDbName = "";
    String sourceUserID = "";
    String sourcePasswd = "";
    String destinationDbName = "";
    String destinationUserID = "";
    String destinationPasswd = "";
    String batchFileName = "";
    CommonDatabaseConnectionInterface sourceConnection = null;
    public SyscomCommonDatabaseConnection destinationConnection = null;
    Vector<String> dataSource = new Vector();
    static final int TABLE_TYPE = 0;
    static final int QUERY_TYPE = 1;
    static final int BATCH_TYPE = 2;
    int flowType = 0;
    boolean isTableView = true;
    boolean isLoadSuccess = true;
    boolean isVFPDriver = false;
    boolean isExcelDriver = false;
    XmlFile xmlFile = null;
    public String sourceSchema = null;
    public String destSchema = null;

    public void setOdbcSource(Brand b) {
        this.brand = b;
    }

    public boolean isDBMaker() {
        return this.brand == Brand.DBMAKER;
    }

    public char getQuoteIdChar() {
        if (this.brand == Brand.MYSQL) {
            return '`';
        }
        return '\"';
    }

    public odbcDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setSize(640, 480);
        this.current = new Introduction(this);
        this.setTitle(this.res.getString("Frame_title") + " - " + this.current.getTitle());
        this.getContentPane().add(this.master);
        this.master.add((Component)this.current, "Center");
        this.dataSource = JdmConfig.getDatabaseNames("dmconfig.ini", false);
        this.dataSource.insertElementAt(new String("  "), 0);
    }

    public void Next(AbstractWizardPanel panel) {
        this.master.removeAll();
        this.current = panel;
        this.setTitle(this.res.getString("Frame_title") + " - " + panel.getTitle());
        this.master.add((Component)this.current, "Center");
        this.current.setCursor(Cursor.getPredefinedCursor(0));
        this.master.revalidate();
        this.master.repaint();
        this.current.grabFocus();
    }

    public void WriteFileContent(FileWriter fw, int spaceNumber, String inStr) {
        char[] spaceCharArray = new char[spaceNumber];
        for (int i = 0; i < spaceNumber; ++i) {
            spaceCharArray[i] = 32;
        }
        try {
            fw.write(spaceCharArray);
            fw.write(inStr);
        }
        catch (IOException ioe) {
            GuiUt.showErrorDlg(this, ioe.getMessage(), null);
            return;
        }
    }

    @Override
    public void dispose() {
        if (this.sourceConnection != null && this.sourceConnection.isConnected()) {
            this.sourceConnection.disconnect();
            this.sourceConnection = null;
        }
        if (this.destinationConnection != null && this.destinationConnection.isConnected()) {
            this.destinationConnection.disconnect();
            this.destinationConnection = null;
        }
        super.dispose();
    }

    public static enum Brand {
        DBMAKER,
        ORACLE,
        SQLSERVER,
        MYSQL,
        OTHER;

    }
}

